// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.serde

import aws.sdk.kotlin.services.neptune.model.DbClusterSnapshot
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeDbClusterSnapshotDocument(reader: XmlTagReader): DbClusterSnapshot {
    val builder = DbClusterSnapshot.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // AvailabilityZones com.amazonaws.neptune#DBClusterSnapshot$AvailabilityZones
            "AvailabilityZones" -> builder.availabilityZones = deserializeAvailabilityZonesShape(curr)
            // DBClusterSnapshotIdentifier com.amazonaws.neptune#DBClusterSnapshot$DBClusterSnapshotIdentifier
            "DBClusterSnapshotIdentifier" -> builder.dbClusterSnapshotIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // DBClusterIdentifier com.amazonaws.neptune#DBClusterSnapshot$DBClusterIdentifier
            "DBClusterIdentifier" -> builder.dbClusterIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // SnapshotCreateTime com.amazonaws.neptune#DBClusterSnapshot$SnapshotCreateTime
            "SnapshotCreateTime" -> builder.snapshotCreateTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.neptune#TStamp`)" }
            // Engine com.amazonaws.neptune#DBClusterSnapshot$Engine
            "Engine" -> builder.engine = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // AllocatedStorage com.amazonaws.neptune#DBClusterSnapshot$AllocatedStorage
            "AllocatedStorage" -> builder.allocatedStorage = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.neptune#Integer`)" }
            // Status com.amazonaws.neptune#DBClusterSnapshot$Status
            "Status" -> builder.status = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // Port com.amazonaws.neptune#DBClusterSnapshot$Port
            "Port" -> builder.port = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.neptune#Integer`)" }
            // VpcId com.amazonaws.neptune#DBClusterSnapshot$VpcId
            "VpcId" -> builder.vpcId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // ClusterCreateTime com.amazonaws.neptune#DBClusterSnapshot$ClusterCreateTime
            "ClusterCreateTime" -> builder.clusterCreateTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.neptune#TStamp`)" }
            // MasterUsername com.amazonaws.neptune#DBClusterSnapshot$MasterUsername
            "MasterUsername" -> builder.masterUsername = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // EngineVersion com.amazonaws.neptune#DBClusterSnapshot$EngineVersion
            "EngineVersion" -> builder.engineVersion = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // LicenseModel com.amazonaws.neptune#DBClusterSnapshot$LicenseModel
            "LicenseModel" -> builder.licenseModel = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // SnapshotType com.amazonaws.neptune#DBClusterSnapshot$SnapshotType
            "SnapshotType" -> builder.snapshotType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // PercentProgress com.amazonaws.neptune#DBClusterSnapshot$PercentProgress
            "PercentProgress" -> builder.percentProgress = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.neptune#Integer`)" }
            // StorageEncrypted com.amazonaws.neptune#DBClusterSnapshot$StorageEncrypted
            "StorageEncrypted" -> builder.storageEncrypted = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.neptune#Boolean`)" }
            // KmsKeyId com.amazonaws.neptune#DBClusterSnapshot$KmsKeyId
            "KmsKeyId" -> builder.kmsKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // DBClusterSnapshotArn com.amazonaws.neptune#DBClusterSnapshot$DBClusterSnapshotArn
            "DBClusterSnapshotArn" -> builder.dbClusterSnapshotArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // SourceDBClusterSnapshotArn com.amazonaws.neptune#DBClusterSnapshot$SourceDBClusterSnapshotArn
            "SourceDBClusterSnapshotArn" -> builder.sourceDbClusterSnapshotArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // IAMDatabaseAuthenticationEnabled com.amazonaws.neptune#DBClusterSnapshot$IAMDatabaseAuthenticationEnabled
            "IAMDatabaseAuthenticationEnabled" -> builder.iamDatabaseAuthenticationEnabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.neptune#Boolean`)" }
            // StorageType com.amazonaws.neptune#DBClusterSnapshot$StorageType
            "StorageType" -> builder.storageType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
