// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.paginators

import aws.sdk.kotlin.services.neptune.NeptuneClient
import aws.sdk.kotlin.services.neptune.model.DbCluster
import aws.sdk.kotlin.services.neptune.model.DbClusterEndpoint
import aws.sdk.kotlin.services.neptune.model.DbClusterParameterGroup
import aws.sdk.kotlin.services.neptune.model.DbClusterSnapshot
import aws.sdk.kotlin.services.neptune.model.DbEngineVersion
import aws.sdk.kotlin.services.neptune.model.DbInstance
import aws.sdk.kotlin.services.neptune.model.DbParameterGroup
import aws.sdk.kotlin.services.neptune.model.DbSubnetGroup
import aws.sdk.kotlin.services.neptune.model.DescribeDbClusterEndpointsRequest
import aws.sdk.kotlin.services.neptune.model.DescribeDbClusterEndpointsResponse
import aws.sdk.kotlin.services.neptune.model.DescribeDbClusterParameterGroupsRequest
import aws.sdk.kotlin.services.neptune.model.DescribeDbClusterParameterGroupsResponse
import aws.sdk.kotlin.services.neptune.model.DescribeDbClusterParametersRequest
import aws.sdk.kotlin.services.neptune.model.DescribeDbClusterParametersResponse
import aws.sdk.kotlin.services.neptune.model.DescribeDbClusterSnapshotsRequest
import aws.sdk.kotlin.services.neptune.model.DescribeDbClusterSnapshotsResponse
import aws.sdk.kotlin.services.neptune.model.DescribeDbClustersRequest
import aws.sdk.kotlin.services.neptune.model.DescribeDbClustersResponse
import aws.sdk.kotlin.services.neptune.model.DescribeDbEngineVersionsRequest
import aws.sdk.kotlin.services.neptune.model.DescribeDbEngineVersionsResponse
import aws.sdk.kotlin.services.neptune.model.DescribeDbInstancesRequest
import aws.sdk.kotlin.services.neptune.model.DescribeDbInstancesResponse
import aws.sdk.kotlin.services.neptune.model.DescribeDbParameterGroupsRequest
import aws.sdk.kotlin.services.neptune.model.DescribeDbParameterGroupsResponse
import aws.sdk.kotlin.services.neptune.model.DescribeDbParametersRequest
import aws.sdk.kotlin.services.neptune.model.DescribeDbParametersResponse
import aws.sdk.kotlin.services.neptune.model.DescribeDbSubnetGroupsRequest
import aws.sdk.kotlin.services.neptune.model.DescribeDbSubnetGroupsResponse
import aws.sdk.kotlin.services.neptune.model.DescribeEngineDefaultParametersRequest
import aws.sdk.kotlin.services.neptune.model.DescribeEngineDefaultParametersResponse
import aws.sdk.kotlin.services.neptune.model.DescribeEventSubscriptionsRequest
import aws.sdk.kotlin.services.neptune.model.DescribeEventSubscriptionsResponse
import aws.sdk.kotlin.services.neptune.model.DescribeEventsRequest
import aws.sdk.kotlin.services.neptune.model.DescribeEventsResponse
import aws.sdk.kotlin.services.neptune.model.DescribeGlobalClustersRequest
import aws.sdk.kotlin.services.neptune.model.DescribeGlobalClustersResponse
import aws.sdk.kotlin.services.neptune.model.DescribeOrderableDbInstanceOptionsRequest
import aws.sdk.kotlin.services.neptune.model.DescribeOrderableDbInstanceOptionsResponse
import aws.sdk.kotlin.services.neptune.model.DescribePendingMaintenanceActionsRequest
import aws.sdk.kotlin.services.neptune.model.DescribePendingMaintenanceActionsResponse
import aws.sdk.kotlin.services.neptune.model.Event
import aws.sdk.kotlin.services.neptune.model.EventSubscription
import aws.sdk.kotlin.services.neptune.model.GlobalCluster
import aws.sdk.kotlin.services.neptune.model.OrderableDbInstanceOption
import aws.sdk.kotlin.services.neptune.model.Parameter
import aws.sdk.kotlin.services.neptune.model.ResourcePendingMaintenanceActions
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeDbClusterEndpointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDbClusterEndpointsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbClusterEndpointsResponse]
 */
public fun NeptuneClient.describeDbClusterEndpointsPaginated(initialRequest: DescribeDbClusterEndpointsRequest = DescribeDbClusterEndpointsRequest { }): Flow<DescribeDbClusterEndpointsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeDbClusterEndpointsPaginated.describeDbClusterEndpoints(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDbClusterEndpointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbClusterEndpointsResponse]
 */
public fun NeptuneClient.describeDbClusterEndpointsPaginated(block: DescribeDbClusterEndpointsRequest.Builder.() -> Unit): Flow<DescribeDbClusterEndpointsResponse> =
    describeDbClusterEndpointsPaginated(DescribeDbClusterEndpointsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeDbClusterEndpointsPaginated]
 * to access the nested member [DbClusterEndpoint]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DbClusterEndpoint]
 */
@JvmName("describeDbClusterEndpointsResponseDbClusterEndpoint")
public fun Flow<DescribeDbClusterEndpointsResponse>.dbClusterEndpoints(): Flow<DbClusterEndpoint> =
    transform() { response ->
        response.dbClusterEndpoints?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeDbClusterParameterGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDbClusterParameterGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbClusterParameterGroupsResponse]
 */
public fun NeptuneClient.describeDbClusterParameterGroupsPaginated(initialRequest: DescribeDbClusterParameterGroupsRequest = DescribeDbClusterParameterGroupsRequest { }): Flow<DescribeDbClusterParameterGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeDbClusterParameterGroupsPaginated.describeDbClusterParameterGroups(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDbClusterParameterGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbClusterParameterGroupsResponse]
 */
public fun NeptuneClient.describeDbClusterParameterGroupsPaginated(block: DescribeDbClusterParameterGroupsRequest.Builder.() -> Unit): Flow<DescribeDbClusterParameterGroupsResponse> =
    describeDbClusterParameterGroupsPaginated(DescribeDbClusterParameterGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeDbClusterParameterGroupsPaginated]
 * to access the nested member [DbClusterParameterGroup]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DbClusterParameterGroup]
 */
@JvmName("describeDbClusterParameterGroupsResponseDbClusterParameterGroup")
public fun Flow<DescribeDbClusterParameterGroupsResponse>.dbClusterParameterGroups(): Flow<DbClusterParameterGroup> =
    transform() { response ->
        response.dbClusterParameterGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeDbClusterParametersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDbClusterParametersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbClusterParametersResponse]
 */
public fun NeptuneClient.describeDbClusterParametersPaginated(initialRequest: DescribeDbClusterParametersRequest): Flow<DescribeDbClusterParametersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeDbClusterParametersPaginated.describeDbClusterParameters(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDbClusterParametersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbClusterParametersResponse]
 */
public fun NeptuneClient.describeDbClusterParametersPaginated(block: DescribeDbClusterParametersRequest.Builder.() -> Unit): Flow<DescribeDbClusterParametersResponse> =
    describeDbClusterParametersPaginated(DescribeDbClusterParametersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeDbClusterParametersPaginated]
 * to access the nested member [Parameter]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Parameter]
 */
@JvmName("describeDbClusterParametersResponseParameter")
public fun Flow<DescribeDbClusterParametersResponse>.parameters(): Flow<Parameter> =
    transform() { response ->
        response.parameters?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeDbClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDbClustersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbClustersResponse]
 */
public fun NeptuneClient.describeDbClustersPaginated(initialRequest: DescribeDbClustersRequest = DescribeDbClustersRequest { }): Flow<DescribeDbClustersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeDbClustersPaginated.describeDbClusters(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDbClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbClustersResponse]
 */
public fun NeptuneClient.describeDbClustersPaginated(block: DescribeDbClustersRequest.Builder.() -> Unit): Flow<DescribeDbClustersResponse> =
    describeDbClustersPaginated(DescribeDbClustersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeDbClustersPaginated]
 * to access the nested member [DbCluster]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DbCluster]
 */
@JvmName("describeDbClustersResponseDbCluster")
public fun Flow<DescribeDbClustersResponse>.dbClusters(): Flow<DbCluster> =
    transform() { response ->
        response.dbClusters?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeDbClusterSnapshotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDbClusterSnapshotsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbClusterSnapshotsResponse]
 */
public fun NeptuneClient.describeDbClusterSnapshotsPaginated(initialRequest: DescribeDbClusterSnapshotsRequest = DescribeDbClusterSnapshotsRequest { }): Flow<DescribeDbClusterSnapshotsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeDbClusterSnapshotsPaginated.describeDbClusterSnapshots(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDbClusterSnapshotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbClusterSnapshotsResponse]
 */
public fun NeptuneClient.describeDbClusterSnapshotsPaginated(block: DescribeDbClusterSnapshotsRequest.Builder.() -> Unit): Flow<DescribeDbClusterSnapshotsResponse> =
    describeDbClusterSnapshotsPaginated(DescribeDbClusterSnapshotsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeDbClusterSnapshotsPaginated]
 * to access the nested member [DbClusterSnapshot]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DbClusterSnapshot]
 */
@JvmName("describeDbClusterSnapshotsResponseDbClusterSnapshot")
public fun Flow<DescribeDbClusterSnapshotsResponse>.dbClusterSnapshots(): Flow<DbClusterSnapshot> =
    transform() { response ->
        response.dbClusterSnapshots?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeDbEngineVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDbEngineVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbEngineVersionsResponse]
 */
public fun NeptuneClient.describeDbEngineVersionsPaginated(initialRequest: DescribeDbEngineVersionsRequest = DescribeDbEngineVersionsRequest { }): Flow<DescribeDbEngineVersionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeDbEngineVersionsPaginated.describeDbEngineVersions(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDbEngineVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbEngineVersionsResponse]
 */
public fun NeptuneClient.describeDbEngineVersionsPaginated(block: DescribeDbEngineVersionsRequest.Builder.() -> Unit): Flow<DescribeDbEngineVersionsResponse> =
    describeDbEngineVersionsPaginated(DescribeDbEngineVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeDbEngineVersionsPaginated]
 * to access the nested member [DbEngineVersion]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DbEngineVersion]
 */
@JvmName("describeDbEngineVersionsResponseDbEngineVersion")
public fun Flow<DescribeDbEngineVersionsResponse>.dbEngineVersions(): Flow<DbEngineVersion> =
    transform() { response ->
        response.dbEngineVersions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeDbInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDbInstancesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbInstancesResponse]
 */
public fun NeptuneClient.describeDbInstancesPaginated(initialRequest: DescribeDbInstancesRequest = DescribeDbInstancesRequest { }): Flow<DescribeDbInstancesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeDbInstancesPaginated.describeDbInstances(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDbInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbInstancesResponse]
 */
public fun NeptuneClient.describeDbInstancesPaginated(block: DescribeDbInstancesRequest.Builder.() -> Unit): Flow<DescribeDbInstancesResponse> =
    describeDbInstancesPaginated(DescribeDbInstancesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeDbInstancesPaginated]
 * to access the nested member [DbInstance]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DbInstance]
 */
@JvmName("describeDbInstancesResponseDbInstance")
public fun Flow<DescribeDbInstancesResponse>.dbInstances(): Flow<DbInstance> =
    transform() { response ->
        response.dbInstances?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeDbParameterGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDbParameterGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbParameterGroupsResponse]
 */
public fun NeptuneClient.describeDbParameterGroupsPaginated(initialRequest: DescribeDbParameterGroupsRequest = DescribeDbParameterGroupsRequest { }): Flow<DescribeDbParameterGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeDbParameterGroupsPaginated.describeDbParameterGroups(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDbParameterGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbParameterGroupsResponse]
 */
public fun NeptuneClient.describeDbParameterGroupsPaginated(block: DescribeDbParameterGroupsRequest.Builder.() -> Unit): Flow<DescribeDbParameterGroupsResponse> =
    describeDbParameterGroupsPaginated(DescribeDbParameterGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeDbParameterGroupsPaginated]
 * to access the nested member [DbParameterGroup]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DbParameterGroup]
 */
@JvmName("describeDbParameterGroupsResponseDbParameterGroup")
public fun Flow<DescribeDbParameterGroupsResponse>.dbParameterGroups(): Flow<DbParameterGroup> =
    transform() { response ->
        response.dbParameterGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeDbParametersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDbParametersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbParametersResponse]
 */
public fun NeptuneClient.describeDbParametersPaginated(initialRequest: DescribeDbParametersRequest): Flow<DescribeDbParametersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeDbParametersPaginated.describeDbParameters(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDbParametersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbParametersResponse]
 */
public fun NeptuneClient.describeDbParametersPaginated(block: DescribeDbParametersRequest.Builder.() -> Unit): Flow<DescribeDbParametersResponse> =
    describeDbParametersPaginated(DescribeDbParametersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeDbParametersPaginated]
 * to access the nested member [Parameter]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Parameter]
 */
@JvmName("describeDbParametersResponseParameter")
public fun Flow<DescribeDbParametersResponse>.parameters(): Flow<Parameter> =
    transform() { response ->
        response.parameters?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeDbSubnetGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDbSubnetGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbSubnetGroupsResponse]
 */
public fun NeptuneClient.describeDbSubnetGroupsPaginated(initialRequest: DescribeDbSubnetGroupsRequest = DescribeDbSubnetGroupsRequest { }): Flow<DescribeDbSubnetGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeDbSubnetGroupsPaginated.describeDbSubnetGroups(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDbSubnetGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDbSubnetGroupsResponse]
 */
public fun NeptuneClient.describeDbSubnetGroupsPaginated(block: DescribeDbSubnetGroupsRequest.Builder.() -> Unit): Flow<DescribeDbSubnetGroupsResponse> =
    describeDbSubnetGroupsPaginated(DescribeDbSubnetGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeDbSubnetGroupsPaginated]
 * to access the nested member [DbSubnetGroup]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DbSubnetGroup]
 */
@JvmName("describeDbSubnetGroupsResponseDbSubnetGroup")
public fun Flow<DescribeDbSubnetGroupsResponse>.dbSubnetGroups(): Flow<DbSubnetGroup> =
    transform() { response ->
        response.dbSubnetGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeEngineDefaultParametersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeEngineDefaultParametersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEngineDefaultParametersResponse]
 */
public fun NeptuneClient.describeEngineDefaultParametersPaginated(initialRequest: DescribeEngineDefaultParametersRequest): Flow<DescribeEngineDefaultParametersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeEngineDefaultParametersPaginated.describeEngineDefaultParameters(req)
            cursor = result.engineDefaults?.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeEngineDefaultParametersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEngineDefaultParametersResponse]
 */
public fun NeptuneClient.describeEngineDefaultParametersPaginated(block: DescribeEngineDefaultParametersRequest.Builder.() -> Unit): Flow<DescribeEngineDefaultParametersResponse> =
    describeEngineDefaultParametersPaginated(DescribeEngineDefaultParametersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeEngineDefaultParametersPaginated]
 * to access the nested member [Parameter]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Parameter]
 */
@JvmName("describeEngineDefaultParametersResponseParameter")
public fun Flow<DescribeEngineDefaultParametersResponse>.parameters(): Flow<Parameter> =
    transform() { response ->
        response.engineDefaults?.parameters?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeEventsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEventsResponse]
 */
public fun NeptuneClient.describeEventsPaginated(initialRequest: DescribeEventsRequest = DescribeEventsRequest { }): Flow<DescribeEventsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeEventsPaginated.describeEvents(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEventsResponse]
 */
public fun NeptuneClient.describeEventsPaginated(block: DescribeEventsRequest.Builder.() -> Unit): Flow<DescribeEventsResponse> =
    describeEventsPaginated(DescribeEventsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeEventsPaginated]
 * to access the nested member [Event]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Event]
 */
@JvmName("describeEventsResponseEvent")
public fun Flow<DescribeEventsResponse>.events(): Flow<Event> =
    transform() { response ->
        response.events?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeEventSubscriptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeEventSubscriptionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEventSubscriptionsResponse]
 */
public fun NeptuneClient.describeEventSubscriptionsPaginated(initialRequest: DescribeEventSubscriptionsRequest = DescribeEventSubscriptionsRequest { }): Flow<DescribeEventSubscriptionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeEventSubscriptionsPaginated.describeEventSubscriptions(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeEventSubscriptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEventSubscriptionsResponse]
 */
public fun NeptuneClient.describeEventSubscriptionsPaginated(block: DescribeEventSubscriptionsRequest.Builder.() -> Unit): Flow<DescribeEventSubscriptionsResponse> =
    describeEventSubscriptionsPaginated(DescribeEventSubscriptionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeEventSubscriptionsPaginated]
 * to access the nested member [EventSubscription]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EventSubscription]
 */
@JvmName("describeEventSubscriptionsResponseEventSubscription")
public fun Flow<DescribeEventSubscriptionsResponse>.eventSubscriptionsList(): Flow<EventSubscription> =
    transform() { response ->
        response.eventSubscriptionsList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeGlobalClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeGlobalClustersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeGlobalClustersResponse]
 */
public fun NeptuneClient.describeGlobalClustersPaginated(initialRequest: DescribeGlobalClustersRequest = DescribeGlobalClustersRequest { }): Flow<DescribeGlobalClustersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeGlobalClustersPaginated.describeGlobalClusters(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeGlobalClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeGlobalClustersResponse]
 */
public fun NeptuneClient.describeGlobalClustersPaginated(block: DescribeGlobalClustersRequest.Builder.() -> Unit): Flow<DescribeGlobalClustersResponse> =
    describeGlobalClustersPaginated(DescribeGlobalClustersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeGlobalClustersPaginated]
 * to access the nested member [GlobalCluster]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GlobalCluster]
 */
@JvmName("describeGlobalClustersResponseGlobalCluster")
public fun Flow<DescribeGlobalClustersResponse>.globalClusters(): Flow<GlobalCluster> =
    transform() { response ->
        response.globalClusters?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeOrderableDbInstanceOptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeOrderableDbInstanceOptionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeOrderableDbInstanceOptionsResponse]
 */
public fun NeptuneClient.describeOrderableDbInstanceOptionsPaginated(initialRequest: DescribeOrderableDbInstanceOptionsRequest): Flow<DescribeOrderableDbInstanceOptionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeOrderableDbInstanceOptionsPaginated.describeOrderableDbInstanceOptions(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeOrderableDbInstanceOptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeOrderableDbInstanceOptionsResponse]
 */
public fun NeptuneClient.describeOrderableDbInstanceOptionsPaginated(block: DescribeOrderableDbInstanceOptionsRequest.Builder.() -> Unit): Flow<DescribeOrderableDbInstanceOptionsResponse> =
    describeOrderableDbInstanceOptionsPaginated(DescribeOrderableDbInstanceOptionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeOrderableDbInstanceOptionsPaginated]
 * to access the nested member [OrderableDbInstanceOption]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [OrderableDbInstanceOption]
 */
@JvmName("describeOrderableDbInstanceOptionsResponseOrderableDbInstanceOption")
public fun Flow<DescribeOrderableDbInstanceOptionsResponse>.orderableDbInstanceOptions(): Flow<OrderableDbInstanceOption> =
    transform() { response ->
        response.orderableDbInstanceOptions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribePendingMaintenanceActionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribePendingMaintenanceActionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribePendingMaintenanceActionsResponse]
 */
public fun NeptuneClient.describePendingMaintenanceActionsPaginated(initialRequest: DescribePendingMaintenanceActionsRequest = DescribePendingMaintenanceActionsRequest { }): Flow<DescribePendingMaintenanceActionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describePendingMaintenanceActionsPaginated.describePendingMaintenanceActions(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribePendingMaintenanceActionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribePendingMaintenanceActionsResponse]
 */
public fun NeptuneClient.describePendingMaintenanceActionsPaginated(block: DescribePendingMaintenanceActionsRequest.Builder.() -> Unit): Flow<DescribePendingMaintenanceActionsResponse> =
    describePendingMaintenanceActionsPaginated(DescribePendingMaintenanceActionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describePendingMaintenanceActionsPaginated]
 * to access the nested member [ResourcePendingMaintenanceActions]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ResourcePendingMaintenanceActions]
 */
@JvmName("describePendingMaintenanceActionsResponseResourcePendingMaintenanceActions")
public fun Flow<DescribePendingMaintenanceActionsResponse>.pendingMaintenanceActions(): Flow<ResourcePendingMaintenanceActions> =
    transform() { response ->
        response.pendingMaintenanceActions?.forEach {
            emit(it)
        }
    }
