// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ModifyDbClusterSnapshotAttributeRequest private constructor(builder: Builder) {
    /**
     * The name of the DB cluster snapshot attribute to modify.
     *
     * To manage authorization for other Amazon accounts to copy or restore a manual DB cluster snapshot, set this value to `restore`.
     */
    public val attributeName: kotlin.String? = builder.attributeName
    /**
     * The identifier for the DB cluster snapshot to modify the attributes for.
     */
    public val dbClusterSnapshotIdentifier: kotlin.String? = builder.dbClusterSnapshotIdentifier
    /**
     * A list of DB cluster snapshot attributes to add to the attribute specified by `AttributeName`.
     *
     * To authorize other Amazon accounts to copy or restore a manual DB cluster snapshot, set this list to include one or more Amazon account IDs, or `all` to make the manual DB cluster snapshot restorable by any Amazon account. Do not add the `all` value for any manual DB cluster snapshots that contain private information that you don't want available to all Amazon accounts.
     */
    public val valuesToAdd: List<String>? = builder.valuesToAdd
    /**
     * A list of DB cluster snapshot attributes to remove from the attribute specified by `AttributeName`.
     *
     * To remove authorization for other Amazon accounts to copy or restore a manual DB cluster snapshot, set this list to include one or more Amazon account identifiers, or `all` to remove authorization for any Amazon account to copy or restore the DB cluster snapshot. If you specify `all`, an Amazon account whose account ID is explicitly added to the `restore` attribute can still copy or restore a manual DB cluster snapshot.
     */
    public val valuesToRemove: List<String>? = builder.valuesToRemove

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptune.model.ModifyDbClusterSnapshotAttributeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyDbClusterSnapshotAttributeRequest(")
        append("attributeName=$attributeName,")
        append("dbClusterSnapshotIdentifier=$dbClusterSnapshotIdentifier,")
        append("valuesToAdd=$valuesToAdd,")
        append("valuesToRemove=$valuesToRemove")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeName?.hashCode() ?: 0
        result = 31 * result + (dbClusterSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (valuesToAdd?.hashCode() ?: 0)
        result = 31 * result + (valuesToRemove?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyDbClusterSnapshotAttributeRequest

        if (attributeName != other.attributeName) return false
        if (dbClusterSnapshotIdentifier != other.dbClusterSnapshotIdentifier) return false
        if (valuesToAdd != other.valuesToAdd) return false
        if (valuesToRemove != other.valuesToRemove) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptune.model.ModifyDbClusterSnapshotAttributeRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the DB cluster snapshot attribute to modify.
         *
         * To manage authorization for other Amazon accounts to copy or restore a manual DB cluster snapshot, set this value to `restore`.
         */
        public var attributeName: kotlin.String? = null
        /**
         * The identifier for the DB cluster snapshot to modify the attributes for.
         */
        public var dbClusterSnapshotIdentifier: kotlin.String? = null
        /**
         * A list of DB cluster snapshot attributes to add to the attribute specified by `AttributeName`.
         *
         * To authorize other Amazon accounts to copy or restore a manual DB cluster snapshot, set this list to include one or more Amazon account IDs, or `all` to make the manual DB cluster snapshot restorable by any Amazon account. Do not add the `all` value for any manual DB cluster snapshots that contain private information that you don't want available to all Amazon accounts.
         */
        public var valuesToAdd: List<String>? = null
        /**
         * A list of DB cluster snapshot attributes to remove from the attribute specified by `AttributeName`.
         *
         * To remove authorization for other Amazon accounts to copy or restore a manual DB cluster snapshot, set this list to include one or more Amazon account identifiers, or `all` to remove authorization for any Amazon account to copy or restore the DB cluster snapshot. If you specify `all`, an Amazon account whose account ID is explicitly added to the `restore` attribute can still copy or restore a manual DB cluster snapshot.
         */
        public var valuesToRemove: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptune.model.ModifyDbClusterSnapshotAttributeRequest) : this() {
            this.attributeName = x.attributeName
            this.dbClusterSnapshotIdentifier = x.dbClusterSnapshotIdentifier
            this.valuesToAdd = x.valuesToAdd
            this.valuesToRemove = x.valuesToRemove
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptune.model.ModifyDbClusterSnapshotAttributeRequest = ModifyDbClusterSnapshotAttributeRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
