// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains the details of an Amazon Neptune global database.
 *
 * This data type is used as a response element for the CreateGlobalCluster, DescribeGlobalClusters, ModifyGlobalCluster, DeleteGlobalCluster, FailoverGlobalCluster, and RemoveFromGlobalCluster actions.
 */
public class GlobalCluster private constructor(builder: Builder) {
    /**
     * The deletion protection setting for the global database.
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * The Neptune database engine used by the global database (`"neptune"`).
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The Neptune engine version used by the global database.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The Amazon Resource Name (ARN) for the global database.
     */
    public val globalClusterArn: kotlin.String? = builder.globalClusterArn
    /**
     * Contains a user-supplied global database cluster identifier. This identifier is the unique key that identifies a global database.
     */
    public val globalClusterIdentifier: kotlin.String? = builder.globalClusterIdentifier
    /**
     * A list of cluster ARNs and instance ARNs for all the DB clusters that are part of the global database.
     */
    public val globalClusterMembers: List<GlobalClusterMember>? = builder.globalClusterMembers
    /**
     * An immutable identifier for the global database that is unique within in all regions. This identifier is found in CloudTrail log entries whenever the KMS key for the DB cluster is accessed.
     */
    public val globalClusterResourceId: kotlin.String? = builder.globalClusterResourceId
    /**
     * Specifies the current state of this global database.
     */
    public val status: kotlin.String? = builder.status
    /**
     * The storage encryption setting for the global database.
     */
    public val storageEncrypted: kotlin.Boolean? = builder.storageEncrypted

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptune.model.GlobalCluster = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GlobalCluster(")
        append("deletionProtection=$deletionProtection,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("globalClusterArn=$globalClusterArn,")
        append("globalClusterIdentifier=$globalClusterIdentifier,")
        append("globalClusterMembers=$globalClusterMembers,")
        append("globalClusterResourceId=$globalClusterResourceId,")
        append("status=$status,")
        append("storageEncrypted=$storageEncrypted")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deletionProtection?.hashCode() ?: 0
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (globalClusterArn?.hashCode() ?: 0)
        result = 31 * result + (globalClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (globalClusterMembers?.hashCode() ?: 0)
        result = 31 * result + (globalClusterResourceId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (storageEncrypted?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GlobalCluster

        if (deletionProtection != other.deletionProtection) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (globalClusterArn != other.globalClusterArn) return false
        if (globalClusterIdentifier != other.globalClusterIdentifier) return false
        if (globalClusterMembers != other.globalClusterMembers) return false
        if (globalClusterResourceId != other.globalClusterResourceId) return false
        if (status != other.status) return false
        if (storageEncrypted != other.storageEncrypted) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptune.model.GlobalCluster = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The deletion protection setting for the global database.
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * The Neptune database engine used by the global database (`"neptune"`).
         */
        public var engine: kotlin.String? = null
        /**
         * The Neptune engine version used by the global database.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the global database.
         */
        public var globalClusterArn: kotlin.String? = null
        /**
         * Contains a user-supplied global database cluster identifier. This identifier is the unique key that identifies a global database.
         */
        public var globalClusterIdentifier: kotlin.String? = null
        /**
         * A list of cluster ARNs and instance ARNs for all the DB clusters that are part of the global database.
         */
        public var globalClusterMembers: List<GlobalClusterMember>? = null
        /**
         * An immutable identifier for the global database that is unique within in all regions. This identifier is found in CloudTrail log entries whenever the KMS key for the DB cluster is accessed.
         */
        public var globalClusterResourceId: kotlin.String? = null
        /**
         * Specifies the current state of this global database.
         */
        public var status: kotlin.String? = null
        /**
         * The storage encryption setting for the global database.
         */
        public var storageEncrypted: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptune.model.GlobalCluster) : this() {
            this.deletionProtection = x.deletionProtection
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.globalClusterArn = x.globalClusterArn
            this.globalClusterIdentifier = x.globalClusterIdentifier
            this.globalClusterMembers = x.globalClusterMembers
            this.globalClusterResourceId = x.globalClusterResourceId
            this.status = x.status
            this.storageEncrypted = x.storageEncrypted
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptune.model.GlobalCluster = GlobalCluster(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
