// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This data type is used as a response element in the action DescribeDBEngineVersions.
 */
public class DbEngineVersion private constructor(builder: Builder) {
    /**
     * The description of the database engine.
     */
    public val dbEngineDescription: kotlin.String? = builder.dbEngineDescription
    /**
     * The description of the database engine version.
     */
    public val dbEngineVersionDescription: kotlin.String? = builder.dbEngineVersionDescription
    /**
     * The name of the DB parameter group family for the database engine.
     */
    public val dbParameterGroupFamily: kotlin.String? = builder.dbParameterGroupFamily
    /**
     * *(Not supported by Neptune)*
     */
    public val defaultCharacterSet: aws.sdk.kotlin.services.neptune.model.CharacterSet? = builder.defaultCharacterSet
    /**
     * The name of the database engine.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The version number of the database engine.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The types of logs that the database engine has available for export to CloudWatch Logs.
     */
    public val exportableLogTypes: List<String>? = builder.exportableLogTypes
    /**
     * *(Not supported by Neptune)*
     */
    public val supportedCharacterSets: List<CharacterSet>? = builder.supportedCharacterSets
    /**
     * A list of the time zones supported by this engine for the `Timezone` parameter of the `CreateDBInstance` action.
     */
    public val supportedTimezones: List<Timezone>? = builder.supportedTimezones
    /**
     * A value that indicates whether you can use Aurora global databases with a specific DB engine version.
     */
    public val supportsGlobalDatabases: kotlin.Boolean? = builder.supportsGlobalDatabases
    /**
     * A value that indicates whether the engine version supports exporting the log types specified by ExportableLogTypes to CloudWatch Logs.
     */
    public val supportsLogExportsToCloudwatchLogs: kotlin.Boolean? = builder.supportsLogExportsToCloudwatchLogs
    /**
     * Indicates whether the database engine version supports read replicas.
     */
    public val supportsReadReplica: kotlin.Boolean? = builder.supportsReadReplica
    /**
     * A list of engine versions that this database engine version can be upgraded to.
     */
    public val validUpgradeTarget: List<UpgradeTarget>? = builder.validUpgradeTarget

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptune.model.DbEngineVersion = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbEngineVersion(")
        append("dbEngineDescription=$dbEngineDescription,")
        append("dbEngineVersionDescription=$dbEngineVersionDescription,")
        append("dbParameterGroupFamily=$dbParameterGroupFamily,")
        append("defaultCharacterSet=$defaultCharacterSet,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("exportableLogTypes=$exportableLogTypes,")
        append("supportedCharacterSets=$supportedCharacterSets,")
        append("supportedTimezones=$supportedTimezones,")
        append("supportsGlobalDatabases=$supportsGlobalDatabases,")
        append("supportsLogExportsToCloudwatchLogs=$supportsLogExportsToCloudwatchLogs,")
        append("supportsReadReplica=$supportsReadReplica,")
        append("validUpgradeTarget=$validUpgradeTarget")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbEngineDescription?.hashCode() ?: 0
        result = 31 * result + (dbEngineVersionDescription?.hashCode() ?: 0)
        result = 31 * result + (dbParameterGroupFamily?.hashCode() ?: 0)
        result = 31 * result + (defaultCharacterSet?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (exportableLogTypes?.hashCode() ?: 0)
        result = 31 * result + (supportedCharacterSets?.hashCode() ?: 0)
        result = 31 * result + (supportedTimezones?.hashCode() ?: 0)
        result = 31 * result + (supportsGlobalDatabases?.hashCode() ?: 0)
        result = 31 * result + (supportsLogExportsToCloudwatchLogs?.hashCode() ?: 0)
        result = 31 * result + (supportsReadReplica?.hashCode() ?: 0)
        result = 31 * result + (validUpgradeTarget?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbEngineVersion

        if (dbEngineDescription != other.dbEngineDescription) return false
        if (dbEngineVersionDescription != other.dbEngineVersionDescription) return false
        if (dbParameterGroupFamily != other.dbParameterGroupFamily) return false
        if (defaultCharacterSet != other.defaultCharacterSet) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (exportableLogTypes != other.exportableLogTypes) return false
        if (supportedCharacterSets != other.supportedCharacterSets) return false
        if (supportedTimezones != other.supportedTimezones) return false
        if (supportsGlobalDatabases != other.supportsGlobalDatabases) return false
        if (supportsLogExportsToCloudwatchLogs != other.supportsLogExportsToCloudwatchLogs) return false
        if (supportsReadReplica != other.supportsReadReplica) return false
        if (validUpgradeTarget != other.validUpgradeTarget) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptune.model.DbEngineVersion = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The description of the database engine.
         */
        public var dbEngineDescription: kotlin.String? = null
        /**
         * The description of the database engine version.
         */
        public var dbEngineVersionDescription: kotlin.String? = null
        /**
         * The name of the DB parameter group family for the database engine.
         */
        public var dbParameterGroupFamily: kotlin.String? = null
        /**
         * *(Not supported by Neptune)*
         */
        public var defaultCharacterSet: aws.sdk.kotlin.services.neptune.model.CharacterSet? = null
        /**
         * The name of the database engine.
         */
        public var engine: kotlin.String? = null
        /**
         * The version number of the database engine.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The types of logs that the database engine has available for export to CloudWatch Logs.
         */
        public var exportableLogTypes: List<String>? = null
        /**
         * *(Not supported by Neptune)*
         */
        public var supportedCharacterSets: List<CharacterSet>? = null
        /**
         * A list of the time zones supported by this engine for the `Timezone` parameter of the `CreateDBInstance` action.
         */
        public var supportedTimezones: List<Timezone>? = null
        /**
         * A value that indicates whether you can use Aurora global databases with a specific DB engine version.
         */
        public var supportsGlobalDatabases: kotlin.Boolean? = null
        /**
         * A value that indicates whether the engine version supports exporting the log types specified by ExportableLogTypes to CloudWatch Logs.
         */
        public var supportsLogExportsToCloudwatchLogs: kotlin.Boolean? = null
        /**
         * Indicates whether the database engine version supports read replicas.
         */
        public var supportsReadReplica: kotlin.Boolean? = null
        /**
         * A list of engine versions that this database engine version can be upgraded to.
         */
        public var validUpgradeTarget: List<UpgradeTarget>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptune.model.DbEngineVersion) : this() {
            this.dbEngineDescription = x.dbEngineDescription
            this.dbEngineVersionDescription = x.dbEngineVersionDescription
            this.dbParameterGroupFamily = x.dbParameterGroupFamily
            this.defaultCharacterSet = x.defaultCharacterSet
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.exportableLogTypes = x.exportableLogTypes
            this.supportedCharacterSets = x.supportedCharacterSets
            this.supportedTimezones = x.supportedTimezones
            this.supportsGlobalDatabases = x.supportsGlobalDatabases
            this.supportsLogExportsToCloudwatchLogs = x.supportsLogExportsToCloudwatchLogs
            this.supportsReadReplica = x.supportsReadReplica
            this.validUpgradeTarget = x.validUpgradeTarget
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptune.model.DbEngineVersion = DbEngineVersion(this)

        /**
         * construct an [aws.sdk.kotlin.services.neptune.model.CharacterSet] inside the given [block]
         */
        public fun defaultCharacterSet(block: aws.sdk.kotlin.services.neptune.model.CharacterSet.Builder.() -> kotlin.Unit) {
            this.defaultCharacterSet = aws.sdk.kotlin.services.neptune.model.CharacterSet.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
