// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateEventSubscriptionRequest private constructor(builder: Builder) {
    /**
     * A Boolean value; set to **true** to activate the subscription, set to **false** to create the subscription but not active it.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * A list of event categories for a SourceType that you want to subscribe to. You can see a list of the categories for a given SourceType by using the **DescribeEventCategories** action.
     */
    public val eventCategories: List<String>? = builder.eventCategories
    /**
     * The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it.
     */
    public val snsTopicArn: kotlin.String? = builder.snsTopicArn
    /**
     * The list of identifiers of the event sources for which events are returned. If not specified, then all sources are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
     *
     * Constraints:
     * + If SourceIds are supplied, SourceType must also be provided.
     * + If the source type is a DB instance, then a `DBInstanceIdentifier` must be supplied.
     * + If the source type is a DB security group, a `DBSecurityGroupName` must be supplied.
     * + If the source type is a DB parameter group, a `DBParameterGroupName` must be supplied.
     * + If the source type is a DB snapshot, a `DBSnapshotIdentifier` must be supplied.
     */
    public val sourceIds: List<String>? = builder.sourceIds
    /**
     * The type of source that is generating the events. For example, if you want to be notified of events generated by a DB instance, you would set this parameter to db-instance. if this value is not specified, all events are returned.
     *
     * Valid values: `db-instance` | `db-cluster` | `db-parameter-group` | `db-security-group` | `db-snapshot` | `db-cluster-snapshot`
     */
    public val sourceType: kotlin.String? = builder.sourceType
    /**
     * The name of the subscription.
     *
     * Constraints: The name must be less than 255 characters.
     */
    public val subscriptionName: kotlin.String? = builder.subscriptionName
    /**
     * The tags to be applied to the new event subscription.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptune.model.CreateEventSubscriptionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateEventSubscriptionRequest(")
        append("enabled=$enabled,")
        append("eventCategories=$eventCategories,")
        append("snsTopicArn=$snsTopicArn,")
        append("sourceIds=$sourceIds,")
        append("sourceType=$sourceType,")
        append("subscriptionName=$subscriptionName,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled?.hashCode() ?: 0
        result = 31 * result + (eventCategories?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (sourceIds?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        result = 31 * result + (subscriptionName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateEventSubscriptionRequest

        if (enabled != other.enabled) return false
        if (eventCategories != other.eventCategories) return false
        if (snsTopicArn != other.snsTopicArn) return false
        if (sourceIds != other.sourceIds) return false
        if (sourceType != other.sourceType) return false
        if (subscriptionName != other.subscriptionName) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptune.model.CreateEventSubscriptionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A Boolean value; set to **true** to activate the subscription, set to **false** to create the subscription but not active it.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * A list of event categories for a SourceType that you want to subscribe to. You can see a list of the categories for a given SourceType by using the **DescribeEventCategories** action.
         */
        public var eventCategories: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it.
         */
        public var snsTopicArn: kotlin.String? = null
        /**
         * The list of identifiers of the event sources for which events are returned. If not specified, then all sources are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
         *
         * Constraints:
         * + If SourceIds are supplied, SourceType must also be provided.
         * + If the source type is a DB instance, then a `DBInstanceIdentifier` must be supplied.
         * + If the source type is a DB security group, a `DBSecurityGroupName` must be supplied.
         * + If the source type is a DB parameter group, a `DBParameterGroupName` must be supplied.
         * + If the source type is a DB snapshot, a `DBSnapshotIdentifier` must be supplied.
         */
        public var sourceIds: List<String>? = null
        /**
         * The type of source that is generating the events. For example, if you want to be notified of events generated by a DB instance, you would set this parameter to db-instance. if this value is not specified, all events are returned.
         *
         * Valid values: `db-instance` | `db-cluster` | `db-parameter-group` | `db-security-group` | `db-snapshot` | `db-cluster-snapshot`
         */
        public var sourceType: kotlin.String? = null
        /**
         * The name of the subscription.
         *
         * Constraints: The name must be less than 255 characters.
         */
        public var subscriptionName: kotlin.String? = null
        /**
         * The tags to be applied to the new event subscription.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptune.model.CreateEventSubscriptionRequest) : this() {
            this.enabled = x.enabled
            this.eventCategories = x.eventCategories
            this.snsTopicArn = x.snsTopicArn
            this.sourceIds = x.sourceIds
            this.sourceType = x.sourceType
            this.subscriptionName = x.subscriptionName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptune.model.CreateEventSubscriptionRequest = CreateEventSubscriptionRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
