// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.serde

import aws.sdk.kotlin.services.neptune.model.GlobalCluster
import aws.sdk.kotlin.services.neptune.model.NeptuneException
import aws.sdk.kotlin.services.neptune.model.RemoveFromGlobalClusterResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class RemoveFromGlobalClusterOperationDeserializer: HttpDeserializer.NonStreaming<RemoveFromGlobalClusterResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): RemoveFromGlobalClusterResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwRemoveFromGlobalClusterError(context, call, payload)
        }
        val builder = RemoveFromGlobalClusterResponse.Builder()

        if (payload != null) {
            deserializeRemoveFromGlobalClusterOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwRemoveFromGlobalClusterError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw NeptuneException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBClusterNotFoundFault" -> DbClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "GlobalClusterNotFoundFault" -> GlobalClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidGlobalClusterStateFault" -> InvalidGlobalClusterStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> NeptuneException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRemoveFromGlobalClusterOperationBody(builder: RemoveFromGlobalClusterResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "RemoveFromGlobalCluster")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // GlobalCluster com.amazonaws.neptune#RemoveFromGlobalClusterResult$GlobalCluster
            "GlobalCluster" -> builder.globalCluster = deserializeGlobalClusterDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
