// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.serde

import aws.sdk.kotlin.services.neptune.model.CreateDbSubnetGroupResponse
import aws.sdk.kotlin.services.neptune.model.DbSubnetGroup
import aws.sdk.kotlin.services.neptune.model.NeptuneException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateDBSubnetGroupOperationDeserializer: HttpDeserializer.NonStreaming<CreateDbSubnetGroupResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateDbSubnetGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateDbSubnetGroupError(context, call, payload)
        }
        val builder = CreateDbSubnetGroupResponse.Builder()

        if (payload != null) {
            deserializeCreateDBSubnetGroupOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateDbSubnetGroupError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw NeptuneException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBSubnetGroupDoesNotCoverEnoughAZs" -> DbSubnetGroupDoesNotCoverEnoughAzsDeserializer().deserialize(context, wrappedCall, payload)
        "DBSubnetGroupQuotaExceeded" -> DbSubnetGroupQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBSubnetQuotaExceededFault" -> DbSubnetQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBSubnetGroupAlreadyExists" -> DbSubnetGroupAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidSubnet" -> InvalidSubnetDeserializer().deserialize(context, wrappedCall, payload)
        else -> NeptuneException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateDBSubnetGroupOperationBody(builder: CreateDbSubnetGroupResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateDBSubnetGroup")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBSubnetGroup com.amazonaws.neptune#CreateDBSubnetGroupResult$DBSubnetGroup
            "DBSubnetGroup" -> builder.dbSubnetGroup = deserializeDbSubnetGroupDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
