// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The version of the database engine that a DB instance can be upgraded to.
 */
public class UpgradeTarget private constructor(builder: Builder) {
    /**
     * A value that indicates whether the target version is applied to any source DB instances that have AutoMinorVersionUpgrade set to true.
     */
    public val autoUpgrade: kotlin.Boolean? = builder.autoUpgrade
    /**
     * The version of the database engine that a DB instance can be upgraded to.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the upgrade target database engine.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The version number of the upgrade target database engine.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * A value that indicates whether a database engine is upgraded to a major version.
     */
    public val isMajorVersionUpgrade: kotlin.Boolean? = builder.isMajorVersionUpgrade
    /**
     * A value that indicates whether you can use Neptune global databases with the target engine version.
     */
    public val supportsGlobalDatabases: kotlin.Boolean? = builder.supportsGlobalDatabases

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptune.model.UpgradeTarget = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpgradeTarget(")
        append("autoUpgrade=$autoUpgrade,")
        append("description=$description,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("isMajorVersionUpgrade=$isMajorVersionUpgrade,")
        append("supportsGlobalDatabases=$supportsGlobalDatabases")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoUpgrade?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (isMajorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (supportsGlobalDatabases?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpgradeTarget

        if (autoUpgrade != other.autoUpgrade) return false
        if (description != other.description) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (isMajorVersionUpgrade != other.isMajorVersionUpgrade) return false
        if (supportsGlobalDatabases != other.supportsGlobalDatabases) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptune.model.UpgradeTarget = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A value that indicates whether the target version is applied to any source DB instances that have AutoMinorVersionUpgrade set to true.
         */
        public var autoUpgrade: kotlin.Boolean? = null
        /**
         * The version of the database engine that a DB instance can be upgraded to.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the upgrade target database engine.
         */
        public var engine: kotlin.String? = null
        /**
         * The version number of the upgrade target database engine.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * A value that indicates whether a database engine is upgraded to a major version.
         */
        public var isMajorVersionUpgrade: kotlin.Boolean? = null
        /**
         * A value that indicates whether you can use Neptune global databases with the target engine version.
         */
        public var supportsGlobalDatabases: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptune.model.UpgradeTarget) : this() {
            this.autoUpgrade = x.autoUpgrade
            this.description = x.description
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.isMajorVersionUpgrade = x.isMajorVersionUpgrade
            this.supportsGlobalDatabases = x.supportsGlobalDatabases
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptune.model.UpgradeTarget = UpgradeTarget(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
