// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains a list of available options for a DB instance.
 *
 *  This data type is used as a response element in the DescribeOrderableDBInstanceOptions action.
 */
public class OrderableDbInstanceOption private constructor(builder: Builder) {
    /**
     * A list of Availability Zones for a DB instance.
     */
    public val availabilityZones: List<AvailabilityZone>? = builder.availabilityZones
    /**
     * The DB instance class for a DB instance.
     */
    public val dbInstanceClass: kotlin.String? = builder.dbInstanceClass
    /**
     * The engine type of a DB instance.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The engine version of a DB instance.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The license model for a DB instance.
     */
    public val licenseModel: kotlin.String? = builder.licenseModel
    /**
     * Maximum total provisioned IOPS for a DB instance.
     */
    public val maxIopsPerDbInstance: kotlin.Int? = builder.maxIopsPerDbInstance
    /**
     * Maximum provisioned IOPS per GiB for a DB instance.
     */
    public val maxIopsPerGib: kotlin.Double? = builder.maxIopsPerGib
    /**
     * Maximum storage size for a DB instance.
     */
    public val maxStorageSize: kotlin.Int? = builder.maxStorageSize
    /**
     * Minimum total provisioned IOPS for a DB instance.
     */
    public val minIopsPerDbInstance: kotlin.Int? = builder.minIopsPerDbInstance
    /**
     * Minimum provisioned IOPS per GiB for a DB instance.
     */
    public val minIopsPerGib: kotlin.Double? = builder.minIopsPerGib
    /**
     * Minimum storage size for a DB instance.
     */
    public val minStorageSize: kotlin.Int? = builder.minStorageSize
    /**
     * Indicates whether a DB instance is Multi-AZ capable.
     */
    public val multiAzCapable: kotlin.Boolean? = builder.multiAzCapable
    /**
     * Indicates whether a DB instance can have a Read Replica.
     */
    public val readReplicaCapable: kotlin.Boolean? = builder.readReplicaCapable
    /**
     * Indicates the storage type for a DB instance.
     */
    public val storageType: kotlin.String? = builder.storageType
    /**
     * Indicates whether a DB instance supports Enhanced Monitoring at intervals from 1 to 60 seconds.
     */
    public val supportsEnhancedMonitoring: kotlin.Boolean? = builder.supportsEnhancedMonitoring
    /**
     * A value that indicates whether you can use Neptune global databases with a specific combination of other DB engine attributes.
     */
    public val supportsGlobalDatabases: kotlin.Boolean? = builder.supportsGlobalDatabases
    /**
     * Indicates whether a DB instance supports IAM database authentication.
     */
    public val supportsIamDatabaseAuthentication: kotlin.Boolean? = builder.supportsIamDatabaseAuthentication
    /**
     * Indicates whether a DB instance supports provisioned IOPS.
     */
    public val supportsIops: kotlin.Boolean? = builder.supportsIops
    /**
     * *(Not supported by Neptune)*
     */
    public val supportsPerformanceInsights: kotlin.Boolean? = builder.supportsPerformanceInsights
    /**
     * Indicates whether a DB instance supports encrypted storage.
     */
    public val supportsStorageEncryption: kotlin.Boolean? = builder.supportsStorageEncryption
    /**
     * Indicates whether a DB instance is in a VPC.
     */
    public val vpc: kotlin.Boolean? = builder.vpc

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptune.model.OrderableDbInstanceOption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OrderableDbInstanceOption(")
        append("availabilityZones=$availabilityZones,")
        append("dbInstanceClass=$dbInstanceClass,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("licenseModel=$licenseModel,")
        append("maxIopsPerDbInstance=$maxIopsPerDbInstance,")
        append("maxIopsPerGib=$maxIopsPerGib,")
        append("maxStorageSize=$maxStorageSize,")
        append("minIopsPerDbInstance=$minIopsPerDbInstance,")
        append("minIopsPerGib=$minIopsPerGib,")
        append("minStorageSize=$minStorageSize,")
        append("multiAzCapable=$multiAzCapable,")
        append("readReplicaCapable=$readReplicaCapable,")
        append("storageType=$storageType,")
        append("supportsEnhancedMonitoring=$supportsEnhancedMonitoring,")
        append("supportsGlobalDatabases=$supportsGlobalDatabases,")
        append("supportsIamDatabaseAuthentication=$supportsIamDatabaseAuthentication,")
        append("supportsIops=$supportsIops,")
        append("supportsPerformanceInsights=$supportsPerformanceInsights,")
        append("supportsStorageEncryption=$supportsStorageEncryption,")
        append("vpc=$vpc")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZones?.hashCode() ?: 0
        result = 31 * result + (dbInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (licenseModel?.hashCode() ?: 0)
        result = 31 * result + (maxIopsPerDbInstance ?: 0)
        result = 31 * result + (maxIopsPerGib?.hashCode() ?: 0)
        result = 31 * result + (maxStorageSize ?: 0)
        result = 31 * result + (minIopsPerDbInstance ?: 0)
        result = 31 * result + (minIopsPerGib?.hashCode() ?: 0)
        result = 31 * result + (minStorageSize ?: 0)
        result = 31 * result + (multiAzCapable?.hashCode() ?: 0)
        result = 31 * result + (readReplicaCapable?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (supportsEnhancedMonitoring?.hashCode() ?: 0)
        result = 31 * result + (supportsGlobalDatabases?.hashCode() ?: 0)
        result = 31 * result + (supportsIamDatabaseAuthentication?.hashCode() ?: 0)
        result = 31 * result + (supportsIops?.hashCode() ?: 0)
        result = 31 * result + (supportsPerformanceInsights?.hashCode() ?: 0)
        result = 31 * result + (supportsStorageEncryption?.hashCode() ?: 0)
        result = 31 * result + (vpc?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OrderableDbInstanceOption

        if (availabilityZones != other.availabilityZones) return false
        if (dbInstanceClass != other.dbInstanceClass) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (licenseModel != other.licenseModel) return false
        if (maxIopsPerDbInstance != other.maxIopsPerDbInstance) return false
        if (maxIopsPerGib != other.maxIopsPerGib) return false
        if (maxStorageSize != other.maxStorageSize) return false
        if (minIopsPerDbInstance != other.minIopsPerDbInstance) return false
        if (minIopsPerGib != other.minIopsPerGib) return false
        if (minStorageSize != other.minStorageSize) return false
        if (multiAzCapable != other.multiAzCapable) return false
        if (readReplicaCapable != other.readReplicaCapable) return false
        if (storageType != other.storageType) return false
        if (supportsEnhancedMonitoring != other.supportsEnhancedMonitoring) return false
        if (supportsGlobalDatabases != other.supportsGlobalDatabases) return false
        if (supportsIamDatabaseAuthentication != other.supportsIamDatabaseAuthentication) return false
        if (supportsIops != other.supportsIops) return false
        if (supportsPerformanceInsights != other.supportsPerformanceInsights) return false
        if (supportsStorageEncryption != other.supportsStorageEncryption) return false
        if (vpc != other.vpc) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptune.model.OrderableDbInstanceOption = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of Availability Zones for a DB instance.
         */
        public var availabilityZones: List<AvailabilityZone>? = null
        /**
         * The DB instance class for a DB instance.
         */
        public var dbInstanceClass: kotlin.String? = null
        /**
         * The engine type of a DB instance.
         */
        public var engine: kotlin.String? = null
        /**
         * The engine version of a DB instance.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The license model for a DB instance.
         */
        public var licenseModel: kotlin.String? = null
        /**
         * Maximum total provisioned IOPS for a DB instance.
         */
        public var maxIopsPerDbInstance: kotlin.Int? = null
        /**
         * Maximum provisioned IOPS per GiB for a DB instance.
         */
        public var maxIopsPerGib: kotlin.Double? = null
        /**
         * Maximum storage size for a DB instance.
         */
        public var maxStorageSize: kotlin.Int? = null
        /**
         * Minimum total provisioned IOPS for a DB instance.
         */
        public var minIopsPerDbInstance: kotlin.Int? = null
        /**
         * Minimum provisioned IOPS per GiB for a DB instance.
         */
        public var minIopsPerGib: kotlin.Double? = null
        /**
         * Minimum storage size for a DB instance.
         */
        public var minStorageSize: kotlin.Int? = null
        /**
         * Indicates whether a DB instance is Multi-AZ capable.
         */
        public var multiAzCapable: kotlin.Boolean? = null
        /**
         * Indicates whether a DB instance can have a Read Replica.
         */
        public var readReplicaCapable: kotlin.Boolean? = null
        /**
         * Indicates the storage type for a DB instance.
         */
        public var storageType: kotlin.String? = null
        /**
         * Indicates whether a DB instance supports Enhanced Monitoring at intervals from 1 to 60 seconds.
         */
        public var supportsEnhancedMonitoring: kotlin.Boolean? = null
        /**
         * A value that indicates whether you can use Neptune global databases with a specific combination of other DB engine attributes.
         */
        public var supportsGlobalDatabases: kotlin.Boolean? = null
        /**
         * Indicates whether a DB instance supports IAM database authentication.
         */
        public var supportsIamDatabaseAuthentication: kotlin.Boolean? = null
        /**
         * Indicates whether a DB instance supports provisioned IOPS.
         */
        public var supportsIops: kotlin.Boolean? = null
        /**
         * *(Not supported by Neptune)*
         */
        public var supportsPerformanceInsights: kotlin.Boolean? = null
        /**
         * Indicates whether a DB instance supports encrypted storage.
         */
        public var supportsStorageEncryption: kotlin.Boolean? = null
        /**
         * Indicates whether a DB instance is in a VPC.
         */
        public var vpc: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptune.model.OrderableDbInstanceOption) : this() {
            this.availabilityZones = x.availabilityZones
            this.dbInstanceClass = x.dbInstanceClass
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.licenseModel = x.licenseModel
            this.maxIopsPerDbInstance = x.maxIopsPerDbInstance
            this.maxIopsPerGib = x.maxIopsPerGib
            this.maxStorageSize = x.maxStorageSize
            this.minIopsPerDbInstance = x.minIopsPerDbInstance
            this.minIopsPerGib = x.minIopsPerGib
            this.minStorageSize = x.minStorageSize
            this.multiAzCapable = x.multiAzCapable
            this.readReplicaCapable = x.readReplicaCapable
            this.storageType = x.storageType
            this.supportsEnhancedMonitoring = x.supportsEnhancedMonitoring
            this.supportsGlobalDatabases = x.supportsGlobalDatabases
            this.supportsIamDatabaseAuthentication = x.supportsIamDatabaseAuthentication
            this.supportsIops = x.supportsIops
            this.supportsPerformanceInsights = x.supportsPerformanceInsights
            this.supportsStorageEncryption = x.supportsStorageEncryption
            this.vpc = x.vpc
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptune.model.OrderableDbInstanceOption = OrderableDbInstanceOption(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
