// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ModifyDbInstanceRequest private constructor(builder: Builder) {
    /**
     * Not supported by Neptune.
     */
    public val allocatedStorage: kotlin.Int? = builder.allocatedStorage
    /**
     * Indicates that major version upgrades are allowed. Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible.
     */
    public val allowMajorVersionUpgrade: kotlin.Boolean? = builder.allowMajorVersionUpgrade
    /**
     * Specifies whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the `PreferredMaintenanceWindow` setting for the DB instance.
     *
     *  If this parameter is set to `false`, changes to the DB instance are applied during the next maintenance window. Some parameter changes can cause an outage and are applied on the next call to RebootDBInstance, or the next failure reboot.
     *
     * Default: `false`
     */
    public val applyImmediately: kotlin.Boolean? = builder.applyImmediately
    /**
     * Indicates that minor version upgrades are applied automatically to the DB instance during the maintenance window. Changing this parameter doesn't result in an outage except in the following case and the change is asynchronously applied as soon as possible. An outage will result if this parameter is set to `true` during the maintenance window, and a newer minor version is available, and Neptune has enabled auto patching for that engine version.
     */
    public val autoMinorVersionUpgrade: kotlin.Boolean? = builder.autoMinorVersionUpgrade
    /**
     * Not applicable. The retention period for automated backups is managed by the DB cluster. For more information, see ModifyDBCluster.
     *
     * Default: Uses existing setting
     */
    public val backupRetentionPeriod: kotlin.Int? = builder.backupRetentionPeriod
    /**
     * Indicates the certificate that needs to be associated with the instance.
     */
    public val caCertificateIdentifier: kotlin.String? = builder.caCertificateIdentifier
    /**
     * The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB instance or DB cluster.
     */
    public val cloudwatchLogsExportConfiguration: aws.sdk.kotlin.services.neptune.model.CloudwatchLogsExportConfiguration? = builder.cloudwatchLogsExportConfiguration
    /**
     * True to copy all tags from the DB instance to snapshots of the DB instance, and otherwise false. The default is false.
     */
    public val copyTagsToSnapshot: kotlin.Boolean? = builder.copyTagsToSnapshot
    /**
     * The new compute and memory capacity of the DB instance, for example, `db.m4.large`. Not all DB instance classes are available in all Amazon Regions.
     *
     * If you modify the DB instance class, an outage occurs during the change. The change is applied during the next maintenance window, unless `ApplyImmediately` is specified as `true` for this request.
     *
     * Default: Uses existing setting
     */
    public val dbInstanceClass: kotlin.String? = builder.dbInstanceClass
    /**
     * The DB instance identifier. This value is stored as a lowercase string.
     *
     * Constraints:
     * + Must match the identifier of an existing DBInstance.
     */
    public val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * The name of the DB parameter group to apply to the DB instance. Changing this setting doesn't result in an outage. The parameter group name itself is changed immediately, but the actual parameter changes are not applied until you reboot the instance without failover. The db instance will NOT be rebooted automatically and the parameter changes will NOT be applied during the next maintenance window.
     *
     * Default: Uses existing setting
     *
     * Constraints: The DB parameter group must be in the same DB parameter group family as this DB instance.
     */
    public val dbParameterGroupName: kotlin.String? = builder.dbParameterGroupName
    /**
     * The port number on which the database accepts connections.
     *
     * The value of the `DBPortNumber` parameter must not match any of the port values specified for options in the option group for the DB instance.
     *
     * Your database will restart when you change the `DBPortNumber` value regardless of the value of the `ApplyImmediately` parameter.
     *
     *  Default: `8182`
     */
    public val dbPortNumber: kotlin.Int? = builder.dbPortNumber
    /**
     * A list of DB security groups to authorize on this DB instance. Changing this setting doesn't result in an outage and the change is asynchronously applied as soon as possible.
     *
     * Constraints:
     * + If supplied, must match existing DBSecurityGroups.
     */
    public val dbSecurityGroups: List<String>? = builder.dbSecurityGroups
    /**
     * The new DB subnet group for the DB instance. You can use this parameter to move your DB instance to a different VPC.
     *
     * Changing the subnet group causes an outage during the change. The change is applied during the next maintenance window, unless you specify `true` for the `ApplyImmediately` parameter.
     *
     * Constraints: If supplied, must match the name of an existing DBSubnetGroup.
     *
     * Example: `mySubnetGroup`
     */
    public val dbSubnetGroupName: kotlin.String? = builder.dbSubnetGroupName
    /**
     * A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. See [Deleting a DB Instance](https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html).
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * Not supported.
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * Not supported
     */
    public val domainIamRoleName: kotlin.String? = builder.domainIamRoleName
    /**
     * True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database accounts, and otherwise false.
     *
     * You can enable IAM database authentication for the following database engines
     *
     * Not applicable. Mapping Amazon IAM accounts to database accounts is managed by the DB cluster. For more information, see ModifyDBCluster.
     *
     * Default: `false`
     */
    public val enableIamDatabaseAuthentication: kotlin.Boolean? = builder.enableIamDatabaseAuthentication
    /**
     * *(Not supported by Neptune)*
     */
    public val enablePerformanceInsights: kotlin.Boolean? = builder.enablePerformanceInsights
    /**
     * The version number of the database engine to upgrade to. Currently, setting this parameter has no effect. To upgrade your database engine to the most recent release, use the ApplyPendingMaintenanceAction API.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The new Provisioned IOPS (I/O operations per second) value for the instance.
     *
     * Changing this setting doesn't result in an outage and the change is applied during the next maintenance window unless the `ApplyImmediately` parameter is set to `true` for this request.
     *
     * Default: Uses existing setting
     */
    public val iops: kotlin.Int? = builder.iops
    /**
     * Not supported by Neptune.
     */
    public val licenseModel: kotlin.String? = builder.licenseModel
    /**
     * Not supported by Neptune.
     */
    public val masterUserPassword: kotlin.String? = builder.masterUserPassword
    /**
     * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0.
     *
     * If `MonitoringRoleArn` is specified, then you must also set `MonitoringInterval` to a value other than 0.
     *
     * Valid Values: `0, 1, 5, 10, 15, 30, 60`
     */
    public val monitoringInterval: kotlin.Int? = builder.monitoringInterval
    /**
     * The ARN for the IAM role that permits Neptune to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, `arn:aws:iam:123456789012:role/emaccess`.
     *
     * If `MonitoringInterval` is set to a value other than 0, then you must supply a `MonitoringRoleArn` value.
     */
    public val monitoringRoleArn: kotlin.String? = builder.monitoringRoleArn
    /**
     * Specifies if the DB instance is a Multi-AZ deployment. Changing this parameter doesn't result in an outage and the change is applied during the next maintenance window unless the `ApplyImmediately` parameter is set to `true` for this request.
     */
    public val multiAz: kotlin.Boolean? = builder.multiAz
    /**
     * The new DB instance identifier for the DB instance when renaming a DB instance. When you change the DB instance identifier, an instance reboot will occur immediately if you set `Apply Immediately` to true, or will occur during the next maintenance window if `Apply Immediately` to false. This value is stored as a lowercase string.
     *
     * Constraints:
     * + Must contain from 1 to 63 letters, numbers, or hyphens.
     * + The first character must be a letter.
     * + Cannot end with a hyphen or contain two consecutive hyphens.
     *
     * Example: `mydbinstance`
     */
    public val newDbInstanceIdentifier: kotlin.String? = builder.newDbInstanceIdentifier
    /**
     * *(Not supported by Neptune)*
     */
    public val optionGroupName: kotlin.String? = builder.optionGroupName
    /**
     * *(Not supported by Neptune)*
     */
    public val performanceInsightsKmsKeyId: kotlin.String? = builder.performanceInsightsKmsKeyId
    /**
     * The daily time range during which automated backups are created if automated backups are enabled.
     *
     * Not applicable. The daily time range for creating automated backups is managed by the DB cluster. For more information, see ModifyDBCluster.
     *
     * Constraints:
     * + Must be in the format hh24:mi-hh24:mi
     * + Must be in Universal Time Coordinated (UTC)
     * + Must not conflict with the preferred maintenance window
     * + Must be at least 30 minutes
     */
    public val preferredBackupWindow: kotlin.String? = builder.preferredBackupWindow
    /**
     * The weekly time range (in UTC) during which system maintenance can occur, which might result in an outage. Changing this parameter doesn't result in an outage, except in the following situation, and the change is asynchronously applied as soon as possible. If there are pending actions that cause a reboot, and the maintenance window is changed to include the current time, then changing this parameter will cause a reboot of the DB instance. If moving this window to the current time, there must be at least 30 minutes between the current time and end of the window to ensure pending changes are applied.
     *
     * Default: Uses existing setting
     *
     * Format: ddd:hh24:mi-ddd:hh24:mi
     *
     * Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
     *
     * Constraints: Must be at least 30 minutes
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * A value that specifies the order in which a Read Replica is promoted to the primary instance after a failure of the existing primary instance.
     *
     * Default: 1
     *
     * Valid Values: 0 - 15
     */
    public val promotionTier: kotlin.Int? = builder.promotionTier
    /**
     * This flag should no longer be used.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * Not supported.
     */
    public val storageType: kotlin.String? = builder.storageType
    /**
     * The ARN from the key store with which to associate the instance for TDE encryption.
     */
    public val tdeCredentialArn: kotlin.String? = builder.tdeCredentialArn
    /**
     * The password for the given ARN from the key store in order to access the device.
     */
    public val tdeCredentialPassword: kotlin.String? = builder.tdeCredentialPassword
    /**
     * A list of EC2 VPC security groups to authorize on this DB instance. This change is asynchronously applied as soon as possible.
     *
     * Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. For more information, see ModifyDBCluster.
     *
     * Constraints:
     * + If supplied, must match existing VpcSecurityGroupIds.
     */
    public val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptune.model.ModifyDbInstanceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyDbInstanceRequest(")
        append("allocatedStorage=$allocatedStorage,")
        append("allowMajorVersionUpgrade=$allowMajorVersionUpgrade,")
        append("applyImmediately=$applyImmediately,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("caCertificateIdentifier=$caCertificateIdentifier,")
        append("cloudwatchLogsExportConfiguration=$cloudwatchLogsExportConfiguration,")
        append("copyTagsToSnapshot=$copyTagsToSnapshot,")
        append("dbInstanceClass=$dbInstanceClass,")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("dbParameterGroupName=$dbParameterGroupName,")
        append("dbPortNumber=$dbPortNumber,")
        append("dbSecurityGroups=$dbSecurityGroups,")
        append("dbSubnetGroupName=$dbSubnetGroupName,")
        append("deletionProtection=$deletionProtection,")
        append("domain=$domain,")
        append("domainIamRoleName=$domainIamRoleName,")
        append("enableIamDatabaseAuthentication=$enableIamDatabaseAuthentication,")
        append("enablePerformanceInsights=$enablePerformanceInsights,")
        append("engineVersion=$engineVersion,")
        append("iops=$iops,")
        append("licenseModel=$licenseModel,")
        append("masterUserPassword=$masterUserPassword,")
        append("monitoringInterval=$monitoringInterval,")
        append("monitoringRoleArn=$monitoringRoleArn,")
        append("multiAz=$multiAz,")
        append("newDbInstanceIdentifier=$newDbInstanceIdentifier,")
        append("optionGroupName=$optionGroupName,")
        append("performanceInsightsKmsKeyId=$performanceInsightsKmsKeyId,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("promotionTier=$promotionTier,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("storageType=$storageType,")
        append("tdeCredentialArn=$tdeCredentialArn,")
        append("tdeCredentialPassword=*** Sensitive Data Redacted ***,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage ?: 0
        result = 31 * result + (allowMajorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (applyImmediately?.hashCode() ?: 0)
        result = 31 * result + (autoMinorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (backupRetentionPeriod ?: 0)
        result = 31 * result + (caCertificateIdentifier?.hashCode() ?: 0)
        result = 31 * result + (cloudwatchLogsExportConfiguration?.hashCode() ?: 0)
        result = 31 * result + (copyTagsToSnapshot?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (dbPortNumber ?: 0)
        result = 31 * result + (dbSecurityGroups?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (domainIamRoleName?.hashCode() ?: 0)
        result = 31 * result + (enableIamDatabaseAuthentication?.hashCode() ?: 0)
        result = 31 * result + (enablePerformanceInsights?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (licenseModel?.hashCode() ?: 0)
        result = 31 * result + (masterUserPassword?.hashCode() ?: 0)
        result = 31 * result + (monitoringInterval ?: 0)
        result = 31 * result + (monitoringRoleArn?.hashCode() ?: 0)
        result = 31 * result + (multiAz?.hashCode() ?: 0)
        result = 31 * result + (newDbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (optionGroupName?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (promotionTier ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (tdeCredentialArn?.hashCode() ?: 0)
        result = 31 * result + (tdeCredentialPassword?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyDbInstanceRequest

        if (allocatedStorage != other.allocatedStorage) return false
        if (allowMajorVersionUpgrade != other.allowMajorVersionUpgrade) return false
        if (applyImmediately != other.applyImmediately) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (caCertificateIdentifier != other.caCertificateIdentifier) return false
        if (cloudwatchLogsExportConfiguration != other.cloudwatchLogsExportConfiguration) return false
        if (copyTagsToSnapshot != other.copyTagsToSnapshot) return false
        if (dbInstanceClass != other.dbInstanceClass) return false
        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (dbParameterGroupName != other.dbParameterGroupName) return false
        if (dbPortNumber != other.dbPortNumber) return false
        if (dbSecurityGroups != other.dbSecurityGroups) return false
        if (dbSubnetGroupName != other.dbSubnetGroupName) return false
        if (deletionProtection != other.deletionProtection) return false
        if (domain != other.domain) return false
        if (domainIamRoleName != other.domainIamRoleName) return false
        if (enableIamDatabaseAuthentication != other.enableIamDatabaseAuthentication) return false
        if (enablePerformanceInsights != other.enablePerformanceInsights) return false
        if (engineVersion != other.engineVersion) return false
        if (iops != other.iops) return false
        if (licenseModel != other.licenseModel) return false
        if (masterUserPassword != other.masterUserPassword) return false
        if (monitoringInterval != other.monitoringInterval) return false
        if (monitoringRoleArn != other.monitoringRoleArn) return false
        if (multiAz != other.multiAz) return false
        if (newDbInstanceIdentifier != other.newDbInstanceIdentifier) return false
        if (optionGroupName != other.optionGroupName) return false
        if (performanceInsightsKmsKeyId != other.performanceInsightsKmsKeyId) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (promotionTier != other.promotionTier) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (storageType != other.storageType) return false
        if (tdeCredentialArn != other.tdeCredentialArn) return false
        if (tdeCredentialPassword != other.tdeCredentialPassword) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptune.model.ModifyDbInstanceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Not supported by Neptune.
         */
        public var allocatedStorage: kotlin.Int? = null
        /**
         * Indicates that major version upgrades are allowed. Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible.
         */
        public var allowMajorVersionUpgrade: kotlin.Boolean? = null
        /**
         * Specifies whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the `PreferredMaintenanceWindow` setting for the DB instance.
         *
         *  If this parameter is set to `false`, changes to the DB instance are applied during the next maintenance window. Some parameter changes can cause an outage and are applied on the next call to RebootDBInstance, or the next failure reboot.
         *
         * Default: `false`
         */
        public var applyImmediately: kotlin.Boolean? = null
        /**
         * Indicates that minor version upgrades are applied automatically to the DB instance during the maintenance window. Changing this parameter doesn't result in an outage except in the following case and the change is asynchronously applied as soon as possible. An outage will result if this parameter is set to `true` during the maintenance window, and a newer minor version is available, and Neptune has enabled auto patching for that engine version.
         */
        public var autoMinorVersionUpgrade: kotlin.Boolean? = null
        /**
         * Not applicable. The retention period for automated backups is managed by the DB cluster. For more information, see ModifyDBCluster.
         *
         * Default: Uses existing setting
         */
        public var backupRetentionPeriod: kotlin.Int? = null
        /**
         * Indicates the certificate that needs to be associated with the instance.
         */
        public var caCertificateIdentifier: kotlin.String? = null
        /**
         * The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB instance or DB cluster.
         */
        public var cloudwatchLogsExportConfiguration: aws.sdk.kotlin.services.neptune.model.CloudwatchLogsExportConfiguration? = null
        /**
         * True to copy all tags from the DB instance to snapshots of the DB instance, and otherwise false. The default is false.
         */
        public var copyTagsToSnapshot: kotlin.Boolean? = null
        /**
         * The new compute and memory capacity of the DB instance, for example, `db.m4.large`. Not all DB instance classes are available in all Amazon Regions.
         *
         * If you modify the DB instance class, an outage occurs during the change. The change is applied during the next maintenance window, unless `ApplyImmediately` is specified as `true` for this request.
         *
         * Default: Uses existing setting
         */
        public var dbInstanceClass: kotlin.String? = null
        /**
         * The DB instance identifier. This value is stored as a lowercase string.
         *
         * Constraints:
         * + Must match the identifier of an existing DBInstance.
         */
        public var dbInstanceIdentifier: kotlin.String? = null
        /**
         * The name of the DB parameter group to apply to the DB instance. Changing this setting doesn't result in an outage. The parameter group name itself is changed immediately, but the actual parameter changes are not applied until you reboot the instance without failover. The db instance will NOT be rebooted automatically and the parameter changes will NOT be applied during the next maintenance window.
         *
         * Default: Uses existing setting
         *
         * Constraints: The DB parameter group must be in the same DB parameter group family as this DB instance.
         */
        public var dbParameterGroupName: kotlin.String? = null
        /**
         * The port number on which the database accepts connections.
         *
         * The value of the `DBPortNumber` parameter must not match any of the port values specified for options in the option group for the DB instance.
         *
         * Your database will restart when you change the `DBPortNumber` value regardless of the value of the `ApplyImmediately` parameter.
         *
         *  Default: `8182`
         */
        public var dbPortNumber: kotlin.Int? = null
        /**
         * A list of DB security groups to authorize on this DB instance. Changing this setting doesn't result in an outage and the change is asynchronously applied as soon as possible.
         *
         * Constraints:
         * + If supplied, must match existing DBSecurityGroups.
         */
        public var dbSecurityGroups: List<String>? = null
        /**
         * The new DB subnet group for the DB instance. You can use this parameter to move your DB instance to a different VPC.
         *
         * Changing the subnet group causes an outage during the change. The change is applied during the next maintenance window, unless you specify `true` for the `ApplyImmediately` parameter.
         *
         * Constraints: If supplied, must match the name of an existing DBSubnetGroup.
         *
         * Example: `mySubnetGroup`
         */
        public var dbSubnetGroupName: kotlin.String? = null
        /**
         * A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. See [Deleting a DB Instance](https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html).
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * Not supported.
         */
        public var domain: kotlin.String? = null
        /**
         * Not supported
         */
        public var domainIamRoleName: kotlin.String? = null
        /**
         * True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database accounts, and otherwise false.
         *
         * You can enable IAM database authentication for the following database engines
         *
         * Not applicable. Mapping Amazon IAM accounts to database accounts is managed by the DB cluster. For more information, see ModifyDBCluster.
         *
         * Default: `false`
         */
        public var enableIamDatabaseAuthentication: kotlin.Boolean? = null
        /**
         * *(Not supported by Neptune)*
         */
        public var enablePerformanceInsights: kotlin.Boolean? = null
        /**
         * The version number of the database engine to upgrade to. Currently, setting this parameter has no effect. To upgrade your database engine to the most recent release, use the ApplyPendingMaintenanceAction API.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The new Provisioned IOPS (I/O operations per second) value for the instance.
         *
         * Changing this setting doesn't result in an outage and the change is applied during the next maintenance window unless the `ApplyImmediately` parameter is set to `true` for this request.
         *
         * Default: Uses existing setting
         */
        public var iops: kotlin.Int? = null
        /**
         * Not supported by Neptune.
         */
        public var licenseModel: kotlin.String? = null
        /**
         * Not supported by Neptune.
         */
        public var masterUserPassword: kotlin.String? = null
        /**
         * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0.
         *
         * If `MonitoringRoleArn` is specified, then you must also set `MonitoringInterval` to a value other than 0.
         *
         * Valid Values: `0, 1, 5, 10, 15, 30, 60`
         */
        public var monitoringInterval: kotlin.Int? = null
        /**
         * The ARN for the IAM role that permits Neptune to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, `arn:aws:iam:123456789012:role/emaccess`.
         *
         * If `MonitoringInterval` is set to a value other than 0, then you must supply a `MonitoringRoleArn` value.
         */
        public var monitoringRoleArn: kotlin.String? = null
        /**
         * Specifies if the DB instance is a Multi-AZ deployment. Changing this parameter doesn't result in an outage and the change is applied during the next maintenance window unless the `ApplyImmediately` parameter is set to `true` for this request.
         */
        public var multiAz: kotlin.Boolean? = null
        /**
         * The new DB instance identifier for the DB instance when renaming a DB instance. When you change the DB instance identifier, an instance reboot will occur immediately if you set `Apply Immediately` to true, or will occur during the next maintenance window if `Apply Immediately` to false. This value is stored as a lowercase string.
         *
         * Constraints:
         * + Must contain from 1 to 63 letters, numbers, or hyphens.
         * + The first character must be a letter.
         * + Cannot end with a hyphen or contain two consecutive hyphens.
         *
         * Example: `mydbinstance`
         */
        public var newDbInstanceIdentifier: kotlin.String? = null
        /**
         * *(Not supported by Neptune)*
         */
        public var optionGroupName: kotlin.String? = null
        /**
         * *(Not supported by Neptune)*
         */
        public var performanceInsightsKmsKeyId: kotlin.String? = null
        /**
         * The daily time range during which automated backups are created if automated backups are enabled.
         *
         * Not applicable. The daily time range for creating automated backups is managed by the DB cluster. For more information, see ModifyDBCluster.
         *
         * Constraints:
         * + Must be in the format hh24:mi-hh24:mi
         * + Must be in Universal Time Coordinated (UTC)
         * + Must not conflict with the preferred maintenance window
         * + Must be at least 30 minutes
         */
        public var preferredBackupWindow: kotlin.String? = null
        /**
         * The weekly time range (in UTC) during which system maintenance can occur, which might result in an outage. Changing this parameter doesn't result in an outage, except in the following situation, and the change is asynchronously applied as soon as possible. If there are pending actions that cause a reboot, and the maintenance window is changed to include the current time, then changing this parameter will cause a reboot of the DB instance. If moving this window to the current time, there must be at least 30 minutes between the current time and end of the window to ensure pending changes are applied.
         *
         * Default: Uses existing setting
         *
         * Format: ddd:hh24:mi-ddd:hh24:mi
         *
         * Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
         *
         * Constraints: Must be at least 30 minutes
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * A value that specifies the order in which a Read Replica is promoted to the primary instance after a failure of the existing primary instance.
         *
         * Default: 1
         *
         * Valid Values: 0 - 15
         */
        public var promotionTier: kotlin.Int? = null
        /**
         * This flag should no longer be used.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var publiclyAccessible: kotlin.Boolean? = null
        /**
         * Not supported.
         */
        public var storageType: kotlin.String? = null
        /**
         * The ARN from the key store with which to associate the instance for TDE encryption.
         */
        public var tdeCredentialArn: kotlin.String? = null
        /**
         * The password for the given ARN from the key store in order to access the device.
         */
        public var tdeCredentialPassword: kotlin.String? = null
        /**
         * A list of EC2 VPC security groups to authorize on this DB instance. This change is asynchronously applied as soon as possible.
         *
         * Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. For more information, see ModifyDBCluster.
         *
         * Constraints:
         * + If supplied, must match existing VpcSecurityGroupIds.
         */
        public var vpcSecurityGroupIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptune.model.ModifyDbInstanceRequest) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.allowMajorVersionUpgrade = x.allowMajorVersionUpgrade
            this.applyImmediately = x.applyImmediately
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.caCertificateIdentifier = x.caCertificateIdentifier
            this.cloudwatchLogsExportConfiguration = x.cloudwatchLogsExportConfiguration
            this.copyTagsToSnapshot = x.copyTagsToSnapshot
            this.dbInstanceClass = x.dbInstanceClass
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.dbParameterGroupName = x.dbParameterGroupName
            this.dbPortNumber = x.dbPortNumber
            this.dbSecurityGroups = x.dbSecurityGroups
            this.dbSubnetGroupName = x.dbSubnetGroupName
            this.deletionProtection = x.deletionProtection
            this.domain = x.domain
            this.domainIamRoleName = x.domainIamRoleName
            this.enableIamDatabaseAuthentication = x.enableIamDatabaseAuthentication
            this.enablePerformanceInsights = x.enablePerformanceInsights
            this.engineVersion = x.engineVersion
            this.iops = x.iops
            this.licenseModel = x.licenseModel
            this.masterUserPassword = x.masterUserPassword
            this.monitoringInterval = x.monitoringInterval
            this.monitoringRoleArn = x.monitoringRoleArn
            this.multiAz = x.multiAz
            this.newDbInstanceIdentifier = x.newDbInstanceIdentifier
            this.optionGroupName = x.optionGroupName
            this.performanceInsightsKmsKeyId = x.performanceInsightsKmsKeyId
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.promotionTier = x.promotionTier
            this.publiclyAccessible = x.publiclyAccessible
            this.storageType = x.storageType
            this.tdeCredentialArn = x.tdeCredentialArn
            this.tdeCredentialPassword = x.tdeCredentialPassword
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptune.model.ModifyDbInstanceRequest = ModifyDbInstanceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.neptune.model.CloudwatchLogsExportConfiguration] inside the given [block]
         */
        public fun cloudwatchLogsExportConfiguration(block: aws.sdk.kotlin.services.neptune.model.CloudwatchLogsExportConfiguration.Builder.() -> kotlin.Unit) {
            this.cloudwatchLogsExportConfiguration = aws.sdk.kotlin.services.neptune.model.CloudwatchLogsExportConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
