// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This data type is used as a response element in the `ModifyDBCluster` operation and contains changes that will be applied during the next maintenance window.
 */
public class ClusterPendingModifiedValues private constructor(builder: Builder) {
    /**
     * The allocated storage size in gibibytes (GiB) for database engines. For Neptune, `AllocatedStorage` always returns 1, because Neptune DB cluster storage size isn't fixed, but instead automatically adjusts as needed.
     */
    public val allocatedStorage: kotlin.Int? = builder.allocatedStorage
    /**
     * The number of days for which automatic DB snapshots are retained.
     */
    public val backupRetentionPeriod: kotlin.Int? = builder.backupRetentionPeriod
    /**
     * The DBClusterIdentifier value for the DB cluster.
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The database engine version.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * A value that indicates whether mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.
     */
    public val iamDatabaseAuthenticationEnabled: kotlin.Boolean? = builder.iamDatabaseAuthenticationEnabled
    /**
     * The Provisioned IOPS (I/O operations per second) value. This setting is only for non-Aurora Multi-AZ DB clusters.
     */
    public val iops: kotlin.Int? = builder.iops
    /**
     * This `PendingCloudwatchLogsExports` structure specifies pending changes to which CloudWatch logs are enabled and which are disabled.
     */
    public val pendingCloudwatchLogsExports: aws.sdk.kotlin.services.neptune.model.PendingCloudwatchLogsExports? = builder.pendingCloudwatchLogsExports
    /**
     * The storage type for the DB cluster.
     */
    public val storageType: kotlin.String? = builder.storageType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptune.model.ClusterPendingModifiedValues = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClusterPendingModifiedValues(")
        append("allocatedStorage=$allocatedStorage,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("engineVersion=$engineVersion,")
        append("iamDatabaseAuthenticationEnabled=$iamDatabaseAuthenticationEnabled,")
        append("iops=$iops,")
        append("pendingCloudwatchLogsExports=$pendingCloudwatchLogsExports,")
        append("storageType=$storageType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage ?: 0
        result = 31 * result + (backupRetentionPeriod ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (iamDatabaseAuthenticationEnabled?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (pendingCloudwatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClusterPendingModifiedValues

        if (allocatedStorage != other.allocatedStorage) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (engineVersion != other.engineVersion) return false
        if (iamDatabaseAuthenticationEnabled != other.iamDatabaseAuthenticationEnabled) return false
        if (iops != other.iops) return false
        if (pendingCloudwatchLogsExports != other.pendingCloudwatchLogsExports) return false
        if (storageType != other.storageType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptune.model.ClusterPendingModifiedValues = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The allocated storage size in gibibytes (GiB) for database engines. For Neptune, `AllocatedStorage` always returns 1, because Neptune DB cluster storage size isn't fixed, but instead automatically adjusts as needed.
         */
        public var allocatedStorage: kotlin.Int? = null
        /**
         * The number of days for which automatic DB snapshots are retained.
         */
        public var backupRetentionPeriod: kotlin.Int? = null
        /**
         * The DBClusterIdentifier value for the DB cluster.
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * The database engine version.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * A value that indicates whether mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.
         */
        public var iamDatabaseAuthenticationEnabled: kotlin.Boolean? = null
        /**
         * The Provisioned IOPS (I/O operations per second) value. This setting is only for non-Aurora Multi-AZ DB clusters.
         */
        public var iops: kotlin.Int? = null
        /**
         * This `PendingCloudwatchLogsExports` structure specifies pending changes to which CloudWatch logs are enabled and which are disabled.
         */
        public var pendingCloudwatchLogsExports: aws.sdk.kotlin.services.neptune.model.PendingCloudwatchLogsExports? = null
        /**
         * The storage type for the DB cluster.
         */
        public var storageType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptune.model.ClusterPendingModifiedValues) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.engineVersion = x.engineVersion
            this.iamDatabaseAuthenticationEnabled = x.iamDatabaseAuthenticationEnabled
            this.iops = x.iops
            this.pendingCloudwatchLogsExports = x.pendingCloudwatchLogsExports
            this.storageType = x.storageType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptune.model.ClusterPendingModifiedValues = ClusterPendingModifiedValues(this)

        /**
         * construct an [aws.sdk.kotlin.services.neptune.model.PendingCloudwatchLogsExports] inside the given [block]
         */
        public fun pendingCloudwatchLogsExports(block: aws.sdk.kotlin.services.neptune.model.PendingCloudwatchLogsExports.Builder.() -> kotlin.Unit) {
            this.pendingCloudwatchLogsExports = aws.sdk.kotlin.services.neptune.model.PendingCloudwatchLogsExports.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
