// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB instance or DB cluster.
 *
 * The `EnableLogTypes` and `DisableLogTypes` arrays determine which logs will be exported (or not exported) to CloudWatch Logs.
 *
 * Valid log types are: `audit` (to publish audit logs) and `slowquery` (to publish slow-query logs). See [Publishing Neptune logs to Amazon CloudWatch logs](https://docs.aws.amazon.com/neptune/latest/userguide/cloudwatch-logs.html).
 */
public class CloudwatchLogsExportConfiguration private constructor(builder: Builder) {
    /**
     * The list of log types to disable.
     */
    public val disableLogTypes: List<String>? = builder.disableLogTypes
    /**
     * The list of log types to enable.
     */
    public val enableLogTypes: List<String>? = builder.enableLogTypes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptune.model.CloudwatchLogsExportConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CloudwatchLogsExportConfiguration(")
        append("disableLogTypes=$disableLogTypes,")
        append("enableLogTypes=$enableLogTypes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = disableLogTypes?.hashCode() ?: 0
        result = 31 * result + (enableLogTypes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CloudwatchLogsExportConfiguration

        if (disableLogTypes != other.disableLogTypes) return false
        if (enableLogTypes != other.enableLogTypes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptune.model.CloudwatchLogsExportConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The list of log types to disable.
         */
        public var disableLogTypes: List<String>? = null
        /**
         * The list of log types to enable.
         */
        public var enableLogTypes: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptune.model.CloudwatchLogsExportConfiguration) : this() {
            this.disableLogTypes = x.disableLogTypes
            this.enableLogTypes = x.enableLogTypes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptune.model.CloudwatchLogsExportConfiguration = CloudwatchLogsExportConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
