// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.neptune.auth.DefaultNeptuneAuthSchemeProvider
import aws.sdk.kotlin.services.neptune.auth.NeptuneAuthSchemeProvider
import aws.sdk.kotlin.services.neptune.endpoints.DefaultNeptuneEndpointProvider
import aws.sdk.kotlin.services.neptune.endpoints.NeptuneEndpointParameters
import aws.sdk.kotlin.services.neptune.endpoints.NeptuneEndpointProvider
import aws.sdk.kotlin.services.neptune.model.AddRoleToDbClusterRequest
import aws.sdk.kotlin.services.neptune.model.AddRoleToDbClusterResponse
import aws.sdk.kotlin.services.neptune.model.AddSourceIdentifierToSubscriptionRequest
import aws.sdk.kotlin.services.neptune.model.AddSourceIdentifierToSubscriptionResponse
import aws.sdk.kotlin.services.neptune.model.AddTagsToResourceRequest
import aws.sdk.kotlin.services.neptune.model.AddTagsToResourceResponse
import aws.sdk.kotlin.services.neptune.model.ApplyPendingMaintenanceActionRequest
import aws.sdk.kotlin.services.neptune.model.ApplyPendingMaintenanceActionResponse
import aws.sdk.kotlin.services.neptune.model.CopyDbClusterParameterGroupRequest
import aws.sdk.kotlin.services.neptune.model.CopyDbClusterParameterGroupResponse
import aws.sdk.kotlin.services.neptune.model.CopyDbClusterSnapshotRequest
import aws.sdk.kotlin.services.neptune.model.CopyDbClusterSnapshotResponse
import aws.sdk.kotlin.services.neptune.model.CopyDbParameterGroupRequest
import aws.sdk.kotlin.services.neptune.model.CopyDbParameterGroupResponse
import aws.sdk.kotlin.services.neptune.model.CreateDbClusterEndpointRequest
import aws.sdk.kotlin.services.neptune.model.CreateDbClusterEndpointResponse
import aws.sdk.kotlin.services.neptune.model.CreateDbClusterParameterGroupRequest
import aws.sdk.kotlin.services.neptune.model.CreateDbClusterParameterGroupResponse
import aws.sdk.kotlin.services.neptune.model.CreateDbClusterRequest
import aws.sdk.kotlin.services.neptune.model.CreateDbClusterResponse
import aws.sdk.kotlin.services.neptune.model.CreateDbClusterSnapshotRequest
import aws.sdk.kotlin.services.neptune.model.CreateDbClusterSnapshotResponse
import aws.sdk.kotlin.services.neptune.model.CreateDbInstanceRequest
import aws.sdk.kotlin.services.neptune.model.CreateDbInstanceResponse
import aws.sdk.kotlin.services.neptune.model.CreateDbParameterGroupRequest
import aws.sdk.kotlin.services.neptune.model.CreateDbParameterGroupResponse
import aws.sdk.kotlin.services.neptune.model.CreateDbSubnetGroupRequest
import aws.sdk.kotlin.services.neptune.model.CreateDbSubnetGroupResponse
import aws.sdk.kotlin.services.neptune.model.CreateEventSubscriptionRequest
import aws.sdk.kotlin.services.neptune.model.CreateEventSubscriptionResponse
import aws.sdk.kotlin.services.neptune.model.CreateGlobalClusterRequest
import aws.sdk.kotlin.services.neptune.model.CreateGlobalClusterResponse
import aws.sdk.kotlin.services.neptune.model.DeleteDbClusterEndpointRequest
import aws.sdk.kotlin.services.neptune.model.DeleteDbClusterEndpointResponse
import aws.sdk.kotlin.services.neptune.model.DeleteDbClusterParameterGroupRequest
import aws.sdk.kotlin.services.neptune.model.DeleteDbClusterParameterGroupResponse
import aws.sdk.kotlin.services.neptune.model.DeleteDbClusterRequest
import aws.sdk.kotlin.services.neptune.model.DeleteDbClusterResponse
import aws.sdk.kotlin.services.neptune.model.DeleteDbClusterSnapshotRequest
import aws.sdk.kotlin.services.neptune.model.DeleteDbClusterSnapshotResponse
import aws.sdk.kotlin.services.neptune.model.DeleteDbInstanceRequest
import aws.sdk.kotlin.services.neptune.model.DeleteDbInstanceResponse
import aws.sdk.kotlin.services.neptune.model.DeleteDbParameterGroupRequest
import aws.sdk.kotlin.services.neptune.model.DeleteDbParameterGroupResponse
import aws.sdk.kotlin.services.neptune.model.DeleteDbSubnetGroupRequest
import aws.sdk.kotlin.services.neptune.model.DeleteDbSubnetGroupResponse
import aws.sdk.kotlin.services.neptune.model.DeleteEventSubscriptionRequest
import aws.sdk.kotlin.services.neptune.model.DeleteEventSubscriptionResponse
import aws.sdk.kotlin.services.neptune.model.DeleteGlobalClusterRequest
import aws.sdk.kotlin.services.neptune.model.DeleteGlobalClusterResponse
import aws.sdk.kotlin.services.neptune.model.DescribeDbClusterEndpointsRequest
import aws.sdk.kotlin.services.neptune.model.DescribeDbClusterEndpointsResponse
import aws.sdk.kotlin.services.neptune.model.DescribeDbClusterParameterGroupsRequest
import aws.sdk.kotlin.services.neptune.model.DescribeDbClusterParameterGroupsResponse
import aws.sdk.kotlin.services.neptune.model.DescribeDbClusterParametersRequest
import aws.sdk.kotlin.services.neptune.model.DescribeDbClusterParametersResponse
import aws.sdk.kotlin.services.neptune.model.DescribeDbClusterSnapshotAttributesRequest
import aws.sdk.kotlin.services.neptune.model.DescribeDbClusterSnapshotAttributesResponse
import aws.sdk.kotlin.services.neptune.model.DescribeDbClusterSnapshotsRequest
import aws.sdk.kotlin.services.neptune.model.DescribeDbClusterSnapshotsResponse
import aws.sdk.kotlin.services.neptune.model.DescribeDbClustersRequest
import aws.sdk.kotlin.services.neptune.model.DescribeDbClustersResponse
import aws.sdk.kotlin.services.neptune.model.DescribeDbEngineVersionsRequest
import aws.sdk.kotlin.services.neptune.model.DescribeDbEngineVersionsResponse
import aws.sdk.kotlin.services.neptune.model.DescribeDbInstancesRequest
import aws.sdk.kotlin.services.neptune.model.DescribeDbInstancesResponse
import aws.sdk.kotlin.services.neptune.model.DescribeDbParameterGroupsRequest
import aws.sdk.kotlin.services.neptune.model.DescribeDbParameterGroupsResponse
import aws.sdk.kotlin.services.neptune.model.DescribeDbParametersRequest
import aws.sdk.kotlin.services.neptune.model.DescribeDbParametersResponse
import aws.sdk.kotlin.services.neptune.model.DescribeDbSubnetGroupsRequest
import aws.sdk.kotlin.services.neptune.model.DescribeDbSubnetGroupsResponse
import aws.sdk.kotlin.services.neptune.model.DescribeEngineDefaultClusterParametersRequest
import aws.sdk.kotlin.services.neptune.model.DescribeEngineDefaultClusterParametersResponse
import aws.sdk.kotlin.services.neptune.model.DescribeEngineDefaultParametersRequest
import aws.sdk.kotlin.services.neptune.model.DescribeEngineDefaultParametersResponse
import aws.sdk.kotlin.services.neptune.model.DescribeEventCategoriesRequest
import aws.sdk.kotlin.services.neptune.model.DescribeEventCategoriesResponse
import aws.sdk.kotlin.services.neptune.model.DescribeEventSubscriptionsRequest
import aws.sdk.kotlin.services.neptune.model.DescribeEventSubscriptionsResponse
import aws.sdk.kotlin.services.neptune.model.DescribeEventsRequest
import aws.sdk.kotlin.services.neptune.model.DescribeEventsResponse
import aws.sdk.kotlin.services.neptune.model.DescribeGlobalClustersRequest
import aws.sdk.kotlin.services.neptune.model.DescribeGlobalClustersResponse
import aws.sdk.kotlin.services.neptune.model.DescribeOrderableDbInstanceOptionsRequest
import aws.sdk.kotlin.services.neptune.model.DescribeOrderableDbInstanceOptionsResponse
import aws.sdk.kotlin.services.neptune.model.DescribePendingMaintenanceActionsRequest
import aws.sdk.kotlin.services.neptune.model.DescribePendingMaintenanceActionsResponse
import aws.sdk.kotlin.services.neptune.model.DescribeValidDbInstanceModificationsRequest
import aws.sdk.kotlin.services.neptune.model.DescribeValidDbInstanceModificationsResponse
import aws.sdk.kotlin.services.neptune.model.FailoverDbClusterRequest
import aws.sdk.kotlin.services.neptune.model.FailoverDbClusterResponse
import aws.sdk.kotlin.services.neptune.model.FailoverGlobalClusterRequest
import aws.sdk.kotlin.services.neptune.model.FailoverGlobalClusterResponse
import aws.sdk.kotlin.services.neptune.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.neptune.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.neptune.model.ModifyDbClusterEndpointRequest
import aws.sdk.kotlin.services.neptune.model.ModifyDbClusterEndpointResponse
import aws.sdk.kotlin.services.neptune.model.ModifyDbClusterParameterGroupRequest
import aws.sdk.kotlin.services.neptune.model.ModifyDbClusterParameterGroupResponse
import aws.sdk.kotlin.services.neptune.model.ModifyDbClusterRequest
import aws.sdk.kotlin.services.neptune.model.ModifyDbClusterResponse
import aws.sdk.kotlin.services.neptune.model.ModifyDbClusterSnapshotAttributeRequest
import aws.sdk.kotlin.services.neptune.model.ModifyDbClusterSnapshotAttributeResponse
import aws.sdk.kotlin.services.neptune.model.ModifyDbInstanceRequest
import aws.sdk.kotlin.services.neptune.model.ModifyDbInstanceResponse
import aws.sdk.kotlin.services.neptune.model.ModifyDbParameterGroupRequest
import aws.sdk.kotlin.services.neptune.model.ModifyDbParameterGroupResponse
import aws.sdk.kotlin.services.neptune.model.ModifyDbSubnetGroupRequest
import aws.sdk.kotlin.services.neptune.model.ModifyDbSubnetGroupResponse
import aws.sdk.kotlin.services.neptune.model.ModifyEventSubscriptionRequest
import aws.sdk.kotlin.services.neptune.model.ModifyEventSubscriptionResponse
import aws.sdk.kotlin.services.neptune.model.ModifyGlobalClusterRequest
import aws.sdk.kotlin.services.neptune.model.ModifyGlobalClusterResponse
import aws.sdk.kotlin.services.neptune.model.PromoteReadReplicaDbClusterRequest
import aws.sdk.kotlin.services.neptune.model.PromoteReadReplicaDbClusterResponse
import aws.sdk.kotlin.services.neptune.model.RebootDbInstanceRequest
import aws.sdk.kotlin.services.neptune.model.RebootDbInstanceResponse
import aws.sdk.kotlin.services.neptune.model.RemoveFromGlobalClusterRequest
import aws.sdk.kotlin.services.neptune.model.RemoveFromGlobalClusterResponse
import aws.sdk.kotlin.services.neptune.model.RemoveRoleFromDbClusterRequest
import aws.sdk.kotlin.services.neptune.model.RemoveRoleFromDbClusterResponse
import aws.sdk.kotlin.services.neptune.model.RemoveSourceIdentifierFromSubscriptionRequest
import aws.sdk.kotlin.services.neptune.model.RemoveSourceIdentifierFromSubscriptionResponse
import aws.sdk.kotlin.services.neptune.model.RemoveTagsFromResourceRequest
import aws.sdk.kotlin.services.neptune.model.RemoveTagsFromResourceResponse
import aws.sdk.kotlin.services.neptune.model.ResetDbClusterParameterGroupRequest
import aws.sdk.kotlin.services.neptune.model.ResetDbClusterParameterGroupResponse
import aws.sdk.kotlin.services.neptune.model.ResetDbParameterGroupRequest
import aws.sdk.kotlin.services.neptune.model.ResetDbParameterGroupResponse
import aws.sdk.kotlin.services.neptune.model.RestoreDbClusterFromSnapshotRequest
import aws.sdk.kotlin.services.neptune.model.RestoreDbClusterFromSnapshotResponse
import aws.sdk.kotlin.services.neptune.model.RestoreDbClusterToPointInTimeRequest
import aws.sdk.kotlin.services.neptune.model.RestoreDbClusterToPointInTimeResponse
import aws.sdk.kotlin.services.neptune.model.StartDbClusterRequest
import aws.sdk.kotlin.services.neptune.model.StartDbClusterResponse
import aws.sdk.kotlin.services.neptune.model.StopDbClusterRequest
import aws.sdk.kotlin.services.neptune.model.StopDbClusterResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Neptune"
public const val SdkVersion: String = "1.2.30"
public const val ServiceApiVersion: String = "2014-10-31"

/**
 * # Amazon Neptune
 * Amazon Neptune is a fast, reliable, fully-managed graph database service that makes it easy to build and run applications that work with highly connected datasets. The core of Amazon Neptune is a purpose-built, high-performance graph database engine optimized for storing billions of relationships and querying the graph with milliseconds latency. Amazon Neptune supports popular graph models Property Graph and W3C's RDF, and their respective query languages Apache TinkerPop Gremlin and SPARQL, allowing you to easily build queries that efficiently navigate highly connected datasets. Neptune powers graph use cases such as recommendation engines, fraud detection, knowledge graphs, drug discovery, and network security.
 *
 * This interface reference for Amazon Neptune contains documentation for a programming or command line interface you can use to manage Amazon Neptune. Note that Amazon Neptune is asynchronous, which means that some interfaces might require techniques such as polling or callback functions to determine when a command has been applied. In this reference, the parameter descriptions indicate whether a command is applied immediately, on the next instance reboot, or during the maintenance window. The reference structure is as follows, and we list following some related topics from the user guide.
 */
public interface NeptuneClient : SdkClient {
    /**
     * NeptuneClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, NeptuneClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Neptune",
                "NEPTUNE",
                "neptune",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, NeptuneClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): NeptuneClient = DefaultNeptuneClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: NeptuneEndpointProvider = builder.endpointProvider ?: DefaultNeptuneEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: NeptuneAuthSchemeProvider = builder.authSchemeProvider ?: DefaultNeptuneAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Neptune"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: NeptuneEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: NeptuneAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Associates an Identity and Access Management (IAM) role with an Neptune DB cluster.
     */
    public suspend fun addRoleToDbCluster(input: AddRoleToDbClusterRequest): AddRoleToDbClusterResponse

    /**
     * Adds a source identifier to an existing event notification subscription.
     */
    public suspend fun addSourceIdentifierToSubscription(input: AddSourceIdentifierToSubscriptionRequest): AddSourceIdentifierToSubscriptionResponse

    /**
     * Adds metadata tags to an Amazon Neptune resource. These tags can also be used with cost allocation reporting to track cost associated with Amazon Neptune resources, or used in a Condition statement in an IAM policy for Amazon Neptune.
     */
    public suspend fun addTagsToResource(input: AddTagsToResourceRequest): AddTagsToResourceResponse

    /**
     * Applies a pending maintenance action to a resource (for example, to a DB instance).
     */
    public suspend fun applyPendingMaintenanceAction(input: ApplyPendingMaintenanceActionRequest): ApplyPendingMaintenanceActionResponse

    /**
     * Copies the specified DB cluster parameter group.
     */
    public suspend fun copyDbClusterParameterGroup(input: CopyDbClusterParameterGroupRequest): CopyDbClusterParameterGroupResponse

    /**
     * Copies a snapshot of a DB cluster.
     *
     * To copy a DB cluster snapshot from a shared manual DB cluster snapshot, `SourceDBClusterSnapshotIdentifier` must be the Amazon Resource Name (ARN) of the shared DB cluster snapshot.
     */
    public suspend fun copyDbClusterSnapshot(input: CopyDbClusterSnapshotRequest): CopyDbClusterSnapshotResponse

    /**
     * Copies the specified DB parameter group.
     */
    public suspend fun copyDbParameterGroup(input: CopyDbParameterGroupRequest): CopyDbParameterGroupResponse

    /**
     * Creates a new Amazon Neptune DB cluster.
     *
     * You can use the `ReplicationSourceIdentifier` parameter to create the DB cluster as a Read Replica of another DB cluster or Amazon Neptune DB instance.
     *
     * Note that when you create a new cluster using `CreateDBCluster` directly, deletion protection is disabled by default (when you create a new production cluster in the console, deletion protection is enabled by default). You can only delete a DB cluster if its `DeletionProtection` field is set to `false`.
     */
    public suspend fun createDbCluster(input: CreateDbClusterRequest): CreateDbClusterResponse

    /**
     * Creates a new custom endpoint and associates it with an Amazon Neptune DB cluster.
     */
    public suspend fun createDbClusterEndpoint(input: CreateDbClusterEndpointRequest): CreateDbClusterEndpointResponse

    /**
     * Creates a new DB cluster parameter group.
     *
     * Parameters in a DB cluster parameter group apply to all of the instances in a DB cluster.
     *
     *  A DB cluster parameter group is initially created with the default parameters for the database engine used by instances in the DB cluster. To provide custom values for any of the parameters, you must modify the group after creating it using ModifyDBClusterParameterGroup. Once you've created a DB cluster parameter group, you need to associate it with your DB cluster using ModifyDBCluster. When you associate a new DB cluster parameter group with a running DB cluster, you need to reboot the DB instances in the DB cluster without failover for the new DB cluster parameter group and associated settings to take effect.
     *
     * After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon Neptune to fully complete the create action before the DB cluster parameter group is used as the default for a new DB cluster. This is especially important for parameters that are critical when creating the default database for a DB cluster, such as the character set for the default database defined by the `character_set_database` parameter. You can use the *Parameter Groups* option of the [Amazon Neptune console](https://console.aws.amazon.com/rds/) or the DescribeDBClusterParameters command to verify that your DB cluster parameter group has been created or modified.
     */
    public suspend fun createDbClusterParameterGroup(input: CreateDbClusterParameterGroupRequest): CreateDbClusterParameterGroupResponse

    /**
     * Creates a snapshot of a DB cluster.
     */
    public suspend fun createDbClusterSnapshot(input: CreateDbClusterSnapshotRequest): CreateDbClusterSnapshotResponse

    /**
     * Creates a new DB instance.
     */
    public suspend fun createDbInstance(input: CreateDbInstanceRequest): CreateDbInstanceResponse

    /**
     * Creates a new DB parameter group.
     *
     * A DB parameter group is initially created with the default parameters for the database engine used by the DB instance. To provide custom values for any of the parameters, you must modify the group after creating it using *ModifyDBParameterGroup*. Once you've created a DB parameter group, you need to associate it with your DB instance using *ModifyDBInstance*. When you associate a new DB parameter group with a running DB instance, you need to reboot the DB instance without failover for the new DB parameter group and associated settings to take effect.
     *
     * After you create a DB parameter group, you should wait at least 5 minutes before creating your first DB instance that uses that DB parameter group as the default parameter group. This allows Amazon Neptune to fully complete the create action before the parameter group is used as the default for a new DB instance. This is especially important for parameters that are critical when creating the default database for a DB instance, such as the character set for the default database defined by the `character_set_database` parameter. You can use the *Parameter Groups* option of the Amazon Neptune console or the *DescribeDBParameters* command to verify that your DB parameter group has been created or modified.
     */
    public suspend fun createDbParameterGroup(input: CreateDbParameterGroupRequest): CreateDbParameterGroupResponse

    /**
     * Creates a new DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the Amazon Region.
     */
    public suspend fun createDbSubnetGroup(input: CreateDbSubnetGroupRequest): CreateDbSubnetGroupResponse

    /**
     * Creates an event notification subscription. This action requires a topic ARN (Amazon Resource Name) created by either the Neptune console, the SNS console, or the SNS API. To obtain an ARN with SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the SNS console.
     *
     * You can specify the type of source (SourceType) you want to be notified of, provide a list of Neptune sources (SourceIds) that triggers the events, and provide a list of event categories (EventCategories) for events you want to be notified of. For example, you can specify SourceType = db-instance, SourceIds = mydbinstance1, mydbinstance2 and EventCategories = Availability, Backup.
     *
     * If you specify both the SourceType and SourceIds, such as SourceType = db-instance and SourceIdentifier = myDBInstance1, you are notified of all the db-instance events for the specified source. If you specify a SourceType but do not specify a SourceIdentifier, you receive notice of the events for that source type for all your Neptune sources. If you do not specify either the SourceType nor the SourceIdentifier, you are notified of events generated from all Neptune sources belonging to your customer account.
     */
    public suspend fun createEventSubscription(input: CreateEventSubscriptionRequest): CreateEventSubscriptionResponse

    /**
     * Creates a Neptune global database spread across multiple Amazon Regions. The global database contains a single primary cluster with read-write capability, and read-only secondary clusters that receive data from the primary cluster through high-speed replication performed by the Neptune storage subsystem.
     *
     * You can create a global database that is initially empty, and then add a primary cluster and secondary clusters to it, or you can specify an existing Neptune cluster during the create operation to become the primary cluster of the global database.
     */
    public suspend fun createGlobalCluster(input: CreateGlobalClusterRequest): CreateGlobalClusterResponse

    /**
     * The DeleteDBCluster action deletes a previously provisioned DB cluster. When you delete a DB cluster, all automated backups for that DB cluster are deleted and can't be recovered. Manual DB cluster snapshots of the specified DB cluster are not deleted.
     *
     * Note that the DB Cluster cannot be deleted if deletion protection is enabled. To delete it, you must first set its `DeletionProtection` field to `False`.
     */
    public suspend fun deleteDbCluster(input: DeleteDbClusterRequest): DeleteDbClusterResponse

    /**
     * Deletes a custom endpoint and removes it from an Amazon Neptune DB cluster.
     */
    public suspend fun deleteDbClusterEndpoint(input: DeleteDbClusterEndpointRequest): DeleteDbClusterEndpointResponse

    /**
     * Deletes a specified DB cluster parameter group. The DB cluster parameter group to be deleted can't be associated with any DB clusters.
     */
    public suspend fun deleteDbClusterParameterGroup(input: DeleteDbClusterParameterGroupRequest): DeleteDbClusterParameterGroupResponse

    /**
     * Deletes a DB cluster snapshot. If the snapshot is being copied, the copy operation is terminated.
     *
     * The DB cluster snapshot must be in the `available` state to be deleted.
     */
    public suspend fun deleteDbClusterSnapshot(input: DeleteDbClusterSnapshotRequest): DeleteDbClusterSnapshotResponse

    /**
     * The DeleteDBInstance action deletes a previously provisioned DB instance. When you delete a DB instance, all automated backups for that instance are deleted and can't be recovered. Manual DB snapshots of the DB instance to be deleted by `DeleteDBInstance` are not deleted.
     *
     *  If you request a final DB snapshot the status of the Amazon Neptune DB instance is `deleting` until the DB snapshot is created. The API action `DescribeDBInstance` is used to monitor the status of this operation. The action can't be canceled or reverted once submitted.
     *
     * Note that when a DB instance is in a failure state and has a status of `failed`, `incompatible-restore`, or `incompatible-network`, you can only delete it when the `SkipFinalSnapshot` parameter is set to `true`.
     *
     * You can't delete a DB instance if it is the only instance in the DB cluster, or if it has deletion protection enabled.
     */
    public suspend fun deleteDbInstance(input: DeleteDbInstanceRequest): DeleteDbInstanceResponse

    /**
     * Deletes a specified DBParameterGroup. The DBParameterGroup to be deleted can't be associated with any DB instances.
     */
    public suspend fun deleteDbParameterGroup(input: DeleteDbParameterGroupRequest): DeleteDbParameterGroupResponse

    /**
     * Deletes a DB subnet group.
     *
     * The specified database subnet group must not be associated with any DB instances.
     */
    public suspend fun deleteDbSubnetGroup(input: DeleteDbSubnetGroupRequest): DeleteDbSubnetGroupResponse

    /**
     * Deletes an event notification subscription.
     */
    public suspend fun deleteEventSubscription(input: DeleteEventSubscriptionRequest): DeleteEventSubscriptionResponse

    /**
     * Deletes a global database. The primary and all secondary clusters must already be detached or deleted first.
     */
    public suspend fun deleteGlobalCluster(input: DeleteGlobalClusterRequest): DeleteGlobalClusterResponse

    /**
     * Returns information about endpoints for an Amazon Neptune DB cluster.
     *
     * This operation can also return information for Amazon RDS clusters and Amazon DocDB clusters.
     */
    public suspend fun describeDbClusterEndpoints(input: DescribeDbClusterEndpointsRequest = DescribeDbClusterEndpointsRequest { }): DescribeDbClusterEndpointsResponse

    /**
     * Returns a list of `DBClusterParameterGroup` descriptions. If a `DBClusterParameterGroupName` parameter is specified, the list will contain only the description of the specified DB cluster parameter group.
     */
    public suspend fun describeDbClusterParameterGroups(input: DescribeDbClusterParameterGroupsRequest = DescribeDbClusterParameterGroupsRequest { }): DescribeDbClusterParameterGroupsResponse

    /**
     * Returns the detailed parameter list for a particular DB cluster parameter group.
     */
    public suspend fun describeDbClusterParameters(input: DescribeDbClusterParametersRequest): DescribeDbClusterParametersResponse

    /**
     * Returns a list of DB cluster snapshot attribute names and values for a manual DB cluster snapshot.
     *
     * When sharing snapshots with other Amazon accounts, `DescribeDBClusterSnapshotAttributes` returns the `restore` attribute and a list of IDs for the Amazon accounts that are authorized to copy or restore the manual DB cluster snapshot. If `all` is included in the list of values for the `restore` attribute, then the manual DB cluster snapshot is public and can be copied or restored by all Amazon accounts.
     *
     * To add or remove access for an Amazon account to copy or restore a manual DB cluster snapshot, or to make the manual DB cluster snapshot public or private, use the ModifyDBClusterSnapshotAttribute API action.
     */
    public suspend fun describeDbClusterSnapshotAttributes(input: DescribeDbClusterSnapshotAttributesRequest): DescribeDbClusterSnapshotAttributesResponse

    /**
     * Returns information about DB cluster snapshots. This API action supports pagination.
     */
    public suspend fun describeDbClusterSnapshots(input: DescribeDbClusterSnapshotsRequest = DescribeDbClusterSnapshotsRequest { }): DescribeDbClusterSnapshotsResponse

    /**
     * Returns information about provisioned DB clusters, and supports pagination.
     *
     * This operation can also return information for Amazon RDS clusters and Amazon DocDB clusters.
     */
    public suspend fun describeDbClusters(input: DescribeDbClustersRequest = DescribeDbClustersRequest { }): DescribeDbClustersResponse

    /**
     * Returns a list of the available DB engines.
     */
    public suspend fun describeDbEngineVersions(input: DescribeDbEngineVersionsRequest = DescribeDbEngineVersionsRequest { }): DescribeDbEngineVersionsResponse

    /**
     * Returns information about provisioned instances, and supports pagination.
     *
     * This operation can also return information for Amazon RDS instances and Amazon DocDB instances.
     */
    public suspend fun describeDbInstances(input: DescribeDbInstancesRequest = DescribeDbInstancesRequest { }): DescribeDbInstancesResponse

    /**
     * Returns a list of `DBParameterGroup` descriptions. If a `DBParameterGroupName` is specified, the list will contain only the description of the specified DB parameter group.
     */
    public suspend fun describeDbParameterGroups(input: DescribeDbParameterGroupsRequest = DescribeDbParameterGroupsRequest { }): DescribeDbParameterGroupsResponse

    /**
     * Returns the detailed parameter list for a particular DB parameter group.
     */
    public suspend fun describeDbParameters(input: DescribeDbParametersRequest): DescribeDbParametersResponse

    /**
     * Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the descriptions of the specified DBSubnetGroup.
     *
     * For an overview of CIDR ranges, go to the [Wikipedia Tutorial](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
     */
    public suspend fun describeDbSubnetGroups(input: DescribeDbSubnetGroupsRequest = DescribeDbSubnetGroupsRequest { }): DescribeDbSubnetGroupsResponse

    /**
     * Returns the default engine and system parameter information for the cluster database engine.
     */
    public suspend fun describeEngineDefaultClusterParameters(input: DescribeEngineDefaultClusterParametersRequest): DescribeEngineDefaultClusterParametersResponse

    /**
     * Returns the default engine and system parameter information for the specified database engine.
     */
    public suspend fun describeEngineDefaultParameters(input: DescribeEngineDefaultParametersRequest): DescribeEngineDefaultParametersResponse

    /**
     * Displays a list of categories for all event source types, or, if specified, for a specified source type.
     */
    public suspend fun describeEventCategories(input: DescribeEventCategoriesRequest = DescribeEventCategoriesRequest { }): DescribeEventCategoriesResponse

    /**
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes SubscriptionName, SNSTopicARN, CustomerID, SourceType, SourceID, CreationTime, and Status.
     *
     * If you specify a SubscriptionName, lists the description for that subscription.
     */
    public suspend fun describeEventSubscriptions(input: DescribeEventSubscriptionsRequest = DescribeEventSubscriptionsRequest { }): DescribeEventSubscriptionsResponse

    /**
     * Returns events related to DB instances, DB security groups, DB snapshots, and DB parameter groups for the past 14 days. Events specific to a particular DB instance, DB security group, database snapshot, or DB parameter group can be obtained by providing the name as a parameter. By default, the past hour of events are returned.
     */
    public suspend fun describeEvents(input: DescribeEventsRequest = DescribeEventsRequest { }): DescribeEventsResponse

    /**
     * Returns information about Neptune global database clusters. This API supports pagination.
     */
    public suspend fun describeGlobalClusters(input: DescribeGlobalClustersRequest = DescribeGlobalClustersRequest { }): DescribeGlobalClustersResponse

    /**
     * Returns a list of orderable DB instance options for the specified engine.
     */
    public suspend fun describeOrderableDbInstanceOptions(input: DescribeOrderableDbInstanceOptionsRequest): DescribeOrderableDbInstanceOptionsResponse

    /**
     * Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.
     */
    public suspend fun describePendingMaintenanceActions(input: DescribePendingMaintenanceActionsRequest = DescribePendingMaintenanceActionsRequest { }): DescribePendingMaintenanceActionsResponse

    /**
     * You can call DescribeValidDBInstanceModifications to learn what modifications you can make to your DB instance. You can use this information when you call ModifyDBInstance.
     */
    public suspend fun describeValidDbInstanceModifications(input: DescribeValidDbInstanceModificationsRequest): DescribeValidDbInstanceModificationsResponse

    /**
     * Forces a failover for a DB cluster.
     *
     * A failover for a DB cluster promotes one of the Read Replicas (read-only instances) in the DB cluster to be the primary instance (the cluster writer).
     *
     * Amazon Neptune will automatically fail over to a Read Replica, if one exists, when the primary instance fails. You can force a failover when you want to simulate a failure of a primary instance for testing. Because each instance in a DB cluster has its own endpoint address, you will need to clean up and re-establish any existing connections that use those endpoint addresses when the failover is complete.
     */
    public suspend fun failoverDbCluster(input: FailoverDbClusterRequest = FailoverDbClusterRequest { }): FailoverDbClusterResponse

    /**
     * Initiates the failover process for a Neptune global database.
     *
     * A failover for a Neptune global database promotes one of secondary read-only DB clusters to be the primary DB cluster and demotes the primary DB cluster to being a secondary (read-only) DB cluster. In other words, the role of the current primary DB cluster and the selected target secondary DB cluster are switched. The selected secondary DB cluster assumes full read/write capabilities for the Neptune global database.
     *
     * This action applies **only** to Neptune global databases. This action is only intended for use on healthy Neptune global databases with healthy Neptune DB clusters and no region-wide outages, to test disaster recovery scenarios or to reconfigure the global database topology.
     */
    public suspend fun failoverGlobalCluster(input: FailoverGlobalClusterRequest): FailoverGlobalClusterResponse

    /**
     * Lists all tags on an Amazon Neptune resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Modify a setting for a DB cluster. You can change one or more database configuration parameters by specifying these parameters and the new values in the request.
     */
    public suspend fun modifyDbCluster(input: ModifyDbClusterRequest): ModifyDbClusterResponse

    /**
     * Modifies the properties of an endpoint in an Amazon Neptune DB cluster.
     */
    public suspend fun modifyDbClusterEndpoint(input: ModifyDbClusterEndpointRequest): ModifyDbClusterEndpointResponse

    /**
     * Modifies the parameters of a DB cluster parameter group. To modify more than one parameter, submit a list of the following: `ParameterName`, `ParameterValue`, and `ApplyMethod`. A maximum of 20 parameters can be modified in a single request.
     *
     * Changes to dynamic parameters are applied immediately. Changes to static parameters require a reboot without failover to the DB cluster associated with the parameter group before the change can take effect.
     *
     * After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon Neptune to fully complete the create action before the parameter group is used as the default for a new DB cluster. This is especially important for parameters that are critical when creating the default database for a DB cluster, such as the character set for the default database defined by the `character_set_database` parameter. You can use the *Parameter Groups* option of the Amazon Neptune console or the DescribeDBClusterParameters command to verify that your DB cluster parameter group has been created or modified.
     */
    public suspend fun modifyDbClusterParameterGroup(input: ModifyDbClusterParameterGroupRequest): ModifyDbClusterParameterGroupResponse

    /**
     * Adds an attribute and values to, or removes an attribute and values from, a manual DB cluster snapshot.
     *
     * To share a manual DB cluster snapshot with other Amazon accounts, specify `restore` as the `AttributeName` and use the `ValuesToAdd` parameter to add a list of IDs of the Amazon accounts that are authorized to restore the manual DB cluster snapshot. Use the value `all` to make the manual DB cluster snapshot public, which means that it can be copied or restored by all Amazon accounts. Do not add the `all` value for any manual DB cluster snapshots that contain private information that you don't want available to all Amazon accounts. If a manual DB cluster snapshot is encrypted, it can be shared, but only by specifying a list of authorized Amazon account IDs for the `ValuesToAdd` parameter. You can't use `all` as a value for that parameter in this case.
     *
     * To view which Amazon accounts have access to copy or restore a manual DB cluster snapshot, or whether a manual DB cluster snapshot public or private, use the DescribeDBClusterSnapshotAttributes API action.
     */
    public suspend fun modifyDbClusterSnapshotAttribute(input: ModifyDbClusterSnapshotAttributeRequest): ModifyDbClusterSnapshotAttributeResponse

    /**
     * Modifies settings for a DB instance. You can change one or more database configuration parameters by specifying these parameters and the new values in the request. To learn what modifications you can make to your DB instance, call DescribeValidDBInstanceModifications before you call ModifyDBInstance.
     */
    public suspend fun modifyDbInstance(input: ModifyDbInstanceRequest): ModifyDbInstanceResponse

    /**
     * Modifies the parameters of a DB parameter group. To modify more than one parameter, submit a list of the following: `ParameterName`, `ParameterValue`, and `ApplyMethod`. A maximum of 20 parameters can be modified in a single request.
     *
     * Changes to dynamic parameters are applied immediately. Changes to static parameters require a reboot without failover to the DB instance associated with the parameter group before the change can take effect.
     *
     * After you modify a DB parameter group, you should wait at least 5 minutes before creating your first DB instance that uses that DB parameter group as the default parameter group. This allows Amazon Neptune to fully complete the modify action before the parameter group is used as the default for a new DB instance. This is especially important for parameters that are critical when creating the default database for a DB instance, such as the character set for the default database defined by the `character_set_database` parameter. You can use the *Parameter Groups* option of the Amazon Neptune console or the *DescribeDBParameters* command to verify that your DB parameter group has been created or modified.
     */
    public suspend fun modifyDbParameterGroup(input: ModifyDbParameterGroupRequest): ModifyDbParameterGroupResponse

    /**
     * Modifies an existing DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the Amazon Region.
     */
    public suspend fun modifyDbSubnetGroup(input: ModifyDbSubnetGroupRequest): ModifyDbSubnetGroupResponse

    /**
     * Modifies an existing event notification subscription. Note that you can't modify the source identifiers using this call; to change source identifiers for a subscription, use the AddSourceIdentifierToSubscription and RemoveSourceIdentifierFromSubscription calls.
     *
     * You can see a list of the event categories for a given SourceType by using the **DescribeEventCategories** action.
     */
    public suspend fun modifyEventSubscription(input: ModifyEventSubscriptionRequest): ModifyEventSubscriptionResponse

    /**
     * Modify a setting for an Amazon Neptune global cluster. You can change one or more database configuration parameters by specifying these parameters and their new values in the request.
     */
    public suspend fun modifyGlobalCluster(input: ModifyGlobalClusterRequest): ModifyGlobalClusterResponse

    /**
     * Not supported.
     */
    public suspend fun promoteReadReplicaDbCluster(input: PromoteReadReplicaDbClusterRequest): PromoteReadReplicaDbClusterResponse

    /**
     * You might need to reboot your DB instance, usually for maintenance reasons. For example, if you make certain modifications, or if you change the DB parameter group associated with the DB instance, you must reboot the instance for the changes to take effect.
     *
     * Rebooting a DB instance restarts the database engine service. Rebooting a DB instance results in a momentary outage, during which the DB instance status is set to rebooting.
     */
    public suspend fun rebootDbInstance(input: RebootDbInstanceRequest): RebootDbInstanceResponse

    /**
     * Detaches a Neptune DB cluster from a Neptune global database. A secondary cluster becomes a normal standalone cluster with read-write capability instead of being read-only, and no longer receives data from a the primary cluster.
     */
    public suspend fun removeFromGlobalCluster(input: RemoveFromGlobalClusterRequest): RemoveFromGlobalClusterResponse

    /**
     * Disassociates an Identity and Access Management (IAM) role from a DB cluster.
     */
    public suspend fun removeRoleFromDbCluster(input: RemoveRoleFromDbClusterRequest): RemoveRoleFromDbClusterResponse

    /**
     * Removes a source identifier from an existing event notification subscription.
     */
    public suspend fun removeSourceIdentifierFromSubscription(input: RemoveSourceIdentifierFromSubscriptionRequest): RemoveSourceIdentifierFromSubscriptionResponse

    /**
     * Removes metadata tags from an Amazon Neptune resource.
     */
    public suspend fun removeTagsFromResource(input: RemoveTagsFromResourceRequest): RemoveTagsFromResourceResponse

    /**
     * Modifies the parameters of a DB cluster parameter group to the default value. To reset specific parameters submit a list of the following: `ParameterName` and `ApplyMethod`. To reset the entire DB cluster parameter group, specify the `DBClusterParameterGroupName` and `ResetAllParameters` parameters.
     *
     *  When resetting the entire group, dynamic parameters are updated immediately and static parameters are set to `pending-reboot` to take effect on the next DB instance restart or RebootDBInstance request. You must call RebootDBInstance for every DB instance in your DB cluster that you want the updated static parameter to apply to.
     */
    public suspend fun resetDbClusterParameterGroup(input: ResetDbClusterParameterGroupRequest): ResetDbClusterParameterGroupResponse

    /**
     * Modifies the parameters of a DB parameter group to the engine/system default value. To reset specific parameters, provide a list of the following: `ParameterName` and `ApplyMethod`. To reset the entire DB parameter group, specify the `DBParameterGroup` name and `ResetAllParameters` parameters. When resetting the entire group, dynamic parameters are updated immediately and static parameters are set to `pending-reboot` to take effect on the next DB instance restart or `RebootDBInstance` request.
     */
    public suspend fun resetDbParameterGroup(input: ResetDbParameterGroupRequest): ResetDbParameterGroupResponse

    /**
     * Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
     *
     * If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default configuration and default security group.
     *
     * If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point with the same configuration as the original source DB cluster, except that the new DB cluster is created with the default security group.
     */
    public suspend fun restoreDbClusterFromSnapshot(input: RestoreDbClusterFromSnapshotRequest): RestoreDbClusterFromSnapshotResponse

    /**
     * Restores a DB cluster to an arbitrary point in time. Users can restore to any point in time before `LatestRestorableTime` for up to `BackupRetentionPeriod` days. The target DB cluster is created from the source DB cluster with the same configuration as the original DB cluster, except that the new DB cluster is created with the default DB security group.
     *
     * This action only restores the DB cluster, not the DB instances for that DB cluster. You must invoke the CreateDBInstance action to create DB instances for the restored DB cluster, specifying the identifier of the restored DB cluster in `DBClusterIdentifier`. You can create DB instances only after the `RestoreDBClusterToPointInTime` action has completed and the DB cluster is available.
     */
    public suspend fun restoreDbClusterToPointInTime(input: RestoreDbClusterToPointInTimeRequest): RestoreDbClusterToPointInTimeResponse

    /**
     * Starts an Amazon Neptune DB cluster that was stopped using the Amazon console, the Amazon CLI stop-db-cluster command, or the StopDBCluster API.
     */
    public suspend fun startDbCluster(input: StartDbClusterRequest): StartDbClusterResponse

    /**
     * Stops an Amazon Neptune DB cluster. When you stop a DB cluster, Neptune retains the DB cluster's metadata, including its endpoints and DB parameter groups.
     *
     * Neptune also retains the transaction logs so you can do a point-in-time restore if necessary.
     */
    public suspend fun stopDbCluster(input: StopDbClusterRequest): StopDbClusterResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun NeptuneClient.withConfig(block: NeptuneClient.Config.Builder.() -> Unit): NeptuneClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultNeptuneClient(newConfig)
}

/**
 * Associates an Identity and Access Management (IAM) role with an Neptune DB cluster.
 */
public suspend inline fun NeptuneClient.addRoleToDbCluster(crossinline block: AddRoleToDbClusterRequest.Builder.() -> Unit): AddRoleToDbClusterResponse = addRoleToDbCluster(AddRoleToDbClusterRequest.Builder().apply(block).build())

/**
 * Adds a source identifier to an existing event notification subscription.
 */
public suspend inline fun NeptuneClient.addSourceIdentifierToSubscription(crossinline block: AddSourceIdentifierToSubscriptionRequest.Builder.() -> Unit): AddSourceIdentifierToSubscriptionResponse = addSourceIdentifierToSubscription(AddSourceIdentifierToSubscriptionRequest.Builder().apply(block).build())

/**
 * Adds metadata tags to an Amazon Neptune resource. These tags can also be used with cost allocation reporting to track cost associated with Amazon Neptune resources, or used in a Condition statement in an IAM policy for Amazon Neptune.
 */
public suspend inline fun NeptuneClient.addTagsToResource(crossinline block: AddTagsToResourceRequest.Builder.() -> Unit): AddTagsToResourceResponse = addTagsToResource(AddTagsToResourceRequest.Builder().apply(block).build())

/**
 * Applies a pending maintenance action to a resource (for example, to a DB instance).
 */
public suspend inline fun NeptuneClient.applyPendingMaintenanceAction(crossinline block: ApplyPendingMaintenanceActionRequest.Builder.() -> Unit): ApplyPendingMaintenanceActionResponse = applyPendingMaintenanceAction(ApplyPendingMaintenanceActionRequest.Builder().apply(block).build())

/**
 * Copies the specified DB cluster parameter group.
 */
public suspend inline fun NeptuneClient.copyDbClusterParameterGroup(crossinline block: CopyDbClusterParameterGroupRequest.Builder.() -> Unit): CopyDbClusterParameterGroupResponse = copyDbClusterParameterGroup(CopyDbClusterParameterGroupRequest.Builder().apply(block).build())

/**
 * Copies a snapshot of a DB cluster.
 *
 * To copy a DB cluster snapshot from a shared manual DB cluster snapshot, `SourceDBClusterSnapshotIdentifier` must be the Amazon Resource Name (ARN) of the shared DB cluster snapshot.
 */
public suspend inline fun NeptuneClient.copyDbClusterSnapshot(crossinline block: CopyDbClusterSnapshotRequest.Builder.() -> Unit): CopyDbClusterSnapshotResponse = copyDbClusterSnapshot(CopyDbClusterSnapshotRequest.Builder().apply(block).build())

/**
 * Copies the specified DB parameter group.
 */
public suspend inline fun NeptuneClient.copyDbParameterGroup(crossinline block: CopyDbParameterGroupRequest.Builder.() -> Unit): CopyDbParameterGroupResponse = copyDbParameterGroup(CopyDbParameterGroupRequest.Builder().apply(block).build())

/**
 * Creates a new Amazon Neptune DB cluster.
 *
 * You can use the `ReplicationSourceIdentifier` parameter to create the DB cluster as a Read Replica of another DB cluster or Amazon Neptune DB instance.
 *
 * Note that when you create a new cluster using `CreateDBCluster` directly, deletion protection is disabled by default (when you create a new production cluster in the console, deletion protection is enabled by default). You can only delete a DB cluster if its `DeletionProtection` field is set to `false`.
 */
public suspend inline fun NeptuneClient.createDbCluster(crossinline block: CreateDbClusterRequest.Builder.() -> Unit): CreateDbClusterResponse = createDbCluster(CreateDbClusterRequest.Builder().apply(block).build())

/**
 * Creates a new custom endpoint and associates it with an Amazon Neptune DB cluster.
 */
public suspend inline fun NeptuneClient.createDbClusterEndpoint(crossinline block: CreateDbClusterEndpointRequest.Builder.() -> Unit): CreateDbClusterEndpointResponse = createDbClusterEndpoint(CreateDbClusterEndpointRequest.Builder().apply(block).build())

/**
 * Creates a new DB cluster parameter group.
 *
 * Parameters in a DB cluster parameter group apply to all of the instances in a DB cluster.
 *
 *  A DB cluster parameter group is initially created with the default parameters for the database engine used by instances in the DB cluster. To provide custom values for any of the parameters, you must modify the group after creating it using ModifyDBClusterParameterGroup. Once you've created a DB cluster parameter group, you need to associate it with your DB cluster using ModifyDBCluster. When you associate a new DB cluster parameter group with a running DB cluster, you need to reboot the DB instances in the DB cluster without failover for the new DB cluster parameter group and associated settings to take effect.
 *
 * After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon Neptune to fully complete the create action before the DB cluster parameter group is used as the default for a new DB cluster. This is especially important for parameters that are critical when creating the default database for a DB cluster, such as the character set for the default database defined by the `character_set_database` parameter. You can use the *Parameter Groups* option of the [Amazon Neptune console](https://console.aws.amazon.com/rds/) or the DescribeDBClusterParameters command to verify that your DB cluster parameter group has been created or modified.
 */
public suspend inline fun NeptuneClient.createDbClusterParameterGroup(crossinline block: CreateDbClusterParameterGroupRequest.Builder.() -> Unit): CreateDbClusterParameterGroupResponse = createDbClusterParameterGroup(CreateDbClusterParameterGroupRequest.Builder().apply(block).build())

/**
 * Creates a snapshot of a DB cluster.
 */
public suspend inline fun NeptuneClient.createDbClusterSnapshot(crossinline block: CreateDbClusterSnapshotRequest.Builder.() -> Unit): CreateDbClusterSnapshotResponse = createDbClusterSnapshot(CreateDbClusterSnapshotRequest.Builder().apply(block).build())

/**
 * Creates a new DB instance.
 */
public suspend inline fun NeptuneClient.createDbInstance(crossinline block: CreateDbInstanceRequest.Builder.() -> Unit): CreateDbInstanceResponse = createDbInstance(CreateDbInstanceRequest.Builder().apply(block).build())

/**
 * Creates a new DB parameter group.
 *
 * A DB parameter group is initially created with the default parameters for the database engine used by the DB instance. To provide custom values for any of the parameters, you must modify the group after creating it using *ModifyDBParameterGroup*. Once you've created a DB parameter group, you need to associate it with your DB instance using *ModifyDBInstance*. When you associate a new DB parameter group with a running DB instance, you need to reboot the DB instance without failover for the new DB parameter group and associated settings to take effect.
 *
 * After you create a DB parameter group, you should wait at least 5 minutes before creating your first DB instance that uses that DB parameter group as the default parameter group. This allows Amazon Neptune to fully complete the create action before the parameter group is used as the default for a new DB instance. This is especially important for parameters that are critical when creating the default database for a DB instance, such as the character set for the default database defined by the `character_set_database` parameter. You can use the *Parameter Groups* option of the Amazon Neptune console or the *DescribeDBParameters* command to verify that your DB parameter group has been created or modified.
 */
public suspend inline fun NeptuneClient.createDbParameterGroup(crossinline block: CreateDbParameterGroupRequest.Builder.() -> Unit): CreateDbParameterGroupResponse = createDbParameterGroup(CreateDbParameterGroupRequest.Builder().apply(block).build())

/**
 * Creates a new DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the Amazon Region.
 */
public suspend inline fun NeptuneClient.createDbSubnetGroup(crossinline block: CreateDbSubnetGroupRequest.Builder.() -> Unit): CreateDbSubnetGroupResponse = createDbSubnetGroup(CreateDbSubnetGroupRequest.Builder().apply(block).build())

/**
 * Creates an event notification subscription. This action requires a topic ARN (Amazon Resource Name) created by either the Neptune console, the SNS console, or the SNS API. To obtain an ARN with SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the SNS console.
 *
 * You can specify the type of source (SourceType) you want to be notified of, provide a list of Neptune sources (SourceIds) that triggers the events, and provide a list of event categories (EventCategories) for events you want to be notified of. For example, you can specify SourceType = db-instance, SourceIds = mydbinstance1, mydbinstance2 and EventCategories = Availability, Backup.
 *
 * If you specify both the SourceType and SourceIds, such as SourceType = db-instance and SourceIdentifier = myDBInstance1, you are notified of all the db-instance events for the specified source. If you specify a SourceType but do not specify a SourceIdentifier, you receive notice of the events for that source type for all your Neptune sources. If you do not specify either the SourceType nor the SourceIdentifier, you are notified of events generated from all Neptune sources belonging to your customer account.
 */
public suspend inline fun NeptuneClient.createEventSubscription(crossinline block: CreateEventSubscriptionRequest.Builder.() -> Unit): CreateEventSubscriptionResponse = createEventSubscription(CreateEventSubscriptionRequest.Builder().apply(block).build())

/**
 * Creates a Neptune global database spread across multiple Amazon Regions. The global database contains a single primary cluster with read-write capability, and read-only secondary clusters that receive data from the primary cluster through high-speed replication performed by the Neptune storage subsystem.
 *
 * You can create a global database that is initially empty, and then add a primary cluster and secondary clusters to it, or you can specify an existing Neptune cluster during the create operation to become the primary cluster of the global database.
 */
public suspend inline fun NeptuneClient.createGlobalCluster(crossinline block: CreateGlobalClusterRequest.Builder.() -> Unit): CreateGlobalClusterResponse = createGlobalCluster(CreateGlobalClusterRequest.Builder().apply(block).build())

/**
 * The DeleteDBCluster action deletes a previously provisioned DB cluster. When you delete a DB cluster, all automated backups for that DB cluster are deleted and can't be recovered. Manual DB cluster snapshots of the specified DB cluster are not deleted.
 *
 * Note that the DB Cluster cannot be deleted if deletion protection is enabled. To delete it, you must first set its `DeletionProtection` field to `False`.
 */
public suspend inline fun NeptuneClient.deleteDbCluster(crossinline block: DeleteDbClusterRequest.Builder.() -> Unit): DeleteDbClusterResponse = deleteDbCluster(DeleteDbClusterRequest.Builder().apply(block).build())

/**
 * Deletes a custom endpoint and removes it from an Amazon Neptune DB cluster.
 */
public suspend inline fun NeptuneClient.deleteDbClusterEndpoint(crossinline block: DeleteDbClusterEndpointRequest.Builder.() -> Unit): DeleteDbClusterEndpointResponse = deleteDbClusterEndpoint(DeleteDbClusterEndpointRequest.Builder().apply(block).build())

/**
 * Deletes a specified DB cluster parameter group. The DB cluster parameter group to be deleted can't be associated with any DB clusters.
 */
public suspend inline fun NeptuneClient.deleteDbClusterParameterGroup(crossinline block: DeleteDbClusterParameterGroupRequest.Builder.() -> Unit): DeleteDbClusterParameterGroupResponse = deleteDbClusterParameterGroup(DeleteDbClusterParameterGroupRequest.Builder().apply(block).build())

/**
 * Deletes a DB cluster snapshot. If the snapshot is being copied, the copy operation is terminated.
 *
 * The DB cluster snapshot must be in the `available` state to be deleted.
 */
public suspend inline fun NeptuneClient.deleteDbClusterSnapshot(crossinline block: DeleteDbClusterSnapshotRequest.Builder.() -> Unit): DeleteDbClusterSnapshotResponse = deleteDbClusterSnapshot(DeleteDbClusterSnapshotRequest.Builder().apply(block).build())

/**
 * The DeleteDBInstance action deletes a previously provisioned DB instance. When you delete a DB instance, all automated backups for that instance are deleted and can't be recovered. Manual DB snapshots of the DB instance to be deleted by `DeleteDBInstance` are not deleted.
 *
 *  If you request a final DB snapshot the status of the Amazon Neptune DB instance is `deleting` until the DB snapshot is created. The API action `DescribeDBInstance` is used to monitor the status of this operation. The action can't be canceled or reverted once submitted.
 *
 * Note that when a DB instance is in a failure state and has a status of `failed`, `incompatible-restore`, or `incompatible-network`, you can only delete it when the `SkipFinalSnapshot` parameter is set to `true`.
 *
 * You can't delete a DB instance if it is the only instance in the DB cluster, or if it has deletion protection enabled.
 */
public suspend inline fun NeptuneClient.deleteDbInstance(crossinline block: DeleteDbInstanceRequest.Builder.() -> Unit): DeleteDbInstanceResponse = deleteDbInstance(DeleteDbInstanceRequest.Builder().apply(block).build())

/**
 * Deletes a specified DBParameterGroup. The DBParameterGroup to be deleted can't be associated with any DB instances.
 */
public suspend inline fun NeptuneClient.deleteDbParameterGroup(crossinline block: DeleteDbParameterGroupRequest.Builder.() -> Unit): DeleteDbParameterGroupResponse = deleteDbParameterGroup(DeleteDbParameterGroupRequest.Builder().apply(block).build())

/**
 * Deletes a DB subnet group.
 *
 * The specified database subnet group must not be associated with any DB instances.
 */
public suspend inline fun NeptuneClient.deleteDbSubnetGroup(crossinline block: DeleteDbSubnetGroupRequest.Builder.() -> Unit): DeleteDbSubnetGroupResponse = deleteDbSubnetGroup(DeleteDbSubnetGroupRequest.Builder().apply(block).build())

/**
 * Deletes an event notification subscription.
 */
public suspend inline fun NeptuneClient.deleteEventSubscription(crossinline block: DeleteEventSubscriptionRequest.Builder.() -> Unit): DeleteEventSubscriptionResponse = deleteEventSubscription(DeleteEventSubscriptionRequest.Builder().apply(block).build())

/**
 * Deletes a global database. The primary and all secondary clusters must already be detached or deleted first.
 */
public suspend inline fun NeptuneClient.deleteGlobalCluster(crossinline block: DeleteGlobalClusterRequest.Builder.() -> Unit): DeleteGlobalClusterResponse = deleteGlobalCluster(DeleteGlobalClusterRequest.Builder().apply(block).build())

/**
 * Returns information about endpoints for an Amazon Neptune DB cluster.
 *
 * This operation can also return information for Amazon RDS clusters and Amazon DocDB clusters.
 */
public suspend inline fun NeptuneClient.describeDbClusterEndpoints(crossinline block: DescribeDbClusterEndpointsRequest.Builder.() -> Unit): DescribeDbClusterEndpointsResponse = describeDbClusterEndpoints(DescribeDbClusterEndpointsRequest.Builder().apply(block).build())

/**
 * Returns a list of `DBClusterParameterGroup` descriptions. If a `DBClusterParameterGroupName` parameter is specified, the list will contain only the description of the specified DB cluster parameter group.
 */
public suspend inline fun NeptuneClient.describeDbClusterParameterGroups(crossinline block: DescribeDbClusterParameterGroupsRequest.Builder.() -> Unit): DescribeDbClusterParameterGroupsResponse = describeDbClusterParameterGroups(DescribeDbClusterParameterGroupsRequest.Builder().apply(block).build())

/**
 * Returns the detailed parameter list for a particular DB cluster parameter group.
 */
public suspend inline fun NeptuneClient.describeDbClusterParameters(crossinline block: DescribeDbClusterParametersRequest.Builder.() -> Unit): DescribeDbClusterParametersResponse = describeDbClusterParameters(DescribeDbClusterParametersRequest.Builder().apply(block).build())

/**
 * Returns a list of DB cluster snapshot attribute names and values for a manual DB cluster snapshot.
 *
 * When sharing snapshots with other Amazon accounts, `DescribeDBClusterSnapshotAttributes` returns the `restore` attribute and a list of IDs for the Amazon accounts that are authorized to copy or restore the manual DB cluster snapshot. If `all` is included in the list of values for the `restore` attribute, then the manual DB cluster snapshot is public and can be copied or restored by all Amazon accounts.
 *
 * To add or remove access for an Amazon account to copy or restore a manual DB cluster snapshot, or to make the manual DB cluster snapshot public or private, use the ModifyDBClusterSnapshotAttribute API action.
 */
public suspend inline fun NeptuneClient.describeDbClusterSnapshotAttributes(crossinline block: DescribeDbClusterSnapshotAttributesRequest.Builder.() -> Unit): DescribeDbClusterSnapshotAttributesResponse = describeDbClusterSnapshotAttributes(DescribeDbClusterSnapshotAttributesRequest.Builder().apply(block).build())

/**
 * Returns information about DB cluster snapshots. This API action supports pagination.
 */
public suspend inline fun NeptuneClient.describeDbClusterSnapshots(crossinline block: DescribeDbClusterSnapshotsRequest.Builder.() -> Unit): DescribeDbClusterSnapshotsResponse = describeDbClusterSnapshots(DescribeDbClusterSnapshotsRequest.Builder().apply(block).build())

/**
 * Returns information about provisioned DB clusters, and supports pagination.
 *
 * This operation can also return information for Amazon RDS clusters and Amazon DocDB clusters.
 */
public suspend inline fun NeptuneClient.describeDbClusters(crossinline block: DescribeDbClustersRequest.Builder.() -> Unit): DescribeDbClustersResponse = describeDbClusters(DescribeDbClustersRequest.Builder().apply(block).build())

/**
 * Returns a list of the available DB engines.
 */
public suspend inline fun NeptuneClient.describeDbEngineVersions(crossinline block: DescribeDbEngineVersionsRequest.Builder.() -> Unit): DescribeDbEngineVersionsResponse = describeDbEngineVersions(DescribeDbEngineVersionsRequest.Builder().apply(block).build())

/**
 * Returns information about provisioned instances, and supports pagination.
 *
 * This operation can also return information for Amazon RDS instances and Amazon DocDB instances.
 */
public suspend inline fun NeptuneClient.describeDbInstances(crossinline block: DescribeDbInstancesRequest.Builder.() -> Unit): DescribeDbInstancesResponse = describeDbInstances(DescribeDbInstancesRequest.Builder().apply(block).build())

/**
 * Returns a list of `DBParameterGroup` descriptions. If a `DBParameterGroupName` is specified, the list will contain only the description of the specified DB parameter group.
 */
public suspend inline fun NeptuneClient.describeDbParameterGroups(crossinline block: DescribeDbParameterGroupsRequest.Builder.() -> Unit): DescribeDbParameterGroupsResponse = describeDbParameterGroups(DescribeDbParameterGroupsRequest.Builder().apply(block).build())

/**
 * Returns the detailed parameter list for a particular DB parameter group.
 */
public suspend inline fun NeptuneClient.describeDbParameters(crossinline block: DescribeDbParametersRequest.Builder.() -> Unit): DescribeDbParametersResponse = describeDbParameters(DescribeDbParametersRequest.Builder().apply(block).build())

/**
 * Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the descriptions of the specified DBSubnetGroup.
 *
 * For an overview of CIDR ranges, go to the [Wikipedia Tutorial](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
 */
public suspend inline fun NeptuneClient.describeDbSubnetGroups(crossinline block: DescribeDbSubnetGroupsRequest.Builder.() -> Unit): DescribeDbSubnetGroupsResponse = describeDbSubnetGroups(DescribeDbSubnetGroupsRequest.Builder().apply(block).build())

/**
 * Returns the default engine and system parameter information for the cluster database engine.
 */
public suspend inline fun NeptuneClient.describeEngineDefaultClusterParameters(crossinline block: DescribeEngineDefaultClusterParametersRequest.Builder.() -> Unit): DescribeEngineDefaultClusterParametersResponse = describeEngineDefaultClusterParameters(DescribeEngineDefaultClusterParametersRequest.Builder().apply(block).build())

/**
 * Returns the default engine and system parameter information for the specified database engine.
 */
public suspend inline fun NeptuneClient.describeEngineDefaultParameters(crossinline block: DescribeEngineDefaultParametersRequest.Builder.() -> Unit): DescribeEngineDefaultParametersResponse = describeEngineDefaultParameters(DescribeEngineDefaultParametersRequest.Builder().apply(block).build())

/**
 * Displays a list of categories for all event source types, or, if specified, for a specified source type.
 */
public suspend inline fun NeptuneClient.describeEventCategories(crossinline block: DescribeEventCategoriesRequest.Builder.() -> Unit): DescribeEventCategoriesResponse = describeEventCategories(DescribeEventCategoriesRequest.Builder().apply(block).build())

/**
 * Lists all the subscription descriptions for a customer account. The description for a subscription includes SubscriptionName, SNSTopicARN, CustomerID, SourceType, SourceID, CreationTime, and Status.
 *
 * If you specify a SubscriptionName, lists the description for that subscription.
 */
public suspend inline fun NeptuneClient.describeEventSubscriptions(crossinline block: DescribeEventSubscriptionsRequest.Builder.() -> Unit): DescribeEventSubscriptionsResponse = describeEventSubscriptions(DescribeEventSubscriptionsRequest.Builder().apply(block).build())

/**
 * Returns events related to DB instances, DB security groups, DB snapshots, and DB parameter groups for the past 14 days. Events specific to a particular DB instance, DB security group, database snapshot, or DB parameter group can be obtained by providing the name as a parameter. By default, the past hour of events are returned.
 */
public suspend inline fun NeptuneClient.describeEvents(crossinline block: DescribeEventsRequest.Builder.() -> Unit): DescribeEventsResponse = describeEvents(DescribeEventsRequest.Builder().apply(block).build())

/**
 * Returns information about Neptune global database clusters. This API supports pagination.
 */
public suspend inline fun NeptuneClient.describeGlobalClusters(crossinline block: DescribeGlobalClustersRequest.Builder.() -> Unit): DescribeGlobalClustersResponse = describeGlobalClusters(DescribeGlobalClustersRequest.Builder().apply(block).build())

/**
 * Returns a list of orderable DB instance options for the specified engine.
 */
public suspend inline fun NeptuneClient.describeOrderableDbInstanceOptions(crossinline block: DescribeOrderableDbInstanceOptionsRequest.Builder.() -> Unit): DescribeOrderableDbInstanceOptionsResponse = describeOrderableDbInstanceOptions(DescribeOrderableDbInstanceOptionsRequest.Builder().apply(block).build())

/**
 * Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.
 */
public suspend inline fun NeptuneClient.describePendingMaintenanceActions(crossinline block: DescribePendingMaintenanceActionsRequest.Builder.() -> Unit): DescribePendingMaintenanceActionsResponse = describePendingMaintenanceActions(DescribePendingMaintenanceActionsRequest.Builder().apply(block).build())

/**
 * You can call DescribeValidDBInstanceModifications to learn what modifications you can make to your DB instance. You can use this information when you call ModifyDBInstance.
 */
public suspend inline fun NeptuneClient.describeValidDbInstanceModifications(crossinline block: DescribeValidDbInstanceModificationsRequest.Builder.() -> Unit): DescribeValidDbInstanceModificationsResponse = describeValidDbInstanceModifications(DescribeValidDbInstanceModificationsRequest.Builder().apply(block).build())

/**
 * Forces a failover for a DB cluster.
 *
 * A failover for a DB cluster promotes one of the Read Replicas (read-only instances) in the DB cluster to be the primary instance (the cluster writer).
 *
 * Amazon Neptune will automatically fail over to a Read Replica, if one exists, when the primary instance fails. You can force a failover when you want to simulate a failure of a primary instance for testing. Because each instance in a DB cluster has its own endpoint address, you will need to clean up and re-establish any existing connections that use those endpoint addresses when the failover is complete.
 */
public suspend inline fun NeptuneClient.failoverDbCluster(crossinline block: FailoverDbClusterRequest.Builder.() -> Unit): FailoverDbClusterResponse = failoverDbCluster(FailoverDbClusterRequest.Builder().apply(block).build())

/**
 * Initiates the failover process for a Neptune global database.
 *
 * A failover for a Neptune global database promotes one of secondary read-only DB clusters to be the primary DB cluster and demotes the primary DB cluster to being a secondary (read-only) DB cluster. In other words, the role of the current primary DB cluster and the selected target secondary DB cluster are switched. The selected secondary DB cluster assumes full read/write capabilities for the Neptune global database.
 *
 * This action applies **only** to Neptune global databases. This action is only intended for use on healthy Neptune global databases with healthy Neptune DB clusters and no region-wide outages, to test disaster recovery scenarios or to reconfigure the global database topology.
 */
public suspend inline fun NeptuneClient.failoverGlobalCluster(crossinline block: FailoverGlobalClusterRequest.Builder.() -> Unit): FailoverGlobalClusterResponse = failoverGlobalCluster(FailoverGlobalClusterRequest.Builder().apply(block).build())

/**
 * Lists all tags on an Amazon Neptune resource.
 */
public suspend inline fun NeptuneClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Modify a setting for a DB cluster. You can change one or more database configuration parameters by specifying these parameters and the new values in the request.
 */
public suspend inline fun NeptuneClient.modifyDbCluster(crossinline block: ModifyDbClusterRequest.Builder.() -> Unit): ModifyDbClusterResponse = modifyDbCluster(ModifyDbClusterRequest.Builder().apply(block).build())

/**
 * Modifies the properties of an endpoint in an Amazon Neptune DB cluster.
 */
public suspend inline fun NeptuneClient.modifyDbClusterEndpoint(crossinline block: ModifyDbClusterEndpointRequest.Builder.() -> Unit): ModifyDbClusterEndpointResponse = modifyDbClusterEndpoint(ModifyDbClusterEndpointRequest.Builder().apply(block).build())

/**
 * Modifies the parameters of a DB cluster parameter group. To modify more than one parameter, submit a list of the following: `ParameterName`, `ParameterValue`, and `ApplyMethod`. A maximum of 20 parameters can be modified in a single request.
 *
 * Changes to dynamic parameters are applied immediately. Changes to static parameters require a reboot without failover to the DB cluster associated with the parameter group before the change can take effect.
 *
 * After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon Neptune to fully complete the create action before the parameter group is used as the default for a new DB cluster. This is especially important for parameters that are critical when creating the default database for a DB cluster, such as the character set for the default database defined by the `character_set_database` parameter. You can use the *Parameter Groups* option of the Amazon Neptune console or the DescribeDBClusterParameters command to verify that your DB cluster parameter group has been created or modified.
 */
public suspend inline fun NeptuneClient.modifyDbClusterParameterGroup(crossinline block: ModifyDbClusterParameterGroupRequest.Builder.() -> Unit): ModifyDbClusterParameterGroupResponse = modifyDbClusterParameterGroup(ModifyDbClusterParameterGroupRequest.Builder().apply(block).build())

/**
 * Adds an attribute and values to, or removes an attribute and values from, a manual DB cluster snapshot.
 *
 * To share a manual DB cluster snapshot with other Amazon accounts, specify `restore` as the `AttributeName` and use the `ValuesToAdd` parameter to add a list of IDs of the Amazon accounts that are authorized to restore the manual DB cluster snapshot. Use the value `all` to make the manual DB cluster snapshot public, which means that it can be copied or restored by all Amazon accounts. Do not add the `all` value for any manual DB cluster snapshots that contain private information that you don't want available to all Amazon accounts. If a manual DB cluster snapshot is encrypted, it can be shared, but only by specifying a list of authorized Amazon account IDs for the `ValuesToAdd` parameter. You can't use `all` as a value for that parameter in this case.
 *
 * To view which Amazon accounts have access to copy or restore a manual DB cluster snapshot, or whether a manual DB cluster snapshot public or private, use the DescribeDBClusterSnapshotAttributes API action.
 */
public suspend inline fun NeptuneClient.modifyDbClusterSnapshotAttribute(crossinline block: ModifyDbClusterSnapshotAttributeRequest.Builder.() -> Unit): ModifyDbClusterSnapshotAttributeResponse = modifyDbClusterSnapshotAttribute(ModifyDbClusterSnapshotAttributeRequest.Builder().apply(block).build())

/**
 * Modifies settings for a DB instance. You can change one or more database configuration parameters by specifying these parameters and the new values in the request. To learn what modifications you can make to your DB instance, call DescribeValidDBInstanceModifications before you call ModifyDBInstance.
 */
public suspend inline fun NeptuneClient.modifyDbInstance(crossinline block: ModifyDbInstanceRequest.Builder.() -> Unit): ModifyDbInstanceResponse = modifyDbInstance(ModifyDbInstanceRequest.Builder().apply(block).build())

/**
 * Modifies the parameters of a DB parameter group. To modify more than one parameter, submit a list of the following: `ParameterName`, `ParameterValue`, and `ApplyMethod`. A maximum of 20 parameters can be modified in a single request.
 *
 * Changes to dynamic parameters are applied immediately. Changes to static parameters require a reboot without failover to the DB instance associated with the parameter group before the change can take effect.
 *
 * After you modify a DB parameter group, you should wait at least 5 minutes before creating your first DB instance that uses that DB parameter group as the default parameter group. This allows Amazon Neptune to fully complete the modify action before the parameter group is used as the default for a new DB instance. This is especially important for parameters that are critical when creating the default database for a DB instance, such as the character set for the default database defined by the `character_set_database` parameter. You can use the *Parameter Groups* option of the Amazon Neptune console or the *DescribeDBParameters* command to verify that your DB parameter group has been created or modified.
 */
public suspend inline fun NeptuneClient.modifyDbParameterGroup(crossinline block: ModifyDbParameterGroupRequest.Builder.() -> Unit): ModifyDbParameterGroupResponse = modifyDbParameterGroup(ModifyDbParameterGroupRequest.Builder().apply(block).build())

/**
 * Modifies an existing DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the Amazon Region.
 */
public suspend inline fun NeptuneClient.modifyDbSubnetGroup(crossinline block: ModifyDbSubnetGroupRequest.Builder.() -> Unit): ModifyDbSubnetGroupResponse = modifyDbSubnetGroup(ModifyDbSubnetGroupRequest.Builder().apply(block).build())

/**
 * Modifies an existing event notification subscription. Note that you can't modify the source identifiers using this call; to change source identifiers for a subscription, use the AddSourceIdentifierToSubscription and RemoveSourceIdentifierFromSubscription calls.
 *
 * You can see a list of the event categories for a given SourceType by using the **DescribeEventCategories** action.
 */
public suspend inline fun NeptuneClient.modifyEventSubscription(crossinline block: ModifyEventSubscriptionRequest.Builder.() -> Unit): ModifyEventSubscriptionResponse = modifyEventSubscription(ModifyEventSubscriptionRequest.Builder().apply(block).build())

/**
 * Modify a setting for an Amazon Neptune global cluster. You can change one or more database configuration parameters by specifying these parameters and their new values in the request.
 */
public suspend inline fun NeptuneClient.modifyGlobalCluster(crossinline block: ModifyGlobalClusterRequest.Builder.() -> Unit): ModifyGlobalClusterResponse = modifyGlobalCluster(ModifyGlobalClusterRequest.Builder().apply(block).build())

/**
 * Not supported.
 */
public suspend inline fun NeptuneClient.promoteReadReplicaDbCluster(crossinline block: PromoteReadReplicaDbClusterRequest.Builder.() -> Unit): PromoteReadReplicaDbClusterResponse = promoteReadReplicaDbCluster(PromoteReadReplicaDbClusterRequest.Builder().apply(block).build())

/**
 * You might need to reboot your DB instance, usually for maintenance reasons. For example, if you make certain modifications, or if you change the DB parameter group associated with the DB instance, you must reboot the instance for the changes to take effect.
 *
 * Rebooting a DB instance restarts the database engine service. Rebooting a DB instance results in a momentary outage, during which the DB instance status is set to rebooting.
 */
public suspend inline fun NeptuneClient.rebootDbInstance(crossinline block: RebootDbInstanceRequest.Builder.() -> Unit): RebootDbInstanceResponse = rebootDbInstance(RebootDbInstanceRequest.Builder().apply(block).build())

/**
 * Detaches a Neptune DB cluster from a Neptune global database. A secondary cluster becomes a normal standalone cluster with read-write capability instead of being read-only, and no longer receives data from a the primary cluster.
 */
public suspend inline fun NeptuneClient.removeFromGlobalCluster(crossinline block: RemoveFromGlobalClusterRequest.Builder.() -> Unit): RemoveFromGlobalClusterResponse = removeFromGlobalCluster(RemoveFromGlobalClusterRequest.Builder().apply(block).build())

/**
 * Disassociates an Identity and Access Management (IAM) role from a DB cluster.
 */
public suspend inline fun NeptuneClient.removeRoleFromDbCluster(crossinline block: RemoveRoleFromDbClusterRequest.Builder.() -> Unit): RemoveRoleFromDbClusterResponse = removeRoleFromDbCluster(RemoveRoleFromDbClusterRequest.Builder().apply(block).build())

/**
 * Removes a source identifier from an existing event notification subscription.
 */
public suspend inline fun NeptuneClient.removeSourceIdentifierFromSubscription(crossinline block: RemoveSourceIdentifierFromSubscriptionRequest.Builder.() -> Unit): RemoveSourceIdentifierFromSubscriptionResponse = removeSourceIdentifierFromSubscription(RemoveSourceIdentifierFromSubscriptionRequest.Builder().apply(block).build())

/**
 * Removes metadata tags from an Amazon Neptune resource.
 */
public suspend inline fun NeptuneClient.removeTagsFromResource(crossinline block: RemoveTagsFromResourceRequest.Builder.() -> Unit): RemoveTagsFromResourceResponse = removeTagsFromResource(RemoveTagsFromResourceRequest.Builder().apply(block).build())

/**
 * Modifies the parameters of a DB cluster parameter group to the default value. To reset specific parameters submit a list of the following: `ParameterName` and `ApplyMethod`. To reset the entire DB cluster parameter group, specify the `DBClusterParameterGroupName` and `ResetAllParameters` parameters.
 *
 *  When resetting the entire group, dynamic parameters are updated immediately and static parameters are set to `pending-reboot` to take effect on the next DB instance restart or RebootDBInstance request. You must call RebootDBInstance for every DB instance in your DB cluster that you want the updated static parameter to apply to.
 */
public suspend inline fun NeptuneClient.resetDbClusterParameterGroup(crossinline block: ResetDbClusterParameterGroupRequest.Builder.() -> Unit): ResetDbClusterParameterGroupResponse = resetDbClusterParameterGroup(ResetDbClusterParameterGroupRequest.Builder().apply(block).build())

/**
 * Modifies the parameters of a DB parameter group to the engine/system default value. To reset specific parameters, provide a list of the following: `ParameterName` and `ApplyMethod`. To reset the entire DB parameter group, specify the `DBParameterGroup` name and `ResetAllParameters` parameters. When resetting the entire group, dynamic parameters are updated immediately and static parameters are set to `pending-reboot` to take effect on the next DB instance restart or `RebootDBInstance` request.
 */
public suspend inline fun NeptuneClient.resetDbParameterGroup(crossinline block: ResetDbParameterGroupRequest.Builder.() -> Unit): ResetDbParameterGroupResponse = resetDbParameterGroup(ResetDbParameterGroupRequest.Builder().apply(block).build())

/**
 * Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
 *
 * If a DB snapshot is specified, the target DB cluster is created from the source DB snapshot with a default configuration and default security group.
 *
 * If a DB cluster snapshot is specified, the target DB cluster is created from the source DB cluster restore point with the same configuration as the original source DB cluster, except that the new DB cluster is created with the default security group.
 */
public suspend inline fun NeptuneClient.restoreDbClusterFromSnapshot(crossinline block: RestoreDbClusterFromSnapshotRequest.Builder.() -> Unit): RestoreDbClusterFromSnapshotResponse = restoreDbClusterFromSnapshot(RestoreDbClusterFromSnapshotRequest.Builder().apply(block).build())

/**
 * Restores a DB cluster to an arbitrary point in time. Users can restore to any point in time before `LatestRestorableTime` for up to `BackupRetentionPeriod` days. The target DB cluster is created from the source DB cluster with the same configuration as the original DB cluster, except that the new DB cluster is created with the default DB security group.
 *
 * This action only restores the DB cluster, not the DB instances for that DB cluster. You must invoke the CreateDBInstance action to create DB instances for the restored DB cluster, specifying the identifier of the restored DB cluster in `DBClusterIdentifier`. You can create DB instances only after the `RestoreDBClusterToPointInTime` action has completed and the DB cluster is available.
 */
public suspend inline fun NeptuneClient.restoreDbClusterToPointInTime(crossinline block: RestoreDbClusterToPointInTimeRequest.Builder.() -> Unit): RestoreDbClusterToPointInTimeResponse = restoreDbClusterToPointInTime(RestoreDbClusterToPointInTimeRequest.Builder().apply(block).build())

/**
 * Starts an Amazon Neptune DB cluster that was stopped using the Amazon console, the Amazon CLI stop-db-cluster command, or the StopDBCluster API.
 */
public suspend inline fun NeptuneClient.startDbCluster(crossinline block: StartDbClusterRequest.Builder.() -> Unit): StartDbClusterResponse = startDbCluster(StartDbClusterRequest.Builder().apply(block).build())

/**
 * Stops an Amazon Neptune DB cluster. When you stop a DB cluster, Neptune retains the DB cluster's metadata, including its endpoints and DB parameter groups.
 *
 * Neptune also retains the transaction logs so you can do a point-in-time restore if necessary.
 */
public suspend inline fun NeptuneClient.stopDbCluster(crossinline block: StopDbClusterRequest.Builder.() -> Unit): StopDbClusterResponse = stopDbCluster(StopDbClusterRequest.Builder().apply(block).build())
