// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.serde

import aws.sdk.kotlin.services.neptune.model.DbCluster
import aws.sdk.kotlin.services.neptune.model.NeptuneException
import aws.sdk.kotlin.services.neptune.model.RestoreDbClusterFromSnapshotResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class RestoreDBClusterFromSnapshotOperationDeserializer: HttpDeserialize<RestoreDbClusterFromSnapshotResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): RestoreDbClusterFromSnapshotResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwRestoreDbClusterFromSnapshotError(context, call)
        }
        val builder = RestoreDbClusterFromSnapshotResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeRestoreDBClusterFromSnapshotOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwRestoreDbClusterFromSnapshotError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw NeptuneException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InsufficientDBClusterCapacityFault" -> InsufficientDbClusterCapacityFaultDeserializer().deserialize(context, wrappedCall)
        "InsufficientStorageClusterCapacity" -> InsufficientStorageClusterCapacityFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidDBSnapshotState" -> InvalidDbSnapshotStateFaultDeserializer().deserialize(context, wrappedCall)
        "DBSubnetGroupNotFoundFault" -> DbSubnetGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "KMSKeyNotAccessibleFault" -> KmsKeyNotAccessibleFaultDeserializer().deserialize(context, wrappedCall)
        "StorageQuotaExceeded" -> StorageQuotaExceededFaultDeserializer().deserialize(context, wrappedCall)
        "DBClusterSnapshotNotFoundFault" -> DbClusterSnapshotNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidVPCNetworkStateFault" -> InvalidVpcNetworkStateFaultDeserializer().deserialize(context, wrappedCall)
        "OptionGroupNotFoundFault" -> OptionGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "DBClusterParameterGroupNotFound" -> DbClusterParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidSubnet" -> InvalidSubnetDeserializer().deserialize(context, wrappedCall)
        "DBSnapshotNotFound" -> DbSnapshotNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidDBClusterSnapshotStateFault" -> InvalidDbClusterSnapshotStateFaultDeserializer().deserialize(context, wrappedCall)
        "DBClusterAlreadyExistsFault" -> DbClusterAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidRestoreFault" -> InvalidRestoreFaultDeserializer().deserialize(context, wrappedCall)
        "DBClusterQuotaExceededFault" -> DbClusterQuotaExceededFaultDeserializer().deserialize(context, wrappedCall)
        else -> NeptuneException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRestoreDBClusterFromSnapshotOperationBody(builder: RestoreDbClusterFromSnapshotResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "RestoreDBClusterFromSnapshot")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBCluster com.amazonaws.neptune#RestoreDBClusterFromSnapshotResult$DBCluster
            "DBCluster" -> builder.dbCluster = deserializeDbClusterDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
