// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.serde

import aws.sdk.kotlin.services.neptune.model.GlobalCluster
import aws.sdk.kotlin.services.neptune.model.ModifyGlobalClusterResponse
import aws.sdk.kotlin.services.neptune.model.NeptuneException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ModifyGlobalClusterOperationDeserializer: HttpDeserialize<ModifyGlobalClusterResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ModifyGlobalClusterResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwModifyGlobalClusterError(context, call)
        }
        val builder = ModifyGlobalClusterResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeModifyGlobalClusterOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwModifyGlobalClusterError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw NeptuneException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "GlobalClusterNotFoundFault" -> GlobalClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidGlobalClusterStateFault" -> InvalidGlobalClusterStateFaultDeserializer().deserialize(context, wrappedCall)
        else -> NeptuneException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyGlobalClusterOperationBody(builder: ModifyGlobalClusterResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "ModifyGlobalCluster")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // GlobalCluster com.amazonaws.neptune#ModifyGlobalClusterResult$GlobalCluster
            "GlobalCluster" -> builder.globalCluster = deserializeGlobalClusterDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
