// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.serde

import aws.sdk.kotlin.services.neptune.model.DbSubnetGroup
import aws.sdk.kotlin.services.neptune.model.ModifyDbSubnetGroupResponse
import aws.sdk.kotlin.services.neptune.model.NeptuneException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ModifyDBSubnetGroupOperationDeserializer: HttpDeserialize<ModifyDbSubnetGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ModifyDbSubnetGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwModifyDbSubnetGroupError(context, call)
        }
        val builder = ModifyDbSubnetGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeModifyDBSubnetGroupOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwModifyDbSubnetGroupError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw NeptuneException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBSubnetGroupDoesNotCoverEnoughAZs" -> DbSubnetGroupDoesNotCoverEnoughAzsDeserializer().deserialize(context, wrappedCall)
        "DBSubnetGroupNotFoundFault" -> DbSubnetGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "DBSubnetQuotaExceededFault" -> DbSubnetQuotaExceededFaultDeserializer().deserialize(context, wrappedCall)
        "SubnetAlreadyInUse" -> SubnetAlreadyInUseDeserializer().deserialize(context, wrappedCall)
        "InvalidSubnet" -> InvalidSubnetDeserializer().deserialize(context, wrappedCall)
        else -> NeptuneException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyDBSubnetGroupOperationBody(builder: ModifyDbSubnetGroupResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "ModifyDBSubnetGroup")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBSubnetGroup com.amazonaws.neptune#ModifyDBSubnetGroupResult$DBSubnetGroup
            "DBSubnetGroup" -> builder.dbSubnetGroup = deserializeDbSubnetGroupDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
