// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.serde

import aws.sdk.kotlin.services.neptune.model.DbClusterSnapshotAttributesResult
import aws.sdk.kotlin.services.neptune.model.ModifyDbClusterSnapshotAttributeResponse
import aws.sdk.kotlin.services.neptune.model.NeptuneException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ModifyDBClusterSnapshotAttributeOperationDeserializer: HttpDeserialize<ModifyDbClusterSnapshotAttributeResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ModifyDbClusterSnapshotAttributeResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwModifyDbClusterSnapshotAttributeError(context, call)
        }
        val builder = ModifyDbClusterSnapshotAttributeResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeModifyDBClusterSnapshotAttributeOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwModifyDbClusterSnapshotAttributeError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw NeptuneException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidDBClusterSnapshotStateFault" -> InvalidDbClusterSnapshotStateFaultDeserializer().deserialize(context, wrappedCall)
        "SharedSnapshotQuotaExceeded" -> SharedSnapshotQuotaExceededFaultDeserializer().deserialize(context, wrappedCall)
        "DBClusterSnapshotNotFoundFault" -> DbClusterSnapshotNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        else -> NeptuneException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyDBClusterSnapshotAttributeOperationBody(builder: ModifyDbClusterSnapshotAttributeResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "ModifyDBClusterSnapshotAttribute")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBClusterSnapshotAttributesResult com.amazonaws.neptune#ModifyDBClusterSnapshotAttributeResult$DBClusterSnapshotAttributesResult
            "DBClusterSnapshotAttributesResult" -> builder.dbClusterSnapshotAttributesResult = deserializeDbClusterSnapshotAttributesResultDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
