// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.serde

import aws.sdk.kotlin.services.neptune.model.FailoverGlobalClusterResponse
import aws.sdk.kotlin.services.neptune.model.GlobalCluster
import aws.sdk.kotlin.services.neptune.model.NeptuneException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class FailoverGlobalClusterOperationDeserializer: HttpDeserialize<FailoverGlobalClusterResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): FailoverGlobalClusterResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwFailoverGlobalClusterError(context, call)
        }
        val builder = FailoverGlobalClusterResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeFailoverGlobalClusterOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwFailoverGlobalClusterError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw NeptuneException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBClusterNotFoundFault" -> DbClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "GlobalClusterNotFoundFault" -> GlobalClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidGlobalClusterStateFault" -> InvalidGlobalClusterStateFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidDBClusterStateFault" -> InvalidDbClusterStateFaultDeserializer().deserialize(context, wrappedCall)
        else -> NeptuneException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeFailoverGlobalClusterOperationBody(builder: FailoverGlobalClusterResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "FailoverGlobalCluster")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // GlobalCluster com.amazonaws.neptune#FailoverGlobalClusterResult$GlobalCluster
            "GlobalCluster" -> builder.globalCluster = deserializeGlobalClusterDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
