// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.serde

import aws.sdk.kotlin.services.neptune.model.DescribeEngineDefaultParametersResponse
import aws.sdk.kotlin.services.neptune.model.EngineDefaults
import aws.sdk.kotlin.services.neptune.model.NeptuneException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class DescribeEngineDefaultParametersOperationDeserializer: HttpDeserialize<DescribeEngineDefaultParametersResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeEngineDefaultParametersResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeEngineDefaultParametersError(context, call)
        }
        val builder = DescribeEngineDefaultParametersResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeEngineDefaultParametersOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeEngineDefaultParametersError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw NeptuneException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> NeptuneException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeEngineDefaultParametersOperationBody(builder: DescribeEngineDefaultParametersResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DescribeEngineDefaultParameters")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // EngineDefaults com.amazonaws.neptune#DescribeEngineDefaultParametersResult$EngineDefaults
            "EngineDefaults" -> builder.engineDefaults = deserializeEngineDefaultsDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
