// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.serde

import aws.sdk.kotlin.services.neptune.model.DescribeDbParametersResponse
import aws.sdk.kotlin.services.neptune.model.NeptuneException
import aws.sdk.kotlin.services.neptune.model.Parameter
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class DescribeDBParametersOperationDeserializer: HttpDeserialize<DescribeDbParametersResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeDbParametersResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeDbParametersError(context, call)
        }
        val builder = DescribeDbParametersResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeDBParametersOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeDbParametersError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw NeptuneException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBParameterGroupNotFound" -> DbParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        else -> NeptuneException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeDBParametersOperationBody(builder: DescribeDbParametersResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DescribeDBParameters")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // Marker com.amazonaws.neptune#DBParameterGroupDetails$Marker
            "Marker" -> builder.marker = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // Parameters com.amazonaws.neptune#DBParameterGroupDetails$Parameters
            "Parameters" -> builder.parameters = deserializeParametersListShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
