// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.serde

import aws.sdk.kotlin.services.neptune.model.DeleteDbClusterEndpointResponse
import aws.sdk.kotlin.services.neptune.model.NeptuneException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class DeleteDBClusterEndpointOperationDeserializer: HttpDeserialize<DeleteDbClusterEndpointResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DeleteDbClusterEndpointResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteDbClusterEndpointError(context, call)
        }
        val builder = DeleteDbClusterEndpointResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteDBClusterEndpointOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDeleteDbClusterEndpointError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw NeptuneException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidDBClusterEndpointStateFault" -> InvalidDbClusterEndpointStateFaultDeserializer().deserialize(context, wrappedCall)
        "DBClusterEndpointNotFoundFault" -> DbClusterEndpointNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidDBClusterStateFault" -> InvalidDbClusterStateFaultDeserializer().deserialize(context, wrappedCall)
        else -> NeptuneException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteDBClusterEndpointOperationBody(builder: DeleteDbClusterEndpointResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DeleteDBClusterEndpoint")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // CustomEndpointType com.amazonaws.neptune#DeleteDBClusterEndpointOutput$CustomEndpointType
            "CustomEndpointType" -> builder.customEndpointType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // DBClusterEndpointArn com.amazonaws.neptune#DeleteDBClusterEndpointOutput$DBClusterEndpointArn
            "DBClusterEndpointArn" -> builder.dbClusterEndpointArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // DBClusterEndpointIdentifier com.amazonaws.neptune#DeleteDBClusterEndpointOutput$DBClusterEndpointIdentifier
            "DBClusterEndpointIdentifier" -> builder.dbClusterEndpointIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // DBClusterEndpointResourceIdentifier com.amazonaws.neptune#DeleteDBClusterEndpointOutput$DBClusterEndpointResourceIdentifier
            "DBClusterEndpointResourceIdentifier" -> builder.dbClusterEndpointResourceIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // DBClusterIdentifier com.amazonaws.neptune#DeleteDBClusterEndpointOutput$DBClusterIdentifier
            "DBClusterIdentifier" -> builder.dbClusterIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // Endpoint com.amazonaws.neptune#DeleteDBClusterEndpointOutput$Endpoint
            "Endpoint" -> builder.endpoint = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // EndpointType com.amazonaws.neptune#DeleteDBClusterEndpointOutput$EndpointType
            "EndpointType" -> builder.endpointType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // ExcludedMembers com.amazonaws.neptune#DeleteDBClusterEndpointOutput$ExcludedMembers
            "ExcludedMembers" -> builder.excludedMembers = deserializeStringListShape(curr)
            // StaticMembers com.amazonaws.neptune#DeleteDBClusterEndpointOutput$StaticMembers
            "StaticMembers" -> builder.staticMembers = deserializeStringListShape(curr)
            // Status com.amazonaws.neptune#DeleteDBClusterEndpointOutput$Status
            "Status" -> builder.status = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            else -> {}
        }
        curr.drop()
    }
}
