// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.serde

import aws.sdk.kotlin.services.neptune.model.DbCluster
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeDbClusterDocument(reader: XmlTagReader): DbCluster {
    val builder = DbCluster.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // AllocatedStorage com.amazonaws.neptune#DBCluster$AllocatedStorage
            "AllocatedStorage" -> builder.allocatedStorage = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.neptune#IntegerOptional`)" }
            // AvailabilityZones com.amazonaws.neptune#DBCluster$AvailabilityZones
            "AvailabilityZones" -> builder.availabilityZones = deserializeAvailabilityZonesShape(curr)
            // BackupRetentionPeriod com.amazonaws.neptune#DBCluster$BackupRetentionPeriod
            "BackupRetentionPeriod" -> builder.backupRetentionPeriod = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.neptune#IntegerOptional`)" }
            // CharacterSetName com.amazonaws.neptune#DBCluster$CharacterSetName
            "CharacterSetName" -> builder.characterSetName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // DatabaseName com.amazonaws.neptune#DBCluster$DatabaseName
            "DatabaseName" -> builder.databaseName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // DBClusterIdentifier com.amazonaws.neptune#DBCluster$DBClusterIdentifier
            "DBClusterIdentifier" -> builder.dbClusterIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // DBClusterParameterGroup com.amazonaws.neptune#DBCluster$DBClusterParameterGroup
            "DBClusterParameterGroup" -> builder.dbClusterParameterGroup = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // DBSubnetGroup com.amazonaws.neptune#DBCluster$DBSubnetGroup
            "DBSubnetGroup" -> builder.dbSubnetGroup = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // Status com.amazonaws.neptune#DBCluster$Status
            "Status" -> builder.status = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // PercentProgress com.amazonaws.neptune#DBCluster$PercentProgress
            "PercentProgress" -> builder.percentProgress = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // EarliestRestorableTime com.amazonaws.neptune#DBCluster$EarliestRestorableTime
            "EarliestRestorableTime" -> builder.earliestRestorableTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.neptune#TStamp`)" }
            // Endpoint com.amazonaws.neptune#DBCluster$Endpoint
            "Endpoint" -> builder.endpoint = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // ReaderEndpoint com.amazonaws.neptune#DBCluster$ReaderEndpoint
            "ReaderEndpoint" -> builder.readerEndpoint = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // MultiAZ com.amazonaws.neptune#DBCluster$MultiAZ
            "MultiAZ" -> builder.multiAz = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.neptune#Boolean`)" }
            // Engine com.amazonaws.neptune#DBCluster$Engine
            "Engine" -> builder.engine = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // EngineVersion com.amazonaws.neptune#DBCluster$EngineVersion
            "EngineVersion" -> builder.engineVersion = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // LatestRestorableTime com.amazonaws.neptune#DBCluster$LatestRestorableTime
            "LatestRestorableTime" -> builder.latestRestorableTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.neptune#TStamp`)" }
            // Port com.amazonaws.neptune#DBCluster$Port
            "Port" -> builder.port = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.neptune#IntegerOptional`)" }
            // MasterUsername com.amazonaws.neptune#DBCluster$MasterUsername
            "MasterUsername" -> builder.masterUsername = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // DBClusterOptionGroupMemberships com.amazonaws.neptune#DBCluster$DBClusterOptionGroupMemberships
            "DBClusterOptionGroupMemberships" -> builder.dbClusterOptionGroupMemberships = deserializeDBClusterOptionGroupMembershipsShape(curr)
            // PreferredBackupWindow com.amazonaws.neptune#DBCluster$PreferredBackupWindow
            "PreferredBackupWindow" -> builder.preferredBackupWindow = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // PreferredMaintenanceWindow com.amazonaws.neptune#DBCluster$PreferredMaintenanceWindow
            "PreferredMaintenanceWindow" -> builder.preferredMaintenanceWindow = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // ReplicationSourceIdentifier com.amazonaws.neptune#DBCluster$ReplicationSourceIdentifier
            "ReplicationSourceIdentifier" -> builder.replicationSourceIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // ReadReplicaIdentifiers com.amazonaws.neptune#DBCluster$ReadReplicaIdentifiers
            "ReadReplicaIdentifiers" -> builder.readReplicaIdentifiers = deserializeReadReplicaIdentifierListShape(curr)
            // DBClusterMembers com.amazonaws.neptune#DBCluster$DBClusterMembers
            "DBClusterMembers" -> builder.dbClusterMembers = deserializeDBClusterMemberListShape(curr)
            // VpcSecurityGroups com.amazonaws.neptune#DBCluster$VpcSecurityGroups
            "VpcSecurityGroups" -> builder.vpcSecurityGroups = deserializeVpcSecurityGroupMembershipListShape(curr)
            // HostedZoneId com.amazonaws.neptune#DBCluster$HostedZoneId
            "HostedZoneId" -> builder.hostedZoneId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // StorageEncrypted com.amazonaws.neptune#DBCluster$StorageEncrypted
            "StorageEncrypted" -> builder.storageEncrypted = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.neptune#Boolean`)" }
            // KmsKeyId com.amazonaws.neptune#DBCluster$KmsKeyId
            "KmsKeyId" -> builder.kmsKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // DbClusterResourceId com.amazonaws.neptune#DBCluster$DbClusterResourceId
            "DbClusterResourceId" -> builder.dbClusterResourceId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // DBClusterArn com.amazonaws.neptune#DBCluster$DBClusterArn
            "DBClusterArn" -> builder.dbClusterArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // AssociatedRoles com.amazonaws.neptune#DBCluster$AssociatedRoles
            "AssociatedRoles" -> builder.associatedRoles = deserializeDBClusterRolesShape(curr)
            // IAMDatabaseAuthenticationEnabled com.amazonaws.neptune#DBCluster$IAMDatabaseAuthenticationEnabled
            "IAMDatabaseAuthenticationEnabled" -> builder.iamDatabaseAuthenticationEnabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.neptune#Boolean`)" }
            // CloneGroupId com.amazonaws.neptune#DBCluster$CloneGroupId
            "CloneGroupId" -> builder.cloneGroupId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // ClusterCreateTime com.amazonaws.neptune#DBCluster$ClusterCreateTime
            "ClusterCreateTime" -> builder.clusterCreateTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.neptune#TStamp`)" }
            // CopyTagsToSnapshot com.amazonaws.neptune#DBCluster$CopyTagsToSnapshot
            "CopyTagsToSnapshot" -> builder.copyTagsToSnapshot = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.neptune#BooleanOptional`)" }
            // EnabledCloudwatchLogsExports com.amazonaws.neptune#DBCluster$EnabledCloudwatchLogsExports
            "EnabledCloudwatchLogsExports" -> builder.enabledCloudwatchLogsExports = deserializeLogTypeListShape(curr)
            // PendingModifiedValues com.amazonaws.neptune#DBCluster$PendingModifiedValues
            "PendingModifiedValues" -> builder.pendingModifiedValues = deserializeClusterPendingModifiedValuesDocument(curr)
            // DeletionProtection com.amazonaws.neptune#DBCluster$DeletionProtection
            "DeletionProtection" -> builder.deletionProtection = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.neptune#BooleanOptional`)" }
            // CrossAccountClone com.amazonaws.neptune#DBCluster$CrossAccountClone
            "CrossAccountClone" -> builder.crossAccountClone = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.neptune#BooleanOptional`)" }
            // AutomaticRestartTime com.amazonaws.neptune#DBCluster$AutomaticRestartTime
            "AutomaticRestartTime" -> builder.automaticRestartTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.neptune#TStamp`)" }
            // ServerlessV2ScalingConfiguration com.amazonaws.neptune#DBCluster$ServerlessV2ScalingConfiguration
            "ServerlessV2ScalingConfiguration" -> builder.serverlessV2ScalingConfiguration = deserializeServerlessV2ScalingConfigurationInfoDocument(curr)
            // GlobalClusterIdentifier com.amazonaws.neptune#DBCluster$GlobalClusterIdentifier
            "GlobalClusterIdentifier" -> builder.globalClusterIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#GlobalClusterIdentifier`)" }
            // IOOptimizedNextAllowedModificationTime com.amazonaws.neptune#DBCluster$IOOptimizedNextAllowedModificationTime
            "IOOptimizedNextAllowedModificationTime" -> builder.ioOptimizedNextAllowedModificationTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.neptune#TStamp`)" }
            // StorageType com.amazonaws.neptune#DBCluster$StorageType
            "StorageType" -> builder.storageType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
