// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.serde

import aws.sdk.kotlin.services.neptune.model.CreateDbSubnetGroupResponse
import aws.sdk.kotlin.services.neptune.model.DbSubnetGroup
import aws.sdk.kotlin.services.neptune.model.NeptuneException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateDBSubnetGroupOperationDeserializer: HttpDeserialize<CreateDbSubnetGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateDbSubnetGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateDbSubnetGroupError(context, call)
        }
        val builder = CreateDbSubnetGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateDBSubnetGroupOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateDbSubnetGroupError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw NeptuneException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBSubnetGroupDoesNotCoverEnoughAZs" -> DbSubnetGroupDoesNotCoverEnoughAzsDeserializer().deserialize(context, wrappedCall)
        "DBSubnetGroupQuotaExceeded" -> DbSubnetGroupQuotaExceededFaultDeserializer().deserialize(context, wrappedCall)
        "DBSubnetQuotaExceededFault" -> DbSubnetQuotaExceededFaultDeserializer().deserialize(context, wrappedCall)
        "DBSubnetGroupAlreadyExists" -> DbSubnetGroupAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidSubnet" -> InvalidSubnetDeserializer().deserialize(context, wrappedCall)
        else -> NeptuneException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateDBSubnetGroupOperationBody(builder: CreateDbSubnetGroupResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateDBSubnetGroup")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBSubnetGroup com.amazonaws.neptune#CreateDBSubnetGroupResult$DBSubnetGroup
            "DBSubnetGroup" -> builder.dbSubnetGroup = deserializeDbSubnetGroupDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
