// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.serde

import aws.sdk.kotlin.services.neptune.model.CreateDbClusterEndpointResponse
import aws.sdk.kotlin.services.neptune.model.NeptuneException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateDBClusterEndpointOperationDeserializer: HttpDeserialize<CreateDbClusterEndpointResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateDbClusterEndpointResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateDbClusterEndpointError(context, call)
        }
        val builder = CreateDbClusterEndpointResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateDBClusterEndpointOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateDbClusterEndpointError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw NeptuneException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBClusterNotFoundFault" -> DbClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "DBInstanceNotFound" -> DbInstanceNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidDBClusterStateFault" -> InvalidDbClusterStateFaultDeserializer().deserialize(context, wrappedCall)
        "DBClusterEndpointQuotaExceededFault" -> DbClusterEndpointQuotaExceededFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidDBInstanceState" -> InvalidDbInstanceStateFaultDeserializer().deserialize(context, wrappedCall)
        "DBClusterEndpointAlreadyExistsFault" -> DbClusterEndpointAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall)
        else -> NeptuneException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateDBClusterEndpointOperationBody(builder: CreateDbClusterEndpointResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateDBClusterEndpoint")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // CustomEndpointType com.amazonaws.neptune#CreateDBClusterEndpointOutput$CustomEndpointType
            "CustomEndpointType" -> builder.customEndpointType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // DBClusterEndpointArn com.amazonaws.neptune#CreateDBClusterEndpointOutput$DBClusterEndpointArn
            "DBClusterEndpointArn" -> builder.dbClusterEndpointArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // DBClusterEndpointIdentifier com.amazonaws.neptune#CreateDBClusterEndpointOutput$DBClusterEndpointIdentifier
            "DBClusterEndpointIdentifier" -> builder.dbClusterEndpointIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // DBClusterEndpointResourceIdentifier com.amazonaws.neptune#CreateDBClusterEndpointOutput$DBClusterEndpointResourceIdentifier
            "DBClusterEndpointResourceIdentifier" -> builder.dbClusterEndpointResourceIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // DBClusterIdentifier com.amazonaws.neptune#CreateDBClusterEndpointOutput$DBClusterIdentifier
            "DBClusterIdentifier" -> builder.dbClusterIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // Endpoint com.amazonaws.neptune#CreateDBClusterEndpointOutput$Endpoint
            "Endpoint" -> builder.endpoint = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // EndpointType com.amazonaws.neptune#CreateDBClusterEndpointOutput$EndpointType
            "EndpointType" -> builder.endpointType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            // ExcludedMembers com.amazonaws.neptune#CreateDBClusterEndpointOutput$ExcludedMembers
            "ExcludedMembers" -> builder.excludedMembers = deserializeStringListShape(curr)
            // StaticMembers com.amazonaws.neptune#CreateDBClusterEndpointOutput$StaticMembers
            "StaticMembers" -> builder.staticMembers = deserializeStringListShape(curr)
            // Status com.amazonaws.neptune#CreateDBClusterEndpointOutput$Status
            "Status" -> builder.status = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.neptune#String`)" }
            else -> {}
        }
        curr.drop()
    }
}
