// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.model

import aws.smithy.kotlin.runtime.time.Instant

public class RestoreDbClusterToPointInTimeRequest private constructor(builder: Builder) {
    /**
     * The name of the new DB cluster to be created.
     *
     * Constraints:
     * + Must contain from 1 to 63 letters, numbers, or hyphens
     * + First character must be a letter
     * + Cannot end with a hyphen or contain two consecutive hyphens
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The name of the DB cluster parameter group to associate with the new DB cluster.
     *
     * Constraints:
     * + If supplied, must match the name of an existing DBClusterParameterGroup.
     */
    public val dbClusterParameterGroupName: kotlin.String? = builder.dbClusterParameterGroupName
    /**
     * The DB subnet group name to use for the new DB cluster.
     *
     * Constraints: If supplied, must match the name of an existing DBSubnetGroup.
     *
     * Example: `mySubnetgroup`
     */
    public val dbSubnetGroupName: kotlin.String? = builder.dbSubnetGroupName
    /**
     * A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * The list of logs that the restored DB cluster is to export to CloudWatch Logs.
     */
    public val enableCloudwatchLogsExports: List<String>? = builder.enableCloudwatchLogsExports
    /**
     * True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database accounts, and otherwise false.
     *
     * Default: `false`
     */
    public val enableIamDatabaseAuthentication: kotlin.Boolean? = builder.enableIamDatabaseAuthentication
    /**
     * The Amazon KMS key identifier to use when restoring an encrypted DB cluster from an encrypted DB cluster.
     *
     * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a DB cluster with the same Amazon account that owns the KMS encryption key used to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.
     *
     * You can restore to a new DB cluster and encrypt the new DB cluster with a KMS key that is different than the KMS key used to encrypt the source DB cluster. The new DB cluster is encrypted with the KMS key identified by the `KmsKeyId` parameter.
     *
     * If you do not specify a value for the `KmsKeyId` parameter, then the following will occur:
     * + If the DB cluster is encrypted, then the restored DB cluster is encrypted using the KMS key that was used to encrypt the source DB cluster.
     * + If the DB cluster is not encrypted, then the restored DB cluster is not encrypted.
     *
     * If `DBClusterIdentifier` refers to a DB cluster that is not encrypted, then the restore request is rejected.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * *(Not supported by Neptune)*
     */
    public val optionGroupName: kotlin.String? = builder.optionGroupName
    /**
     * The port number on which the new DB cluster accepts connections.
     *
     * Constraints: Value must be `1150-65535`
     *
     * Default: The same port as the original DB cluster.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The date and time to restore the DB cluster to.
     *
     * Valid Values: Value must be a time in Universal Coordinated Time (UTC) format
     *
     * Constraints:
     * + Must be before the latest restorable time for the DB instance
     * + Must be specified if `UseLatestRestorableTime` parameter is not provided
     * + Cannot be specified if `UseLatestRestorableTime` parameter is true
     * + Cannot be specified if `RestoreType` parameter is `copy-on-write`
     *
     * Example: `2015-03-07T23:45:00Z`
     */
    public val restoreToTime: aws.smithy.kotlin.runtime.time.Instant? = builder.restoreToTime
    /**
     * The type of restore to be performed. You can specify one of the following values:
     * + `full-copy` - The new DB cluster is restored as a full copy of the source DB cluster.
     * + `copy-on-write` - The new DB cluster is restored as a clone of the source DB cluster.
     *
     * If you don't specify a `RestoreType` value, then the new DB cluster is restored as a full copy of the source DB cluster.
     */
    public val restoreType: kotlin.String? = builder.restoreType
    /**
     * Contains the scaling configuration of a Neptune Serverless DB cluster.
     *
     * For more information, see [Using Amazon Neptune Serverless](https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-using.html) in the *Amazon Neptune User Guide*.
     */
    public val serverlessV2ScalingConfiguration: aws.sdk.kotlin.services.neptune.model.ServerlessV2ScalingConfiguration? = builder.serverlessV2ScalingConfiguration
    /**
     * The identifier of the source DB cluster from which to restore.
     *
     * Constraints:
     * + Must match the identifier of an existing DBCluster.
     */
    public val sourceDbClusterIdentifier: kotlin.String? = builder.sourceDbClusterIdentifier
    /**
     * Specifies the storage type to be associated with the DB cluster.
     *
     * Valid values: `standard`, `iopt1`
     *
     * Default: `standard`
     */
    public val storageType: kotlin.String? = builder.storageType
    /**
     * The tags to be applied to the restored DB cluster.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * A value that is set to `true` to restore the DB cluster to the latest restorable backup time, and `false` otherwise.
     *
     * Default: `false`
     *
     * Constraints: Cannot be specified if `RestoreToTime` parameter is provided.
     */
    public val useLatestRestorableTime: kotlin.Boolean? = builder.useLatestRestorableTime
    /**
     * A list of VPC security groups that the new DB cluster belongs to.
     */
    public val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptune.model.RestoreDbClusterToPointInTimeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreDbClusterToPointInTimeRequest(")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbClusterParameterGroupName=$dbClusterParameterGroupName,")
        append("dbSubnetGroupName=$dbSubnetGroupName,")
        append("deletionProtection=$deletionProtection,")
        append("enableCloudwatchLogsExports=$enableCloudwatchLogsExports,")
        append("enableIamDatabaseAuthentication=$enableIamDatabaseAuthentication,")
        append("kmsKeyId=$kmsKeyId,")
        append("optionGroupName=$optionGroupName,")
        append("port=$port,")
        append("restoreToTime=$restoreToTime,")
        append("restoreType=$restoreType,")
        append("serverlessV2ScalingConfiguration=$serverlessV2ScalingConfiguration,")
        append("sourceDbClusterIdentifier=$sourceDbClusterIdentifier,")
        append("storageType=$storageType,")
        append("tags=$tags,")
        append("useLatestRestorableTime=$useLatestRestorableTime,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbClusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (dbClusterParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (enableCloudwatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (enableIamDatabaseAuthentication?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (optionGroupName?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (restoreToTime?.hashCode() ?: 0)
        result = 31 * result + (restoreType?.hashCode() ?: 0)
        result = 31 * result + (serverlessV2ScalingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (sourceDbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (useLatestRestorableTime?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestoreDbClusterToPointInTimeRequest

        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbClusterParameterGroupName != other.dbClusterParameterGroupName) return false
        if (dbSubnetGroupName != other.dbSubnetGroupName) return false
        if (deletionProtection != other.deletionProtection) return false
        if (enableCloudwatchLogsExports != other.enableCloudwatchLogsExports) return false
        if (enableIamDatabaseAuthentication != other.enableIamDatabaseAuthentication) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (optionGroupName != other.optionGroupName) return false
        if (port != other.port) return false
        if (restoreToTime != other.restoreToTime) return false
        if (restoreType != other.restoreType) return false
        if (serverlessV2ScalingConfiguration != other.serverlessV2ScalingConfiguration) return false
        if (sourceDbClusterIdentifier != other.sourceDbClusterIdentifier) return false
        if (storageType != other.storageType) return false
        if (tags != other.tags) return false
        if (useLatestRestorableTime != other.useLatestRestorableTime) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptune.model.RestoreDbClusterToPointInTimeRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the new DB cluster to be created.
         *
         * Constraints:
         * + Must contain from 1 to 63 letters, numbers, or hyphens
         * + First character must be a letter
         * + Cannot end with a hyphen or contain two consecutive hyphens
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * The name of the DB cluster parameter group to associate with the new DB cluster.
         *
         * Constraints:
         * + If supplied, must match the name of an existing DBClusterParameterGroup.
         */
        public var dbClusterParameterGroupName: kotlin.String? = null
        /**
         * The DB subnet group name to use for the new DB cluster.
         *
         * Constraints: If supplied, must match the name of an existing DBSubnetGroup.
         *
         * Example: `mySubnetgroup`
         */
        public var dbSubnetGroupName: kotlin.String? = null
        /**
         * A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * The list of logs that the restored DB cluster is to export to CloudWatch Logs.
         */
        public var enableCloudwatchLogsExports: List<String>? = null
        /**
         * True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database accounts, and otherwise false.
         *
         * Default: `false`
         */
        public var enableIamDatabaseAuthentication: kotlin.Boolean? = null
        /**
         * The Amazon KMS key identifier to use when restoring an encrypted DB cluster from an encrypted DB cluster.
         *
         * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a DB cluster with the same Amazon account that owns the KMS encryption key used to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.
         *
         * You can restore to a new DB cluster and encrypt the new DB cluster with a KMS key that is different than the KMS key used to encrypt the source DB cluster. The new DB cluster is encrypted with the KMS key identified by the `KmsKeyId` parameter.
         *
         * If you do not specify a value for the `KmsKeyId` parameter, then the following will occur:
         * + If the DB cluster is encrypted, then the restored DB cluster is encrypted using the KMS key that was used to encrypt the source DB cluster.
         * + If the DB cluster is not encrypted, then the restored DB cluster is not encrypted.
         *
         * If `DBClusterIdentifier` refers to a DB cluster that is not encrypted, then the restore request is rejected.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * *(Not supported by Neptune)*
         */
        public var optionGroupName: kotlin.String? = null
        /**
         * The port number on which the new DB cluster accepts connections.
         *
         * Constraints: Value must be `1150-65535`
         *
         * Default: The same port as the original DB cluster.
         */
        public var port: kotlin.Int? = null
        /**
         * The date and time to restore the DB cluster to.
         *
         * Valid Values: Value must be a time in Universal Coordinated Time (UTC) format
         *
         * Constraints:
         * + Must be before the latest restorable time for the DB instance
         * + Must be specified if `UseLatestRestorableTime` parameter is not provided
         * + Cannot be specified if `UseLatestRestorableTime` parameter is true
         * + Cannot be specified if `RestoreType` parameter is `copy-on-write`
         *
         * Example: `2015-03-07T23:45:00Z`
         */
        public var restoreToTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The type of restore to be performed. You can specify one of the following values:
         * + `full-copy` - The new DB cluster is restored as a full copy of the source DB cluster.
         * + `copy-on-write` - The new DB cluster is restored as a clone of the source DB cluster.
         *
         * If you don't specify a `RestoreType` value, then the new DB cluster is restored as a full copy of the source DB cluster.
         */
        public var restoreType: kotlin.String? = null
        /**
         * Contains the scaling configuration of a Neptune Serverless DB cluster.
         *
         * For more information, see [Using Amazon Neptune Serverless](https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-using.html) in the *Amazon Neptune User Guide*.
         */
        public var serverlessV2ScalingConfiguration: aws.sdk.kotlin.services.neptune.model.ServerlessV2ScalingConfiguration? = null
        /**
         * The identifier of the source DB cluster from which to restore.
         *
         * Constraints:
         * + Must match the identifier of an existing DBCluster.
         */
        public var sourceDbClusterIdentifier: kotlin.String? = null
        /**
         * Specifies the storage type to be associated with the DB cluster.
         *
         * Valid values: `standard`, `iopt1`
         *
         * Default: `standard`
         */
        public var storageType: kotlin.String? = null
        /**
         * The tags to be applied to the restored DB cluster.
         */
        public var tags: List<Tag>? = null
        /**
         * A value that is set to `true` to restore the DB cluster to the latest restorable backup time, and `false` otherwise.
         *
         * Default: `false`
         *
         * Constraints: Cannot be specified if `RestoreToTime` parameter is provided.
         */
        public var useLatestRestorableTime: kotlin.Boolean? = null
        /**
         * A list of VPC security groups that the new DB cluster belongs to.
         */
        public var vpcSecurityGroupIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptune.model.RestoreDbClusterToPointInTimeRequest) : this() {
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbClusterParameterGroupName = x.dbClusterParameterGroupName
            this.dbSubnetGroupName = x.dbSubnetGroupName
            this.deletionProtection = x.deletionProtection
            this.enableCloudwatchLogsExports = x.enableCloudwatchLogsExports
            this.enableIamDatabaseAuthentication = x.enableIamDatabaseAuthentication
            this.kmsKeyId = x.kmsKeyId
            this.optionGroupName = x.optionGroupName
            this.port = x.port
            this.restoreToTime = x.restoreToTime
            this.restoreType = x.restoreType
            this.serverlessV2ScalingConfiguration = x.serverlessV2ScalingConfiguration
            this.sourceDbClusterIdentifier = x.sourceDbClusterIdentifier
            this.storageType = x.storageType
            this.tags = x.tags
            this.useLatestRestorableTime = x.useLatestRestorableTime
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptune.model.RestoreDbClusterToPointInTimeRequest = RestoreDbClusterToPointInTimeRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.neptune.model.ServerlessV2ScalingConfiguration] inside the given [block]
         */
        public fun serverlessV2ScalingConfiguration(block: aws.sdk.kotlin.services.neptune.model.ServerlessV2ScalingConfiguration.Builder.() -> kotlin.Unit) {
            this.serverlessV2ScalingConfiguration = aws.sdk.kotlin.services.neptune.model.ServerlessV2ScalingConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
