// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.model



public class RestoreDbClusterFromSnapshotRequest private constructor(builder: Builder) {
    /**
     * Provides the list of EC2 Availability Zones that instances in the restored DB cluster can be created in.
     */
    public val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * *If set to `true`, tags are copied to any snapshot of the restored DB cluster that is created.*
     */
    public val copyTagsToSnapshot: kotlin.Boolean? = builder.copyTagsToSnapshot
    /**
     * Not supported.
     */
    public val databaseName: kotlin.String? = builder.databaseName
    /**
     * The name of the DB cluster to create from the DB snapshot or DB cluster snapshot. This parameter isn't case-sensitive.
     *
     * Constraints:
     * + Must contain from 1 to 63 letters, numbers, or hyphens
     * + First character must be a letter
     * + Cannot end with a hyphen or contain two consecutive hyphens
     *
     * Example: `my-snapshot-id`
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The name of the DB cluster parameter group to associate with the new DB cluster.
     *
     * Constraints:
     * + If supplied, must match the name of an existing DBClusterParameterGroup.
     */
    public val dbClusterParameterGroupName: kotlin.String? = builder.dbClusterParameterGroupName
    /**
     * The name of the DB subnet group to use for the new DB cluster.
     *
     * Constraints: If supplied, must match the name of an existing DBSubnetGroup.
     *
     * Example: `mySubnetgroup`
     */
    public val dbSubnetGroupName: kotlin.String? = builder.dbSubnetGroupName
    /**
     * A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * The list of logs that the restored DB cluster is to export to Amazon CloudWatch Logs.
     */
    public val enableCloudwatchLogsExports: List<String>? = builder.enableCloudwatchLogsExports
    /**
     * True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database accounts, and otherwise false.
     *
     * Default: `false`
     */
    public val enableIamDatabaseAuthentication: kotlin.Boolean? = builder.enableIamDatabaseAuthentication
    /**
     * The database engine to use for the new DB cluster.
     *
     * Default: The same as source
     *
     * Constraint: Must be compatible with the engine of the source
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The version of the database engine to use for the new DB cluster.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The Amazon KMS key identifier to use when restoring an encrypted DB cluster from a DB snapshot or DB cluster snapshot.
     *
     * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a DB cluster with the same Amazon account that owns the KMS encryption key used to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.
     *
     * If you do not specify a value for the `KmsKeyId` parameter, then the following will occur:
     * + If the DB snapshot or DB cluster snapshot in `SnapshotIdentifier` is encrypted, then the restored DB cluster is encrypted using the KMS key that was used to encrypt the DB snapshot or DB cluster snapshot.
     * + If the DB snapshot or DB cluster snapshot in `SnapshotIdentifier` is not encrypted, then the restored DB cluster is not encrypted.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * *(Not supported by Neptune)*
     */
    public val optionGroupName: kotlin.String? = builder.optionGroupName
    /**
     * The port number on which the new DB cluster accepts connections.
     *
     * Constraints: Value must be `1150-65535`
     *
     * Default: The same port as the original DB cluster.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * Contains the scaling configuration of a Neptune Serverless DB cluster.
     *
     * For more information, see [Using Amazon Neptune Serverless](https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-using.html) in the *Amazon Neptune User Guide*.
     */
    public val serverlessV2ScalingConfiguration: aws.sdk.kotlin.services.neptune.model.ServerlessV2ScalingConfiguration? = builder.serverlessV2ScalingConfiguration
    /**
     * The identifier for the DB snapshot or DB cluster snapshot to restore from.
     *
     * You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you can use only the ARN to specify a DB snapshot.
     *
     * Constraints:
     * + Must match the identifier of an existing Snapshot.
     */
    public val snapshotIdentifier: kotlin.String? = builder.snapshotIdentifier
    /**
     * Specifies the storage type to be associated with the DB cluster.
     *
     * Valid values: `standard`, `iopt1`
     *
     * Default: `standard`
     */
    public val storageType: kotlin.String? = builder.storageType
    /**
     * The tags to be assigned to the restored DB cluster.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * A list of VPC security groups that the new DB cluster will belong to.
     */
    public val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptune.model.RestoreDbClusterFromSnapshotRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreDbClusterFromSnapshotRequest(")
        append("availabilityZones=$availabilityZones,")
        append("copyTagsToSnapshot=$copyTagsToSnapshot,")
        append("databaseName=$databaseName,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbClusterParameterGroupName=$dbClusterParameterGroupName,")
        append("dbSubnetGroupName=$dbSubnetGroupName,")
        append("deletionProtection=$deletionProtection,")
        append("enableCloudwatchLogsExports=$enableCloudwatchLogsExports,")
        append("enableIamDatabaseAuthentication=$enableIamDatabaseAuthentication,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("kmsKeyId=$kmsKeyId,")
        append("optionGroupName=$optionGroupName,")
        append("port=$port,")
        append("serverlessV2ScalingConfiguration=$serverlessV2ScalingConfiguration,")
        append("snapshotIdentifier=$snapshotIdentifier,")
        append("storageType=$storageType,")
        append("tags=$tags,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZones?.hashCode() ?: 0
        result = 31 * result + (copyTagsToSnapshot?.hashCode() ?: 0)
        result = 31 * result + (databaseName?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbClusterParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (enableCloudwatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (enableIamDatabaseAuthentication?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (optionGroupName?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (serverlessV2ScalingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (snapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestoreDbClusterFromSnapshotRequest

        if (availabilityZones != other.availabilityZones) return false
        if (copyTagsToSnapshot != other.copyTagsToSnapshot) return false
        if (databaseName != other.databaseName) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbClusterParameterGroupName != other.dbClusterParameterGroupName) return false
        if (dbSubnetGroupName != other.dbSubnetGroupName) return false
        if (deletionProtection != other.deletionProtection) return false
        if (enableCloudwatchLogsExports != other.enableCloudwatchLogsExports) return false
        if (enableIamDatabaseAuthentication != other.enableIamDatabaseAuthentication) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (optionGroupName != other.optionGroupName) return false
        if (port != other.port) return false
        if (serverlessV2ScalingConfiguration != other.serverlessV2ScalingConfiguration) return false
        if (snapshotIdentifier != other.snapshotIdentifier) return false
        if (storageType != other.storageType) return false
        if (tags != other.tags) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptune.model.RestoreDbClusterFromSnapshotRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Provides the list of EC2 Availability Zones that instances in the restored DB cluster can be created in.
         */
        public var availabilityZones: List<String>? = null
        /**
         * *If set to `true`, tags are copied to any snapshot of the restored DB cluster that is created.*
         */
        public var copyTagsToSnapshot: kotlin.Boolean? = null
        /**
         * Not supported.
         */
        public var databaseName: kotlin.String? = null
        /**
         * The name of the DB cluster to create from the DB snapshot or DB cluster snapshot. This parameter isn't case-sensitive.
         *
         * Constraints:
         * + Must contain from 1 to 63 letters, numbers, or hyphens
         * + First character must be a letter
         * + Cannot end with a hyphen or contain two consecutive hyphens
         *
         * Example: `my-snapshot-id`
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * The name of the DB cluster parameter group to associate with the new DB cluster.
         *
         * Constraints:
         * + If supplied, must match the name of an existing DBClusterParameterGroup.
         */
        public var dbClusterParameterGroupName: kotlin.String? = null
        /**
         * The name of the DB subnet group to use for the new DB cluster.
         *
         * Constraints: If supplied, must match the name of an existing DBSubnetGroup.
         *
         * Example: `mySubnetgroup`
         */
        public var dbSubnetGroupName: kotlin.String? = null
        /**
         * A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * The list of logs that the restored DB cluster is to export to Amazon CloudWatch Logs.
         */
        public var enableCloudwatchLogsExports: List<String>? = null
        /**
         * True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database accounts, and otherwise false.
         *
         * Default: `false`
         */
        public var enableIamDatabaseAuthentication: kotlin.Boolean? = null
        /**
         * The database engine to use for the new DB cluster.
         *
         * Default: The same as source
         *
         * Constraint: Must be compatible with the engine of the source
         */
        public var engine: kotlin.String? = null
        /**
         * The version of the database engine to use for the new DB cluster.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The Amazon KMS key identifier to use when restoring an encrypted DB cluster from a DB snapshot or DB cluster snapshot.
         *
         * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a DB cluster with the same Amazon account that owns the KMS encryption key used to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.
         *
         * If you do not specify a value for the `KmsKeyId` parameter, then the following will occur:
         * + If the DB snapshot or DB cluster snapshot in `SnapshotIdentifier` is encrypted, then the restored DB cluster is encrypted using the KMS key that was used to encrypt the DB snapshot or DB cluster snapshot.
         * + If the DB snapshot or DB cluster snapshot in `SnapshotIdentifier` is not encrypted, then the restored DB cluster is not encrypted.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * *(Not supported by Neptune)*
         */
        public var optionGroupName: kotlin.String? = null
        /**
         * The port number on which the new DB cluster accepts connections.
         *
         * Constraints: Value must be `1150-65535`
         *
         * Default: The same port as the original DB cluster.
         */
        public var port: kotlin.Int? = null
        /**
         * Contains the scaling configuration of a Neptune Serverless DB cluster.
         *
         * For more information, see [Using Amazon Neptune Serverless](https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-using.html) in the *Amazon Neptune User Guide*.
         */
        public var serverlessV2ScalingConfiguration: aws.sdk.kotlin.services.neptune.model.ServerlessV2ScalingConfiguration? = null
        /**
         * The identifier for the DB snapshot or DB cluster snapshot to restore from.
         *
         * You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you can use only the ARN to specify a DB snapshot.
         *
         * Constraints:
         * + Must match the identifier of an existing Snapshot.
         */
        public var snapshotIdentifier: kotlin.String? = null
        /**
         * Specifies the storage type to be associated with the DB cluster.
         *
         * Valid values: `standard`, `iopt1`
         *
         * Default: `standard`
         */
        public var storageType: kotlin.String? = null
        /**
         * The tags to be assigned to the restored DB cluster.
         */
        public var tags: List<Tag>? = null
        /**
         * A list of VPC security groups that the new DB cluster will belong to.
         */
        public var vpcSecurityGroupIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptune.model.RestoreDbClusterFromSnapshotRequest) : this() {
            this.availabilityZones = x.availabilityZones
            this.copyTagsToSnapshot = x.copyTagsToSnapshot
            this.databaseName = x.databaseName
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbClusterParameterGroupName = x.dbClusterParameterGroupName
            this.dbSubnetGroupName = x.dbSubnetGroupName
            this.deletionProtection = x.deletionProtection
            this.enableCloudwatchLogsExports = x.enableCloudwatchLogsExports
            this.enableIamDatabaseAuthentication = x.enableIamDatabaseAuthentication
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.kmsKeyId = x.kmsKeyId
            this.optionGroupName = x.optionGroupName
            this.port = x.port
            this.serverlessV2ScalingConfiguration = x.serverlessV2ScalingConfiguration
            this.snapshotIdentifier = x.snapshotIdentifier
            this.storageType = x.storageType
            this.tags = x.tags
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptune.model.RestoreDbClusterFromSnapshotRequest = RestoreDbClusterFromSnapshotRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.neptune.model.ServerlessV2ScalingConfiguration] inside the given [block]
         */
        public fun serverlessV2ScalingConfiguration(block: aws.sdk.kotlin.services.neptune.model.ServerlessV2ScalingConfiguration.Builder.() -> kotlin.Unit) {
            this.serverlessV2ScalingConfiguration = aws.sdk.kotlin.services.neptune.model.ServerlessV2ScalingConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
