// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.model



public class ModifyDbClusterRequest private constructor(builder: Builder) {
    /**
     * A value that indicates whether upgrades between different major versions are allowed.
     *
     * Constraints: You must set the allow-major-version-upgrade flag when providing an `EngineVersion` parameter that uses a different major version than the DB cluster's current version.
     */
    public val allowMajorVersionUpgrade: kotlin.Boolean? = builder.allowMajorVersionUpgrade
    /**
     * A value that specifies whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the `PreferredMaintenanceWindow` setting for the DB cluster. If this parameter is set to `false`, changes to the DB cluster are applied during the next maintenance window.
     *
     * The `ApplyImmediately` parameter only affects `NewDBClusterIdentifier` values. If you set the `ApplyImmediately` parameter value to false, then changes to `NewDBClusterIdentifier` values are applied during the next maintenance window. All other changes are applied immediately, regardless of the value of the `ApplyImmediately` parameter.
     *
     * Default: `false`
     */
    public val applyImmediately: kotlin.Boolean? = builder.applyImmediately
    /**
     * The number of days for which automated backups are retained. You must specify a minimum value of 1.
     *
     * Default: 1
     *
     * Constraints:
     * + Must be a value from 1 to 35
     */
    public val backupRetentionPeriod: kotlin.Int? = builder.backupRetentionPeriod
    /**
     * The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB cluster. See [Using the CLI to publish Neptune audit logs to CloudWatch Logs](https://docs.aws.amazon.com/neptune/latest/userguide/cloudwatch-logs.html#cloudwatch-logs-cli).
     */
    public val cloudwatchLogsExportConfiguration: aws.sdk.kotlin.services.neptune.model.CloudwatchLogsExportConfiguration? = builder.cloudwatchLogsExportConfiguration
    /**
     * *If set to `true`, tags are copied to any snapshot of the DB cluster that is created.*
     */
    public val copyTagsToSnapshot: kotlin.Boolean? = builder.copyTagsToSnapshot
    /**
     * The DB cluster identifier for the cluster being modified. This parameter is not case-sensitive.
     *
     * Constraints:
     * + Must match the identifier of an existing DBCluster.
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The name of the DB cluster parameter group to use for the DB cluster.
     */
    public val dbClusterParameterGroupName: kotlin.String? = builder.dbClusterParameterGroupName
    /**
     * The name of the DB parameter group to apply to all instances of the DB cluster.
     *
     * When you apply a parameter group using `DBInstanceParameterGroupName`, parameter changes aren't applied during the next maintenance window but instead are applied immediately.
     *
     * Default: The existing name setting
     *
     * Constraints:
     * + The DB parameter group must be in the same DB parameter group family as the target DB cluster version.
     * + The `DBInstanceParameterGroupName` parameter is only valid in combination with the `AllowMajorVersionUpgrade` parameter.
     */
    public val dbInstanceParameterGroupName: kotlin.String? = builder.dbInstanceParameterGroupName
    /**
     * A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database accounts, and otherwise false.
     *
     * Default: `false`
     */
    public val enableIamDatabaseAuthentication: kotlin.Boolean? = builder.enableIamDatabaseAuthentication
    /**
     * The version number of the database engine to which you want to upgrade. Changing this parameter results in an outage. The change is applied during the next maintenance window unless the `ApplyImmediately` parameter is set to true.
     *
     * For a list of valid engine versions, see [Engine Releases for Amazon Neptune](https://docs.aws.amazon.com/neptune/latest/userguide/engine-releases.html), or call DescribeDBEngineVersions.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * Not supported by Neptune.
     */
    public val masterUserPassword: kotlin.String? = builder.masterUserPassword
    /**
     * The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is stored as a lowercase string.
     *
     * Constraints:
     * + Must contain from 1 to 63 letters, numbers, or hyphens
     * + The first character must be a letter
     * + Cannot end with a hyphen or contain two consecutive hyphens
     *
     * Example: `my-cluster2`
     */
    public val newDbClusterIdentifier: kotlin.String? = builder.newDbClusterIdentifier
    /**
     * *Not supported by Neptune.*
     */
    public val optionGroupName: kotlin.String? = builder.optionGroupName
    /**
     * The port number on which the DB cluster accepts connections.
     *
     * Constraints: Value must be `1150-65535`
     *
     * Default: The same port as the original DB cluster.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The daily time range during which automated backups are created if automated backups are enabled, using the `BackupRetentionPeriod` parameter.
     *
     * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region.
     *
     * Constraints:
     * + Must be in the format `hh24:mi-hh24:mi`.
     * + Must be in Universal Coordinated Time (UTC).
     * + Must not conflict with the preferred maintenance window.
     * + Must be at least 30 minutes.
     */
    public val preferredBackupWindow: kotlin.String? = builder.preferredBackupWindow
    /**
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     *
     * Format: `ddd:hh24:mi-ddd:hh24:mi`
     *
     * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region, occurring on a random day of the week.
     *
     * Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     *
     * Constraints: Minimum 30-minute window.
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * Contains the scaling configuration of a Neptune Serverless DB cluster.
     *
     * For more information, see [Using Amazon Neptune Serverless](https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-using.html) in the *Amazon Neptune User Guide*.
     */
    public val serverlessV2ScalingConfiguration: aws.sdk.kotlin.services.neptune.model.ServerlessV2ScalingConfiguration? = builder.serverlessV2ScalingConfiguration
    /**
     * The storage type to associate with the DB cluster.
     *
     * Valid Values:
     * + `standard | iopt1`
     *
     * Default:
     * + `standard`
     */
    public val storageType: kotlin.String? = builder.storageType
    /**
     * A list of VPC security groups that the DB cluster will belong to.
     */
    public val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptune.model.ModifyDbClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyDbClusterRequest(")
        append("allowMajorVersionUpgrade=$allowMajorVersionUpgrade,")
        append("applyImmediately=$applyImmediately,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("cloudwatchLogsExportConfiguration=$cloudwatchLogsExportConfiguration,")
        append("copyTagsToSnapshot=$copyTagsToSnapshot,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbClusterParameterGroupName=$dbClusterParameterGroupName,")
        append("dbInstanceParameterGroupName=$dbInstanceParameterGroupName,")
        append("deletionProtection=$deletionProtection,")
        append("enableIamDatabaseAuthentication=$enableIamDatabaseAuthentication,")
        append("engineVersion=$engineVersion,")
        append("masterUserPassword=$masterUserPassword,")
        append("newDbClusterIdentifier=$newDbClusterIdentifier,")
        append("optionGroupName=$optionGroupName,")
        append("port=$port,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("serverlessV2ScalingConfiguration=$serverlessV2ScalingConfiguration,")
        append("storageType=$storageType,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowMajorVersionUpgrade?.hashCode() ?: 0
        result = 31 * result + (applyImmediately?.hashCode() ?: 0)
        result = 31 * result + (backupRetentionPeriod ?: 0)
        result = 31 * result + (cloudwatchLogsExportConfiguration?.hashCode() ?: 0)
        result = 31 * result + (copyTagsToSnapshot?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbClusterParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (enableIamDatabaseAuthentication?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (masterUserPassword?.hashCode() ?: 0)
        result = 31 * result + (newDbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (optionGroupName?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (serverlessV2ScalingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyDbClusterRequest

        if (allowMajorVersionUpgrade != other.allowMajorVersionUpgrade) return false
        if (applyImmediately != other.applyImmediately) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (cloudwatchLogsExportConfiguration != other.cloudwatchLogsExportConfiguration) return false
        if (copyTagsToSnapshot != other.copyTagsToSnapshot) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbClusterParameterGroupName != other.dbClusterParameterGroupName) return false
        if (dbInstanceParameterGroupName != other.dbInstanceParameterGroupName) return false
        if (deletionProtection != other.deletionProtection) return false
        if (enableIamDatabaseAuthentication != other.enableIamDatabaseAuthentication) return false
        if (engineVersion != other.engineVersion) return false
        if (masterUserPassword != other.masterUserPassword) return false
        if (newDbClusterIdentifier != other.newDbClusterIdentifier) return false
        if (optionGroupName != other.optionGroupName) return false
        if (port != other.port) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (serverlessV2ScalingConfiguration != other.serverlessV2ScalingConfiguration) return false
        if (storageType != other.storageType) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptune.model.ModifyDbClusterRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A value that indicates whether upgrades between different major versions are allowed.
         *
         * Constraints: You must set the allow-major-version-upgrade flag when providing an `EngineVersion` parameter that uses a different major version than the DB cluster's current version.
         */
        public var allowMajorVersionUpgrade: kotlin.Boolean? = null
        /**
         * A value that specifies whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the `PreferredMaintenanceWindow` setting for the DB cluster. If this parameter is set to `false`, changes to the DB cluster are applied during the next maintenance window.
         *
         * The `ApplyImmediately` parameter only affects `NewDBClusterIdentifier` values. If you set the `ApplyImmediately` parameter value to false, then changes to `NewDBClusterIdentifier` values are applied during the next maintenance window. All other changes are applied immediately, regardless of the value of the `ApplyImmediately` parameter.
         *
         * Default: `false`
         */
        public var applyImmediately: kotlin.Boolean? = null
        /**
         * The number of days for which automated backups are retained. You must specify a minimum value of 1.
         *
         * Default: 1
         *
         * Constraints:
         * + Must be a value from 1 to 35
         */
        public var backupRetentionPeriod: kotlin.Int? = null
        /**
         * The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB cluster. See [Using the CLI to publish Neptune audit logs to CloudWatch Logs](https://docs.aws.amazon.com/neptune/latest/userguide/cloudwatch-logs.html#cloudwatch-logs-cli).
         */
        public var cloudwatchLogsExportConfiguration: aws.sdk.kotlin.services.neptune.model.CloudwatchLogsExportConfiguration? = null
        /**
         * *If set to `true`, tags are copied to any snapshot of the DB cluster that is created.*
         */
        public var copyTagsToSnapshot: kotlin.Boolean? = null
        /**
         * The DB cluster identifier for the cluster being modified. This parameter is not case-sensitive.
         *
         * Constraints:
         * + Must match the identifier of an existing DBCluster.
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * The name of the DB cluster parameter group to use for the DB cluster.
         */
        public var dbClusterParameterGroupName: kotlin.String? = null
        /**
         * The name of the DB parameter group to apply to all instances of the DB cluster.
         *
         * When you apply a parameter group using `DBInstanceParameterGroupName`, parameter changes aren't applied during the next maintenance window but instead are applied immediately.
         *
         * Default: The existing name setting
         *
         * Constraints:
         * + The DB parameter group must be in the same DB parameter group family as the target DB cluster version.
         * + The `DBInstanceParameterGroupName` parameter is only valid in combination with the `AllowMajorVersionUpgrade` parameter.
         */
        public var dbInstanceParameterGroupName: kotlin.String? = null
        /**
         * A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * True to enable mapping of Amazon Identity and Access Management (IAM) accounts to database accounts, and otherwise false.
         *
         * Default: `false`
         */
        public var enableIamDatabaseAuthentication: kotlin.Boolean? = null
        /**
         * The version number of the database engine to which you want to upgrade. Changing this parameter results in an outage. The change is applied during the next maintenance window unless the `ApplyImmediately` parameter is set to true.
         *
         * For a list of valid engine versions, see [Engine Releases for Amazon Neptune](https://docs.aws.amazon.com/neptune/latest/userguide/engine-releases.html), or call DescribeDBEngineVersions.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * Not supported by Neptune.
         */
        public var masterUserPassword: kotlin.String? = null
        /**
         * The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is stored as a lowercase string.
         *
         * Constraints:
         * + Must contain from 1 to 63 letters, numbers, or hyphens
         * + The first character must be a letter
         * + Cannot end with a hyphen or contain two consecutive hyphens
         *
         * Example: `my-cluster2`
         */
        public var newDbClusterIdentifier: kotlin.String? = null
        /**
         * *Not supported by Neptune.*
         */
        public var optionGroupName: kotlin.String? = null
        /**
         * The port number on which the DB cluster accepts connections.
         *
         * Constraints: Value must be `1150-65535`
         *
         * Default: The same port as the original DB cluster.
         */
        public var port: kotlin.Int? = null
        /**
         * The daily time range during which automated backups are created if automated backups are enabled, using the `BackupRetentionPeriod` parameter.
         *
         * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region.
         *
         * Constraints:
         * + Must be in the format `hh24:mi-hh24:mi`.
         * + Must be in Universal Coordinated Time (UTC).
         * + Must not conflict with the preferred maintenance window.
         * + Must be at least 30 minutes.
         */
        public var preferredBackupWindow: kotlin.String? = null
        /**
         * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         *
         * Format: `ddd:hh24:mi-ddd:hh24:mi`
         *
         * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region, occurring on a random day of the week.
         *
         * Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
         *
         * Constraints: Minimum 30-minute window.
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * Contains the scaling configuration of a Neptune Serverless DB cluster.
         *
         * For more information, see [Using Amazon Neptune Serverless](https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-using.html) in the *Amazon Neptune User Guide*.
         */
        public var serverlessV2ScalingConfiguration: aws.sdk.kotlin.services.neptune.model.ServerlessV2ScalingConfiguration? = null
        /**
         * The storage type to associate with the DB cluster.
         *
         * Valid Values:
         * + `standard | iopt1`
         *
         * Default:
         * + `standard`
         */
        public var storageType: kotlin.String? = null
        /**
         * A list of VPC security groups that the DB cluster will belong to.
         */
        public var vpcSecurityGroupIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptune.model.ModifyDbClusterRequest) : this() {
            this.allowMajorVersionUpgrade = x.allowMajorVersionUpgrade
            this.applyImmediately = x.applyImmediately
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.cloudwatchLogsExportConfiguration = x.cloudwatchLogsExportConfiguration
            this.copyTagsToSnapshot = x.copyTagsToSnapshot
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbClusterParameterGroupName = x.dbClusterParameterGroupName
            this.dbInstanceParameterGroupName = x.dbInstanceParameterGroupName
            this.deletionProtection = x.deletionProtection
            this.enableIamDatabaseAuthentication = x.enableIamDatabaseAuthentication
            this.engineVersion = x.engineVersion
            this.masterUserPassword = x.masterUserPassword
            this.newDbClusterIdentifier = x.newDbClusterIdentifier
            this.optionGroupName = x.optionGroupName
            this.port = x.port
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.serverlessV2ScalingConfiguration = x.serverlessV2ScalingConfiguration
            this.storageType = x.storageType
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptune.model.ModifyDbClusterRequest = ModifyDbClusterRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.neptune.model.CloudwatchLogsExportConfiguration] inside the given [block]
         */
        public fun cloudwatchLogsExportConfiguration(block: aws.sdk.kotlin.services.neptune.model.CloudwatchLogsExportConfiguration.Builder.() -> kotlin.Unit) {
            this.cloudwatchLogsExportConfiguration = aws.sdk.kotlin.services.neptune.model.CloudwatchLogsExportConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.neptune.model.ServerlessV2ScalingConfiguration] inside the given [block]
         */
        public fun serverlessV2ScalingConfiguration(block: aws.sdk.kotlin.services.neptune.model.ServerlessV2ScalingConfiguration.Builder.() -> kotlin.Unit) {
            this.serverlessV2ScalingConfiguration = aws.sdk.kotlin.services.neptune.model.ServerlessV2ScalingConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
