// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.model



public class FailoverGlobalClusterRequest private constructor(builder: Builder) {
    /**
     * Identifier of the Neptune global database that should be failed over. The identifier is the unique key assigned by the user when the Neptune global database was created. In other words, it's the name of the global database that you want to fail over.
     *
     * Constraints: Must match the identifier of an existing Neptune global database.
     */
    public val globalClusterIdentifier: kotlin.String? = builder.globalClusterIdentifier
    /**
     * The Amazon Resource Name (ARN) of the secondary Neptune DB cluster that you want to promote to primary for the global database.
     */
    public val targetDbClusterIdentifier: kotlin.String? = builder.targetDbClusterIdentifier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptune.model.FailoverGlobalClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FailoverGlobalClusterRequest(")
        append("globalClusterIdentifier=$globalClusterIdentifier,")
        append("targetDbClusterIdentifier=$targetDbClusterIdentifier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = globalClusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (targetDbClusterIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FailoverGlobalClusterRequest

        if (globalClusterIdentifier != other.globalClusterIdentifier) return false
        if (targetDbClusterIdentifier != other.targetDbClusterIdentifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptune.model.FailoverGlobalClusterRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Identifier of the Neptune global database that should be failed over. The identifier is the unique key assigned by the user when the Neptune global database was created. In other words, it's the name of the global database that you want to fail over.
         *
         * Constraints: Must match the identifier of an existing Neptune global database.
         */
        public var globalClusterIdentifier: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the secondary Neptune DB cluster that you want to promote to primary for the global database.
         */
        public var targetDbClusterIdentifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptune.model.FailoverGlobalClusterRequest) : this() {
            this.globalClusterIdentifier = x.globalClusterIdentifier
            this.targetDbClusterIdentifier = x.targetDbClusterIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptune.model.FailoverGlobalClusterRequest = FailoverGlobalClusterRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
