// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.model



public class DescribeDbClusterSnapshotsRequest private constructor(builder: Builder) {
    /**
     * The ID of the DB cluster to retrieve the list of DB cluster snapshots for. This parameter can't be used in conjunction with the `DBClusterSnapshotIdentifier` parameter. This parameter is not case-sensitive.
     *
     * Constraints:
     * + If supplied, must match the identifier of an existing DBCluster.
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * A specific DB cluster snapshot identifier to describe. This parameter can't be used in conjunction with the `DBClusterIdentifier` parameter. This value is stored as a lowercase string.
     *
     * Constraints:
     * + If supplied, must match the identifier of an existing DBClusterSnapshot.
     * + If this identifier is for an automated snapshot, the `SnapshotType` parameter must also be specified.
     */
    public val dbClusterSnapshotIdentifier: kotlin.String? = builder.dbClusterSnapshotIdentifier
    /**
     * This parameter is not currently supported.
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * True to include manual DB cluster snapshots that are public and can be copied or restored by any Amazon account, and otherwise false. The default is `false`. The default is false.
     *
     * You can share a manual DB cluster snapshot as public by using the ModifyDBClusterSnapshotAttribute API action.
     */
    public val includePublic: kotlin.Boolean? = builder.includePublic
    /**
     * True to include shared manual DB cluster snapshots from other Amazon accounts that this Amazon account has been given permission to copy or restore, and otherwise false. The default is `false`.
     *
     * You can give an Amazon account permission to restore a manual DB cluster snapshot from another Amazon account by the ModifyDBClusterSnapshotAttribute API action.
     */
    public val includeShared: kotlin.Boolean? = builder.includeShared
    /**
     * An optional pagination token provided by a previous `DescribeDBClusterSnapshots` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.
     *
     * Default: 100
     *
     * Constraints: Minimum 20, maximum 100.
     */
    public val maxRecords: kotlin.Int? = builder.maxRecords
    /**
     * The type of DB cluster snapshots to be returned. You can specify one of the following values:
     * + `automated` - Return all DB cluster snapshots that have been automatically taken by Amazon Neptune for my Amazon account.
     * + `manual` - Return all DB cluster snapshots that have been taken by my Amazon account.
     * + `shared` - Return all manual DB cluster snapshots that have been shared to my Amazon account.
     * + `public` - Return all DB cluster snapshots that have been marked as public.
     *
     * If you don't specify a `SnapshotType` value, then both automated and manual DB cluster snapshots are returned. You can include shared DB cluster snapshots with these results by setting the `IncludeShared` parameter to `true`. You can include public DB cluster snapshots with these results by setting the `IncludePublic` parameter to `true`.
     *
     * The `IncludeShared` and `IncludePublic` parameters don't apply for `SnapshotType` values of `manual` or `automated`. The `IncludePublic` parameter doesn't apply when `SnapshotType` is set to `shared`. The `IncludeShared` parameter doesn't apply when `SnapshotType` is set to `public`.
     */
    public val snapshotType: kotlin.String? = builder.snapshotType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptune.model.DescribeDbClusterSnapshotsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDbClusterSnapshotsRequest(")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbClusterSnapshotIdentifier=$dbClusterSnapshotIdentifier,")
        append("filters=$filters,")
        append("includePublic=$includePublic,")
        append("includeShared=$includeShared,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("snapshotType=$snapshotType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbClusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (dbClusterSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (includePublic?.hashCode() ?: 0)
        result = 31 * result + (includeShared?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (snapshotType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeDbClusterSnapshotsRequest

        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbClusterSnapshotIdentifier != other.dbClusterSnapshotIdentifier) return false
        if (filters != other.filters) return false
        if (includePublic != other.includePublic) return false
        if (includeShared != other.includeShared) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (snapshotType != other.snapshotType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptune.model.DescribeDbClusterSnapshotsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the DB cluster to retrieve the list of DB cluster snapshots for. This parameter can't be used in conjunction with the `DBClusterSnapshotIdentifier` parameter. This parameter is not case-sensitive.
         *
         * Constraints:
         * + If supplied, must match the identifier of an existing DBCluster.
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * A specific DB cluster snapshot identifier to describe. This parameter can't be used in conjunction with the `DBClusterIdentifier` parameter. This value is stored as a lowercase string.
         *
         * Constraints:
         * + If supplied, must match the identifier of an existing DBClusterSnapshot.
         * + If this identifier is for an automated snapshot, the `SnapshotType` parameter must also be specified.
         */
        public var dbClusterSnapshotIdentifier: kotlin.String? = null
        /**
         * This parameter is not currently supported.
         */
        public var filters: List<Filter>? = null
        /**
         * True to include manual DB cluster snapshots that are public and can be copied or restored by any Amazon account, and otherwise false. The default is `false`. The default is false.
         *
         * You can share a manual DB cluster snapshot as public by using the ModifyDBClusterSnapshotAttribute API action.
         */
        public var includePublic: kotlin.Boolean? = null
        /**
         * True to include shared manual DB cluster snapshots from other Amazon accounts that this Amazon account has been given permission to copy or restore, and otherwise false. The default is `false`.
         *
         * You can give an Amazon account permission to restore a manual DB cluster snapshot from another Amazon account by the ModifyDBClusterSnapshotAttribute API action.
         */
        public var includeShared: kotlin.Boolean? = null
        /**
         * An optional pagination token provided by a previous `DescribeDBClusterSnapshots` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
         */
        public var marker: kotlin.String? = null
        /**
         * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.
         *
         * Default: 100
         *
         * Constraints: Minimum 20, maximum 100.
         */
        public var maxRecords: kotlin.Int? = null
        /**
         * The type of DB cluster snapshots to be returned. You can specify one of the following values:
         * + `automated` - Return all DB cluster snapshots that have been automatically taken by Amazon Neptune for my Amazon account.
         * + `manual` - Return all DB cluster snapshots that have been taken by my Amazon account.
         * + `shared` - Return all manual DB cluster snapshots that have been shared to my Amazon account.
         * + `public` - Return all DB cluster snapshots that have been marked as public.
         *
         * If you don't specify a `SnapshotType` value, then both automated and manual DB cluster snapshots are returned. You can include shared DB cluster snapshots with these results by setting the `IncludeShared` parameter to `true`. You can include public DB cluster snapshots with these results by setting the `IncludePublic` parameter to `true`.
         *
         * The `IncludeShared` and `IncludePublic` parameters don't apply for `SnapshotType` values of `manual` or `automated`. The `IncludePublic` parameter doesn't apply when `SnapshotType` is set to `shared`. The `IncludeShared` parameter doesn't apply when `SnapshotType` is set to `public`.
         */
        public var snapshotType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptune.model.DescribeDbClusterSnapshotsRequest) : this() {
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbClusterSnapshotIdentifier = x.dbClusterSnapshotIdentifier
            this.filters = x.filters
            this.includePublic = x.includePublic
            this.includeShared = x.includeShared
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.snapshotType = x.snapshotType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptune.model.DescribeDbClusterSnapshotsRequest = DescribeDbClusterSnapshotsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
