// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.model



public class DeleteDbInstanceRequest private constructor(builder: Builder) {
    /**
     * The DB instance identifier for the DB instance to be deleted. This parameter isn't case-sensitive.
     *
     * Constraints:
     * + Must match the name of an existing DB instance.
     */
    public val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * The DBSnapshotIdentifier of the new DBSnapshot created when SkipFinalSnapshot is set to `false`.
     *
     * Specifying this parameter and also setting the SkipFinalShapshot parameter to true results in an error.
     *
     * Constraints:
     * + Must be 1 to 255 letters or numbers.
     * + First character must be a letter
     * + Cannot end with a hyphen or contain two consecutive hyphens
     * + Cannot be specified when deleting a Read Replica.
     */
    public val finalDbSnapshotIdentifier: kotlin.String? = builder.finalDbSnapshotIdentifier
    /**
     * Determines whether a final DB snapshot is created before the DB instance is deleted. If `true` is specified, no DBSnapshot is created. If `false` is specified, a DB snapshot is created before the DB instance is deleted.
     *
     * Note that when a DB instance is in a failure state and has a status of 'failed', 'incompatible-restore', or 'incompatible-network', it can only be deleted when the SkipFinalSnapshot parameter is set to "true".
     *
     * Specify `true` when deleting a Read Replica.
     *
     * The FinalDBSnapshotIdentifier parameter must be specified if SkipFinalSnapshot is `false`.
     *
     * Default: `false`
     */
    public val skipFinalSnapshot: kotlin.Boolean? = builder.skipFinalSnapshot

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptune.model.DeleteDbInstanceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteDbInstanceRequest(")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("finalDbSnapshotIdentifier=$finalDbSnapshotIdentifier,")
        append("skipFinalSnapshot=$skipFinalSnapshot")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbInstanceIdentifier?.hashCode() ?: 0
        result = 31 * result + (finalDbSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (skipFinalSnapshot?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteDbInstanceRequest

        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (finalDbSnapshotIdentifier != other.finalDbSnapshotIdentifier) return false
        if (skipFinalSnapshot != other.skipFinalSnapshot) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptune.model.DeleteDbInstanceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The DB instance identifier for the DB instance to be deleted. This parameter isn't case-sensitive.
         *
         * Constraints:
         * + Must match the name of an existing DB instance.
         */
        public var dbInstanceIdentifier: kotlin.String? = null
        /**
         * The DBSnapshotIdentifier of the new DBSnapshot created when SkipFinalSnapshot is set to `false`.
         *
         * Specifying this parameter and also setting the SkipFinalShapshot parameter to true results in an error.
         *
         * Constraints:
         * + Must be 1 to 255 letters or numbers.
         * + First character must be a letter
         * + Cannot end with a hyphen or contain two consecutive hyphens
         * + Cannot be specified when deleting a Read Replica.
         */
        public var finalDbSnapshotIdentifier: kotlin.String? = null
        /**
         * Determines whether a final DB snapshot is created before the DB instance is deleted. If `true` is specified, no DBSnapshot is created. If `false` is specified, a DB snapshot is created before the DB instance is deleted.
         *
         * Note that when a DB instance is in a failure state and has a status of 'failed', 'incompatible-restore', or 'incompatible-network', it can only be deleted when the SkipFinalSnapshot parameter is set to "true".
         *
         * Specify `true` when deleting a Read Replica.
         *
         * The FinalDBSnapshotIdentifier parameter must be specified if SkipFinalSnapshot is `false`.
         *
         * Default: `false`
         */
        public var skipFinalSnapshot: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptune.model.DeleteDbInstanceRequest) : this() {
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.finalDbSnapshotIdentifier = x.finalDbSnapshotIdentifier
            this.skipFinalSnapshot = x.skipFinalSnapshot
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptune.model.DeleteDbInstanceRequest = DeleteDbInstanceRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
