// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.model



public class DeleteDbClusterRequest private constructor(builder: Builder) {
    /**
     * The DB cluster identifier for the DB cluster to be deleted. This parameter isn't case-sensitive.
     *
     * Constraints:
     * + Must match an existing DBClusterIdentifier.
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The DB cluster snapshot identifier of the new DB cluster snapshot created when `SkipFinalSnapshot` is set to `false`.
     *
     *  Specifying this parameter and also setting the `SkipFinalShapshot` parameter to true results in an error.
     *
     * Constraints:
     * + Must be 1 to 255 letters, numbers, or hyphens.
     * + First character must be a letter
     * + Cannot end with a hyphen or contain two consecutive hyphens
     */
    public val finalDbSnapshotIdentifier: kotlin.String? = builder.finalDbSnapshotIdentifier
    /**
     * Determines whether a final DB cluster snapshot is created before the DB cluster is deleted. If `true` is specified, no DB cluster snapshot is created. If `false` is specified, a DB cluster snapshot is created before the DB cluster is deleted.
     *
     * You must specify a `FinalDBSnapshotIdentifier` parameter if `SkipFinalSnapshot` is `false`.
     *
     * Default: `false`
     */
    public val skipFinalSnapshot: kotlin.Boolean? = builder.skipFinalSnapshot

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptune.model.DeleteDbClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteDbClusterRequest(")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("finalDbSnapshotIdentifier=$finalDbSnapshotIdentifier,")
        append("skipFinalSnapshot=$skipFinalSnapshot")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbClusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (finalDbSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (skipFinalSnapshot?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteDbClusterRequest

        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (finalDbSnapshotIdentifier != other.finalDbSnapshotIdentifier) return false
        if (skipFinalSnapshot != other.skipFinalSnapshot) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptune.model.DeleteDbClusterRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The DB cluster identifier for the DB cluster to be deleted. This parameter isn't case-sensitive.
         *
         * Constraints:
         * + Must match an existing DBClusterIdentifier.
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * The DB cluster snapshot identifier of the new DB cluster snapshot created when `SkipFinalSnapshot` is set to `false`.
         *
         *  Specifying this parameter and also setting the `SkipFinalShapshot` parameter to true results in an error.
         *
         * Constraints:
         * + Must be 1 to 255 letters, numbers, or hyphens.
         * + First character must be a letter
         * + Cannot end with a hyphen or contain two consecutive hyphens
         */
        public var finalDbSnapshotIdentifier: kotlin.String? = null
        /**
         * Determines whether a final DB cluster snapshot is created before the DB cluster is deleted. If `true` is specified, no DB cluster snapshot is created. If `false` is specified, a DB cluster snapshot is created before the DB cluster is deleted.
         *
         * You must specify a `FinalDBSnapshotIdentifier` parameter if `SkipFinalSnapshot` is `false`.
         *
         * Default: `false`
         */
        public var skipFinalSnapshot: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptune.model.DeleteDbClusterRequest) : this() {
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.finalDbSnapshotIdentifier = x.finalDbSnapshotIdentifier
            this.skipFinalSnapshot = x.skipFinalSnapshot
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptune.model.DeleteDbClusterRequest = DeleteDbClusterRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
