// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the details of an Amazon Neptune DB instance.
 *
 * This data type is used as a response element in the DescribeDBInstances action.
 */
public class DbInstance private constructor(builder: Builder) {
    /**
     * Not supported by Neptune.
     */
    public val allocatedStorage: kotlin.Int? = builder.allocatedStorage
    /**
     * Indicates that minor version patches are applied automatically.
     */
    public val autoMinorVersionUpgrade: kotlin.Boolean? = builder.autoMinorVersionUpgrade
    /**
     * Specifies the name of the Availability Zone the DB instance is located in.
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * Specifies the number of days for which automatic DB snapshots are retained.
     */
    public val backupRetentionPeriod: kotlin.Int? = builder.backupRetentionPeriod
    /**
     * The identifier of the CA certificate for this DB instance.
     */
    public val caCertificateIdentifier: kotlin.String? = builder.caCertificateIdentifier
    /**
     * *(Not supported by Neptune)*
     */
    public val characterSetName: kotlin.String? = builder.characterSetName
    /**
     * Specifies whether tags are copied from the DB instance to snapshots of the DB instance.
     */
    public val copyTagsToSnapshot: kotlin.Boolean? = builder.copyTagsToSnapshot
    /**
     * If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB instance is a member of.
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The Amazon Resource Name (ARN) for the DB instance.
     */
    public val dbInstanceArn: kotlin.String? = builder.dbInstanceArn
    /**
     * Contains the name of the compute and memory capacity class of the DB instance.
     */
    public val dbInstanceClass: kotlin.String? = builder.dbInstanceClass
    /**
     * Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB instance.
     */
    public val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this can be a different port than the DB cluster port.
     */
    public val dbInstancePort: kotlin.Int? = builder.dbInstancePort
    /**
     * Specifies the current state of this database.
     */
    public val dbInstanceStatus: kotlin.String? = builder.dbInstanceStatus
    /**
     * The database name.
     */
    public val dbName: kotlin.String? = builder.dbName
    /**
     * Provides the list of DB parameter groups applied to this DB instance.
     */
    public val dbParameterGroups: List<DbParameterGroupStatus>? = builder.dbParameterGroups
    /**
     * Provides List of DB security group elements containing only `DBSecurityGroup.Name` and `DBSecurityGroup.Status` subelements.
     */
    public val dbSecurityGroups: List<DbSecurityGroupMembership>? = builder.dbSecurityGroups
    /**
     * Specifies information on the subnet group associated with the DB instance, including the name, description, and subnets in the subnet group.
     */
    public val dbSubnetGroup: aws.sdk.kotlin.services.neptune.model.DbSubnetGroup? = builder.dbSubnetGroup
    /**
     * The Amazon Region-unique, immutable identifier for the DB instance. This identifier is found in Amazon CloudTrail log entries whenever the Amazon KMS key for the DB instance is accessed.
     */
    public val dbiResourceId: kotlin.String? = builder.dbiResourceId
    /**
     * Indicates whether or not the DB instance has deletion protection enabled. The instance can't be deleted when deletion protection is enabled. See [Deleting a DB Instance](https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html).
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * Not supported
     */
    public val domainMemberships: List<DomainMembership>? = builder.domainMemberships
    /**
     * A list of log types that this DB instance is configured to export to CloudWatch Logs.
     */
    public val enabledCloudwatchLogsExports: List<String>? = builder.enabledCloudwatchLogsExports
    /**
     * Specifies the connection endpoint.
     */
    public val endpoint: aws.sdk.kotlin.services.neptune.model.Endpoint? = builder.endpoint
    /**
     * Provides the name of the database engine to be used for this DB instance.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * Indicates the database engine version.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log stream that receives the Enhanced Monitoring metrics data for the DB instance.
     */
    public val enhancedMonitoringResourceArn: kotlin.String? = builder.enhancedMonitoringResourceArn
    /**
     * True if Amazon Identity and Access Management (IAM) authentication is enabled, and otherwise false.
     */
    public val iamDatabaseAuthenticationEnabled: kotlin.Boolean? = builder.iamDatabaseAuthenticationEnabled
    /**
     * Provides the date and time the DB instance was created.
     */
    public val instanceCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.instanceCreateTime
    /**
     * Specifies the Provisioned IOPS (I/O operations per second) value.
     */
    public val iops: kotlin.Int? = builder.iops
    /**
     * Not supported: The encryption for DB instances is managed by the DB cluster.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Specifies the latest time to which a database can be restored with point-in-time restore.
     */
    public val latestRestorableTime: aws.smithy.kotlin.runtime.time.Instant? = builder.latestRestorableTime
    /**
     * License model information for this DB instance.
     */
    public val licenseModel: kotlin.String? = builder.licenseModel
    /**
     * Not supported by Neptune.
     */
    public val masterUsername: kotlin.String? = builder.masterUsername
    /**
     * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.
     */
    public val monitoringInterval: kotlin.Int? = builder.monitoringInterval
    /**
     * The ARN for the IAM role that permits Neptune to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.
     */
    public val monitoringRoleArn: kotlin.String? = builder.monitoringRoleArn
    /**
     * Specifies if the DB instance is a Multi-AZ deployment.
     */
    public val multiAz: kotlin.Boolean? = builder.multiAz
    /**
     * *(Not supported by Neptune)*
     */
    public val optionGroupMemberships: List<OptionGroupMembership>? = builder.optionGroupMemberships
    /**
     * Specifies that changes to the DB instance are pending. This element is only included when changes are pending. Specific changes are identified by subelements.
     */
    public val pendingModifiedValues: aws.sdk.kotlin.services.neptune.model.PendingModifiedValues? = builder.pendingModifiedValues
    /**
     * *(Not supported by Neptune)*
     */
    public val performanceInsightsEnabled: kotlin.Boolean? = builder.performanceInsightsEnabled
    /**
     * *(Not supported by Neptune)*
     */
    public val performanceInsightsKmsKeyId: kotlin.String? = builder.performanceInsightsKmsKeyId
    /**
     * Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the `BackupRetentionPeriod`.
     */
    public val preferredBackupWindow: kotlin.String? = builder.preferredBackupWindow
    /**
     * Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * A value that specifies the order in which a Read Replica is promoted to the primary instance after a failure of the existing primary instance.
     */
    public val promotionTier: kotlin.Int? = builder.promotionTier
    /**
     * This flag should no longer be used.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * Contains one or more identifiers of DB clusters that are Read Replicas of this DB instance.
     */
    public val readReplicaDbClusterIdentifiers: List<String>? = builder.readReplicaDbClusterIdentifiers
    /**
     * Contains one or more identifiers of the Read Replicas associated with this DB instance.
     */
    public val readReplicaDbInstanceIdentifiers: List<String>? = builder.readReplicaDbInstanceIdentifiers
    /**
     * Contains the identifier of the source DB instance if this DB instance is a Read Replica.
     */
    public val readReplicaSourceDbInstanceIdentifier: kotlin.String? = builder.readReplicaSourceDbInstanceIdentifier
    /**
     * If present, specifies the name of the secondary Availability Zone for a DB instance with multi-AZ support.
     */
    public val secondaryAvailabilityZone: kotlin.String? = builder.secondaryAvailabilityZone
    /**
     * The status of a Read Replica. If the instance is not a Read Replica, this is blank.
     */
    public val statusInfos: List<DbInstanceStatusInfo>? = builder.statusInfos
    /**
     * Not supported: The encryption for DB instances is managed by the DB cluster.
     */
    public val storageEncrypted: kotlin.Boolean? = builder.storageEncrypted
    /**
     * Specifies the storage type associated with DB instance.
     */
    public val storageType: kotlin.String? = builder.storageType
    /**
     * The ARN from the key store with which the instance is associated for TDE encryption.
     */
    public val tdeCredentialArn: kotlin.String? = builder.tdeCredentialArn
    /**
     * Not supported.
     */
    public val timezone: kotlin.String? = builder.timezone
    /**
     * Provides a list of VPC security group elements that the DB instance belongs to.
     */
    public val vpcSecurityGroups: List<VpcSecurityGroupMembership>? = builder.vpcSecurityGroups

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptune.model.DbInstance = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbInstance(")
        append("allocatedStorage=$allocatedStorage,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("availabilityZone=$availabilityZone,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("caCertificateIdentifier=$caCertificateIdentifier,")
        append("characterSetName=$characterSetName,")
        append("copyTagsToSnapshot=$copyTagsToSnapshot,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbInstanceArn=$dbInstanceArn,")
        append("dbInstanceClass=$dbInstanceClass,")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("dbInstancePort=$dbInstancePort,")
        append("dbInstanceStatus=$dbInstanceStatus,")
        append("dbName=$dbName,")
        append("dbParameterGroups=$dbParameterGroups,")
        append("dbSecurityGroups=$dbSecurityGroups,")
        append("dbSubnetGroup=$dbSubnetGroup,")
        append("dbiResourceId=$dbiResourceId,")
        append("deletionProtection=$deletionProtection,")
        append("domainMemberships=$domainMemberships,")
        append("enabledCloudwatchLogsExports=$enabledCloudwatchLogsExports,")
        append("endpoint=$endpoint,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("enhancedMonitoringResourceArn=$enhancedMonitoringResourceArn,")
        append("iamDatabaseAuthenticationEnabled=$iamDatabaseAuthenticationEnabled,")
        append("instanceCreateTime=$instanceCreateTime,")
        append("iops=$iops,")
        append("kmsKeyId=$kmsKeyId,")
        append("latestRestorableTime=$latestRestorableTime,")
        append("licenseModel=$licenseModel,")
        append("masterUsername=$masterUsername,")
        append("monitoringInterval=$monitoringInterval,")
        append("monitoringRoleArn=$monitoringRoleArn,")
        append("multiAz=$multiAz,")
        append("optionGroupMemberships=$optionGroupMemberships,")
        append("pendingModifiedValues=$pendingModifiedValues,")
        append("performanceInsightsEnabled=$performanceInsightsEnabled,")
        append("performanceInsightsKmsKeyId=$performanceInsightsKmsKeyId,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("promotionTier=$promotionTier,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("readReplicaDbClusterIdentifiers=$readReplicaDbClusterIdentifiers,")
        append("readReplicaDbInstanceIdentifiers=$readReplicaDbInstanceIdentifiers,")
        append("readReplicaSourceDbInstanceIdentifier=$readReplicaSourceDbInstanceIdentifier,")
        append("secondaryAvailabilityZone=$secondaryAvailabilityZone,")
        append("statusInfos=$statusInfos,")
        append("storageEncrypted=$storageEncrypted,")
        append("storageType=$storageType,")
        append("tdeCredentialArn=$tdeCredentialArn,")
        append("timezone=$timezone,")
        append("vpcSecurityGroups=$vpcSecurityGroups")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage ?: 0
        result = 31 * result + (autoMinorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (backupRetentionPeriod ?: 0)
        result = 31 * result + (caCertificateIdentifier?.hashCode() ?: 0)
        result = 31 * result + (characterSetName?.hashCode() ?: 0)
        result = 31 * result + (copyTagsToSnapshot?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbInstancePort ?: 0)
        result = 31 * result + (dbInstanceStatus?.hashCode() ?: 0)
        result = 31 * result + (dbName?.hashCode() ?: 0)
        result = 31 * result + (dbParameterGroups?.hashCode() ?: 0)
        result = 31 * result + (dbSecurityGroups?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroup?.hashCode() ?: 0)
        result = 31 * result + (dbiResourceId?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (domainMemberships?.hashCode() ?: 0)
        result = 31 * result + (enabledCloudwatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (enhancedMonitoringResourceArn?.hashCode() ?: 0)
        result = 31 * result + (iamDatabaseAuthenticationEnabled?.hashCode() ?: 0)
        result = 31 * result + (instanceCreateTime?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (latestRestorableTime?.hashCode() ?: 0)
        result = 31 * result + (licenseModel?.hashCode() ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (monitoringInterval ?: 0)
        result = 31 * result + (monitoringRoleArn?.hashCode() ?: 0)
        result = 31 * result + (multiAz?.hashCode() ?: 0)
        result = 31 * result + (optionGroupMemberships?.hashCode() ?: 0)
        result = 31 * result + (pendingModifiedValues?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsEnabled?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (promotionTier ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (readReplicaDbClusterIdentifiers?.hashCode() ?: 0)
        result = 31 * result + (readReplicaDbInstanceIdentifiers?.hashCode() ?: 0)
        result = 31 * result + (readReplicaSourceDbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (secondaryAvailabilityZone?.hashCode() ?: 0)
        result = 31 * result + (statusInfos?.hashCode() ?: 0)
        result = 31 * result + (storageEncrypted?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (tdeCredentialArn?.hashCode() ?: 0)
        result = 31 * result + (timezone?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroups?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbInstance

        if (allocatedStorage != other.allocatedStorage) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (availabilityZone != other.availabilityZone) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (caCertificateIdentifier != other.caCertificateIdentifier) return false
        if (characterSetName != other.characterSetName) return false
        if (copyTagsToSnapshot != other.copyTagsToSnapshot) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbInstanceArn != other.dbInstanceArn) return false
        if (dbInstanceClass != other.dbInstanceClass) return false
        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (dbInstancePort != other.dbInstancePort) return false
        if (dbInstanceStatus != other.dbInstanceStatus) return false
        if (dbName != other.dbName) return false
        if (dbParameterGroups != other.dbParameterGroups) return false
        if (dbSecurityGroups != other.dbSecurityGroups) return false
        if (dbSubnetGroup != other.dbSubnetGroup) return false
        if (dbiResourceId != other.dbiResourceId) return false
        if (deletionProtection != other.deletionProtection) return false
        if (domainMemberships != other.domainMemberships) return false
        if (enabledCloudwatchLogsExports != other.enabledCloudwatchLogsExports) return false
        if (endpoint != other.endpoint) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (enhancedMonitoringResourceArn != other.enhancedMonitoringResourceArn) return false
        if (iamDatabaseAuthenticationEnabled != other.iamDatabaseAuthenticationEnabled) return false
        if (instanceCreateTime != other.instanceCreateTime) return false
        if (iops != other.iops) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (latestRestorableTime != other.latestRestorableTime) return false
        if (licenseModel != other.licenseModel) return false
        if (masterUsername != other.masterUsername) return false
        if (monitoringInterval != other.monitoringInterval) return false
        if (monitoringRoleArn != other.monitoringRoleArn) return false
        if (multiAz != other.multiAz) return false
        if (optionGroupMemberships != other.optionGroupMemberships) return false
        if (pendingModifiedValues != other.pendingModifiedValues) return false
        if (performanceInsightsEnabled != other.performanceInsightsEnabled) return false
        if (performanceInsightsKmsKeyId != other.performanceInsightsKmsKeyId) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (promotionTier != other.promotionTier) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (readReplicaDbClusterIdentifiers != other.readReplicaDbClusterIdentifiers) return false
        if (readReplicaDbInstanceIdentifiers != other.readReplicaDbInstanceIdentifiers) return false
        if (readReplicaSourceDbInstanceIdentifier != other.readReplicaSourceDbInstanceIdentifier) return false
        if (secondaryAvailabilityZone != other.secondaryAvailabilityZone) return false
        if (statusInfos != other.statusInfos) return false
        if (storageEncrypted != other.storageEncrypted) return false
        if (storageType != other.storageType) return false
        if (tdeCredentialArn != other.tdeCredentialArn) return false
        if (timezone != other.timezone) return false
        if (vpcSecurityGroups != other.vpcSecurityGroups) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptune.model.DbInstance = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Not supported by Neptune.
         */
        public var allocatedStorage: kotlin.Int? = null
        /**
         * Indicates that minor version patches are applied automatically.
         */
        public var autoMinorVersionUpgrade: kotlin.Boolean? = null
        /**
         * Specifies the name of the Availability Zone the DB instance is located in.
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * Specifies the number of days for which automatic DB snapshots are retained.
         */
        public var backupRetentionPeriod: kotlin.Int? = null
        /**
         * The identifier of the CA certificate for this DB instance.
         */
        public var caCertificateIdentifier: kotlin.String? = null
        /**
         * *(Not supported by Neptune)*
         */
        public var characterSetName: kotlin.String? = null
        /**
         * Specifies whether tags are copied from the DB instance to snapshots of the DB instance.
         */
        public var copyTagsToSnapshot: kotlin.Boolean? = null
        /**
         * If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB instance is a member of.
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the DB instance.
         */
        public var dbInstanceArn: kotlin.String? = null
        /**
         * Contains the name of the compute and memory capacity class of the DB instance.
         */
        public var dbInstanceClass: kotlin.String? = null
        /**
         * Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB instance.
         */
        public var dbInstanceIdentifier: kotlin.String? = null
        /**
         * Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this can be a different port than the DB cluster port.
         */
        public var dbInstancePort: kotlin.Int? = null
        /**
         * Specifies the current state of this database.
         */
        public var dbInstanceStatus: kotlin.String? = null
        /**
         * The database name.
         */
        public var dbName: kotlin.String? = null
        /**
         * Provides the list of DB parameter groups applied to this DB instance.
         */
        public var dbParameterGroups: List<DbParameterGroupStatus>? = null
        /**
         * Provides List of DB security group elements containing only `DBSecurityGroup.Name` and `DBSecurityGroup.Status` subelements.
         */
        public var dbSecurityGroups: List<DbSecurityGroupMembership>? = null
        /**
         * Specifies information on the subnet group associated with the DB instance, including the name, description, and subnets in the subnet group.
         */
        public var dbSubnetGroup: aws.sdk.kotlin.services.neptune.model.DbSubnetGroup? = null
        /**
         * The Amazon Region-unique, immutable identifier for the DB instance. This identifier is found in Amazon CloudTrail log entries whenever the Amazon KMS key for the DB instance is accessed.
         */
        public var dbiResourceId: kotlin.String? = null
        /**
         * Indicates whether or not the DB instance has deletion protection enabled. The instance can't be deleted when deletion protection is enabled. See [Deleting a DB Instance](https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html).
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * Not supported
         */
        public var domainMemberships: List<DomainMembership>? = null
        /**
         * A list of log types that this DB instance is configured to export to CloudWatch Logs.
         */
        public var enabledCloudwatchLogsExports: List<String>? = null
        /**
         * Specifies the connection endpoint.
         */
        public var endpoint: aws.sdk.kotlin.services.neptune.model.Endpoint? = null
        /**
         * Provides the name of the database engine to be used for this DB instance.
         */
        public var engine: kotlin.String? = null
        /**
         * Indicates the database engine version.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log stream that receives the Enhanced Monitoring metrics data for the DB instance.
         */
        public var enhancedMonitoringResourceArn: kotlin.String? = null
        /**
         * True if Amazon Identity and Access Management (IAM) authentication is enabled, and otherwise false.
         */
        public var iamDatabaseAuthenticationEnabled: kotlin.Boolean? = null
        /**
         * Provides the date and time the DB instance was created.
         */
        public var instanceCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the Provisioned IOPS (I/O operations per second) value.
         */
        public var iops: kotlin.Int? = null
        /**
         * Not supported: The encryption for DB instances is managed by the DB cluster.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Specifies the latest time to which a database can be restored with point-in-time restore.
         */
        public var latestRestorableTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * License model information for this DB instance.
         */
        public var licenseModel: kotlin.String? = null
        /**
         * Not supported by Neptune.
         */
        public var masterUsername: kotlin.String? = null
        /**
         * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.
         */
        public var monitoringInterval: kotlin.Int? = null
        /**
         * The ARN for the IAM role that permits Neptune to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.
         */
        public var monitoringRoleArn: kotlin.String? = null
        /**
         * Specifies if the DB instance is a Multi-AZ deployment.
         */
        public var multiAz: kotlin.Boolean? = null
        /**
         * *(Not supported by Neptune)*
         */
        public var optionGroupMemberships: List<OptionGroupMembership>? = null
        /**
         * Specifies that changes to the DB instance are pending. This element is only included when changes are pending. Specific changes are identified by subelements.
         */
        public var pendingModifiedValues: aws.sdk.kotlin.services.neptune.model.PendingModifiedValues? = null
        /**
         * *(Not supported by Neptune)*
         */
        public var performanceInsightsEnabled: kotlin.Boolean? = null
        /**
         * *(Not supported by Neptune)*
         */
        public var performanceInsightsKmsKeyId: kotlin.String? = null
        /**
         * Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the `BackupRetentionPeriod`.
         */
        public var preferredBackupWindow: kotlin.String? = null
        /**
         * Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * A value that specifies the order in which a Read Replica is promoted to the primary instance after a failure of the existing primary instance.
         */
        public var promotionTier: kotlin.Int? = null
        /**
         * This flag should no longer be used.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var publiclyAccessible: kotlin.Boolean? = null
        /**
         * Contains one or more identifiers of DB clusters that are Read Replicas of this DB instance.
         */
        public var readReplicaDbClusterIdentifiers: List<String>? = null
        /**
         * Contains one or more identifiers of the Read Replicas associated with this DB instance.
         */
        public var readReplicaDbInstanceIdentifiers: List<String>? = null
        /**
         * Contains the identifier of the source DB instance if this DB instance is a Read Replica.
         */
        public var readReplicaSourceDbInstanceIdentifier: kotlin.String? = null
        /**
         * If present, specifies the name of the secondary Availability Zone for a DB instance with multi-AZ support.
         */
        public var secondaryAvailabilityZone: kotlin.String? = null
        /**
         * The status of a Read Replica. If the instance is not a Read Replica, this is blank.
         */
        public var statusInfos: List<DbInstanceStatusInfo>? = null
        /**
         * Not supported: The encryption for DB instances is managed by the DB cluster.
         */
        public var storageEncrypted: kotlin.Boolean? = null
        /**
         * Specifies the storage type associated with DB instance.
         */
        public var storageType: kotlin.String? = null
        /**
         * The ARN from the key store with which the instance is associated for TDE encryption.
         */
        public var tdeCredentialArn: kotlin.String? = null
        /**
         * Not supported.
         */
        public var timezone: kotlin.String? = null
        /**
         * Provides a list of VPC security group elements that the DB instance belongs to.
         */
        public var vpcSecurityGroups: List<VpcSecurityGroupMembership>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptune.model.DbInstance) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.availabilityZone = x.availabilityZone
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.caCertificateIdentifier = x.caCertificateIdentifier
            this.characterSetName = x.characterSetName
            this.copyTagsToSnapshot = x.copyTagsToSnapshot
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbInstanceArn = x.dbInstanceArn
            this.dbInstanceClass = x.dbInstanceClass
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.dbInstancePort = x.dbInstancePort
            this.dbInstanceStatus = x.dbInstanceStatus
            this.dbName = x.dbName
            this.dbParameterGroups = x.dbParameterGroups
            this.dbSecurityGroups = x.dbSecurityGroups
            this.dbSubnetGroup = x.dbSubnetGroup
            this.dbiResourceId = x.dbiResourceId
            this.deletionProtection = x.deletionProtection
            this.domainMemberships = x.domainMemberships
            this.enabledCloudwatchLogsExports = x.enabledCloudwatchLogsExports
            this.endpoint = x.endpoint
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.enhancedMonitoringResourceArn = x.enhancedMonitoringResourceArn
            this.iamDatabaseAuthenticationEnabled = x.iamDatabaseAuthenticationEnabled
            this.instanceCreateTime = x.instanceCreateTime
            this.iops = x.iops
            this.kmsKeyId = x.kmsKeyId
            this.latestRestorableTime = x.latestRestorableTime
            this.licenseModel = x.licenseModel
            this.masterUsername = x.masterUsername
            this.monitoringInterval = x.monitoringInterval
            this.monitoringRoleArn = x.monitoringRoleArn
            this.multiAz = x.multiAz
            this.optionGroupMemberships = x.optionGroupMemberships
            this.pendingModifiedValues = x.pendingModifiedValues
            this.performanceInsightsEnabled = x.performanceInsightsEnabled
            this.performanceInsightsKmsKeyId = x.performanceInsightsKmsKeyId
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.promotionTier = x.promotionTier
            this.publiclyAccessible = x.publiclyAccessible
            this.readReplicaDbClusterIdentifiers = x.readReplicaDbClusterIdentifiers
            this.readReplicaDbInstanceIdentifiers = x.readReplicaDbInstanceIdentifiers
            this.readReplicaSourceDbInstanceIdentifier = x.readReplicaSourceDbInstanceIdentifier
            this.secondaryAvailabilityZone = x.secondaryAvailabilityZone
            this.statusInfos = x.statusInfos
            this.storageEncrypted = x.storageEncrypted
            this.storageType = x.storageType
            this.tdeCredentialArn = x.tdeCredentialArn
            this.timezone = x.timezone
            this.vpcSecurityGroups = x.vpcSecurityGroups
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptune.model.DbInstance = DbInstance(this)

        /**
         * construct an [aws.sdk.kotlin.services.neptune.model.DbSubnetGroup] inside the given [block]
         */
        public fun dbSubnetGroup(block: aws.sdk.kotlin.services.neptune.model.DbSubnetGroup.Builder.() -> kotlin.Unit) {
            this.dbSubnetGroup = aws.sdk.kotlin.services.neptune.model.DbSubnetGroup.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.neptune.model.Endpoint] inside the given [block]
         */
        public fun endpoint(block: aws.sdk.kotlin.services.neptune.model.Endpoint.Builder.() -> kotlin.Unit) {
            this.endpoint = aws.sdk.kotlin.services.neptune.model.Endpoint.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.neptune.model.PendingModifiedValues] inside the given [block]
         */
        public fun pendingModifiedValues(block: aws.sdk.kotlin.services.neptune.model.PendingModifiedValues.Builder.() -> kotlin.Unit) {
            this.pendingModifiedValues = aws.sdk.kotlin.services.neptune.model.PendingModifiedValues.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
