// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.model



/**
 * Contains the details of an Amazon Neptune DB cluster parameter group.
 *
 * This data type is used as a response element in the DescribeDBClusterParameterGroups action.
 */
public class DbClusterParameterGroup private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the DB cluster parameter group.
     */
    public val dbClusterParameterGroupArn: kotlin.String? = builder.dbClusterParameterGroupArn
    /**
     * Provides the name of the DB cluster parameter group.
     */
    public val dbClusterParameterGroupName: kotlin.String? = builder.dbClusterParameterGroupName
    /**
     * Provides the name of the DB parameter group family that this DB cluster parameter group is compatible with.
     */
    public val dbParameterGroupFamily: kotlin.String? = builder.dbParameterGroupFamily
    /**
     * Provides the customer-specified description for this DB cluster parameter group.
     */
    public val description: kotlin.String? = builder.description

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptune.model.DbClusterParameterGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbClusterParameterGroup(")
        append("dbClusterParameterGroupArn=$dbClusterParameterGroupArn,")
        append("dbClusterParameterGroupName=$dbClusterParameterGroupName,")
        append("dbParameterGroupFamily=$dbParameterGroupFamily,")
        append("description=$description")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbClusterParameterGroupArn?.hashCode() ?: 0
        result = 31 * result + (dbClusterParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (dbParameterGroupFamily?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbClusterParameterGroup

        if (dbClusterParameterGroupArn != other.dbClusterParameterGroupArn) return false
        if (dbClusterParameterGroupName != other.dbClusterParameterGroupName) return false
        if (dbParameterGroupFamily != other.dbParameterGroupFamily) return false
        if (description != other.description) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptune.model.DbClusterParameterGroup = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for the DB cluster parameter group.
         */
        public var dbClusterParameterGroupArn: kotlin.String? = null
        /**
         * Provides the name of the DB cluster parameter group.
         */
        public var dbClusterParameterGroupName: kotlin.String? = null
        /**
         * Provides the name of the DB parameter group family that this DB cluster parameter group is compatible with.
         */
        public var dbParameterGroupFamily: kotlin.String? = null
        /**
         * Provides the customer-specified description for this DB cluster parameter group.
         */
        public var description: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptune.model.DbClusterParameterGroup) : this() {
            this.dbClusterParameterGroupArn = x.dbClusterParameterGroupArn
            this.dbClusterParameterGroupName = x.dbClusterParameterGroupName
            this.dbParameterGroupFamily = x.dbParameterGroupFamily
            this.description = x.description
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptune.model.DbClusterParameterGroup = DbClusterParameterGroup(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
