// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the details of an Amazon Neptune DB cluster.
 *
 * This data type is used as a response element in the DescribeDBClusters.
 */
public class DbCluster private constructor(builder: Builder) {
    /**
     * `AllocatedStorage` always returns 1, because Neptune DB cluster storage size is not fixed, but instead automatically adjusts as needed.
     */
    public val allocatedStorage: kotlin.Int? = builder.allocatedStorage
    /**
     * Provides a list of the Amazon Identity and Access Management (IAM) roles that are associated with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon services on your behalf.
     */
    public val associatedRoles: List<DbClusterRole>? = builder.associatedRoles
    /**
     * Time at which the DB cluster will be automatically restarted.
     */
    public val automaticRestartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.automaticRestartTime
    /**
     * Provides the list of EC2 Availability Zones that instances in the DB cluster can be created in.
     */
    public val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * Specifies the number of days for which automatic DB snapshots are retained.
     */
    public val backupRetentionPeriod: kotlin.Int? = builder.backupRetentionPeriod
    /**
     * Not supported by Neptune.
     */
    public val characterSetName: kotlin.String? = builder.characterSetName
    /**
     * Identifies the clone group to which the DB cluster is associated.
     */
    public val cloneGroupId: kotlin.String? = builder.cloneGroupId
    /**
     * Specifies the time when the DB cluster was created, in Universal Coordinated Time (UTC).
     */
    public val clusterCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.clusterCreateTime
    /**
     * *If set to `true`, tags are copied to any snapshot of the DB cluster that is created.*
     */
    public val copyTagsToSnapshot: kotlin.Boolean? = builder.copyTagsToSnapshot
    /**
     * If set to `true`, the DB cluster can be cloned across accounts.
     */
    public val crossAccountClone: kotlin.Boolean? = builder.crossAccountClone
    /**
     * Contains the name of the initial database of this DB cluster that was provided at create time, if one was specified when the DB cluster was created. This same name is returned for the life of the DB cluster.
     */
    public val databaseName: kotlin.String? = builder.databaseName
    /**
     * The Amazon Resource Name (ARN) for the DB cluster.
     */
    public val dbClusterArn: kotlin.String? = builder.dbClusterArn
    /**
     * Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * Provides the list of instances that make up the DB cluster.
     */
    public val dbClusterMembers: List<DbClusterMember>? = builder.dbClusterMembers
    /**
     * Not supported by Neptune.
     */
    public val dbClusterOptionGroupMemberships: List<DbClusterOptionGroupStatus>? = builder.dbClusterOptionGroupMemberships
    /**
     * Specifies the name of the DB cluster parameter group for the DB cluster.
     */
    public val dbClusterParameterGroup: kotlin.String? = builder.dbClusterParameterGroup
    /**
     * The Amazon Region-unique, immutable identifier for the DB cluster. This identifier is found in Amazon CloudTrail log entries whenever the Amazon KMS key for the DB cluster is accessed.
     */
    public val dbClusterResourceId: kotlin.String? = builder.dbClusterResourceId
    /**
     * Specifies information on the subnet group associated with the DB cluster, including the name, description, and subnets in the subnet group.
     */
    public val dbSubnetGroup: kotlin.String? = builder.dbSubnetGroup
    /**
     * Indicates whether or not the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled.
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * Specifies the earliest time to which a database can be restored with point-in-time restore.
     */
    public val earliestRestorableTime: aws.smithy.kotlin.runtime.time.Instant? = builder.earliestRestorableTime
    /**
     * A list of the log types that this DB cluster is configured to export to CloudWatch Logs. Valid log types are: `audit` (to publish audit logs to CloudWatch) and slowquery (to publish slow-query logs to CloudWatch). See [Publishing Neptune logs to Amazon CloudWatch logs](https://docs.aws.amazon.com/neptune/latest/userguide/cloudwatch-logs.html).
     */
    public val enabledCloudwatchLogsExports: List<String>? = builder.enabledCloudwatchLogsExports
    /**
     * Specifies the connection endpoint for the primary instance of the DB cluster.
     */
    public val endpoint: kotlin.String? = builder.endpoint
    /**
     * Provides the name of the database engine to be used for this DB cluster.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * Indicates the database engine version.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * Contains a user-supplied global database cluster identifier. This identifier is the unique key that identifies a global database.
     */
    public val globalClusterIdentifier: kotlin.String? = builder.globalClusterIdentifier
    /**
     * Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
     */
    public val hostedZoneId: kotlin.String? = builder.hostedZoneId
    /**
     * True if mapping of Amazon Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.
     */
    public val iamDatabaseAuthenticationEnabled: kotlin.Boolean? = builder.iamDatabaseAuthenticationEnabled
    /**
     * The next time you can modify the DB cluster to use the `iopt1` storage type.
     */
    public val ioOptimizedNextAllowedModificationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.ioOptimizedNextAllowedModificationTime
    /**
     * If `StorageEncrypted` is true, the Amazon KMS key identifier for the encrypted DB cluster.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Specifies the latest time to which a database can be restored with point-in-time restore.
     */
    public val latestRestorableTime: aws.smithy.kotlin.runtime.time.Instant? = builder.latestRestorableTime
    /**
     * Not supported by Neptune.
     */
    public val masterUsername: kotlin.String? = builder.masterUsername
    /**
     * Specifies whether the DB cluster has instances in multiple Availability Zones.
     */
    public val multiAz: kotlin.Boolean? = builder.multiAz
    /**
     * This data type is used as a response element in the `ModifyDBCluster` operation and contains changes that will be applied during the next maintenance window.
     */
    public val pendingModifiedValues: aws.sdk.kotlin.services.neptune.model.ClusterPendingModifiedValues? = builder.pendingModifiedValues
    /**
     * Specifies the progress of the operation as a percentage.
     */
    public val percentProgress: kotlin.String? = builder.percentProgress
    /**
     * Specifies the port that the database engine is listening on.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the `BackupRetentionPeriod`.
     */
    public val preferredBackupWindow: kotlin.String? = builder.preferredBackupWindow
    /**
     * Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * Contains one or more identifiers of the Read Replicas associated with this DB cluster.
     */
    public val readReplicaIdentifiers: List<String>? = builder.readReplicaIdentifiers
    /**
     * The reader endpoint for the DB cluster. The reader endpoint for a DB cluster load-balances connections across the Read Replicas that are available in a DB cluster. As clients request new connections to the reader endpoint, Neptune distributes the connection requests among the Read Replicas in the DB cluster. This functionality can help balance your read workload across multiple Read Replicas in your DB cluster.
     *
     * If a failover occurs, and the Read Replica that you are connected to is promoted to be the primary instance, your connection is dropped. To continue sending your read workload to other Read Replicas in the cluster, you can then reconnect to the reader endpoint.
     */
    public val readerEndpoint: kotlin.String? = builder.readerEndpoint
    /**
     * Not supported by Neptune.
     */
    public val replicationSourceIdentifier: kotlin.String? = builder.replicationSourceIdentifier
    /**
     * Shows the scaling configuration for a Neptune Serverless DB cluster.
     *
     * For more information, see [Using Amazon Neptune Serverless](https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-using.html) in the *Amazon Neptune User Guide*.
     */
    public val serverlessV2ScalingConfiguration: aws.sdk.kotlin.services.neptune.model.ServerlessV2ScalingConfigurationInfo? = builder.serverlessV2ScalingConfiguration
    /**
     * Specifies the current state of this DB cluster.
     */
    public val status: kotlin.String? = builder.status
    /**
     * Specifies whether the DB cluster is encrypted.
     */
    public val storageEncrypted: kotlin.Boolean? = builder.storageEncrypted
    /**
     * The storage type associated with the DB cluster.
     */
    public val storageType: kotlin.String? = builder.storageType
    /**
     * Provides a list of VPC security groups that the DB cluster belongs to.
     */
    public val vpcSecurityGroups: List<VpcSecurityGroupMembership>? = builder.vpcSecurityGroups

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptune.model.DbCluster = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbCluster(")
        append("allocatedStorage=$allocatedStorage,")
        append("associatedRoles=$associatedRoles,")
        append("automaticRestartTime=$automaticRestartTime,")
        append("availabilityZones=$availabilityZones,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("characterSetName=$characterSetName,")
        append("cloneGroupId=$cloneGroupId,")
        append("clusterCreateTime=$clusterCreateTime,")
        append("copyTagsToSnapshot=$copyTagsToSnapshot,")
        append("crossAccountClone=$crossAccountClone,")
        append("databaseName=$databaseName,")
        append("dbClusterArn=$dbClusterArn,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbClusterMembers=$dbClusterMembers,")
        append("dbClusterOptionGroupMemberships=$dbClusterOptionGroupMemberships,")
        append("dbClusterParameterGroup=$dbClusterParameterGroup,")
        append("dbClusterResourceId=$dbClusterResourceId,")
        append("dbSubnetGroup=$dbSubnetGroup,")
        append("deletionProtection=$deletionProtection,")
        append("earliestRestorableTime=$earliestRestorableTime,")
        append("enabledCloudwatchLogsExports=$enabledCloudwatchLogsExports,")
        append("endpoint=$endpoint,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("globalClusterIdentifier=$globalClusterIdentifier,")
        append("hostedZoneId=$hostedZoneId,")
        append("iamDatabaseAuthenticationEnabled=$iamDatabaseAuthenticationEnabled,")
        append("ioOptimizedNextAllowedModificationTime=$ioOptimizedNextAllowedModificationTime,")
        append("kmsKeyId=$kmsKeyId,")
        append("latestRestorableTime=$latestRestorableTime,")
        append("masterUsername=$masterUsername,")
        append("multiAz=$multiAz,")
        append("pendingModifiedValues=$pendingModifiedValues,")
        append("percentProgress=$percentProgress,")
        append("port=$port,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("readReplicaIdentifiers=$readReplicaIdentifiers,")
        append("readerEndpoint=$readerEndpoint,")
        append("replicationSourceIdentifier=$replicationSourceIdentifier,")
        append("serverlessV2ScalingConfiguration=$serverlessV2ScalingConfiguration,")
        append("status=$status,")
        append("storageEncrypted=$storageEncrypted,")
        append("storageType=$storageType,")
        append("vpcSecurityGroups=$vpcSecurityGroups")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage ?: 0
        result = 31 * result + (associatedRoles?.hashCode() ?: 0)
        result = 31 * result + (automaticRestartTime?.hashCode() ?: 0)
        result = 31 * result + (availabilityZones?.hashCode() ?: 0)
        result = 31 * result + (backupRetentionPeriod ?: 0)
        result = 31 * result + (characterSetName?.hashCode() ?: 0)
        result = 31 * result + (cloneGroupId?.hashCode() ?: 0)
        result = 31 * result + (clusterCreateTime?.hashCode() ?: 0)
        result = 31 * result + (copyTagsToSnapshot?.hashCode() ?: 0)
        result = 31 * result + (crossAccountClone?.hashCode() ?: 0)
        result = 31 * result + (databaseName?.hashCode() ?: 0)
        result = 31 * result + (dbClusterArn?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbClusterMembers?.hashCode() ?: 0)
        result = 31 * result + (dbClusterOptionGroupMemberships?.hashCode() ?: 0)
        result = 31 * result + (dbClusterParameterGroup?.hashCode() ?: 0)
        result = 31 * result + (dbClusterResourceId?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroup?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (earliestRestorableTime?.hashCode() ?: 0)
        result = 31 * result + (enabledCloudwatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (globalClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (hostedZoneId?.hashCode() ?: 0)
        result = 31 * result + (iamDatabaseAuthenticationEnabled?.hashCode() ?: 0)
        result = 31 * result + (ioOptimizedNextAllowedModificationTime?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (latestRestorableTime?.hashCode() ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (multiAz?.hashCode() ?: 0)
        result = 31 * result + (pendingModifiedValues?.hashCode() ?: 0)
        result = 31 * result + (percentProgress?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (readReplicaIdentifiers?.hashCode() ?: 0)
        result = 31 * result + (readerEndpoint?.hashCode() ?: 0)
        result = 31 * result + (replicationSourceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (serverlessV2ScalingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (storageEncrypted?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroups?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbCluster

        if (allocatedStorage != other.allocatedStorage) return false
        if (associatedRoles != other.associatedRoles) return false
        if (automaticRestartTime != other.automaticRestartTime) return false
        if (availabilityZones != other.availabilityZones) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (characterSetName != other.characterSetName) return false
        if (cloneGroupId != other.cloneGroupId) return false
        if (clusterCreateTime != other.clusterCreateTime) return false
        if (copyTagsToSnapshot != other.copyTagsToSnapshot) return false
        if (crossAccountClone != other.crossAccountClone) return false
        if (databaseName != other.databaseName) return false
        if (dbClusterArn != other.dbClusterArn) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbClusterMembers != other.dbClusterMembers) return false
        if (dbClusterOptionGroupMemberships != other.dbClusterOptionGroupMemberships) return false
        if (dbClusterParameterGroup != other.dbClusterParameterGroup) return false
        if (dbClusterResourceId != other.dbClusterResourceId) return false
        if (dbSubnetGroup != other.dbSubnetGroup) return false
        if (deletionProtection != other.deletionProtection) return false
        if (earliestRestorableTime != other.earliestRestorableTime) return false
        if (enabledCloudwatchLogsExports != other.enabledCloudwatchLogsExports) return false
        if (endpoint != other.endpoint) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (globalClusterIdentifier != other.globalClusterIdentifier) return false
        if (hostedZoneId != other.hostedZoneId) return false
        if (iamDatabaseAuthenticationEnabled != other.iamDatabaseAuthenticationEnabled) return false
        if (ioOptimizedNextAllowedModificationTime != other.ioOptimizedNextAllowedModificationTime) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (latestRestorableTime != other.latestRestorableTime) return false
        if (masterUsername != other.masterUsername) return false
        if (multiAz != other.multiAz) return false
        if (pendingModifiedValues != other.pendingModifiedValues) return false
        if (percentProgress != other.percentProgress) return false
        if (port != other.port) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (readReplicaIdentifiers != other.readReplicaIdentifiers) return false
        if (readerEndpoint != other.readerEndpoint) return false
        if (replicationSourceIdentifier != other.replicationSourceIdentifier) return false
        if (serverlessV2ScalingConfiguration != other.serverlessV2ScalingConfiguration) return false
        if (status != other.status) return false
        if (storageEncrypted != other.storageEncrypted) return false
        if (storageType != other.storageType) return false
        if (vpcSecurityGroups != other.vpcSecurityGroups) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptune.model.DbCluster = Builder(this).apply(block).build()

    public class Builder {
        /**
         * `AllocatedStorage` always returns 1, because Neptune DB cluster storage size is not fixed, but instead automatically adjusts as needed.
         */
        public var allocatedStorage: kotlin.Int? = null
        /**
         * Provides a list of the Amazon Identity and Access Management (IAM) roles that are associated with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon services on your behalf.
         */
        public var associatedRoles: List<DbClusterRole>? = null
        /**
         * Time at which the DB cluster will be automatically restarted.
         */
        public var automaticRestartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Provides the list of EC2 Availability Zones that instances in the DB cluster can be created in.
         */
        public var availabilityZones: List<String>? = null
        /**
         * Specifies the number of days for which automatic DB snapshots are retained.
         */
        public var backupRetentionPeriod: kotlin.Int? = null
        /**
         * Not supported by Neptune.
         */
        public var characterSetName: kotlin.String? = null
        /**
         * Identifies the clone group to which the DB cluster is associated.
         */
        public var cloneGroupId: kotlin.String? = null
        /**
         * Specifies the time when the DB cluster was created, in Universal Coordinated Time (UTC).
         */
        public var clusterCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * *If set to `true`, tags are copied to any snapshot of the DB cluster that is created.*
         */
        public var copyTagsToSnapshot: kotlin.Boolean? = null
        /**
         * If set to `true`, the DB cluster can be cloned across accounts.
         */
        public var crossAccountClone: kotlin.Boolean? = null
        /**
         * Contains the name of the initial database of this DB cluster that was provided at create time, if one was specified when the DB cluster was created. This same name is returned for the life of the DB cluster.
         */
        public var databaseName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the DB cluster.
         */
        public var dbClusterArn: kotlin.String? = null
        /**
         * Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * Provides the list of instances that make up the DB cluster.
         */
        public var dbClusterMembers: List<DbClusterMember>? = null
        /**
         * Not supported by Neptune.
         */
        public var dbClusterOptionGroupMemberships: List<DbClusterOptionGroupStatus>? = null
        /**
         * Specifies the name of the DB cluster parameter group for the DB cluster.
         */
        public var dbClusterParameterGroup: kotlin.String? = null
        /**
         * The Amazon Region-unique, immutable identifier for the DB cluster. This identifier is found in Amazon CloudTrail log entries whenever the Amazon KMS key for the DB cluster is accessed.
         */
        public var dbClusterResourceId: kotlin.String? = null
        /**
         * Specifies information on the subnet group associated with the DB cluster, including the name, description, and subnets in the subnet group.
         */
        public var dbSubnetGroup: kotlin.String? = null
        /**
         * Indicates whether or not the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled.
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * Specifies the earliest time to which a database can be restored with point-in-time restore.
         */
        public var earliestRestorableTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of the log types that this DB cluster is configured to export to CloudWatch Logs. Valid log types are: `audit` (to publish audit logs to CloudWatch) and slowquery (to publish slow-query logs to CloudWatch). See [Publishing Neptune logs to Amazon CloudWatch logs](https://docs.aws.amazon.com/neptune/latest/userguide/cloudwatch-logs.html).
         */
        public var enabledCloudwatchLogsExports: List<String>? = null
        /**
         * Specifies the connection endpoint for the primary instance of the DB cluster.
         */
        public var endpoint: kotlin.String? = null
        /**
         * Provides the name of the database engine to be used for this DB cluster.
         */
        public var engine: kotlin.String? = null
        /**
         * Indicates the database engine version.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * Contains a user-supplied global database cluster identifier. This identifier is the unique key that identifies a global database.
         */
        public var globalClusterIdentifier: kotlin.String? = null
        /**
         * Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
         */
        public var hostedZoneId: kotlin.String? = null
        /**
         * True if mapping of Amazon Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.
         */
        public var iamDatabaseAuthenticationEnabled: kotlin.Boolean? = null
        /**
         * The next time you can modify the DB cluster to use the `iopt1` storage type.
         */
        public var ioOptimizedNextAllowedModificationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If `StorageEncrypted` is true, the Amazon KMS key identifier for the encrypted DB cluster.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Specifies the latest time to which a database can be restored with point-in-time restore.
         */
        public var latestRestorableTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Not supported by Neptune.
         */
        public var masterUsername: kotlin.String? = null
        /**
         * Specifies whether the DB cluster has instances in multiple Availability Zones.
         */
        public var multiAz: kotlin.Boolean? = null
        /**
         * This data type is used as a response element in the `ModifyDBCluster` operation and contains changes that will be applied during the next maintenance window.
         */
        public var pendingModifiedValues: aws.sdk.kotlin.services.neptune.model.ClusterPendingModifiedValues? = null
        /**
         * Specifies the progress of the operation as a percentage.
         */
        public var percentProgress: kotlin.String? = null
        /**
         * Specifies the port that the database engine is listening on.
         */
        public var port: kotlin.Int? = null
        /**
         * Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the `BackupRetentionPeriod`.
         */
        public var preferredBackupWindow: kotlin.String? = null
        /**
         * Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * Contains one or more identifiers of the Read Replicas associated with this DB cluster.
         */
        public var readReplicaIdentifiers: List<String>? = null
        /**
         * The reader endpoint for the DB cluster. The reader endpoint for a DB cluster load-balances connections across the Read Replicas that are available in a DB cluster. As clients request new connections to the reader endpoint, Neptune distributes the connection requests among the Read Replicas in the DB cluster. This functionality can help balance your read workload across multiple Read Replicas in your DB cluster.
         *
         * If a failover occurs, and the Read Replica that you are connected to is promoted to be the primary instance, your connection is dropped. To continue sending your read workload to other Read Replicas in the cluster, you can then reconnect to the reader endpoint.
         */
        public var readerEndpoint: kotlin.String? = null
        /**
         * Not supported by Neptune.
         */
        public var replicationSourceIdentifier: kotlin.String? = null
        /**
         * Shows the scaling configuration for a Neptune Serverless DB cluster.
         *
         * For more information, see [Using Amazon Neptune Serverless](https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-using.html) in the *Amazon Neptune User Guide*.
         */
        public var serverlessV2ScalingConfiguration: aws.sdk.kotlin.services.neptune.model.ServerlessV2ScalingConfigurationInfo? = null
        /**
         * Specifies the current state of this DB cluster.
         */
        public var status: kotlin.String? = null
        /**
         * Specifies whether the DB cluster is encrypted.
         */
        public var storageEncrypted: kotlin.Boolean? = null
        /**
         * The storage type associated with the DB cluster.
         */
        public var storageType: kotlin.String? = null
        /**
         * Provides a list of VPC security groups that the DB cluster belongs to.
         */
        public var vpcSecurityGroups: List<VpcSecurityGroupMembership>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptune.model.DbCluster) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.associatedRoles = x.associatedRoles
            this.automaticRestartTime = x.automaticRestartTime
            this.availabilityZones = x.availabilityZones
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.characterSetName = x.characterSetName
            this.cloneGroupId = x.cloneGroupId
            this.clusterCreateTime = x.clusterCreateTime
            this.copyTagsToSnapshot = x.copyTagsToSnapshot
            this.crossAccountClone = x.crossAccountClone
            this.databaseName = x.databaseName
            this.dbClusterArn = x.dbClusterArn
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbClusterMembers = x.dbClusterMembers
            this.dbClusterOptionGroupMemberships = x.dbClusterOptionGroupMemberships
            this.dbClusterParameterGroup = x.dbClusterParameterGroup
            this.dbClusterResourceId = x.dbClusterResourceId
            this.dbSubnetGroup = x.dbSubnetGroup
            this.deletionProtection = x.deletionProtection
            this.earliestRestorableTime = x.earliestRestorableTime
            this.enabledCloudwatchLogsExports = x.enabledCloudwatchLogsExports
            this.endpoint = x.endpoint
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.globalClusterIdentifier = x.globalClusterIdentifier
            this.hostedZoneId = x.hostedZoneId
            this.iamDatabaseAuthenticationEnabled = x.iamDatabaseAuthenticationEnabled
            this.ioOptimizedNextAllowedModificationTime = x.ioOptimizedNextAllowedModificationTime
            this.kmsKeyId = x.kmsKeyId
            this.latestRestorableTime = x.latestRestorableTime
            this.masterUsername = x.masterUsername
            this.multiAz = x.multiAz
            this.pendingModifiedValues = x.pendingModifiedValues
            this.percentProgress = x.percentProgress
            this.port = x.port
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.readReplicaIdentifiers = x.readReplicaIdentifiers
            this.readerEndpoint = x.readerEndpoint
            this.replicationSourceIdentifier = x.replicationSourceIdentifier
            this.serverlessV2ScalingConfiguration = x.serverlessV2ScalingConfiguration
            this.status = x.status
            this.storageEncrypted = x.storageEncrypted
            this.storageType = x.storageType
            this.vpcSecurityGroups = x.vpcSecurityGroups
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptune.model.DbCluster = DbCluster(this)

        /**
         * construct an [aws.sdk.kotlin.services.neptune.model.ClusterPendingModifiedValues] inside the given [block]
         */
        public fun pendingModifiedValues(block: aws.sdk.kotlin.services.neptune.model.ClusterPendingModifiedValues.Builder.() -> kotlin.Unit) {
            this.pendingModifiedValues = aws.sdk.kotlin.services.neptune.model.ClusterPendingModifiedValues.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.neptune.model.ServerlessV2ScalingConfigurationInfo] inside the given [block]
         */
        public fun serverlessV2ScalingConfiguration(block: aws.sdk.kotlin.services.neptune.model.ServerlessV2ScalingConfigurationInfo.Builder.() -> kotlin.Unit) {
            this.serverlessV2ScalingConfiguration = aws.sdk.kotlin.services.neptune.model.ServerlessV2ScalingConfigurationInfo.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
