// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.model



public class CreateDbInstanceRequest private constructor(builder: Builder) {
    /**
     * Not supported by Neptune.
     */
    public val allocatedStorage: kotlin.Int? = builder.allocatedStorage
    /**
     * Indicates that minor engine upgrades are applied automatically to the DB instance during the maintenance window.
     *
     * Default: `true`
     */
    public val autoMinorVersionUpgrade: kotlin.Boolean? = builder.autoMinorVersionUpgrade
    /**
     * The EC2 Availability Zone that the DB instance is created in
     *
     * Default: A random, system-chosen Availability Zone in the endpoint's Amazon Region.
     *
     *  Example: `us-east-1d`
     *
     *  Constraint: The AvailabilityZone parameter can't be specified if the MultiAZ parameter is set to `true`. The specified Availability Zone must be in the same Amazon Region as the current endpoint.
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The number of days for which automated backups are retained.
     *
     * Not applicable. The retention period for automated backups is managed by the DB cluster. For more information, see CreateDBCluster.
     *
     * Default: 1
     *
     * Constraints:
     * + Must be a value from 0 to 35
     * + Cannot be set to 0 if the DB instance is a source to Read Replicas
     */
    public val backupRetentionPeriod: kotlin.Int? = builder.backupRetentionPeriod
    /**
     * *(Not supported by Neptune)*
     */
    public val characterSetName: kotlin.String? = builder.characterSetName
    /**
     * True to copy all tags from the DB instance to snapshots of the DB instance, and otherwise false. The default is false.
     */
    public val copyTagsToSnapshot: kotlin.Boolean? = builder.copyTagsToSnapshot
    /**
     * The identifier of the DB cluster that the instance will belong to.
     *
     * For information on creating a DB cluster, see CreateDBCluster.
     *
     * Type: String
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The compute and memory capacity of the DB instance, for example, `db.m4.large`. Not all DB instance classes are available in all Amazon Regions.
     */
    public val dbInstanceClass: kotlin.String? = builder.dbInstanceClass
    /**
     * The DB instance identifier. This parameter is stored as a lowercase string.
     *
     * Constraints:
     * + Must contain from 1 to 63 letters, numbers, or hyphens.
     * + First character must be a letter.
     * + Cannot end with a hyphen or contain two consecutive hyphens.
     *
     * Example: `mydbinstance`
     */
    public val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * Not supported.
     */
    public val dbName: kotlin.String? = builder.dbName
    /**
     * The name of the DB parameter group to associate with this DB instance. If this argument is omitted, the default DBParameterGroup for the specified engine is used.
     *
     * Constraints:
     * + Must be 1 to 255 letters, numbers, or hyphens.
     * + First character must be a letter
     * + Cannot end with a hyphen or contain two consecutive hyphens
     */
    public val dbParameterGroupName: kotlin.String? = builder.dbParameterGroupName
    /**
     * A list of DB security groups to associate with this DB instance.
     *
     * Default: The default DB security group for the database engine.
     */
    public val dbSecurityGroups: List<String>? = builder.dbSecurityGroups
    /**
     * A DB subnet group to associate with this DB instance.
     *
     * If there is no DB subnet group, then it is a non-VPC DB instance.
     */
    public val dbSubnetGroupName: kotlin.String? = builder.dbSubnetGroupName
    /**
     * A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. See [Deleting a DB Instance](https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html).
     *
     * DB instances in a DB cluster can be deleted even when deletion protection is enabled in their parent DB cluster.
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * Specify the Active Directory Domain to create the instance in.
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * Specify the name of the IAM role to be used when making API calls to the Directory Service.
     */
    public val domainIamRoleName: kotlin.String? = builder.domainIamRoleName
    /**
     * The list of log types that need to be enabled for exporting to CloudWatch Logs.
     */
    public val enableCloudwatchLogsExports: List<String>? = builder.enableCloudwatchLogsExports
    /**
     * Not supported by Neptune (ignored).
     */
    public val enableIamDatabaseAuthentication: kotlin.Boolean? = builder.enableIamDatabaseAuthentication
    /**
     * *(Not supported by Neptune)*
     */
    public val enablePerformanceInsights: kotlin.Boolean? = builder.enablePerformanceInsights
    /**
     * The name of the database engine to be used for this instance.
     *
     * Valid Values: `neptune`
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The version number of the database engine to use. Currently, setting this parameter has no effect.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for the DB instance.
     */
    public val iops: kotlin.Int? = builder.iops
    /**
     * The Amazon KMS key identifier for an encrypted DB instance.
     *
     * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a DB instance with the same Amazon account that owns the KMS encryption key used to encrypt the new DB instance, then you can use the KMS key alias instead of the ARN for the KM encryption key.
     *
     * Not applicable. The KMS key identifier is managed by the DB cluster. For more information, see CreateDBCluster.
     *
     * If the `StorageEncrypted` parameter is true, and you do not specify a value for the `KmsKeyId` parameter, then Amazon Neptune will use your default encryption key. Amazon KMS creates the default encryption key for your Amazon account. Your Amazon account has a different default encryption key for each Amazon Region.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * License model information for this DB instance.
     *
     *  Valid values: `license-included` | `bring-your-own-license` | `general-public-license`
     */
    public val licenseModel: kotlin.String? = builder.licenseModel
    /**
     * Not supported by Neptune.
     */
    public val masterUserPassword: kotlin.String? = builder.masterUserPassword
    /**
     * Not supported by Neptune.
     */
    public val masterUsername: kotlin.String? = builder.masterUsername
    /**
     * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0.
     *
     * If `MonitoringRoleArn` is specified, then you must also set `MonitoringInterval` to a value other than 0.
     *
     * Valid Values: `0, 1, 5, 10, 15, 30, 60`
     */
    public val monitoringInterval: kotlin.Int? = builder.monitoringInterval
    /**
     * The ARN for the IAM role that permits Neptune to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, `arn:aws:iam:123456789012:role/emaccess`.
     *
     * If `MonitoringInterval` is set to a value other than 0, then you must supply a `MonitoringRoleArn` value.
     */
    public val monitoringRoleArn: kotlin.String? = builder.monitoringRoleArn
    /**
     * Specifies if the DB instance is a Multi-AZ deployment. You can't set the AvailabilityZone parameter if the MultiAZ parameter is set to true.
     */
    public val multiAz: kotlin.Boolean? = builder.multiAz
    /**
     * *(Not supported by Neptune)*
     */
    public val optionGroupName: kotlin.String? = builder.optionGroupName
    /**
     * *(Not supported by Neptune)*
     */
    public val performanceInsightsKmsKeyId: kotlin.String? = builder.performanceInsightsKmsKeyId
    /**
     * The port number on which the database accepts connections.
     *
     * Not applicable. The port is managed by the DB cluster. For more information, see CreateDBCluster.
     *
     *  Default: `8182`
     *
     * Type: Integer
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The daily time range during which automated backups are created.
     *
     * Not applicable. The daily time range for creating automated backups is managed by the DB cluster. For more information, see CreateDBCluster.
     */
    public val preferredBackupWindow: kotlin.String? = builder.preferredBackupWindow
    /**
     * The time range each week during which system maintenance can occur, in Universal Coordinated Time (UTC).
     *
     *  Format: `ddd:hh24:mi-ddd:hh24:mi`
     *
     * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region, occurring on a random day of the week.
     *
     * Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     *
     * Constraints: Minimum 30-minute window.
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * A value that specifies the order in which an Read Replica is promoted to the primary instance after a failure of the existing primary instance.
     *
     * Default: 1
     *
     * Valid Values: 0 - 15
     */
    public val promotionTier: kotlin.Int? = builder.promotionTier
    /**
     * This flag should no longer be used.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * Specifies whether the DB instance is encrypted.
     *
     * Not applicable. The encryption for DB instances is managed by the DB cluster. For more information, see CreateDBCluster.
     *
     * Default: false
     */
    public val storageEncrypted: kotlin.Boolean? = builder.storageEncrypted
    /**
     * Specifies the storage type to be associated with the DB instance.
     *
     * Not applicable. Storage is managed by the DB Cluster.
     */
    public val storageType: kotlin.String? = builder.storageType
    /**
     * The tags to assign to the new instance.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The ARN from the key store with which to associate the instance for TDE encryption.
     */
    public val tdeCredentialArn: kotlin.String? = builder.tdeCredentialArn
    /**
     * The password for the given ARN from the key store in order to access the device.
     */
    public val tdeCredentialPassword: kotlin.String? = builder.tdeCredentialPassword
    /**
     * The time zone of the DB instance.
     */
    public val timezone: kotlin.String? = builder.timezone
    /**
     * A list of EC2 VPC security groups to associate with this DB instance.
     *
     * Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. For more information, see CreateDBCluster.
     *
     * Default: The default EC2 VPC security group for the DB subnet group's VPC.
     */
    public val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptune.model.CreateDbInstanceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDbInstanceRequest(")
        append("allocatedStorage=$allocatedStorage,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("availabilityZone=$availabilityZone,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("characterSetName=$characterSetName,")
        append("copyTagsToSnapshot=$copyTagsToSnapshot,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbInstanceClass=$dbInstanceClass,")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("dbName=$dbName,")
        append("dbParameterGroupName=$dbParameterGroupName,")
        append("dbSecurityGroups=$dbSecurityGroups,")
        append("dbSubnetGroupName=$dbSubnetGroupName,")
        append("deletionProtection=$deletionProtection,")
        append("domain=$domain,")
        append("domainIamRoleName=$domainIamRoleName,")
        append("enableCloudwatchLogsExports=$enableCloudwatchLogsExports,")
        append("enableIamDatabaseAuthentication=$enableIamDatabaseAuthentication,")
        append("enablePerformanceInsights=$enablePerformanceInsights,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("iops=$iops,")
        append("kmsKeyId=$kmsKeyId,")
        append("licenseModel=$licenseModel,")
        append("masterUserPassword=$masterUserPassword,")
        append("masterUsername=$masterUsername,")
        append("monitoringInterval=$monitoringInterval,")
        append("monitoringRoleArn=$monitoringRoleArn,")
        append("multiAz=$multiAz,")
        append("optionGroupName=$optionGroupName,")
        append("performanceInsightsKmsKeyId=$performanceInsightsKmsKeyId,")
        append("port=$port,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("promotionTier=$promotionTier,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("storageEncrypted=$storageEncrypted,")
        append("storageType=$storageType,")
        append("tags=$tags,")
        append("tdeCredentialArn=$tdeCredentialArn,")
        append("tdeCredentialPassword=*** Sensitive Data Redacted ***,")
        append("timezone=$timezone,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage ?: 0
        result = 31 * result + (autoMinorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (backupRetentionPeriod ?: 0)
        result = 31 * result + (characterSetName?.hashCode() ?: 0)
        result = 31 * result + (copyTagsToSnapshot?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbName?.hashCode() ?: 0)
        result = 31 * result + (dbParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (dbSecurityGroups?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (domainIamRoleName?.hashCode() ?: 0)
        result = 31 * result + (enableCloudwatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (enableIamDatabaseAuthentication?.hashCode() ?: 0)
        result = 31 * result + (enablePerformanceInsights?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (licenseModel?.hashCode() ?: 0)
        result = 31 * result + (masterUserPassword?.hashCode() ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (monitoringInterval ?: 0)
        result = 31 * result + (monitoringRoleArn?.hashCode() ?: 0)
        result = 31 * result + (multiAz?.hashCode() ?: 0)
        result = 31 * result + (optionGroupName?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (promotionTier ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (storageEncrypted?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tdeCredentialArn?.hashCode() ?: 0)
        result = 31 * result + (tdeCredentialPassword?.hashCode() ?: 0)
        result = 31 * result + (timezone?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDbInstanceRequest

        if (allocatedStorage != other.allocatedStorage) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (availabilityZone != other.availabilityZone) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (characterSetName != other.characterSetName) return false
        if (copyTagsToSnapshot != other.copyTagsToSnapshot) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbInstanceClass != other.dbInstanceClass) return false
        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (dbName != other.dbName) return false
        if (dbParameterGroupName != other.dbParameterGroupName) return false
        if (dbSecurityGroups != other.dbSecurityGroups) return false
        if (dbSubnetGroupName != other.dbSubnetGroupName) return false
        if (deletionProtection != other.deletionProtection) return false
        if (domain != other.domain) return false
        if (domainIamRoleName != other.domainIamRoleName) return false
        if (enableCloudwatchLogsExports != other.enableCloudwatchLogsExports) return false
        if (enableIamDatabaseAuthentication != other.enableIamDatabaseAuthentication) return false
        if (enablePerformanceInsights != other.enablePerformanceInsights) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (iops != other.iops) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (licenseModel != other.licenseModel) return false
        if (masterUserPassword != other.masterUserPassword) return false
        if (masterUsername != other.masterUsername) return false
        if (monitoringInterval != other.monitoringInterval) return false
        if (monitoringRoleArn != other.monitoringRoleArn) return false
        if (multiAz != other.multiAz) return false
        if (optionGroupName != other.optionGroupName) return false
        if (performanceInsightsKmsKeyId != other.performanceInsightsKmsKeyId) return false
        if (port != other.port) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (promotionTier != other.promotionTier) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (storageEncrypted != other.storageEncrypted) return false
        if (storageType != other.storageType) return false
        if (tags != other.tags) return false
        if (tdeCredentialArn != other.tdeCredentialArn) return false
        if (tdeCredentialPassword != other.tdeCredentialPassword) return false
        if (timezone != other.timezone) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptune.model.CreateDbInstanceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Not supported by Neptune.
         */
        public var allocatedStorage: kotlin.Int? = null
        /**
         * Indicates that minor engine upgrades are applied automatically to the DB instance during the maintenance window.
         *
         * Default: `true`
         */
        public var autoMinorVersionUpgrade: kotlin.Boolean? = null
        /**
         * The EC2 Availability Zone that the DB instance is created in
         *
         * Default: A random, system-chosen Availability Zone in the endpoint's Amazon Region.
         *
         *  Example: `us-east-1d`
         *
         *  Constraint: The AvailabilityZone parameter can't be specified if the MultiAZ parameter is set to `true`. The specified Availability Zone must be in the same Amazon Region as the current endpoint.
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * The number of days for which automated backups are retained.
         *
         * Not applicable. The retention period for automated backups is managed by the DB cluster. For more information, see CreateDBCluster.
         *
         * Default: 1
         *
         * Constraints:
         * + Must be a value from 0 to 35
         * + Cannot be set to 0 if the DB instance is a source to Read Replicas
         */
        public var backupRetentionPeriod: kotlin.Int? = null
        /**
         * *(Not supported by Neptune)*
         */
        public var characterSetName: kotlin.String? = null
        /**
         * True to copy all tags from the DB instance to snapshots of the DB instance, and otherwise false. The default is false.
         */
        public var copyTagsToSnapshot: kotlin.Boolean? = null
        /**
         * The identifier of the DB cluster that the instance will belong to.
         *
         * For information on creating a DB cluster, see CreateDBCluster.
         *
         * Type: String
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * The compute and memory capacity of the DB instance, for example, `db.m4.large`. Not all DB instance classes are available in all Amazon Regions.
         */
        public var dbInstanceClass: kotlin.String? = null
        /**
         * The DB instance identifier. This parameter is stored as a lowercase string.
         *
         * Constraints:
         * + Must contain from 1 to 63 letters, numbers, or hyphens.
         * + First character must be a letter.
         * + Cannot end with a hyphen or contain two consecutive hyphens.
         *
         * Example: `mydbinstance`
         */
        public var dbInstanceIdentifier: kotlin.String? = null
        /**
         * Not supported.
         */
        public var dbName: kotlin.String? = null
        /**
         * The name of the DB parameter group to associate with this DB instance. If this argument is omitted, the default DBParameterGroup for the specified engine is used.
         *
         * Constraints:
         * + Must be 1 to 255 letters, numbers, or hyphens.
         * + First character must be a letter
         * + Cannot end with a hyphen or contain two consecutive hyphens
         */
        public var dbParameterGroupName: kotlin.String? = null
        /**
         * A list of DB security groups to associate with this DB instance.
         *
         * Default: The default DB security group for the database engine.
         */
        public var dbSecurityGroups: List<String>? = null
        /**
         * A DB subnet group to associate with this DB instance.
         *
         * If there is no DB subnet group, then it is a non-VPC DB instance.
         */
        public var dbSubnetGroupName: kotlin.String? = null
        /**
         * A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. See [Deleting a DB Instance](https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-instances-delete.html).
         *
         * DB instances in a DB cluster can be deleted even when deletion protection is enabled in their parent DB cluster.
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * Specify the Active Directory Domain to create the instance in.
         */
        public var domain: kotlin.String? = null
        /**
         * Specify the name of the IAM role to be used when making API calls to the Directory Service.
         */
        public var domainIamRoleName: kotlin.String? = null
        /**
         * The list of log types that need to be enabled for exporting to CloudWatch Logs.
         */
        public var enableCloudwatchLogsExports: List<String>? = null
        /**
         * Not supported by Neptune (ignored).
         */
        public var enableIamDatabaseAuthentication: kotlin.Boolean? = null
        /**
         * *(Not supported by Neptune)*
         */
        public var enablePerformanceInsights: kotlin.Boolean? = null
        /**
         * The name of the database engine to be used for this instance.
         *
         * Valid Values: `neptune`
         */
        public var engine: kotlin.String? = null
        /**
         * The version number of the database engine to use. Currently, setting this parameter has no effect.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for the DB instance.
         */
        public var iops: kotlin.Int? = null
        /**
         * The Amazon KMS key identifier for an encrypted DB instance.
         *
         * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a DB instance with the same Amazon account that owns the KMS encryption key used to encrypt the new DB instance, then you can use the KMS key alias instead of the ARN for the KM encryption key.
         *
         * Not applicable. The KMS key identifier is managed by the DB cluster. For more information, see CreateDBCluster.
         *
         * If the `StorageEncrypted` parameter is true, and you do not specify a value for the `KmsKeyId` parameter, then Amazon Neptune will use your default encryption key. Amazon KMS creates the default encryption key for your Amazon account. Your Amazon account has a different default encryption key for each Amazon Region.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * License model information for this DB instance.
         *
         *  Valid values: `license-included` | `bring-your-own-license` | `general-public-license`
         */
        public var licenseModel: kotlin.String? = null
        /**
         * Not supported by Neptune.
         */
        public var masterUserPassword: kotlin.String? = null
        /**
         * Not supported by Neptune.
         */
        public var masterUsername: kotlin.String? = null
        /**
         * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0.
         *
         * If `MonitoringRoleArn` is specified, then you must also set `MonitoringInterval` to a value other than 0.
         *
         * Valid Values: `0, 1, 5, 10, 15, 30, 60`
         */
        public var monitoringInterval: kotlin.Int? = null
        /**
         * The ARN for the IAM role that permits Neptune to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, `arn:aws:iam:123456789012:role/emaccess`.
         *
         * If `MonitoringInterval` is set to a value other than 0, then you must supply a `MonitoringRoleArn` value.
         */
        public var monitoringRoleArn: kotlin.String? = null
        /**
         * Specifies if the DB instance is a Multi-AZ deployment. You can't set the AvailabilityZone parameter if the MultiAZ parameter is set to true.
         */
        public var multiAz: kotlin.Boolean? = null
        /**
         * *(Not supported by Neptune)*
         */
        public var optionGroupName: kotlin.String? = null
        /**
         * *(Not supported by Neptune)*
         */
        public var performanceInsightsKmsKeyId: kotlin.String? = null
        /**
         * The port number on which the database accepts connections.
         *
         * Not applicable. The port is managed by the DB cluster. For more information, see CreateDBCluster.
         *
         *  Default: `8182`
         *
         * Type: Integer
         */
        public var port: kotlin.Int? = null
        /**
         * The daily time range during which automated backups are created.
         *
         * Not applicable. The daily time range for creating automated backups is managed by the DB cluster. For more information, see CreateDBCluster.
         */
        public var preferredBackupWindow: kotlin.String? = null
        /**
         * The time range each week during which system maintenance can occur, in Universal Coordinated Time (UTC).
         *
         *  Format: `ddd:hh24:mi-ddd:hh24:mi`
         *
         * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region, occurring on a random day of the week.
         *
         * Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
         *
         * Constraints: Minimum 30-minute window.
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * A value that specifies the order in which an Read Replica is promoted to the primary instance after a failure of the existing primary instance.
         *
         * Default: 1
         *
         * Valid Values: 0 - 15
         */
        public var promotionTier: kotlin.Int? = null
        /**
         * This flag should no longer be used.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var publiclyAccessible: kotlin.Boolean? = null
        /**
         * Specifies whether the DB instance is encrypted.
         *
         * Not applicable. The encryption for DB instances is managed by the DB cluster. For more information, see CreateDBCluster.
         *
         * Default: false
         */
        public var storageEncrypted: kotlin.Boolean? = null
        /**
         * Specifies the storage type to be associated with the DB instance.
         *
         * Not applicable. Storage is managed by the DB Cluster.
         */
        public var storageType: kotlin.String? = null
        /**
         * The tags to assign to the new instance.
         */
        public var tags: List<Tag>? = null
        /**
         * The ARN from the key store with which to associate the instance for TDE encryption.
         */
        public var tdeCredentialArn: kotlin.String? = null
        /**
         * The password for the given ARN from the key store in order to access the device.
         */
        public var tdeCredentialPassword: kotlin.String? = null
        /**
         * The time zone of the DB instance.
         */
        public var timezone: kotlin.String? = null
        /**
         * A list of EC2 VPC security groups to associate with this DB instance.
         *
         * Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. For more information, see CreateDBCluster.
         *
         * Default: The default EC2 VPC security group for the DB subnet group's VPC.
         */
        public var vpcSecurityGroupIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptune.model.CreateDbInstanceRequest) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.availabilityZone = x.availabilityZone
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.characterSetName = x.characterSetName
            this.copyTagsToSnapshot = x.copyTagsToSnapshot
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbInstanceClass = x.dbInstanceClass
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.dbName = x.dbName
            this.dbParameterGroupName = x.dbParameterGroupName
            this.dbSecurityGroups = x.dbSecurityGroups
            this.dbSubnetGroupName = x.dbSubnetGroupName
            this.deletionProtection = x.deletionProtection
            this.domain = x.domain
            this.domainIamRoleName = x.domainIamRoleName
            this.enableCloudwatchLogsExports = x.enableCloudwatchLogsExports
            this.enableIamDatabaseAuthentication = x.enableIamDatabaseAuthentication
            this.enablePerformanceInsights = x.enablePerformanceInsights
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.iops = x.iops
            this.kmsKeyId = x.kmsKeyId
            this.licenseModel = x.licenseModel
            this.masterUserPassword = x.masterUserPassword
            this.masterUsername = x.masterUsername
            this.monitoringInterval = x.monitoringInterval
            this.monitoringRoleArn = x.monitoringRoleArn
            this.multiAz = x.multiAz
            this.optionGroupName = x.optionGroupName
            this.performanceInsightsKmsKeyId = x.performanceInsightsKmsKeyId
            this.port = x.port
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.promotionTier = x.promotionTier
            this.publiclyAccessible = x.publiclyAccessible
            this.storageEncrypted = x.storageEncrypted
            this.storageType = x.storageType
            this.tags = x.tags
            this.tdeCredentialArn = x.tdeCredentialArn
            this.tdeCredentialPassword = x.tdeCredentialPassword
            this.timezone = x.timezone
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptune.model.CreateDbInstanceRequest = CreateDbInstanceRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
