// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.model



public class CreateDbClusterRequest private constructor(builder: Builder) {
    /**
     * A list of EC2 Availability Zones that instances in the DB cluster can be created in.
     */
    public val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * The number of days for which automated backups are retained. You must specify a minimum value of 1.
     *
     * Default: 1
     *
     * Constraints:
     * + Must be a value from 1 to 35
     */
    public val backupRetentionPeriod: kotlin.Int? = builder.backupRetentionPeriod
    /**
     * *(Not supported by Neptune)*
     */
    public val characterSetName: kotlin.String? = builder.characterSetName
    /**
     * *If set to `true`, tags are copied to any snapshot of the DB cluster that is created.*
     */
    public val copyTagsToSnapshot: kotlin.Boolean? = builder.copyTagsToSnapshot
    /**
     * The name for your database of up to 64 alpha-numeric characters. If you do not provide a name, Amazon Neptune will not create a database in the DB cluster you are creating.
     */
    public val databaseName: kotlin.String? = builder.databaseName
    /**
     * The DB cluster identifier. This parameter is stored as a lowercase string.
     *
     * Constraints:
     * + Must contain from 1 to 63 letters, numbers, or hyphens.
     * + First character must be a letter.
     * + Cannot end with a hyphen or contain two consecutive hyphens.
     *
     * Example: `my-cluster1`
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The name of the DB cluster parameter group to associate with this DB cluster. If this argument is omitted, the default is used.
     *
     * Constraints:
     * + If supplied, must match the name of an existing DBClusterParameterGroup.
     */
    public val dbClusterParameterGroupName: kotlin.String? = builder.dbClusterParameterGroupName
    /**
     * A DB subnet group to associate with this DB cluster.
     *
     * Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.
     *
     * Example: `mySubnetgroup`
     */
    public val dbSubnetGroupName: kotlin.String? = builder.dbSubnetGroupName
    /**
     * A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is enabled.
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * A list of the log types that this DB cluster should export to CloudWatch Logs. Valid log types are: `audit` (to publish audit logs) and `slowquery` (to publish slow-query logs). See [Publishing Neptune logs to Amazon CloudWatch logs](https://docs.aws.amazon.com/neptune/latest/userguide/cloudwatch-logs.html).
     */
    public val enableCloudwatchLogsExports: List<String>? = builder.enableCloudwatchLogsExports
    /**
     * If set to `true`, enables Amazon Identity and Access Management (IAM) authentication for the entire DB cluster (this cannot be set at an instance level).
     *
     * Default: `false`.
     */
    public val enableIamDatabaseAuthentication: kotlin.Boolean? = builder.enableIamDatabaseAuthentication
    /**
     * The name of the database engine to be used for this DB cluster.
     *
     * Valid Values: `neptune`
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The version number of the database engine to use for the new DB cluster.
     *
     * Example: `1.0.2.1`
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The ID of the Neptune global database to which this new DB cluster should be added.
     */
    public val globalClusterIdentifier: kotlin.String? = builder.globalClusterIdentifier
    /**
     * The Amazon KMS key identifier for an encrypted DB cluster.
     *
     * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a DB cluster with the same Amazon account that owns the KMS encryption key used to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.
     *
     * If an encryption key is not specified in `KmsKeyId`:
     * + If `ReplicationSourceIdentifier` identifies an encrypted source, then Amazon Neptune will use the encryption key used to encrypt the source. Otherwise, Amazon Neptune will use your default encryption key.
     * + If the `StorageEncrypted` parameter is true and `ReplicationSourceIdentifier` is not specified, then Amazon Neptune will use your default encryption key.
     *
     * Amazon KMS creates the default encryption key for your Amazon account. Your Amazon account has a different default encryption key for each Amazon Region.
     *
     * If you create a Read Replica of an encrypted DB cluster in another Amazon Region, you must set `KmsKeyId` to a KMS key ID that is valid in the destination Amazon Region. This key is used to encrypt the Read Replica in that Amazon Region.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Not supported by Neptune.
     */
    public val masterUserPassword: kotlin.String? = builder.masterUserPassword
    /**
     * Not supported by Neptune.
     */
    public val masterUsername: kotlin.String? = builder.masterUsername
    /**
     * *(Not supported by Neptune)*
     */
    public val optionGroupName: kotlin.String? = builder.optionGroupName
    /**
     * The port number on which the instances in the DB cluster accept connections.
     *
     *  Default: `8182`
     */
    public val port: kotlin.Int? = builder.port
    /**
     * This parameter is not currently supported.
     */
    public val preSignedUrl: kotlin.String? = builder.preSignedUrl
    /**
     * The daily time range during which automated backups are created if automated backups are enabled using the `BackupRetentionPeriod` parameter.
     *
     * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region. To see the time blocks available, see [Neptune Maintenance Window](https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-maintaining.html#manage-console-maintaining-window) in the *Amazon Neptune User Guide.*
     *
     * Constraints:
     * + Must be in the format `hh24:mi-hh24:mi`.
     * + Must be in Universal Coordinated Time (UTC).
     * + Must not conflict with the preferred maintenance window.
     * + Must be at least 30 minutes.
     */
    public val preferredBackupWindow: kotlin.String? = builder.preferredBackupWindow
    /**
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     *
     * Format: `ddd:hh24:mi-ddd:hh24:mi`
     *
     * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region, occurring on a random day of the week. To see the time blocks available, see [Neptune Maintenance Window](https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-maintaining.html#manage-console-maintaining-window) in the *Amazon Neptune User Guide.*
     *
     * Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     *
     * Constraints: Minimum 30-minute window.
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a Read Replica.
     */
    public val replicationSourceIdentifier: kotlin.String? = builder.replicationSourceIdentifier
    /**
     * Contains the scaling configuration of a Neptune Serverless DB cluster.
     *
     * For more information, see [Using Amazon Neptune Serverless](https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-using.html) in the *Amazon Neptune User Guide*.
     */
    public val serverlessV2ScalingConfiguration: aws.sdk.kotlin.services.neptune.model.ServerlessV2ScalingConfiguration? = builder.serverlessV2ScalingConfiguration
    /**
     * Specifies whether the DB cluster is encrypted.
     */
    public val storageEncrypted: kotlin.Boolean? = builder.storageEncrypted
    /**
     * The storage type to associate with the DB cluster.
     *
     * Valid Values:
     * + `standard | iopt1`
     *
     * Default:
     * + `standard`
     *
     * When you create a Neptune cluster with the storage type set to `iopt1`, the storage type is returned in the response. The storage type isn't returned when you set it to `standard`.
     */
    public val storageType: kotlin.String? = builder.storageType
    /**
     * The tags to assign to the new DB cluster.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * A list of EC2 VPC security groups to associate with this DB cluster.
     */
    public val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptune.model.CreateDbClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDbClusterRequest(")
        append("availabilityZones=$availabilityZones,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("characterSetName=$characterSetName,")
        append("copyTagsToSnapshot=$copyTagsToSnapshot,")
        append("databaseName=$databaseName,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbClusterParameterGroupName=$dbClusterParameterGroupName,")
        append("dbSubnetGroupName=$dbSubnetGroupName,")
        append("deletionProtection=$deletionProtection,")
        append("enableCloudwatchLogsExports=$enableCloudwatchLogsExports,")
        append("enableIamDatabaseAuthentication=$enableIamDatabaseAuthentication,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("globalClusterIdentifier=$globalClusterIdentifier,")
        append("kmsKeyId=$kmsKeyId,")
        append("masterUserPassword=$masterUserPassword,")
        append("masterUsername=$masterUsername,")
        append("optionGroupName=$optionGroupName,")
        append("port=$port,")
        append("preSignedUrl=$preSignedUrl,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("replicationSourceIdentifier=$replicationSourceIdentifier,")
        append("serverlessV2ScalingConfiguration=$serverlessV2ScalingConfiguration,")
        append("storageEncrypted=$storageEncrypted,")
        append("storageType=$storageType,")
        append("tags=$tags,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZones?.hashCode() ?: 0
        result = 31 * result + (backupRetentionPeriod ?: 0)
        result = 31 * result + (characterSetName?.hashCode() ?: 0)
        result = 31 * result + (copyTagsToSnapshot?.hashCode() ?: 0)
        result = 31 * result + (databaseName?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbClusterParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (enableCloudwatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (enableIamDatabaseAuthentication?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (globalClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (masterUserPassword?.hashCode() ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (optionGroupName?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (preSignedUrl?.hashCode() ?: 0)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (replicationSourceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (serverlessV2ScalingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (storageEncrypted?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDbClusterRequest

        if (availabilityZones != other.availabilityZones) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (characterSetName != other.characterSetName) return false
        if (copyTagsToSnapshot != other.copyTagsToSnapshot) return false
        if (databaseName != other.databaseName) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbClusterParameterGroupName != other.dbClusterParameterGroupName) return false
        if (dbSubnetGroupName != other.dbSubnetGroupName) return false
        if (deletionProtection != other.deletionProtection) return false
        if (enableCloudwatchLogsExports != other.enableCloudwatchLogsExports) return false
        if (enableIamDatabaseAuthentication != other.enableIamDatabaseAuthentication) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (globalClusterIdentifier != other.globalClusterIdentifier) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (masterUserPassword != other.masterUserPassword) return false
        if (masterUsername != other.masterUsername) return false
        if (optionGroupName != other.optionGroupName) return false
        if (port != other.port) return false
        if (preSignedUrl != other.preSignedUrl) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (replicationSourceIdentifier != other.replicationSourceIdentifier) return false
        if (serverlessV2ScalingConfiguration != other.serverlessV2ScalingConfiguration) return false
        if (storageEncrypted != other.storageEncrypted) return false
        if (storageType != other.storageType) return false
        if (tags != other.tags) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptune.model.CreateDbClusterRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of EC2 Availability Zones that instances in the DB cluster can be created in.
         */
        public var availabilityZones: List<String>? = null
        /**
         * The number of days for which automated backups are retained. You must specify a minimum value of 1.
         *
         * Default: 1
         *
         * Constraints:
         * + Must be a value from 1 to 35
         */
        public var backupRetentionPeriod: kotlin.Int? = null
        /**
         * *(Not supported by Neptune)*
         */
        public var characterSetName: kotlin.String? = null
        /**
         * *If set to `true`, tags are copied to any snapshot of the DB cluster that is created.*
         */
        public var copyTagsToSnapshot: kotlin.Boolean? = null
        /**
         * The name for your database of up to 64 alpha-numeric characters. If you do not provide a name, Amazon Neptune will not create a database in the DB cluster you are creating.
         */
        public var databaseName: kotlin.String? = null
        /**
         * The DB cluster identifier. This parameter is stored as a lowercase string.
         *
         * Constraints:
         * + Must contain from 1 to 63 letters, numbers, or hyphens.
         * + First character must be a letter.
         * + Cannot end with a hyphen or contain two consecutive hyphens.
         *
         * Example: `my-cluster1`
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * The name of the DB cluster parameter group to associate with this DB cluster. If this argument is omitted, the default is used.
         *
         * Constraints:
         * + If supplied, must match the name of an existing DBClusterParameterGroup.
         */
        public var dbClusterParameterGroupName: kotlin.String? = null
        /**
         * A DB subnet group to associate with this DB cluster.
         *
         * Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.
         *
         * Example: `mySubnetgroup`
         */
        public var dbSubnetGroupName: kotlin.String? = null
        /**
         * A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is enabled.
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * A list of the log types that this DB cluster should export to CloudWatch Logs. Valid log types are: `audit` (to publish audit logs) and `slowquery` (to publish slow-query logs). See [Publishing Neptune logs to Amazon CloudWatch logs](https://docs.aws.amazon.com/neptune/latest/userguide/cloudwatch-logs.html).
         */
        public var enableCloudwatchLogsExports: List<String>? = null
        /**
         * If set to `true`, enables Amazon Identity and Access Management (IAM) authentication for the entire DB cluster (this cannot be set at an instance level).
         *
         * Default: `false`.
         */
        public var enableIamDatabaseAuthentication: kotlin.Boolean? = null
        /**
         * The name of the database engine to be used for this DB cluster.
         *
         * Valid Values: `neptune`
         */
        public var engine: kotlin.String? = null
        /**
         * The version number of the database engine to use for the new DB cluster.
         *
         * Example: `1.0.2.1`
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The ID of the Neptune global database to which this new DB cluster should be added.
         */
        public var globalClusterIdentifier: kotlin.String? = null
        /**
         * The Amazon KMS key identifier for an encrypted DB cluster.
         *
         * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a DB cluster with the same Amazon account that owns the KMS encryption key used to encrypt the new DB cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.
         *
         * If an encryption key is not specified in `KmsKeyId`:
         * + If `ReplicationSourceIdentifier` identifies an encrypted source, then Amazon Neptune will use the encryption key used to encrypt the source. Otherwise, Amazon Neptune will use your default encryption key.
         * + If the `StorageEncrypted` parameter is true and `ReplicationSourceIdentifier` is not specified, then Amazon Neptune will use your default encryption key.
         *
         * Amazon KMS creates the default encryption key for your Amazon account. Your Amazon account has a different default encryption key for each Amazon Region.
         *
         * If you create a Read Replica of an encrypted DB cluster in another Amazon Region, you must set `KmsKeyId` to a KMS key ID that is valid in the destination Amazon Region. This key is used to encrypt the Read Replica in that Amazon Region.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Not supported by Neptune.
         */
        public var masterUserPassword: kotlin.String? = null
        /**
         * Not supported by Neptune.
         */
        public var masterUsername: kotlin.String? = null
        /**
         * *(Not supported by Neptune)*
         */
        public var optionGroupName: kotlin.String? = null
        /**
         * The port number on which the instances in the DB cluster accept connections.
         *
         *  Default: `8182`
         */
        public var port: kotlin.Int? = null
        /**
         * This parameter is not currently supported.
         */
        public var preSignedUrl: kotlin.String? = null
        /**
         * The daily time range during which automated backups are created if automated backups are enabled using the `BackupRetentionPeriod` parameter.
         *
         * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region. To see the time blocks available, see [Neptune Maintenance Window](https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-maintaining.html#manage-console-maintaining-window) in the *Amazon Neptune User Guide.*
         *
         * Constraints:
         * + Must be in the format `hh24:mi-hh24:mi`.
         * + Must be in Universal Coordinated Time (UTC).
         * + Must not conflict with the preferred maintenance window.
         * + Must be at least 30 minutes.
         */
        public var preferredBackupWindow: kotlin.String? = null
        /**
         * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         *
         * Format: `ddd:hh24:mi-ddd:hh24:mi`
         *
         * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Region, occurring on a random day of the week. To see the time blocks available, see [Neptune Maintenance Window](https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-maintaining.html#manage-console-maintaining-window) in the *Amazon Neptune User Guide.*
         *
         * Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
         *
         * Constraints: Minimum 30-minute window.
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a Read Replica.
         */
        public var replicationSourceIdentifier: kotlin.String? = null
        /**
         * Contains the scaling configuration of a Neptune Serverless DB cluster.
         *
         * For more information, see [Using Amazon Neptune Serverless](https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-using.html) in the *Amazon Neptune User Guide*.
         */
        public var serverlessV2ScalingConfiguration: aws.sdk.kotlin.services.neptune.model.ServerlessV2ScalingConfiguration? = null
        /**
         * Specifies whether the DB cluster is encrypted.
         */
        public var storageEncrypted: kotlin.Boolean? = null
        /**
         * The storage type to associate with the DB cluster.
         *
         * Valid Values:
         * + `standard | iopt1`
         *
         * Default:
         * + `standard`
         *
         * When you create a Neptune cluster with the storage type set to `iopt1`, the storage type is returned in the response. The storage type isn't returned when you set it to `standard`.
         */
        public var storageType: kotlin.String? = null
        /**
         * The tags to assign to the new DB cluster.
         */
        public var tags: List<Tag>? = null
        /**
         * A list of EC2 VPC security groups to associate with this DB cluster.
         */
        public var vpcSecurityGroupIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptune.model.CreateDbClusterRequest) : this() {
            this.availabilityZones = x.availabilityZones
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.characterSetName = x.characterSetName
            this.copyTagsToSnapshot = x.copyTagsToSnapshot
            this.databaseName = x.databaseName
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbClusterParameterGroupName = x.dbClusterParameterGroupName
            this.dbSubnetGroupName = x.dbSubnetGroupName
            this.deletionProtection = x.deletionProtection
            this.enableCloudwatchLogsExports = x.enableCloudwatchLogsExports
            this.enableIamDatabaseAuthentication = x.enableIamDatabaseAuthentication
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.globalClusterIdentifier = x.globalClusterIdentifier
            this.kmsKeyId = x.kmsKeyId
            this.masterUserPassword = x.masterUserPassword
            this.masterUsername = x.masterUsername
            this.optionGroupName = x.optionGroupName
            this.port = x.port
            this.preSignedUrl = x.preSignedUrl
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.replicationSourceIdentifier = x.replicationSourceIdentifier
            this.serverlessV2ScalingConfiguration = x.serverlessV2ScalingConfiguration
            this.storageEncrypted = x.storageEncrypted
            this.storageType = x.storageType
            this.tags = x.tags
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptune.model.CreateDbClusterRequest = CreateDbClusterRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.neptune.model.ServerlessV2ScalingConfiguration] inside the given [block]
         */
        public fun serverlessV2ScalingConfiguration(block: aws.sdk.kotlin.services.neptune.model.ServerlessV2ScalingConfiguration.Builder.() -> kotlin.Unit) {
            this.serverlessV2ScalingConfiguration = aws.sdk.kotlin.services.neptune.model.ServerlessV2ScalingConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
