// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.neptune.model



public class CopyDbClusterSnapshotRequest private constructor(builder: Builder) {
    /**
     * True to copy all tags from the source DB cluster snapshot to the target DB cluster snapshot, and otherwise false. The default is false.
     */
    public val copyTags: kotlin.Boolean? = builder.copyTags
    /**
     * The Amazon Amazon KMS key ID for an encrypted DB cluster snapshot. The KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or the KMS key alias for the KMS encryption key.
     *
     * If you copy an encrypted DB cluster snapshot from your Amazon account, you can specify a value for `KmsKeyId` to encrypt the copy with a new KMS encryption key. If you don't specify a value for `KmsKeyId`, then the copy of the DB cluster snapshot is encrypted with the same KMS key as the source DB cluster snapshot.
     *
     * If you copy an encrypted DB cluster snapshot that is shared from another Amazon account, then you must specify a value for `KmsKeyId`.
     *
     *  KMS encryption keys are specific to the Amazon Region that they are created in, and you can't use encryption keys from one Amazon Region in another Amazon Region.
     *
     * You cannot encrypt an unencrypted DB cluster snapshot when you copy it. If you try to copy an unencrypted DB cluster snapshot and specify a value for the KmsKeyId parameter, an error is returned.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Not currently supported.
     */
    public val preSignedUrl: kotlin.String? = builder.preSignedUrl
    /**
     * The identifier of the DB cluster snapshot to copy. This parameter is not case-sensitive.
     *
     * Constraints:
     * + Must specify a valid system snapshot in the "available" state.
     * + Specify a valid DB snapshot identifier.
     *
     * Example: `my-cluster-snapshot1`
     */
    public val sourceDbClusterSnapshotIdentifier: kotlin.String? = builder.sourceDbClusterSnapshotIdentifier
    /**
     * The tags to assign to the new DB cluster snapshot copy.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The identifier of the new DB cluster snapshot to create from the source DB cluster snapshot. This parameter is not case-sensitive.
     *
     * Constraints:
     * + Must contain from 1 to 63 letters, numbers, or hyphens.
     * + First character must be a letter.
     * + Cannot end with a hyphen or contain two consecutive hyphens.
     *
     * Example: `my-cluster-snapshot2`
     */
    public val targetDbClusterSnapshotIdentifier: kotlin.String? = builder.targetDbClusterSnapshotIdentifier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.neptune.model.CopyDbClusterSnapshotRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CopyDbClusterSnapshotRequest(")
        append("copyTags=$copyTags,")
        append("kmsKeyId=$kmsKeyId,")
        append("preSignedUrl=$preSignedUrl,")
        append("sourceDbClusterSnapshotIdentifier=$sourceDbClusterSnapshotIdentifier,")
        append("tags=$tags,")
        append("targetDbClusterSnapshotIdentifier=$targetDbClusterSnapshotIdentifier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = copyTags?.hashCode() ?: 0
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (preSignedUrl?.hashCode() ?: 0)
        result = 31 * result + (sourceDbClusterSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetDbClusterSnapshotIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CopyDbClusterSnapshotRequest

        if (copyTags != other.copyTags) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (preSignedUrl != other.preSignedUrl) return false
        if (sourceDbClusterSnapshotIdentifier != other.sourceDbClusterSnapshotIdentifier) return false
        if (tags != other.tags) return false
        if (targetDbClusterSnapshotIdentifier != other.targetDbClusterSnapshotIdentifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.neptune.model.CopyDbClusterSnapshotRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * True to copy all tags from the source DB cluster snapshot to the target DB cluster snapshot, and otherwise false. The default is false.
         */
        public var copyTags: kotlin.Boolean? = null
        /**
         * The Amazon Amazon KMS key ID for an encrypted DB cluster snapshot. The KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or the KMS key alias for the KMS encryption key.
         *
         * If you copy an encrypted DB cluster snapshot from your Amazon account, you can specify a value for `KmsKeyId` to encrypt the copy with a new KMS encryption key. If you don't specify a value for `KmsKeyId`, then the copy of the DB cluster snapshot is encrypted with the same KMS key as the source DB cluster snapshot.
         *
         * If you copy an encrypted DB cluster snapshot that is shared from another Amazon account, then you must specify a value for `KmsKeyId`.
         *
         *  KMS encryption keys are specific to the Amazon Region that they are created in, and you can't use encryption keys from one Amazon Region in another Amazon Region.
         *
         * You cannot encrypt an unencrypted DB cluster snapshot when you copy it. If you try to copy an unencrypted DB cluster snapshot and specify a value for the KmsKeyId parameter, an error is returned.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Not currently supported.
         */
        public var preSignedUrl: kotlin.String? = null
        /**
         * The identifier of the DB cluster snapshot to copy. This parameter is not case-sensitive.
         *
         * Constraints:
         * + Must specify a valid system snapshot in the "available" state.
         * + Specify a valid DB snapshot identifier.
         *
         * Example: `my-cluster-snapshot1`
         */
        public var sourceDbClusterSnapshotIdentifier: kotlin.String? = null
        /**
         * The tags to assign to the new DB cluster snapshot copy.
         */
        public var tags: List<Tag>? = null
        /**
         * The identifier of the new DB cluster snapshot to create from the source DB cluster snapshot. This parameter is not case-sensitive.
         *
         * Constraints:
         * + Must contain from 1 to 63 letters, numbers, or hyphens.
         * + First character must be a letter.
         * + Cannot end with a hyphen or contain two consecutive hyphens.
         *
         * Example: `my-cluster-snapshot2`
         */
        public var targetDbClusterSnapshotIdentifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.neptune.model.CopyDbClusterSnapshotRequest) : this() {
            this.copyTags = x.copyTags
            this.kmsKeyId = x.kmsKeyId
            this.preSignedUrl = x.preSignedUrl
            this.sourceDbClusterSnapshotIdentifier = x.sourceDbClusterSnapshotIdentifier
            this.tags = x.tags
            this.targetDbClusterSnapshotIdentifier = x.targetDbClusterSnapshotIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.neptune.model.CopyDbClusterSnapshotRequest = CopyDbClusterSnapshotRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
