// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mwaa.serde

import aws.sdk.kotlin.services.mwaa.model.LoggingConfigurationInput
import aws.sdk.kotlin.services.mwaa.model.UpdateEnvironmentRequest
import aws.sdk.kotlin.services.mwaa.model.UpdateNetworkConfigurationInput
import aws.sdk.kotlin.services.mwaa.model.WebserverAccessMode
import aws.sdk.kotlin.services.mwaa.model.WorkerReplacementStrategy
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateEnvironmentOperationSerializer: HttpSerializer.NonStreaming<UpdateEnvironmentRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateEnvironmentRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            path.encodedSegments {
                add(PercentEncoding.Path.encode("environments"))
                add(PercentEncoding.SmithyLabel.encode(input.name))
            }
        }

        val payload = serializeUpdateEnvironmentOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateEnvironmentOperationBody(context: ExecutionContext, input: UpdateEnvironmentRequest): ByteArray {
    val serializer = JsonSerializer()
    val AIRFLOWCONFIGURATIONOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("AirflowConfigurationOptions"))
    val AIRFLOWVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AirflowVersion"))
    val DAGS3PATH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DagS3Path"))
    val ENVIRONMENTCLASS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EnvironmentClass"))
    val EXECUTIONROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ExecutionRoleArn"))
    val LOGGINGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LoggingConfiguration"))
    val MAXWEBSERVERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxWebservers"))
    val MAXWORKERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxWorkers"))
    val MINWEBSERVERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MinWebservers"))
    val MINWORKERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MinWorkers"))
    val NETWORKCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("NetworkConfiguration"))
    val PLUGINSS3OBJECTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PluginsS3ObjectVersion"))
    val PLUGINSS3PATH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PluginsS3Path"))
    val REQUIREMENTSS3OBJECTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RequirementsS3ObjectVersion"))
    val REQUIREMENTSS3PATH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RequirementsS3Path"))
    val SCHEDULERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("Schedulers"))
    val SOURCEBUCKETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceBucketArn"))
    val STARTUPSCRIPTS3OBJECTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StartupScriptS3ObjectVersion"))
    val STARTUPSCRIPTS3PATH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StartupScriptS3Path"))
    val WEBSERVERACCESSMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WebserverAccessMode"))
    val WEEKLYMAINTENANCEWINDOWSTART_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WeeklyMaintenanceWindowStart"))
    val WORKERREPLACEMENTSTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WorkerReplacementStrategy"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AIRFLOWCONFIGURATIONOPTIONS_DESCRIPTOR)
        field(AIRFLOWVERSION_DESCRIPTOR)
        field(DAGS3PATH_DESCRIPTOR)
        field(ENVIRONMENTCLASS_DESCRIPTOR)
        field(EXECUTIONROLEARN_DESCRIPTOR)
        field(LOGGINGCONFIGURATION_DESCRIPTOR)
        field(MAXWEBSERVERS_DESCRIPTOR)
        field(MAXWORKERS_DESCRIPTOR)
        field(MINWEBSERVERS_DESCRIPTOR)
        field(MINWORKERS_DESCRIPTOR)
        field(NETWORKCONFIGURATION_DESCRIPTOR)
        field(PLUGINSS3OBJECTVERSION_DESCRIPTOR)
        field(PLUGINSS3PATH_DESCRIPTOR)
        field(REQUIREMENTSS3OBJECTVERSION_DESCRIPTOR)
        field(REQUIREMENTSS3PATH_DESCRIPTOR)
        field(SCHEDULERS_DESCRIPTOR)
        field(SOURCEBUCKETARN_DESCRIPTOR)
        field(STARTUPSCRIPTS3OBJECTVERSION_DESCRIPTOR)
        field(STARTUPSCRIPTS3PATH_DESCRIPTOR)
        field(WEBSERVERACCESSMODE_DESCRIPTOR)
        field(WEEKLYMAINTENANCEWINDOWSTART_DESCRIPTOR)
        field(WORKERREPLACEMENTSTRATEGY_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.airflowConfigurationOptions != null) {
            mapField(AIRFLOWCONFIGURATIONOPTIONS_DESCRIPTOR) {
                input.airflowConfigurationOptions.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        input.airflowVersion?.let { field(AIRFLOWVERSION_DESCRIPTOR, it) }
        input.dagS3Path?.let { field(DAGS3PATH_DESCRIPTOR, it) }
        input.environmentClass?.let { field(ENVIRONMENTCLASS_DESCRIPTOR, it) }
        input.executionRoleArn?.let { field(EXECUTIONROLEARN_DESCRIPTOR, it) }
        input.loggingConfiguration?.let { field(LOGGINGCONFIGURATION_DESCRIPTOR, it, ::serializeLoggingConfigurationInputDocument) }
        input.maxWebservers?.let { field(MAXWEBSERVERS_DESCRIPTOR, it) }
        input.maxWorkers?.let { field(MAXWORKERS_DESCRIPTOR, it) }
        input.minWebservers?.let { field(MINWEBSERVERS_DESCRIPTOR, it) }
        input.minWorkers?.let { field(MINWORKERS_DESCRIPTOR, it) }
        input.networkConfiguration?.let { field(NETWORKCONFIGURATION_DESCRIPTOR, it, ::serializeUpdateNetworkConfigurationInputDocument) }
        input.pluginsS3ObjectVersion?.let { field(PLUGINSS3OBJECTVERSION_DESCRIPTOR, it) }
        input.pluginsS3Path?.let { field(PLUGINSS3PATH_DESCRIPTOR, it) }
        input.requirementsS3ObjectVersion?.let { field(REQUIREMENTSS3OBJECTVERSION_DESCRIPTOR, it) }
        input.requirementsS3Path?.let { field(REQUIREMENTSS3PATH_DESCRIPTOR, it) }
        input.schedulers?.let { field(SCHEDULERS_DESCRIPTOR, it) }
        input.sourceBucketArn?.let { field(SOURCEBUCKETARN_DESCRIPTOR, it) }
        input.startupScriptS3ObjectVersion?.let { field(STARTUPSCRIPTS3OBJECTVERSION_DESCRIPTOR, it) }
        input.startupScriptS3Path?.let { field(STARTUPSCRIPTS3PATH_DESCRIPTOR, it) }
        input.webserverAccessMode?.let { field(WEBSERVERACCESSMODE_DESCRIPTOR, it.value) }
        input.weeklyMaintenanceWindowStart?.let { field(WEEKLYMAINTENANCEWINDOWSTART_DESCRIPTOR, it) }
        input.workerReplacementStrategy?.let { field(WORKERREPLACEMENTSTRATEGY_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
