// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mwaa.serde

import aws.sdk.kotlin.services.mwaa.model.InvokeRestApiResponse
import aws.sdk.kotlin.services.mwaa.model.MwaaException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.content.Document
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class InvokeRestApiOperationDeserializer: HttpDeserializer.NonStreaming<InvokeRestApiResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): InvokeRestApiResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwInvokeRestApiError(context, call, payload)
        }
        val builder = InvokeRestApiResponse.Builder()

        if (payload != null) {
            deserializeInvokeRestApiOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwInvokeRestApiError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MwaaException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RestApiClientException" -> RestApiClientExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RestApiServerException" -> RestApiServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> MwaaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeInvokeRestApiOperationBody(builder: InvokeRestApiResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val RESTAPIRESPONSE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Document, JsonSerialName("RestApiResponse"))
    val RESTAPISTATUSCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("RestApiStatusCode"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(RESTAPIRESPONSE_DESCRIPTOR)
        field(RESTAPISTATUSCODE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                RESTAPIRESPONSE_DESCRIPTOR.index -> builder.restApiResponse = deserializeDocument()
                RESTAPISTATUSCODE_DESCRIPTOR.index -> builder.restApiStatusCode = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
