// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mwaa.serde

import aws.sdk.kotlin.services.mwaa.model.CreateEnvironmentRequest
import aws.sdk.kotlin.services.mwaa.model.EndpointManagement
import aws.sdk.kotlin.services.mwaa.model.LoggingConfigurationInput
import aws.sdk.kotlin.services.mwaa.model.NetworkConfiguration
import aws.sdk.kotlin.services.mwaa.model.WebserverAccessMode
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateEnvironmentOperationSerializer: HttpSerializer.NonStreaming<CreateEnvironmentRequest> {
    override fun serialize(context: ExecutionContext, input: CreateEnvironmentRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            path.encodedSegments {
                add(PercentEncoding.Path.encode("environments"))
                add(PercentEncoding.SmithyLabel.encode(input.name))
            }
        }

        val payload = serializeCreateEnvironmentOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateEnvironmentOperationBody(context: ExecutionContext, input: CreateEnvironmentRequest): ByteArray {
    val serializer = JsonSerializer()
    val AIRFLOWCONFIGURATIONOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("AirflowConfigurationOptions"))
    val AIRFLOWVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AirflowVersion"))
    val DAGS3PATH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DagS3Path"))
    val ENDPOINTMANAGEMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EndpointManagement"))
    val ENVIRONMENTCLASS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EnvironmentClass"))
    val EXECUTIONROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ExecutionRoleArn"))
    val KMSKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKey"))
    val LOGGINGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LoggingConfiguration"))
    val MAXWEBSERVERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxWebservers"))
    val MAXWORKERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxWorkers"))
    val MINWEBSERVERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MinWebservers"))
    val MINWORKERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MinWorkers"))
    val NETWORKCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("NetworkConfiguration"))
    val PLUGINSS3OBJECTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PluginsS3ObjectVersion"))
    val PLUGINSS3PATH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PluginsS3Path"))
    val REQUIREMENTSS3OBJECTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RequirementsS3ObjectVersion"))
    val REQUIREMENTSS3PATH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RequirementsS3Path"))
    val SCHEDULERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("Schedulers"))
    val SOURCEBUCKETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceBucketArn"))
    val STARTUPSCRIPTS3OBJECTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StartupScriptS3ObjectVersion"))
    val STARTUPSCRIPTS3PATH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StartupScriptS3Path"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val WEBSERVERACCESSMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WebserverAccessMode"))
    val WEEKLYMAINTENANCEWINDOWSTART_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WeeklyMaintenanceWindowStart"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AIRFLOWCONFIGURATIONOPTIONS_DESCRIPTOR)
        field(AIRFLOWVERSION_DESCRIPTOR)
        field(DAGS3PATH_DESCRIPTOR)
        field(ENDPOINTMANAGEMENT_DESCRIPTOR)
        field(ENVIRONMENTCLASS_DESCRIPTOR)
        field(EXECUTIONROLEARN_DESCRIPTOR)
        field(KMSKEY_DESCRIPTOR)
        field(LOGGINGCONFIGURATION_DESCRIPTOR)
        field(MAXWEBSERVERS_DESCRIPTOR)
        field(MAXWORKERS_DESCRIPTOR)
        field(MINWEBSERVERS_DESCRIPTOR)
        field(MINWORKERS_DESCRIPTOR)
        field(NETWORKCONFIGURATION_DESCRIPTOR)
        field(PLUGINSS3OBJECTVERSION_DESCRIPTOR)
        field(PLUGINSS3PATH_DESCRIPTOR)
        field(REQUIREMENTSS3OBJECTVERSION_DESCRIPTOR)
        field(REQUIREMENTSS3PATH_DESCRIPTOR)
        field(SCHEDULERS_DESCRIPTOR)
        field(SOURCEBUCKETARN_DESCRIPTOR)
        field(STARTUPSCRIPTS3OBJECTVERSION_DESCRIPTOR)
        field(STARTUPSCRIPTS3PATH_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(WEBSERVERACCESSMODE_DESCRIPTOR)
        field(WEEKLYMAINTENANCEWINDOWSTART_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.airflowConfigurationOptions != null) {
            mapField(AIRFLOWCONFIGURATIONOPTIONS_DESCRIPTOR) {
                input.airflowConfigurationOptions.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        input.airflowVersion?.let { field(AIRFLOWVERSION_DESCRIPTOR, it) }
        field(DAGS3PATH_DESCRIPTOR, input.dagS3Path)
        input.endpointManagement?.let { field(ENDPOINTMANAGEMENT_DESCRIPTOR, it.value) }
        input.environmentClass?.let { field(ENVIRONMENTCLASS_DESCRIPTOR, it) }
        field(EXECUTIONROLEARN_DESCRIPTOR, input.executionRoleArn)
        input.kmsKey?.let { field(KMSKEY_DESCRIPTOR, it) }
        input.loggingConfiguration?.let { field(LOGGINGCONFIGURATION_DESCRIPTOR, it, ::serializeLoggingConfigurationInputDocument) }
        input.maxWebservers?.let { field(MAXWEBSERVERS_DESCRIPTOR, it) }
        input.maxWorkers?.let { field(MAXWORKERS_DESCRIPTOR, it) }
        input.minWebservers?.let { field(MINWEBSERVERS_DESCRIPTOR, it) }
        input.minWorkers?.let { field(MINWORKERS_DESCRIPTOR, it) }
        input.networkConfiguration?.let { field(NETWORKCONFIGURATION_DESCRIPTOR, it, ::serializeNetworkConfigurationDocument) }
        input.pluginsS3ObjectVersion?.let { field(PLUGINSS3OBJECTVERSION_DESCRIPTOR, it) }
        input.pluginsS3Path?.let { field(PLUGINSS3PATH_DESCRIPTOR, it) }
        input.requirementsS3ObjectVersion?.let { field(REQUIREMENTSS3OBJECTVERSION_DESCRIPTOR, it) }
        input.requirementsS3Path?.let { field(REQUIREMENTSS3PATH_DESCRIPTOR, it) }
        input.schedulers?.let { field(SCHEDULERS_DESCRIPTOR, it) }
        field(SOURCEBUCKETARN_DESCRIPTOR, input.sourceBucketArn)
        input.startupScriptS3ObjectVersion?.let { field(STARTUPSCRIPTS3OBJECTVERSION_DESCRIPTOR, it) }
        input.startupScriptS3Path?.let { field(STARTUPSCRIPTS3PATH_DESCRIPTOR, it) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        input.webserverAccessMode?.let { field(WEBSERVERACCESSMODE_DESCRIPTOR, it.value) }
        input.weeklyMaintenanceWindowStart?.let { field(WEEKLYMAINTENANCEWINDOWSTART_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
