// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mwaa.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateEnvironmentRequest private constructor(builder: Builder) {
    /**
     * A list of key-value pairs containing the Apache Airflow configuration options you want to attach to your environment. For more information, see [Apache Airflow configuration options](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html).
     */
    public val airflowConfigurationOptions: Map<String, String>? = builder.airflowConfigurationOptions
    /**
     * The Apache Airflow version for your environment. To upgrade your environment, specify a newer version of Apache Airflow supported by Amazon MWAA.
     *
     * Before you upgrade an environment, make sure your requirements, DAGs, plugins, and other resources used in your workflows are compatible with the new Apache Airflow version. For more information about updating your resources, see [Upgrading an Amazon MWAA environment](https://docs.aws.amazon.com/mwaa/latest/userguide/upgrading-environment.html).
     *
     * Valid values: `1.10.12`, `2.0.2`, `2.2.2`, `2.4.3`, `2.5.1`, `2.6.3`, `2.7.2`, `2.8.1`, `2.9.2`, `2.10.1`, and `2.10.3`.
     */
    public val airflowVersion: kotlin.String? = builder.airflowVersion
    /**
     * The relative path to the DAGs folder on your Amazon S3 bucket. For example, `dags`. For more information, see [Adding or updating DAGs](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html).
     */
    public val dagS3Path: kotlin.String? = builder.dagS3Path
    /**
     * The environment class type. Valid values: `mw1.micro`, `mw1.small`, `mw1.medium`, `mw1.large`, `mw1.xlarge`, and `mw1.2xlarge`. For more information, see [Amazon MWAA environment class](https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html).
     */
    public val environmentClass: kotlin.String? = builder.environmentClass
    /**
     * The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access Amazon Web Services resources in your environment. For example, `arn:aws:iam::123456789:role/my-execution-role`. For more information, see [Amazon MWAA Execution role](https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html).
     */
    public val executionRoleArn: kotlin.String? = builder.executionRoleArn
    /**
     * The Apache Airflow log types to send to CloudWatch Logs.
     */
    public val loggingConfiguration: aws.sdk.kotlin.services.mwaa.model.LoggingConfigurationInput? = builder.loggingConfiguration
    /**
     * The maximum number of web servers that you want to run in your environment. Amazon MWAA scales the number of Apache Airflow web servers up to the number you specify for `MaxWebservers` when you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. For example, in scenarios where your workload requires network calls to the Apache Airflow REST API with a high transaction-per-second (TPS) rate, Amazon MWAA will increase the number of web servers up to the number set in `MaxWebserers`. As TPS rates decrease Amazon MWAA disposes of the additional web servers, and scales down to the number set in `MinxWebserers`.
     *
     * Valid values: For environments larger than mw1.micro, accepts values from `2` to `5`. Defaults to `2` for all environment sizes except mw1.micro, which defaults to `1`.
     */
    public val maxWebservers: kotlin.Int? = builder.maxWebservers
    /**
     * The maximum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the `MaxWorkers` field. For example, `20`. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the one worker that is included with your environment, or the number you specify in `MinWorkers`.
     */
    public val maxWorkers: kotlin.Int? = builder.maxWorkers
    /**
     * The minimum number of web servers that you want to run in your environment. Amazon MWAA scales the number of Apache Airflow web servers up to the number you specify for `MaxWebservers` when you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. As the transaction-per-second rate, and the network load, decrease, Amazon MWAA disposes of the additional web servers, and scales down to the number set in `MinxWebserers`.
     *
     * Valid values: For environments larger than mw1.micro, accepts values from `2` to `5`. Defaults to `2` for all environment sizes except mw1.micro, which defaults to `1`.
     */
    public val minWebservers: kotlin.Int? = builder.minWebservers
    /**
     * The minimum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the `MaxWorkers` field. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the worker count you specify in the `MinWorkers` field. For example, `2`.
     */
    public val minWorkers: kotlin.Int? = builder.minWorkers
    /**
     * The name of your Amazon MWAA environment. For example, `MyMWAAEnvironment`.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The VPC networking components used to secure and enable network traffic between the Amazon Web Services resources for your environment. For more information, see [About networking on Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html).
     */
    public val networkConfiguration: aws.sdk.kotlin.services.mwaa.model.UpdateNetworkConfigurationInput? = builder.networkConfiguration
    /**
     * The version of the plugins.zip file on your Amazon S3 bucket. You must specify a version each time a `plugins.zip` file is updated. For more information, see [How S3 Versioning works](https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html).
     */
    public val pluginsS3ObjectVersion: kotlin.String? = builder.pluginsS3ObjectVersion
    /**
     * The relative path to the `plugins.zip` file on your Amazon S3 bucket. For example, `plugins.zip`. If specified, then the plugins.zip version is required. For more information, see [Installing custom plugins](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html).
     */
    public val pluginsS3Path: kotlin.String? = builder.pluginsS3Path
    /**
     * The version of the requirements.txt file on your Amazon S3 bucket. You must specify a version each time a `requirements.txt` file is updated. For more information, see [How S3 Versioning works](https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html).
     */
    public val requirementsS3ObjectVersion: kotlin.String? = builder.requirementsS3ObjectVersion
    /**
     * The relative path to the `requirements.txt` file on your Amazon S3 bucket. For example, `requirements.txt`. If specified, then a file version is required. For more information, see [Installing Python dependencies](https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html).
     */
    public val requirementsS3Path: kotlin.String? = builder.requirementsS3Path
    /**
     * The number of Apache Airflow schedulers to run in your Amazon MWAA environment.
     */
    public val schedulers: kotlin.Int? = builder.schedulers
    /**
     * The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For example, `arn:aws:s3:::my-airflow-bucket-unique-name`. For more information, see [Create an Amazon S3 bucket for Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html).
     */
    public val sourceBucketArn: kotlin.String? = builder.sourceBucketArn
    /**
     * The version of the startup shell script in your Amazon S3 bucket. You must specify the [version ID](https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html) that Amazon S3 assigns to the file every time you update the script.
     *
     *  Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes long. The following is an example:
     *
     * `3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo`
     *
     *  For more information, see [Using a startup script](https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html).
     */
    public val startupScriptS3ObjectVersion: kotlin.String? = builder.startupScriptS3ObjectVersion
    /**
     * The relative path to the startup shell script in your Amazon S3 bucket. For example, `s3://mwaa-environment/startup.sh`.
     *
     *  Amazon MWAA runs the script as your environment starts, and before running the Apache Airflow process. You can use this script to install dependencies, modify Apache Airflow configuration options, and set environment variables. For more information, see [Using a startup script](https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html).
     */
    public val startupScriptS3Path: kotlin.String? = builder.startupScriptS3Path
    /**
     * The Apache Airflow *Web server* access mode. For more information, see [Apache Airflow access modes](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html).
     */
    public val webserverAccessMode: aws.sdk.kotlin.services.mwaa.model.WebserverAccessMode? = builder.webserverAccessMode
    /**
     * The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time to start weekly maintenance updates of your environment in the following format: `DAY:HH:MM`. For example: `TUE:03:30`. You can specify a start time in 30 minute increments only.
     */
    public val weeklyMaintenanceWindowStart: kotlin.String? = builder.weeklyMaintenanceWindowStart
    /**
     * The worker replacement strategy to use when updating the environment.
     *
     * You can select one of the following strategies:
     * + **Forced -** Stops and replaces Apache Airflow workers without waiting for tasks to complete before an update.
     * + **Graceful -** Allows Apache Airflow workers to complete running tasks for up to 12 hours during an update before they're stopped and replaced.
     */
    public val workerReplacementStrategy: aws.sdk.kotlin.services.mwaa.model.WorkerReplacementStrategy? = builder.workerReplacementStrategy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mwaa.model.UpdateEnvironmentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateEnvironmentRequest(")
        append("airflowConfigurationOptions=*** Sensitive Data Redacted ***,")
        append("airflowVersion=$airflowVersion,")
        append("dagS3Path=$dagS3Path,")
        append("environmentClass=$environmentClass,")
        append("executionRoleArn=$executionRoleArn,")
        append("loggingConfiguration=$loggingConfiguration,")
        append("maxWebservers=$maxWebservers,")
        append("maxWorkers=$maxWorkers,")
        append("minWebservers=$minWebservers,")
        append("minWorkers=$minWorkers,")
        append("name=$name,")
        append("networkConfiguration=$networkConfiguration,")
        append("pluginsS3ObjectVersion=$pluginsS3ObjectVersion,")
        append("pluginsS3Path=$pluginsS3Path,")
        append("requirementsS3ObjectVersion=$requirementsS3ObjectVersion,")
        append("requirementsS3Path=$requirementsS3Path,")
        append("schedulers=$schedulers,")
        append("sourceBucketArn=$sourceBucketArn,")
        append("startupScriptS3ObjectVersion=$startupScriptS3ObjectVersion,")
        append("startupScriptS3Path=$startupScriptS3Path,")
        append("webserverAccessMode=$webserverAccessMode,")
        append("weeklyMaintenanceWindowStart=$weeklyMaintenanceWindowStart,")
        append("workerReplacementStrategy=$workerReplacementStrategy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = airflowConfigurationOptions?.hashCode() ?: 0
        result = 31 * result + (airflowVersion?.hashCode() ?: 0)
        result = 31 * result + (dagS3Path?.hashCode() ?: 0)
        result = 31 * result + (environmentClass?.hashCode() ?: 0)
        result = 31 * result + (executionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (loggingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (maxWebservers ?: 0)
        result = 31 * result + (maxWorkers ?: 0)
        result = 31 * result + (minWebservers ?: 0)
        result = 31 * result + (minWorkers ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (networkConfiguration?.hashCode() ?: 0)
        result = 31 * result + (pluginsS3ObjectVersion?.hashCode() ?: 0)
        result = 31 * result + (pluginsS3Path?.hashCode() ?: 0)
        result = 31 * result + (requirementsS3ObjectVersion?.hashCode() ?: 0)
        result = 31 * result + (requirementsS3Path?.hashCode() ?: 0)
        result = 31 * result + (schedulers ?: 0)
        result = 31 * result + (sourceBucketArn?.hashCode() ?: 0)
        result = 31 * result + (startupScriptS3ObjectVersion?.hashCode() ?: 0)
        result = 31 * result + (startupScriptS3Path?.hashCode() ?: 0)
        result = 31 * result + (webserverAccessMode?.hashCode() ?: 0)
        result = 31 * result + (weeklyMaintenanceWindowStart?.hashCode() ?: 0)
        result = 31 * result + (workerReplacementStrategy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateEnvironmentRequest

        if (airflowConfigurationOptions != other.airflowConfigurationOptions) return false
        if (airflowVersion != other.airflowVersion) return false
        if (dagS3Path != other.dagS3Path) return false
        if (environmentClass != other.environmentClass) return false
        if (executionRoleArn != other.executionRoleArn) return false
        if (loggingConfiguration != other.loggingConfiguration) return false
        if (maxWebservers != other.maxWebservers) return false
        if (maxWorkers != other.maxWorkers) return false
        if (minWebservers != other.minWebservers) return false
        if (minWorkers != other.minWorkers) return false
        if (name != other.name) return false
        if (networkConfiguration != other.networkConfiguration) return false
        if (pluginsS3ObjectVersion != other.pluginsS3ObjectVersion) return false
        if (pluginsS3Path != other.pluginsS3Path) return false
        if (requirementsS3ObjectVersion != other.requirementsS3ObjectVersion) return false
        if (requirementsS3Path != other.requirementsS3Path) return false
        if (schedulers != other.schedulers) return false
        if (sourceBucketArn != other.sourceBucketArn) return false
        if (startupScriptS3ObjectVersion != other.startupScriptS3ObjectVersion) return false
        if (startupScriptS3Path != other.startupScriptS3Path) return false
        if (webserverAccessMode != other.webserverAccessMode) return false
        if (weeklyMaintenanceWindowStart != other.weeklyMaintenanceWindowStart) return false
        if (workerReplacementStrategy != other.workerReplacementStrategy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mwaa.model.UpdateEnvironmentRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of key-value pairs containing the Apache Airflow configuration options you want to attach to your environment. For more information, see [Apache Airflow configuration options](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html).
         */
        public var airflowConfigurationOptions: Map<String, String>? = null
        /**
         * The Apache Airflow version for your environment. To upgrade your environment, specify a newer version of Apache Airflow supported by Amazon MWAA.
         *
         * Before you upgrade an environment, make sure your requirements, DAGs, plugins, and other resources used in your workflows are compatible with the new Apache Airflow version. For more information about updating your resources, see [Upgrading an Amazon MWAA environment](https://docs.aws.amazon.com/mwaa/latest/userguide/upgrading-environment.html).
         *
         * Valid values: `1.10.12`, `2.0.2`, `2.2.2`, `2.4.3`, `2.5.1`, `2.6.3`, `2.7.2`, `2.8.1`, `2.9.2`, `2.10.1`, and `2.10.3`.
         */
        public var airflowVersion: kotlin.String? = null
        /**
         * The relative path to the DAGs folder on your Amazon S3 bucket. For example, `dags`. For more information, see [Adding or updating DAGs](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html).
         */
        public var dagS3Path: kotlin.String? = null
        /**
         * The environment class type. Valid values: `mw1.micro`, `mw1.small`, `mw1.medium`, `mw1.large`, `mw1.xlarge`, and `mw1.2xlarge`. For more information, see [Amazon MWAA environment class](https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html).
         */
        public var environmentClass: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access Amazon Web Services resources in your environment. For example, `arn:aws:iam::123456789:role/my-execution-role`. For more information, see [Amazon MWAA Execution role](https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html).
         */
        public var executionRoleArn: kotlin.String? = null
        /**
         * The Apache Airflow log types to send to CloudWatch Logs.
         */
        public var loggingConfiguration: aws.sdk.kotlin.services.mwaa.model.LoggingConfigurationInput? = null
        /**
         * The maximum number of web servers that you want to run in your environment. Amazon MWAA scales the number of Apache Airflow web servers up to the number you specify for `MaxWebservers` when you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. For example, in scenarios where your workload requires network calls to the Apache Airflow REST API with a high transaction-per-second (TPS) rate, Amazon MWAA will increase the number of web servers up to the number set in `MaxWebserers`. As TPS rates decrease Amazon MWAA disposes of the additional web servers, and scales down to the number set in `MinxWebserers`.
         *
         * Valid values: For environments larger than mw1.micro, accepts values from `2` to `5`. Defaults to `2` for all environment sizes except mw1.micro, which defaults to `1`.
         */
        public var maxWebservers: kotlin.Int? = null
        /**
         * The maximum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the `MaxWorkers` field. For example, `20`. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the one worker that is included with your environment, or the number you specify in `MinWorkers`.
         */
        public var maxWorkers: kotlin.Int? = null
        /**
         * The minimum number of web servers that you want to run in your environment. Amazon MWAA scales the number of Apache Airflow web servers up to the number you specify for `MaxWebservers` when you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. As the transaction-per-second rate, and the network load, decrease, Amazon MWAA disposes of the additional web servers, and scales down to the number set in `MinxWebserers`.
         *
         * Valid values: For environments larger than mw1.micro, accepts values from `2` to `5`. Defaults to `2` for all environment sizes except mw1.micro, which defaults to `1`.
         */
        public var minWebservers: kotlin.Int? = null
        /**
         * The minimum number of workers that you want to run in your environment. MWAA scales the number of Apache Airflow workers up to the number you specify in the `MaxWorkers` field. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the worker count you specify in the `MinWorkers` field. For example, `2`.
         */
        public var minWorkers: kotlin.Int? = null
        /**
         * The name of your Amazon MWAA environment. For example, `MyMWAAEnvironment`.
         */
        public var name: kotlin.String? = null
        /**
         * The VPC networking components used to secure and enable network traffic between the Amazon Web Services resources for your environment. For more information, see [About networking on Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html).
         */
        public var networkConfiguration: aws.sdk.kotlin.services.mwaa.model.UpdateNetworkConfigurationInput? = null
        /**
         * The version of the plugins.zip file on your Amazon S3 bucket. You must specify a version each time a `plugins.zip` file is updated. For more information, see [How S3 Versioning works](https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html).
         */
        public var pluginsS3ObjectVersion: kotlin.String? = null
        /**
         * The relative path to the `plugins.zip` file on your Amazon S3 bucket. For example, `plugins.zip`. If specified, then the plugins.zip version is required. For more information, see [Installing custom plugins](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html).
         */
        public var pluginsS3Path: kotlin.String? = null
        /**
         * The version of the requirements.txt file on your Amazon S3 bucket. You must specify a version each time a `requirements.txt` file is updated. For more information, see [How S3 Versioning works](https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html).
         */
        public var requirementsS3ObjectVersion: kotlin.String? = null
        /**
         * The relative path to the `requirements.txt` file on your Amazon S3 bucket. For example, `requirements.txt`. If specified, then a file version is required. For more information, see [Installing Python dependencies](https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html).
         */
        public var requirementsS3Path: kotlin.String? = null
        /**
         * The number of Apache Airflow schedulers to run in your Amazon MWAA environment.
         */
        public var schedulers: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For example, `arn:aws:s3:::my-airflow-bucket-unique-name`. For more information, see [Create an Amazon S3 bucket for Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html).
         */
        public var sourceBucketArn: kotlin.String? = null
        /**
         * The version of the startup shell script in your Amazon S3 bucket. You must specify the [version ID](https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html) that Amazon S3 assigns to the file every time you update the script.
         *
         *  Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes long. The following is an example:
         *
         * `3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo`
         *
         *  For more information, see [Using a startup script](https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html).
         */
        public var startupScriptS3ObjectVersion: kotlin.String? = null
        /**
         * The relative path to the startup shell script in your Amazon S3 bucket. For example, `s3://mwaa-environment/startup.sh`.
         *
         *  Amazon MWAA runs the script as your environment starts, and before running the Apache Airflow process. You can use this script to install dependencies, modify Apache Airflow configuration options, and set environment variables. For more information, see [Using a startup script](https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html).
         */
        public var startupScriptS3Path: kotlin.String? = null
        /**
         * The Apache Airflow *Web server* access mode. For more information, see [Apache Airflow access modes](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html).
         */
        public var webserverAccessMode: aws.sdk.kotlin.services.mwaa.model.WebserverAccessMode? = null
        /**
         * The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time to start weekly maintenance updates of your environment in the following format: `DAY:HH:MM`. For example: `TUE:03:30`. You can specify a start time in 30 minute increments only.
         */
        public var weeklyMaintenanceWindowStart: kotlin.String? = null
        /**
         * The worker replacement strategy to use when updating the environment.
         *
         * You can select one of the following strategies:
         * + **Forced -** Stops and replaces Apache Airflow workers without waiting for tasks to complete before an update.
         * + **Graceful -** Allows Apache Airflow workers to complete running tasks for up to 12 hours during an update before they're stopped and replaced.
         */
        public var workerReplacementStrategy: aws.sdk.kotlin.services.mwaa.model.WorkerReplacementStrategy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mwaa.model.UpdateEnvironmentRequest) : this() {
            this.airflowConfigurationOptions = x.airflowConfigurationOptions
            this.airflowVersion = x.airflowVersion
            this.dagS3Path = x.dagS3Path
            this.environmentClass = x.environmentClass
            this.executionRoleArn = x.executionRoleArn
            this.loggingConfiguration = x.loggingConfiguration
            this.maxWebservers = x.maxWebservers
            this.maxWorkers = x.maxWorkers
            this.minWebservers = x.minWebservers
            this.minWorkers = x.minWorkers
            this.name = x.name
            this.networkConfiguration = x.networkConfiguration
            this.pluginsS3ObjectVersion = x.pluginsS3ObjectVersion
            this.pluginsS3Path = x.pluginsS3Path
            this.requirementsS3ObjectVersion = x.requirementsS3ObjectVersion
            this.requirementsS3Path = x.requirementsS3Path
            this.schedulers = x.schedulers
            this.sourceBucketArn = x.sourceBucketArn
            this.startupScriptS3ObjectVersion = x.startupScriptS3ObjectVersion
            this.startupScriptS3Path = x.startupScriptS3Path
            this.webserverAccessMode = x.webserverAccessMode
            this.weeklyMaintenanceWindowStart = x.weeklyMaintenanceWindowStart
            this.workerReplacementStrategy = x.workerReplacementStrategy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mwaa.model.UpdateEnvironmentRequest = UpdateEnvironmentRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.mwaa.model.LoggingConfigurationInput] inside the given [block]
         */
        public fun loggingConfiguration(block: aws.sdk.kotlin.services.mwaa.model.LoggingConfigurationInput.Builder.() -> kotlin.Unit) {
            this.loggingConfiguration = aws.sdk.kotlin.services.mwaa.model.LoggingConfigurationInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mwaa.model.UpdateNetworkConfigurationInput] inside the given [block]
         */
        public fun networkConfiguration(block: aws.sdk.kotlin.services.mwaa.model.UpdateNetworkConfigurationInput.Builder.() -> kotlin.Unit) {
            this.networkConfiguration = aws.sdk.kotlin.services.mwaa.model.UpdateNetworkConfigurationInput.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            return this
        }
    }
}
