// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mwaa.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the VPC networking components used to secure and enable network traffic between the Amazon Web Services resources for your environment. For more information, see [About networking on Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html).
 */
public class NetworkConfiguration private constructor(builder: Builder) {
    /**
     * A list of security group IDs. For more information, see [Security in your VPC on Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/vpc-security.html).
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * A list of subnet IDs. For more information, see [About networking on Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html).
     */
    public val subnetIds: List<String>? = builder.subnetIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mwaa.model.NetworkConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NetworkConfiguration(")
        append("securityGroupIds=$securityGroupIds,")
        append("subnetIds=$subnetIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = securityGroupIds?.hashCode() ?: 0
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NetworkConfiguration

        if (securityGroupIds != other.securityGroupIds) return false
        if (subnetIds != other.subnetIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mwaa.model.NetworkConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of security group IDs. For more information, see [Security in your VPC on Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/vpc-security.html).
         */
        public var securityGroupIds: List<String>? = null
        /**
         * A list of subnet IDs. For more information, see [About networking on Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html).
         */
        public var subnetIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mwaa.model.NetworkConfiguration) : this() {
            this.securityGroupIds = x.securityGroupIds
            this.subnetIds = x.subnetIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mwaa.model.NetworkConfiguration = NetworkConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
