// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mwaa.serde

import aws.sdk.kotlin.services.mwaa.model.InvokeRestApiRequest
import aws.sdk.kotlin.services.mwaa.model.RestApiMethod
import aws.smithy.kotlin.runtime.content.Document
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class InvokeRestApiOperationSerializer: HttpSerializer.NonStreaming<InvokeRestApiRequest> {
    override fun serialize(context: ExecutionContext, input: InvokeRestApiRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.name) { "name is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("restapi"))
                add(PercentEncoding.SmithyLabel.encode(input.name))
            }
        }

        val payload = serializeInvokeRestApiOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeInvokeRestApiOperationBody(context: ExecutionContext, input: InvokeRestApiRequest): ByteArray {
    val serializer = JsonSerializer()
    val BODY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Document, JsonSerialName("Body"))
    val METHOD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Method"))
    val PATH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Path"))
    val QUERYPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Document, JsonSerialName("QueryParameters"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BODY_DESCRIPTOR)
        field(METHOD_DESCRIPTOR)
        field(PATH_DESCRIPTOR)
        field(QUERYPARAMETERS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.body?.let { field(BODY_DESCRIPTOR, it) }
        input.method?.let { field(METHOD_DESCRIPTOR, it.value) }
        input.path?.let { field(PATH_DESCRIPTOR, it) }
        input.queryParameters?.let { field(QUERYPARAMETERS_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
