// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mwaa.paginators

import aws.sdk.kotlin.services.mwaa.MwaaClient
import aws.sdk.kotlin.services.mwaa.model.ListEnvironmentsRequest
import aws.sdk.kotlin.services.mwaa.model.ListEnvironmentsResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListEnvironmentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEnvironmentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEnvironmentsResponse]
 */
public fun MwaaClient.listEnvironmentsPaginated(initialRequest: ListEnvironmentsRequest = ListEnvironmentsRequest { }): Flow<ListEnvironmentsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEnvironmentsPaginated.listEnvironments(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEnvironmentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEnvironmentsResponse]
 */
public fun MwaaClient.listEnvironmentsPaginated(block: ListEnvironmentsRequest.Builder.() -> Unit): Flow<ListEnvironmentsResponse> =
    listEnvironmentsPaginated(ListEnvironmentsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listEnvironmentsPaginated]
 * to access the nested member [EnvironmentName]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EnvironmentName]
 */
@JvmName("listEnvironmentsResponseEnvironmentName")
public fun Flow<ListEnvironmentsResponse>.environments(): Flow<String> =
    transform() { response ->
        response.environments?.forEach {
            emit(it)
        }
    }
