// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mwaa.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.ServiceErrorMetadata
import aws.smithy.kotlin.runtime.content.Document

/**
 * An exception indicating that a server-side error occurred during the Apache Airflow REST API call.
 */
public class RestApiServerException private constructor(builder: Builder) : MwaaException() {

    /**
     * The error response data from the Apache Airflow REST API call, provided as a JSON object.
     */
    public val restApiResponse: aws.smithy.kotlin.runtime.content.Document? = builder.restApiResponse
    /**
     * The HTTP status code returned by the Apache Airflow REST API call.
     */
    public val restApiStatusCode: kotlin.Int? = builder.restApiStatusCode

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mwaa.model.RestApiServerException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestApiServerException(")
        append("restApiResponse=*** Sensitive Data Redacted ***,")
        append("restApiStatusCode=$restApiStatusCode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = restApiResponse?.hashCode() ?: 0
        result = 31 * result + (restApiStatusCode ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestApiServerException

        if (restApiResponse != other.restApiResponse) return false
        if (restApiStatusCode != other.restApiStatusCode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mwaa.model.RestApiServerException = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The error response data from the Apache Airflow REST API call, provided as a JSON object.
         */
        public var restApiResponse: aws.smithy.kotlin.runtime.content.Document? = null
        /**
         * The HTTP status code returned by the Apache Airflow REST API call.
         */
        public var restApiStatusCode: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mwaa.model.RestApiServerException) : this() {
            this.restApiResponse = x.restApiResponse
            this.restApiStatusCode = x.restApiStatusCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mwaa.model.RestApiServerException = RestApiServerException(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
