// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mwaa.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the Apache Airflow log details for the log type (e.g. `DagProcessingLogs`).
 */
public class ModuleLoggingConfiguration private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the CloudWatch Logs group where the Apache Airflow log type (e.g. `DagProcessingLogs`) is published. For example, `arn:aws:logs:us-east-1:123456789012:log-group:airflow-MyMWAAEnvironment-MwaaEnvironment-DAGProcessing:*`.
     */
    public val cloudWatchLogGroupArn: kotlin.String? = builder.cloudWatchLogGroupArn
    /**
     * Indicates whether the Apache Airflow log type (e.g. `DagProcessingLogs`) is enabled.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * The Apache Airflow log level for the log type (e.g. `DagProcessingLogs`).
     */
    public val logLevel: aws.sdk.kotlin.services.mwaa.model.LoggingLevel? = builder.logLevel

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mwaa.model.ModuleLoggingConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModuleLoggingConfiguration(")
        append("cloudWatchLogGroupArn=$cloudWatchLogGroupArn,")
        append("enabled=$enabled,")
        append("logLevel=$logLevel")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchLogGroupArn?.hashCode() ?: 0
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (logLevel?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModuleLoggingConfiguration

        if (cloudWatchLogGroupArn != other.cloudWatchLogGroupArn) return false
        if (enabled != other.enabled) return false
        if (logLevel != other.logLevel) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mwaa.model.ModuleLoggingConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for the CloudWatch Logs group where the Apache Airflow log type (e.g. `DagProcessingLogs`) is published. For example, `arn:aws:logs:us-east-1:123456789012:log-group:airflow-MyMWAAEnvironment-MwaaEnvironment-DAGProcessing:*`.
         */
        public var cloudWatchLogGroupArn: kotlin.String? = null
        /**
         * Indicates whether the Apache Airflow log type (e.g. `DagProcessingLogs`) is enabled.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * The Apache Airflow log level for the log type (e.g. `DagProcessingLogs`).
         */
        public var logLevel: aws.sdk.kotlin.services.mwaa.model.LoggingLevel? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mwaa.model.ModuleLoggingConfiguration) : this() {
            this.cloudWatchLogGroupArn = x.cloudWatchLogGroupArn
            this.enabled = x.enabled
            this.logLevel = x.logLevel
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mwaa.model.ModuleLoggingConfiguration = ModuleLoggingConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
