// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mwaa.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an Amazon Managed Workflows for Apache Airflow (MWAA) environment.
 */
public class Environment private constructor(builder: Builder) {
    /**
     * A list of key-value pairs containing the Apache Airflow configuration options attached to your environment. For more information, see [Apache Airflow configuration options](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html).
     */
    public val airflowConfigurationOptions: Map<String, String>? = builder.airflowConfigurationOptions
    /**
     * The Apache Airflow version on your environment.
     *
     * Valid values: `1.10.12`, `2.0.2`, `2.2.2`, `2.4.3`, `2.5.1`, `2.6.3`, `2.7.2`, `2.8.1`, `2.9.2`, `2.10.1`, and `2.10.3`.
     */
    public val airflowVersion: kotlin.String? = builder.airflowVersion
    /**
     * The Amazon Resource Name (ARN) of the Amazon MWAA environment.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The queue ARN for the environment's [Celery Executor](https://airflow.apache.org/docs/apache-airflow/stable/core-concepts/executor/celery.html). Amazon MWAA uses a Celery Executor to distribute tasks across multiple workers. When you create an environment in a shared VPC, you must provide access to the Celery Executor queue from your VPC.
     */
    public val celeryExecutorQueue: kotlin.String? = builder.celeryExecutorQueue
    /**
     * The day and time the environment was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The relative path to the DAGs folder in your Amazon S3 bucket. For example, `s3://mwaa-environment/dags`. For more information, see [Adding or updating DAGs](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html).
     */
    public val dagS3Path: kotlin.String? = builder.dagS3Path
    /**
     * The VPC endpoint for the environment's Amazon RDS database.
     */
    public val databaseVpcEndpointService: kotlin.String? = builder.databaseVpcEndpointService
    /**
     * Defines whether the VPC endpoints configured for the environment are created, and managed, by the customer or by Amazon MWAA. If set to `SERVICE`, Amazon MWAA will create and manage the required VPC endpoints in your VPC. If set to `CUSTOMER`, you must create, and manage, the VPC endpoints in your VPC.
     */
    public val endpointManagement: aws.sdk.kotlin.services.mwaa.model.EndpointManagement? = builder.endpointManagement
    /**
     * The environment class type. Valid values: `mw1.micro`, `mw1.small`, `mw1.medium`, `mw1.large`, `mw1.xlarge`, and `mw1.2xlarge`. For more information, see [Amazon MWAA environment class](https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html).
     */
    public val environmentClass: kotlin.String? = builder.environmentClass
    /**
     * The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access Amazon Web Services resources in your environment. For example, `arn:aws:iam::123456789:role/my-execution-role`. For more information, see [Amazon MWAA Execution role](https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html).
     */
    public val executionRoleArn: kotlin.String? = builder.executionRoleArn
    /**
     * The KMS encryption key used to encrypt the data in your environment.
     */
    public val kmsKey: kotlin.String? = builder.kmsKey
    /**
     * The status of the last update on the environment.
     */
    public val lastUpdate: aws.sdk.kotlin.services.mwaa.model.LastUpdate? = builder.lastUpdate
    /**
     * The Apache Airflow logs published to CloudWatch Logs.
     */
    public val loggingConfiguration: aws.sdk.kotlin.services.mwaa.model.LoggingConfiguration? = builder.loggingConfiguration
    /**
     * The maximum number of web servers that you want to run in your environment. Amazon MWAA scales the number of Apache Airflow web servers up to the number you specify for `MaxWebservers` when you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. For example, in scenarios where your workload requires network calls to the Apache Airflow REST API with a high transaction-per-second (TPS) rate, Amazon MWAA will increase the number of web servers up to the number set in `MaxWebserers`. As TPS rates decrease Amazon MWAA disposes of the additional web servers, and scales down to the number set in `MinxWebserers`.
     *
     * Valid values: For environments larger than mw1.micro, accepts values from `2` to `5`. Defaults to `2` for all environment sizes except mw1.micro, which defaults to `1`.
     */
    public val maxWebservers: kotlin.Int? = builder.maxWebservers
    /**
     * The maximum number of workers that run in your environment. For example, `20`.
     */
    public val maxWorkers: kotlin.Int? = builder.maxWorkers
    /**
     * The minimum number of web servers that you want to run in your environment. Amazon MWAA scales the number of Apache Airflow web servers up to the number you specify for `MaxWebservers` when you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. As the transaction-per-second rate, and the network load, decrease, Amazon MWAA disposes of the additional web servers, and scales down to the number set in `MinxWebserers`.
     *
     * Valid values: For environments larger than mw1.micro, accepts values from `2` to `5`. Defaults to `2` for all environment sizes except mw1.micro, which defaults to `1`.
     */
    public val minWebservers: kotlin.Int? = builder.minWebservers
    /**
     * The minimum number of workers that run in your environment. For example, `2`.
     */
    public val minWorkers: kotlin.Int? = builder.minWorkers
    /**
     * The name of the Amazon MWAA environment. For example, `MyMWAAEnvironment`.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Describes the VPC networking components used to secure and enable network traffic between the Amazon Web Services resources for your environment. For more information, see [About networking on Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html).
     */
    public val networkConfiguration: aws.sdk.kotlin.services.mwaa.model.NetworkConfiguration? = builder.networkConfiguration
    /**
     * The version of the `plugins.zip` file in your Amazon S3 bucket. You must specify the [version ID](https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html) that Amazon S3 assigns to the file.
     *
     *  Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes long. The following is an example:
     *
     * `3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo`
     *
     * For more information, see [Installing custom plugins](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html).
     */
    public val pluginsS3ObjectVersion: kotlin.String? = builder.pluginsS3ObjectVersion
    /**
     * The relative path to the file in your Amazon S3 bucket. For example, `s3://mwaa-environment/plugins.zip`. For more information, see [Installing custom plugins](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html).
     */
    public val pluginsS3Path: kotlin.String? = builder.pluginsS3Path
    /**
     * The version of the `requirements.txt ` file on your Amazon S3 bucket. You must specify the [version ID](https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html) that Amazon S3 assigns to the file.
     *
     *  Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes long. The following is an example:
     *
     * `3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo`
     *
     *  For more information, see [Installing Python dependencies](https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html).
     */
    public val requirementsS3ObjectVersion: kotlin.String? = builder.requirementsS3ObjectVersion
    /**
     * The relative path to the `requirements.txt` file in your Amazon S3 bucket. For example, `s3://mwaa-environment/requirements.txt`. For more information, see [Installing Python dependencies](https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html).
     */
    public val requirementsS3Path: kotlin.String? = builder.requirementsS3Path
    /**
     * The number of Apache Airflow schedulers that run in your Amazon MWAA environment.
     */
    public val schedulers: kotlin.Int? = builder.schedulers
    /**
     * The Amazon Resource Name (ARN) for the service-linked role of the environment. For more information, see [Amazon MWAA Service-linked role](https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-slr.html).
     */
    public val serviceRoleArn: kotlin.String? = builder.serviceRoleArn
    /**
     * The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For example, `arn:aws:s3:::my-airflow-bucket-unique-name`. For more information, see [Create an Amazon S3 bucket for Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html).
     */
    public val sourceBucketArn: kotlin.String? = builder.sourceBucketArn
    /**
     * The version of the startup shell script in your Amazon S3 bucket. You must specify the [version ID](https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html) that Amazon S3 assigns to the file.
     *
     *  Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes long. The following is an example:
     *
     * `3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo`
     *
     *  For more information, see [Using a startup script](https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html).
     */
    public val startupScriptS3ObjectVersion: kotlin.String? = builder.startupScriptS3ObjectVersion
    /**
     * The relative path to the startup shell script in your Amazon S3 bucket. For example, `s3://mwaa-environment/startup.sh`.
     *
     *  Amazon MWAA runs the script as your environment starts, and before running the Apache Airflow process. You can use this script to install dependencies, modify Apache Airflow configuration options, and set environment variables. For more information, see [Using a startup script](https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html).
     */
    public val startupScriptS3Path: kotlin.String? = builder.startupScriptS3Path
    /**
     * The status of the Amazon MWAA environment.
     *
     * Valid values:
     * + `CREATING` - Indicates the request to create the environment is in progress.
     * + `CREATING_SNAPSHOT` - Indicates the request to update environment details, or upgrade the environment version, is in progress and Amazon MWAA is creating a storage volume snapshot of the Amazon RDS database cluster associated with the environment. A database snapshot is a backup created at a specific point in time. Amazon MWAA uses snapshots to recover environment metadata if the process to update or upgrade an environment fails.
     * + `CREATE_FAILED` - Indicates the request to create the environment failed, and the environment could not be created.
     * + `AVAILABLE` - Indicates the request was successful and the environment is ready to use.
     * + `PENDING` - Indicates the request was successful, but the process to create the environment is paused until you create the required VPC endpoints in your VPC. After you create the VPC endpoints, the process resumes.
     * + `UPDATING` - Indicates the request to update the environment is in progress.
     * + `ROLLING_BACK` - Indicates the request to update environment details, or upgrade the environment version, failed and Amazon MWAA is restoring the environment using the latest storage volume snapshot.
     * + `DELETING` - Indicates the request to delete the environment is in progress.
     * + `DELETED` - Indicates the request to delete the environment is complete, and the environment has been deleted.
     * + `UNAVAILABLE` - Indicates the request failed, but the environment did not return to its previous state and is not stable.
     * + `UPDATE_FAILED` - Indicates the request to update the environment failed, and the environment was restored to its previous state successfully and is ready to use.
     * + `MAINTENANCE` - Indicates that the environment is undergoing maintenance. Depending on the type of work Amazon MWAA is performing, your environment might become unavailable during this process. After all operations are done, your environment will return to its status prior to mainteneace operations.
     *
     * We recommend reviewing our troubleshooting guide for a list of common errors and their solutions. For more information, see [Amazon MWAA troubleshooting](https://docs.aws.amazon.com/mwaa/latest/userguide/troubleshooting.html).
     */
    public val status: aws.sdk.kotlin.services.mwaa.model.EnvironmentStatus? = builder.status
    /**
     * The key-value tag pairs associated to your environment. For example, `"Environment": "Staging"`. For more information, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The Apache Airflow *web server* access mode. For more information, see [Apache Airflow access modes](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html).
     */
    public val webserverAccessMode: aws.sdk.kotlin.services.mwaa.model.WebserverAccessMode? = builder.webserverAccessMode
    /**
     * The Apache Airflow *web server* host name for the Amazon MWAA environment. For more information, see [Accessing the Apache Airflow UI](https://docs.aws.amazon.com/mwaa/latest/userguide/access-airflow-ui.html).
     */
    public val webserverUrl: kotlin.String? = builder.webserverUrl
    /**
     * The VPC endpoint for the environment's web server.
     */
    public val webserverVpcEndpointService: kotlin.String? = builder.webserverVpcEndpointService
    /**
     * The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time that weekly maintenance updates are scheduled. For example: `TUE:03:30`.
     */
    public val weeklyMaintenanceWindowStart: kotlin.String? = builder.weeklyMaintenanceWindowStart

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mwaa.model.Environment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Environment(")
        append("airflowConfigurationOptions=*** Sensitive Data Redacted ***,")
        append("airflowVersion=$airflowVersion,")
        append("arn=$arn,")
        append("celeryExecutorQueue=$celeryExecutorQueue,")
        append("createdAt=$createdAt,")
        append("dagS3Path=$dagS3Path,")
        append("databaseVpcEndpointService=$databaseVpcEndpointService,")
        append("endpointManagement=$endpointManagement,")
        append("environmentClass=$environmentClass,")
        append("executionRoleArn=$executionRoleArn,")
        append("kmsKey=$kmsKey,")
        append("lastUpdate=$lastUpdate,")
        append("loggingConfiguration=$loggingConfiguration,")
        append("maxWebservers=$maxWebservers,")
        append("maxWorkers=$maxWorkers,")
        append("minWebservers=$minWebservers,")
        append("minWorkers=$minWorkers,")
        append("name=$name,")
        append("networkConfiguration=$networkConfiguration,")
        append("pluginsS3ObjectVersion=$pluginsS3ObjectVersion,")
        append("pluginsS3Path=$pluginsS3Path,")
        append("requirementsS3ObjectVersion=$requirementsS3ObjectVersion,")
        append("requirementsS3Path=$requirementsS3Path,")
        append("schedulers=$schedulers,")
        append("serviceRoleArn=$serviceRoleArn,")
        append("sourceBucketArn=$sourceBucketArn,")
        append("startupScriptS3ObjectVersion=$startupScriptS3ObjectVersion,")
        append("startupScriptS3Path=$startupScriptS3Path,")
        append("status=$status,")
        append("tags=$tags,")
        append("webserverAccessMode=$webserverAccessMode,")
        append("webserverUrl=$webserverUrl,")
        append("webserverVpcEndpointService=$webserverVpcEndpointService,")
        append("weeklyMaintenanceWindowStart=$weeklyMaintenanceWindowStart")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = airflowConfigurationOptions?.hashCode() ?: 0
        result = 31 * result + (airflowVersion?.hashCode() ?: 0)
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (celeryExecutorQueue?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (dagS3Path?.hashCode() ?: 0)
        result = 31 * result + (databaseVpcEndpointService?.hashCode() ?: 0)
        result = 31 * result + (endpointManagement?.hashCode() ?: 0)
        result = 31 * result + (environmentClass?.hashCode() ?: 0)
        result = 31 * result + (executionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        result = 31 * result + (lastUpdate?.hashCode() ?: 0)
        result = 31 * result + (loggingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (maxWebservers ?: 0)
        result = 31 * result + (maxWorkers ?: 0)
        result = 31 * result + (minWebservers ?: 0)
        result = 31 * result + (minWorkers ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (networkConfiguration?.hashCode() ?: 0)
        result = 31 * result + (pluginsS3ObjectVersion?.hashCode() ?: 0)
        result = 31 * result + (pluginsS3Path?.hashCode() ?: 0)
        result = 31 * result + (requirementsS3ObjectVersion?.hashCode() ?: 0)
        result = 31 * result + (requirementsS3Path?.hashCode() ?: 0)
        result = 31 * result + (schedulers ?: 0)
        result = 31 * result + (serviceRoleArn?.hashCode() ?: 0)
        result = 31 * result + (sourceBucketArn?.hashCode() ?: 0)
        result = 31 * result + (startupScriptS3ObjectVersion?.hashCode() ?: 0)
        result = 31 * result + (startupScriptS3Path?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (webserverAccessMode?.hashCode() ?: 0)
        result = 31 * result + (webserverUrl?.hashCode() ?: 0)
        result = 31 * result + (webserverVpcEndpointService?.hashCode() ?: 0)
        result = 31 * result + (weeklyMaintenanceWindowStart?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Environment

        if (airflowConfigurationOptions != other.airflowConfigurationOptions) return false
        if (airflowVersion != other.airflowVersion) return false
        if (arn != other.arn) return false
        if (celeryExecutorQueue != other.celeryExecutorQueue) return false
        if (createdAt != other.createdAt) return false
        if (dagS3Path != other.dagS3Path) return false
        if (databaseVpcEndpointService != other.databaseVpcEndpointService) return false
        if (endpointManagement != other.endpointManagement) return false
        if (environmentClass != other.environmentClass) return false
        if (executionRoleArn != other.executionRoleArn) return false
        if (kmsKey != other.kmsKey) return false
        if (lastUpdate != other.lastUpdate) return false
        if (loggingConfiguration != other.loggingConfiguration) return false
        if (maxWebservers != other.maxWebservers) return false
        if (maxWorkers != other.maxWorkers) return false
        if (minWebservers != other.minWebservers) return false
        if (minWorkers != other.minWorkers) return false
        if (name != other.name) return false
        if (networkConfiguration != other.networkConfiguration) return false
        if (pluginsS3ObjectVersion != other.pluginsS3ObjectVersion) return false
        if (pluginsS3Path != other.pluginsS3Path) return false
        if (requirementsS3ObjectVersion != other.requirementsS3ObjectVersion) return false
        if (requirementsS3Path != other.requirementsS3Path) return false
        if (schedulers != other.schedulers) return false
        if (serviceRoleArn != other.serviceRoleArn) return false
        if (sourceBucketArn != other.sourceBucketArn) return false
        if (startupScriptS3ObjectVersion != other.startupScriptS3ObjectVersion) return false
        if (startupScriptS3Path != other.startupScriptS3Path) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (webserverAccessMode != other.webserverAccessMode) return false
        if (webserverUrl != other.webserverUrl) return false
        if (webserverVpcEndpointService != other.webserverVpcEndpointService) return false
        if (weeklyMaintenanceWindowStart != other.weeklyMaintenanceWindowStart) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mwaa.model.Environment = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of key-value pairs containing the Apache Airflow configuration options attached to your environment. For more information, see [Apache Airflow configuration options](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html).
         */
        public var airflowConfigurationOptions: Map<String, String>? = null
        /**
         * The Apache Airflow version on your environment.
         *
         * Valid values: `1.10.12`, `2.0.2`, `2.2.2`, `2.4.3`, `2.5.1`, `2.6.3`, `2.7.2`, `2.8.1`, `2.9.2`, `2.10.1`, and `2.10.3`.
         */
        public var airflowVersion: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon MWAA environment.
         */
        public var arn: kotlin.String? = null
        /**
         * The queue ARN for the environment's [Celery Executor](https://airflow.apache.org/docs/apache-airflow/stable/core-concepts/executor/celery.html). Amazon MWAA uses a Celery Executor to distribute tasks across multiple workers. When you create an environment in a shared VPC, you must provide access to the Celery Executor queue from your VPC.
         */
        public var celeryExecutorQueue: kotlin.String? = null
        /**
         * The day and time the environment was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The relative path to the DAGs folder in your Amazon S3 bucket. For example, `s3://mwaa-environment/dags`. For more information, see [Adding or updating DAGs](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html).
         */
        public var dagS3Path: kotlin.String? = null
        /**
         * The VPC endpoint for the environment's Amazon RDS database.
         */
        public var databaseVpcEndpointService: kotlin.String? = null
        /**
         * Defines whether the VPC endpoints configured for the environment are created, and managed, by the customer or by Amazon MWAA. If set to `SERVICE`, Amazon MWAA will create and manage the required VPC endpoints in your VPC. If set to `CUSTOMER`, you must create, and manage, the VPC endpoints in your VPC.
         */
        public var endpointManagement: aws.sdk.kotlin.services.mwaa.model.EndpointManagement? = null
        /**
         * The environment class type. Valid values: `mw1.micro`, `mw1.small`, `mw1.medium`, `mw1.large`, `mw1.xlarge`, and `mw1.2xlarge`. For more information, see [Amazon MWAA environment class](https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html).
         */
        public var environmentClass: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access Amazon Web Services resources in your environment. For example, `arn:aws:iam::123456789:role/my-execution-role`. For more information, see [Amazon MWAA Execution role](https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html).
         */
        public var executionRoleArn: kotlin.String? = null
        /**
         * The KMS encryption key used to encrypt the data in your environment.
         */
        public var kmsKey: kotlin.String? = null
        /**
         * The status of the last update on the environment.
         */
        public var lastUpdate: aws.sdk.kotlin.services.mwaa.model.LastUpdate? = null
        /**
         * The Apache Airflow logs published to CloudWatch Logs.
         */
        public var loggingConfiguration: aws.sdk.kotlin.services.mwaa.model.LoggingConfiguration? = null
        /**
         * The maximum number of web servers that you want to run in your environment. Amazon MWAA scales the number of Apache Airflow web servers up to the number you specify for `MaxWebservers` when you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. For example, in scenarios where your workload requires network calls to the Apache Airflow REST API with a high transaction-per-second (TPS) rate, Amazon MWAA will increase the number of web servers up to the number set in `MaxWebserers`. As TPS rates decrease Amazon MWAA disposes of the additional web servers, and scales down to the number set in `MinxWebserers`.
         *
         * Valid values: For environments larger than mw1.micro, accepts values from `2` to `5`. Defaults to `2` for all environment sizes except mw1.micro, which defaults to `1`.
         */
        public var maxWebservers: kotlin.Int? = null
        /**
         * The maximum number of workers that run in your environment. For example, `20`.
         */
        public var maxWorkers: kotlin.Int? = null
        /**
         * The minimum number of web servers that you want to run in your environment. Amazon MWAA scales the number of Apache Airflow web servers up to the number you specify for `MaxWebservers` when you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. As the transaction-per-second rate, and the network load, decrease, Amazon MWAA disposes of the additional web servers, and scales down to the number set in `MinxWebserers`.
         *
         * Valid values: For environments larger than mw1.micro, accepts values from `2` to `5`. Defaults to `2` for all environment sizes except mw1.micro, which defaults to `1`.
         */
        public var minWebservers: kotlin.Int? = null
        /**
         * The minimum number of workers that run in your environment. For example, `2`.
         */
        public var minWorkers: kotlin.Int? = null
        /**
         * The name of the Amazon MWAA environment. For example, `MyMWAAEnvironment`.
         */
        public var name: kotlin.String? = null
        /**
         * Describes the VPC networking components used to secure and enable network traffic between the Amazon Web Services resources for your environment. For more information, see [About networking on Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html).
         */
        public var networkConfiguration: aws.sdk.kotlin.services.mwaa.model.NetworkConfiguration? = null
        /**
         * The version of the `plugins.zip` file in your Amazon S3 bucket. You must specify the [version ID](https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html) that Amazon S3 assigns to the file.
         *
         *  Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes long. The following is an example:
         *
         * `3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo`
         *
         * For more information, see [Installing custom plugins](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html).
         */
        public var pluginsS3ObjectVersion: kotlin.String? = null
        /**
         * The relative path to the file in your Amazon S3 bucket. For example, `s3://mwaa-environment/plugins.zip`. For more information, see [Installing custom plugins](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html).
         */
        public var pluginsS3Path: kotlin.String? = null
        /**
         * The version of the `requirements.txt ` file on your Amazon S3 bucket. You must specify the [version ID](https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html) that Amazon S3 assigns to the file.
         *
         *  Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes long. The following is an example:
         *
         * `3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo`
         *
         *  For more information, see [Installing Python dependencies](https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html).
         */
        public var requirementsS3ObjectVersion: kotlin.String? = null
        /**
         * The relative path to the `requirements.txt` file in your Amazon S3 bucket. For example, `s3://mwaa-environment/requirements.txt`. For more information, see [Installing Python dependencies](https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html).
         */
        public var requirementsS3Path: kotlin.String? = null
        /**
         * The number of Apache Airflow schedulers that run in your Amazon MWAA environment.
         */
        public var schedulers: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) for the service-linked role of the environment. For more information, see [Amazon MWAA Service-linked role](https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-slr.html).
         */
        public var serviceRoleArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. For example, `arn:aws:s3:::my-airflow-bucket-unique-name`. For more information, see [Create an Amazon S3 bucket for Amazon MWAA](https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html).
         */
        public var sourceBucketArn: kotlin.String? = null
        /**
         * The version of the startup shell script in your Amazon S3 bucket. You must specify the [version ID](https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html) that Amazon S3 assigns to the file.
         *
         *  Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes long. The following is an example:
         *
         * `3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo`
         *
         *  For more information, see [Using a startup script](https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html).
         */
        public var startupScriptS3ObjectVersion: kotlin.String? = null
        /**
         * The relative path to the startup shell script in your Amazon S3 bucket. For example, `s3://mwaa-environment/startup.sh`.
         *
         *  Amazon MWAA runs the script as your environment starts, and before running the Apache Airflow process. You can use this script to install dependencies, modify Apache Airflow configuration options, and set environment variables. For more information, see [Using a startup script](https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html).
         */
        public var startupScriptS3Path: kotlin.String? = null
        /**
         * The status of the Amazon MWAA environment.
         *
         * Valid values:
         * + `CREATING` - Indicates the request to create the environment is in progress.
         * + `CREATING_SNAPSHOT` - Indicates the request to update environment details, or upgrade the environment version, is in progress and Amazon MWAA is creating a storage volume snapshot of the Amazon RDS database cluster associated with the environment. A database snapshot is a backup created at a specific point in time. Amazon MWAA uses snapshots to recover environment metadata if the process to update or upgrade an environment fails.
         * + `CREATE_FAILED` - Indicates the request to create the environment failed, and the environment could not be created.
         * + `AVAILABLE` - Indicates the request was successful and the environment is ready to use.
         * + `PENDING` - Indicates the request was successful, but the process to create the environment is paused until you create the required VPC endpoints in your VPC. After you create the VPC endpoints, the process resumes.
         * + `UPDATING` - Indicates the request to update the environment is in progress.
         * + `ROLLING_BACK` - Indicates the request to update environment details, or upgrade the environment version, failed and Amazon MWAA is restoring the environment using the latest storage volume snapshot.
         * + `DELETING` - Indicates the request to delete the environment is in progress.
         * + `DELETED` - Indicates the request to delete the environment is complete, and the environment has been deleted.
         * + `UNAVAILABLE` - Indicates the request failed, but the environment did not return to its previous state and is not stable.
         * + `UPDATE_FAILED` - Indicates the request to update the environment failed, and the environment was restored to its previous state successfully and is ready to use.
         * + `MAINTENANCE` - Indicates that the environment is undergoing maintenance. Depending on the type of work Amazon MWAA is performing, your environment might become unavailable during this process. After all operations are done, your environment will return to its status prior to mainteneace operations.
         *
         * We recommend reviewing our troubleshooting guide for a list of common errors and their solutions. For more information, see [Amazon MWAA troubleshooting](https://docs.aws.amazon.com/mwaa/latest/userguide/troubleshooting.html).
         */
        public var status: aws.sdk.kotlin.services.mwaa.model.EnvironmentStatus? = null
        /**
         * The key-value tag pairs associated to your environment. For example, `"Environment": "Staging"`. For more information, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
         */
        public var tags: Map<String, String>? = null
        /**
         * The Apache Airflow *web server* access mode. For more information, see [Apache Airflow access modes](https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html).
         */
        public var webserverAccessMode: aws.sdk.kotlin.services.mwaa.model.WebserverAccessMode? = null
        /**
         * The Apache Airflow *web server* host name for the Amazon MWAA environment. For more information, see [Accessing the Apache Airflow UI](https://docs.aws.amazon.com/mwaa/latest/userguide/access-airflow-ui.html).
         */
        public var webserverUrl: kotlin.String? = null
        /**
         * The VPC endpoint for the environment's web server.
         */
        public var webserverVpcEndpointService: kotlin.String? = null
        /**
         * The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time that weekly maintenance updates are scheduled. For example: `TUE:03:30`.
         */
        public var weeklyMaintenanceWindowStart: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mwaa.model.Environment) : this() {
            this.airflowConfigurationOptions = x.airflowConfigurationOptions
            this.airflowVersion = x.airflowVersion
            this.arn = x.arn
            this.celeryExecutorQueue = x.celeryExecutorQueue
            this.createdAt = x.createdAt
            this.dagS3Path = x.dagS3Path
            this.databaseVpcEndpointService = x.databaseVpcEndpointService
            this.endpointManagement = x.endpointManagement
            this.environmentClass = x.environmentClass
            this.executionRoleArn = x.executionRoleArn
            this.kmsKey = x.kmsKey
            this.lastUpdate = x.lastUpdate
            this.loggingConfiguration = x.loggingConfiguration
            this.maxWebservers = x.maxWebservers
            this.maxWorkers = x.maxWorkers
            this.minWebservers = x.minWebservers
            this.minWorkers = x.minWorkers
            this.name = x.name
            this.networkConfiguration = x.networkConfiguration
            this.pluginsS3ObjectVersion = x.pluginsS3ObjectVersion
            this.pluginsS3Path = x.pluginsS3Path
            this.requirementsS3ObjectVersion = x.requirementsS3ObjectVersion
            this.requirementsS3Path = x.requirementsS3Path
            this.schedulers = x.schedulers
            this.serviceRoleArn = x.serviceRoleArn
            this.sourceBucketArn = x.sourceBucketArn
            this.startupScriptS3ObjectVersion = x.startupScriptS3ObjectVersion
            this.startupScriptS3Path = x.startupScriptS3Path
            this.status = x.status
            this.tags = x.tags
            this.webserverAccessMode = x.webserverAccessMode
            this.webserverUrl = x.webserverUrl
            this.webserverVpcEndpointService = x.webserverVpcEndpointService
            this.weeklyMaintenanceWindowStart = x.weeklyMaintenanceWindowStart
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mwaa.model.Environment = Environment(this)

        /**
         * construct an [aws.sdk.kotlin.services.mwaa.model.LastUpdate] inside the given [block]
         */
        public fun lastUpdate(block: aws.sdk.kotlin.services.mwaa.model.LastUpdate.Builder.() -> kotlin.Unit) {
            this.lastUpdate = aws.sdk.kotlin.services.mwaa.model.LastUpdate.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mwaa.model.LoggingConfiguration] inside the given [block]
         */
        public fun loggingConfiguration(block: aws.sdk.kotlin.services.mwaa.model.LoggingConfiguration.Builder.() -> kotlin.Unit) {
            this.loggingConfiguration = aws.sdk.kotlin.services.mwaa.model.LoggingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mwaa.model.NetworkConfiguration] inside the given [block]
         */
        public fun networkConfiguration(block: aws.sdk.kotlin.services.mwaa.model.NetworkConfiguration.Builder.() -> kotlin.Unit) {
            this.networkConfiguration = aws.sdk.kotlin.services.mwaa.model.NetworkConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
