// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mwaa.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.mwaa.model.CreateWebLoginTokenResponse
import aws.sdk.kotlin.services.mwaa.model.MwaaException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateWebLoginTokenOperationDeserializer: HttpDeserialize<CreateWebLoginTokenResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateWebLoginTokenResponse {
        if (!response.status.isSuccess()) {
            throwCreateWebLoginTokenError(context, response)
        }
        val builder = CreateWebLoginTokenResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateWebLoginTokenOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateWebLoginTokenError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MwaaException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> MwaaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateWebLoginTokenOperationBody(builder: CreateWebLoginTokenResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val WEBSERVERHOSTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WebServerHostname"))
    val WEBTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WebToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(WEBSERVERHOSTNAME_DESCRIPTOR)
        field(WEBTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                WEBSERVERHOSTNAME_DESCRIPTOR.index -> builder.webServerHostname = deserializeString()
                WEBTOKEN_DESCRIPTOR.index -> builder.webToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
