// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mwaa.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.mwaa.model.CreateCliTokenResponse
import aws.sdk.kotlin.services.mwaa.model.MwaaException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateCliTokenOperationDeserializer: HttpDeserialize<CreateCliTokenResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateCliTokenResponse {
        if (!response.status.isSuccess()) {
            throwCreateCliTokenError(context, response)
        }
        val builder = CreateCliTokenResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateCliTokenOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateCliTokenError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MwaaException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> MwaaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateCliTokenOperationBody(builder: CreateCliTokenResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CLITOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CliToken"))
    val WEBSERVERHOSTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WebServerHostname"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLITOKEN_DESCRIPTOR)
        field(WEBSERVERHOSTNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CLITOKEN_DESCRIPTOR.index -> builder.cliToken = deserializeString()
                WEBSERVERHOSTNAME_DESCRIPTOR.index -> builder.webServerHostname = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
